/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Stationmeteo;
import Interfaces.ParametreJFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modules.LasyTools;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class StationJDialog
extends JDialog {
    boolean AddStation = false;
    int StationId;
    Frame parentFrame;
    private JButton CloseButton;
    private JButton deleteButton;
    private EntityManager entityManager;
    private JLabel indiceLabel;
    private JComboBox jComboBoxIndice;
    private JLabel jLabel1;
    private JPanel jPanelStation;
    private List<Stationmeteo> list;
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private JTextField namestationField;
    private JLabel namestationLabel;
    private JButton newButton;
    private Query query;
    private JButton saveButton;
    private BindingGroup bindingGroup;

    public StationJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.parentFrame = parent;
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT s FROM Stationmeteo s");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.jPanelStation = new JPanel();
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.namestationLabel = new JLabel();
        this.namestationField = new JTextField();
        this.saveButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.jLabel1 = new JLabel();
        this.CloseButton = new JButton();
        this.indiceLabel = new JLabel();
        this.jComboBoxIndice = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(bundle.getString("GESTION_STATIONS"));
        this.setResizable(false);
        this.jPanelStation.setBackground(new Color(51, 51, 51));
        this.jPanelStation.setName("jPanelStation");
        this.masterScrollPane.setName("masterScrollPane");
        this.masterTable.setFont(new Font("Arial", 0, 12));
        this.masterTable.setForeground(new Color(0, 1, 0));
        this.masterTable.setName("masterTable");
        this.masterTable.getTableHeader().setReorderingAllowed(false);
        JTableBinding<Stationmeteo, List<Stationmeteo>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${namestation}"));
        columnBinding.setColumnName(bundle.getString("NAMESTATION"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${indice}"));
        columnBinding.setColumnName(bundle.getString("INDICE DE PR\u00c9CIPITATION"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding.setEditable(false);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idstationmeteo}"));
        columnBinding.setColumnName("id");
        columnBinding.setColumnClass(Integer.class);
        columnBinding.setEditable(false);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StationJDialog.this.masterTableMouseClicked(evt);
            }
        });
        this.masterScrollPane.setViewportView(this.masterTable);
        this.masterTable.getColumnModel().getColumn(2).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(2).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(2).setMaxWidth(1);
        this.namestationLabel.setFont(new Font("Arial", 0, 12));
        this.namestationLabel.setForeground(new Color(255, 254, 255));
        this.namestationLabel.setText(bundle.getString("STATION:"));
        this.namestationLabel.setName("namestationLabel");
        this.namestationField.setFont(new Font("Arial", 0, 12));
        this.namestationField.setForeground(new Color(0, 1, 0));
        this.namestationField.setName("namestationField");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.namestation}"), this.namestationField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement != null}"), this.namestationField, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.namestationField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                StationJDialog.this.namestationFieldCaretUpdate(evt);
            }
        });
        this.saveButton.setFont(new Font("Arial", 0, 12));
        this.saveButton.setForeground(new Color(0, 1, 0));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationJDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.newButton.setFont(new Font("Arial", 0, 12));
        this.newButton.setForeground(new Color(0, 1, 0));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.newButton.setText(bundle.getString("AJOUTER"));
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.setName("newButton");
        this.newButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                StationJDialog.this.newButtonMouseReleased(evt);
            }
        });
        this.deleteButton.setFont(new Font("Arial", 0, 12));
        this.deleteButton.setForeground(new Color(0, 1, 0));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.deleteButton.setText(bundle.getString("SUPPRIMER"));
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationJDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Arial", 0, 14));
        this.jLabel1.setForeground(new Color(255, 254, 255));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(bundle.getString("GESTION_STATIONS"));
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setName("jLabel1");
        this.CloseButton.setFont(new Font("Arial", 0, 12));
        this.CloseButton.setForeground(new Color(0, 1, 0));
        this.CloseButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.CloseButton.setText(bundle.getString("FERMER"));
        this.CloseButton.setHorizontalTextPosition(0);
        this.CloseButton.setName("CloseButton");
        this.CloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                StationJDialog.this.CloseButtonMouseReleased(evt);
            }
        });
        this.indiceLabel.setFont(new Font("Arial", 0, 12));
        this.indiceLabel.setForeground(new Color(255, 254, 255));
        this.indiceLabel.setText(bundle.getString("INDICE DE PR\u00c9CIPITATION:"));
        this.indiceLabel.setName("indiceLabel");
        this.jComboBoxIndice.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5"}));
        this.jComboBoxIndice.setName("jComboBoxIndice");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.indice}"), this.jComboBoxIndice, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxIndice.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                StationJDialog.this.jComboBoxIndicePopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        GroupLayout jPanelStationLayout = new GroupLayout(this.jPanelStation);
        this.jPanelStation.setLayout(jPanelStationLayout);
        jPanelStationLayout.setHorizontalGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStationLayout.createSequentialGroup().addContainerGap().addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.masterScrollPane, -2, 311, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanelStationLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 241, -2).addGap(33, 33, 33)).addGroup(jPanelStationLayout.createSequentialGroup().addComponent(this.namestationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.namestationField, -2, 250, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanelStationLayout.createSequentialGroup().addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newButton, -2, 130, -2).addComponent(this.deleteButton, -2, 130, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 51, Short.MAX_VALUE).addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.CloseButton, -2, 130, -2).addComponent(this.saveButton, -2, 130, -2))).addGroup(jPanelStationLayout.createSequentialGroup().addComponent(this.indiceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxIndice, -2, 39, -2))).addContainerGap()));
        jPanelStationLayout.setVerticalGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStationLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 27, -2).addGap(18, 18, 18).addComponent(this.masterScrollPane, -2, 190, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.namestationLabel).addComponent(this.namestationField, -2, 20, -2)).addGap(18, 18, 18).addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indiceLabel).addComponent(this.jComboBoxIndice, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newButton, -2, 22, -2).addGroup(jPanelStationLayout.createSequentialGroup().addComponent(this.saveButton, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelStationLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CloseButton, -2, 22, -2).addComponent(this.deleteButton, -2, 22, -2)))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelStation, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelStation, -2, -1, -2));
        this.bindingGroup.bind();
        this.pack();
    }

    private void masterTableMouseClicked(MouseEvent evt) {
        LasyTools Tool = new LasyTools();
        this.FreeseStation(true);
        int RowSelect = 0;
        RowSelect = this.masterTable.getSelectedRow();
        try {
            this.StationId = Tool.SetAsA_Int(this.masterTable.getValueAt(RowSelect, 2).toString());
        }
        catch (NullPointerException | ParseException ex) {
            this.StationId = 0;
        }
        try {
            this.jComboBoxIndice.setSelectedItem(this.masterTable.getValueAt(RowSelect, 1).toString());
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("AJOUTER"));
    }

    private void namestationFieldCaretUpdate(CaretEvent evt) {
        int row = 0;
        String Val = "";
        try {
            if (this.namestationField.isFocusOwner()) {
                row = this.masterTable.getSelectedRow();
                Val = this.namestationField.getText();
                this.masterTable.setValueAt(Val, row, 0);
                this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("ANNULER"));
                this.saveButton.setEnabled(true);
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.SaveStation();
        if (this.AddStation) {
            JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("ENREGISTREMENT REUSSI"), ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("CONFIRMATION_SAUVEGARDE"), -1);
        } else {
            JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("MISE \u00c0 JOUR EFFECTU\u00c9E"), ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("CONFIRMATION_MISE_A_JOUR"), -1);
        }
        this.AddStation = false;
        this.FreeseStation(false);
        this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("AJOUTER"));
    }

    private void newButtonMouseReleased(MouseEvent evt) {
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("AJOUTER"))) {
            this.AddStation();
            this.AddStation = true;
            this.FreeseStation(true);
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("ANNULER"));
        } else {
            this.refreshStation();
            this.AddStation = false;
            this.FreeseStation(false);
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("AJOUTER"));
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.deleteButton.isEnabled()) {
            int choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("CONFIRMER_SUPPRESSION"), ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("SUPPRESSION"), 2);
            if (this.masterTable.getSelectedRow() != -1) {
                if (choix == 0) {
                    this.RemoveStation();
                    this.AddStation = false;
                    this.FreeseStation(false);
                    this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("AJOUTER"));
                    this.namestationField.setText("");
                }
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("S\u00c9LECTIONNER_LIGNE"), ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("SUPPRESSION IMPOSSIBLE"), -1);
            }
        }
    }

    private void CloseButtonMouseReleased(MouseEvent evt) {
        this.Onclose();
    }

    private void jComboBoxIndicePopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        String val = "";
        int row = 0;
        try {
            val = this.jComboBoxIndice.getSelectedItem().toString();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (this.masterTable.getSelectedRow() != -1) {
            row = this.masterTable.getSelectedRow();
            this.masterTable.setValueAt(val, row, 1);
        }
        this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("ANNULER"));
        this.saveButton.setEnabled(true);
    }

    public void CentreFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void formWindowClosed(WindowEvent evt) {
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("ANNULER"))) {
            int choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("QUITTER_SANS_SAUVEGARDER"), ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("SUPPRESSION"), 2);
            if (choix == 0) {
                this.UpdateListStation();
            } else {
                this.ReOpen(this.parentFrame);
            }
        } else {
            this.UpdateListStation();
        }
    }

    private void AddStation() {
        Stationmeteo s = new Stationmeteo();
        this.StationId = this.getLastStationId();
        s.setIdstationmeteo(this.StationId);
        this.entityManager.persist((Object)s);
        this.list.add(s);
        int row = this.list.size() - 1;
        this.masterTable.setRowSelectionInterval(row, row);
        this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
        this.namestationField.requestFocus(true);
    }

    public int getLastStationId() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("CRITERBASE.DB3PU"));
        EntityManager ThisEntityManager = emf.createEntityManager();
        if (!Beans.isDesignTime() && !ThisEntityManager.getTransaction().isActive()) {
            ThisEntityManager.getTransaction().begin();
        }
        int id = 0;
        int tmpId = 0;
        List StationList = ThisEntityManager.createNamedQuery("Stationmeteo.findAll").getResultList();
        if (!StationList.isEmpty()) {
            for (Stationmeteo s : StationList) {
                tmpId = s.getIdstationmeteo();
                List StationList2 = ThisEntityManager.createQuery("SELECT s FROM Stationmeteo s WHERE s.idstationmeteo > " + tmpId).getResultList();
                if (!StationList2.isEmpty()) continue;
                id = tmpId + 1;
                break;
            }
        }
        ThisEntityManager.clear();
        ThisEntityManager.close();
        return id;
    }

    private void RemoveStation() {
        int[] selected = this.masterTable.getSelectedRows();
        ArrayList<Stationmeteo> toRemove = new ArrayList<Stationmeteo>(selected.length);
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        for (int idx = 0; idx < selected.length; ++idx) {
            Stationmeteo s = this.list.get(this.masterTable.convertRowIndexToModel(selected[idx]));
            toRemove.add(s);
            this.entityManager.remove((Object)s);
        }
        this.list.removeAll(toRemove);
        this.entityManager.getTransaction().commit();
    }

    private void SaveStation() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        try {
            if (this.StationId != 0) {
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
            }
        }
        catch (RollbackException rex) {
            rex.printStackTrace();
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
            for (Stationmeteo s : this.list) {
                merged.add(this.entityManager.merge((Object)s));
            }
            this.list.clear();
            this.list.addAll(merged);
        }
    }

    private void FreeseStation(boolean statut) {
        this.namestationField.setEnabled(statut);
        this.deleteButton.setEnabled(statut);
        this.saveButton.setEnabled(statut);
    }

    private void refreshStation() {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void Onclose() {
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("ANNULER"))) {
            int choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("QUITTER_SANS_SAUVEGARDER"), ResourceBundle.getBundle("Interfaces/resources/StationMeteoBundle").getString("SUPPRESSION"), 2);
            if (choix == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void UpdateListStation() {
        ParametreJFrame P = new ParametreJFrame();
        if (P.jComboBoxStation.getSelectedIndex() != 0) {
            P.init_listStation();
            P.repaint();
            P.pack();
        } else {
            P.jComboBoxStation.setSelectedIndex(1);
            P.init_listStation();
            P.jComboBoxStation.setSelectedIndex(0);
            P.repaint();
            P.pack();
        }
        P.CentreFrame();
        P = null;
    }

    private void ReOpen(Frame parent) {
        StationJDialog StationMenu = new StationJDialog(parent, true);
        LasyTools Tool = new LasyTools();
        StationMenu.setDefaultCloseOperation(2);
        StationMenu.pack();
        this.CentreFrame();
        StationMenu.setName("StationMenu");
        StationMenu.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StationJDialog dialog = new StationJDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

