/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Crop;
import DataBase.Fraissechagemais;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import modules.CultureMod;
import modules.FraisSechageMod;
import modules.LasyTools;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class SechageGrainPanel
extends JPanel {
    boolean LimitMax = false;
    private JButton deleteButton;
    private EntityManager entityManager;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelCICTitle;
    private JLabel jLabelInfoHumiRef;
    private JScrollPane jScrollPaneInfo;
    private JSeparator jSeparator1;
    private JTextField jTextFieldHumiMax;
    private JTextField jTextFieldHumiMin;
    private JTextField jTextFieldPrix;
    private JTextPane jTextPaneInfo;
    private List<Fraissechagemais> list;
    private List<Crop> listcrop;
    private JScrollPane masterScrollPane;
    private JScrollPane masterScrollPaneCrop;
    private JTable masterTableA;
    private JTable masterTableB;
    private JButton newButton;
    private Query query;
    private Query querycrop;
    private JButton refreshButton;
    private JButton saveButton;
    private BindingGroup bindingGroup;

    public SechageGrainPanel() {
        this.initComponents();
        if (!Beans.isDesignTime()) {
            this.entityManager.getTransaction().begin();
        }
        this.jLabelInfoHumiRef.setText("");
        this.SetTableData(-1);
        this.EnableElements(false);
    }

    private void SetCurrentData() {
        String CropSelected = "";
        int CropIdSelected = 0;
        try {
            CropSelected = this.masterTableA.getValueAt(this.masterTableA.getSelectedRow(), 0).toString();
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException ext) {
            CropSelected = "";
        }
        CultureMod CropT = new CultureMod();
        CropIdSelected = CropT.GetIdCultByNameCult(CropSelected);
        this.SetTableData(CropIdSelected);
    }

    private void SetTableData(int CropIdSelected) {
        int compteur = 0;
        String SQL = "";
        SQL = "SELECT f FROM Fraissechagemais f WHERE f.crop.idcult=" + CropIdSelected;
        this.newButton.setEnabled(true);
        this.query = this.entityManager.createQuery(SQL);
        this.Refresh();
        compteur = this.list.size();
        this.AjustElements(compteur);
    }

    private void AjustElements(int compteur) {
        String msg = "";
        this.jScrollPaneInfo.setVisible(true);
        if (compteur > 85) {
            this.LimitMax = true;
            msg = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("SEULES LES 85 PREMI\u00c8RES LIGNES PEUVENT \u00caTRE AFFICH\u00c9ES (LIMITE DE L'INTERFACE)");
            msg = msg + ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("TANT QUE CETTE CULTURE COMPORTE PLUS DE 85 LIGNES, IL EST POSSIBLE DE SUPPRIMER MAIS PAS D'ENREGISTRER");
            msg = msg + ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("(VEUILLEZ UTILISER UN GESTIONNAIRE DE BASE DE DONN\u00c9ES)");
            msg = msg + ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CETTE RESTRICTION D'AFFICHAGE N'AFFECTE EN RIEN LES CALCULS DE CRITER MOBILISANT CES INFORMATIONS");
            this.jTextPaneInfo.setForeground(Color.red);
            this.SetDimensions(true);
        } else if (compteur > 84) {
            this.LimitMax = true;
            msg = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VOUS AVEZ ATTEINT LE NOMBRE LIMITE D'ENREGISTREMENTS (85) POUR CETTE CULTURE.");
            this.jTextPaneInfo.setForeground(Color.red);
        } else if (compteur == 84) {
            msg = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VOUS POUVEZ AJOUTER ENCORE 1 ENREGISTREMENT AVANT D'ATTEINDRE LA LIMITE POUR CETTE CULTURE.");
            this.jTextPaneInfo.setForeground(Color.GREEN);
            this.LimitMax = false;
        } else if (compteur == 0) {
            msg = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("AUCUN ENREGISTREMENT POUR CETTE CULTURE.");
            this.jTextPaneInfo.setForeground(Color.white);
            this.LimitMax = false;
        } else if (compteur == 1) {
            msg = compteur + ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("SEUL ENREGISTREMENT D\u00c9TECT\u00c9 POUR CETTE CULTURE.");
            this.jTextPaneInfo.setForeground(Color.white);
            this.LimitMax = false;
        } else {
            msg = compteur + ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ENREGISTREMENTS D\u00c9TECT\u00c9S POUR CETTE CULTURE.");
            this.jTextPaneInfo.setForeground(Color.white);
            this.LimitMax = false;
        }
        if (this.masterTableA.getSelectedRow() <= 0) {
            msg = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("S\u00c9LECTIONNEZ UNE CULTURE POUR MODIFIER SES VALEURS OU RENSEIGNER DES NOUVELLES DONN\u00c9ES \u00c0 L'AIDE DU BOUTON [AJOUTER].");
            this.jTextPaneInfo.setForeground(Color.white);
            this.SetDimensions(false);
        }
        this.jTextPaneInfo.setText(msg);
    }

    private void SetDimensions(boolean SetLarge) {
        if (SetLarge) {
            this.setBounds(0, 0, 640, 450);
            this.jScrollPaneInfo.setBounds(12, 320, 544, 80);
            this.newButton.setBounds(this.newButton.getBounds().x, 410, this.newButton.getBounds().width, this.newButton.getBounds().height);
            this.deleteButton.setBounds(this.deleteButton.getBounds().x, 410, this.deleteButton.getBounds().width, this.deleteButton.getBounds().height);
            this.refreshButton.setBounds(this.refreshButton.getBounds().x, 410, this.refreshButton.getBounds().width, this.refreshButton.getBounds().height);
            this.saveButton.setBounds(this.saveButton.getBounds().x, 410, this.saveButton.getBounds().width, this.saveButton.getBounds().height);
        } else {
            this.setBounds(0, 0, 640, 420);
            this.jScrollPaneInfo.setBounds(15, 335, 544, 33);
            this.newButton.setBounds(this.newButton.getBounds().x, 385, this.newButton.getBounds().width, this.newButton.getBounds().height);
            this.deleteButton.setBounds(this.deleteButton.getBounds().x, 385, this.deleteButton.getBounds().width, this.deleteButton.getBounds().height);
            this.refreshButton.setBounds(this.refreshButton.getBounds().x, 385, this.refreshButton.getBounds().width, this.refreshButton.getBounds().height);
            this.saveButton.setBounds(this.saveButton.getBounds().x, 385, this.saveButton.getBounds().width, this.saveButton.getBounds().height);
        }
    }

    private void Refresh() {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void Save() {
        try {
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            this.Refresh();
            this.SetCurrentData();
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ENREGISTREMENT REUSSI !"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
        }
        catch (RollbackException rex) {
            rex.printStackTrace();
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
            for (Fraissechagemais f : this.list) {
                merged.add(this.entityManager.merge((Object)f));
            }
            this.list.clear();
            this.list.addAll(merged);
        }
    }

    private void New() {
        Fraissechagemais f = new Fraissechagemais();
        this.entityManager.persist((Object)f);
        this.list.add(f);
        int row = this.list.size() - 1;
        this.masterTableB.setRowSelectionInterval(row, row);
        this.masterTableB.scrollRectToVisible(this.masterTableB.getCellRect(row, 0, true));
        int idcrop = 0;
        try {
            LasyTools tools = new LasyTools();
            idcrop = tools.SetAsA_Int(this.masterTableA.getValueAt(this.masterTableA.getSelectedRow(), 1).toString());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | ParseException ext) {
            idcrop = 0;
        }
        if (idcrop != 0) {
            CultureMod CropT = new CultureMod();
            Crop Crop2 = (Crop)this.entityManager.find(Crop.class, (Object)idcrop);
            try {
                this.masterTableB.setValueAt(Crop2, row, 4);
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("LA CULTURE N'A PAS \u00c9T\u00c9 R\u00c9CUP\u00c9R\u00c9E LORS DE LA SELECTION (INTERFACE S\u00c9CHAGE GRAIN)"));
            }
        }
        this.EnableElements(true);
    }

    private void Delete() {
        int choix;
        if (this.deleteButton.isEnabled() && (choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VEUILLEZ CONFIRMER LA SUPPRESSION DE CET ENREGISTREMENT"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("SUPPRESSION"), 2)) == 0) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            int[] selected = this.masterTableB.getSelectedRows();
            ArrayList<Fraissechagemais> toRemove = new ArrayList<Fraissechagemais>(selected.length);
            for (int idx = 0; idx < selected.length; ++idx) {
                Fraissechagemais f = this.list.get(this.masterTableB.convertRowIndexToModel(selected[idx]));
                toRemove.add(f);
                this.entityManager.remove((Object)f);
            }
            this.list.removeAll(toRemove);
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            this.EnableElements(false);
        }
    }

    private void ReinitElements() {
        this.jTextFieldHumiMin.setText("");
        this.jTextFieldHumiMax.setText("");
        this.jTextFieldPrix.setText("");
    }

    private void EnableElements(boolean Statut) {
        this.jTextFieldHumiMin.setEnabled(Statut);
        this.jTextFieldHumiMax.setEnabled(Statut);
        this.jTextFieldPrix.setEnabled(Statut);
        this.newButton.setEnabled(Statut);
        this.refreshButton.setEnabled(Statut);
        this.saveButton.setEnabled(Statut);
        this.deleteButton.setEnabled(Statut);
    }

    private void TestContentField() {
        LasyTools tool = new LasyTools();
        String msgNumeric = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CHAMPS_NUM\u00c9RIQUE");
        String msgStr = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CHAMPS_CARACTERES");
        if (!this.jTextFieldHumiMin.getText().isEmpty()) {
            if (!tool.ThisFieldIsNumeric(this.jTextFieldHumiMin)) {
                JOptionPane.showMessageDialog(this, msgStr, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("FORMAT INCORRECT"), -1);
                this.jTextFieldHumiMin.setForeground(Color.red);
                this.jTextFieldHumiMin.requestFocus();
            } else {
                this.jTextFieldHumiMin.setForeground(Color.BLACK);
            }
        }
        if (!this.jTextFieldHumiMax.getText().isEmpty()) {
            if (!tool.ThisFieldIsNumeric(this.jTextFieldHumiMax)) {
                JOptionPane.showMessageDialog(this, msgStr, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("FORMAT INCORRECT"), -1);
                this.jTextFieldHumiMax.setForeground(Color.red);
                this.jTextFieldHumiMax.requestFocus();
            } else {
                this.jTextFieldHumiMax.setForeground(Color.BLACK);
            }
        }
        if (!this.jTextFieldPrix.getText().isEmpty()) {
            if (!tool.ThisFieldIsNumeric(this.jTextFieldPrix)) {
                JOptionPane.showMessageDialog(this, msgStr, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("FORMAT INCORRECT"), -1);
                this.jTextFieldPrix.setForeground(Color.red);
                this.jTextFieldPrix.requestFocus();
            } else {
                this.jTextFieldPrix.setForeground(Color.BLACK);
            }
        }
    }

    private boolean CoutIsHumiditeOk() {
        double Humiref = 0.0;
        double Cout = 0.0;
        boolean CoutHumidite = true;
        CultureMod CropTools = new CultureMod();
        LasyTools tools = new LasyTools();
        int idcrop = 0;
        try {
            idcrop = tools.SetAsA_Int(this.masterTableA.getValueAt(this.masterTableA.getSelectedRow(), 1).toString());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | ParseException ext) {
            idcrop = 0;
        }
        try {
            Humiref = CropTools.GetHumiditeRef(idcrop);
        }
        catch (NullPointerException | ParseException ex) {
            Humiref = 0.0;
        }
        if (!this.jTextFieldHumiMin.getText().isEmpty()) {
            try {
                Cout = tools.SetAsAdouble(this.jTextFieldHumiMin.getText());
            }
            catch (NullPointerException | ParseException ex) {
                Cout = 0.0;
            }
            if (Cout < Humiref) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("L'HUMIDIT\u00c9 MINIMUM DOIT \u00caTRE SUP\u00c9RIEURE OU \u00c9GALE \u00c0 L'HUMIDIT\u00c9 DE R\u00c9F\u00c9RENCE DE LA CULTURE R\u00c9COLT\u00c9E."), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VALEUR INCORRECTE"), -1);
                CoutHumidite = false;
                this.jTextFieldHumiMin.requestFocus();
                this.jTextFieldHumiMin.setForeground(Color.red);
                this.jLabelInfoHumiRef.setText(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("HUMIDIT\u00c9 DE R\u00c9F\u00c9RENCE: ") + Humiref);
                this.jLabelInfoHumiRef.setForeground(Color.CYAN);
            } else {
                this.jTextFieldHumiMin.setForeground(Color.green);
                this.jLabelInfoHumiRef.setText("");
            }
        }
        return CoutHumidite;
    }

    private boolean IsMax() {
        boolean Statut = false;
        double min = 0.0;
        double max = 0.0;
        LasyTools tool = new LasyTools();
        if (!this.jTextFieldHumiMin.getText().isEmpty()) {
            try {
                min = tool.SetAsABigdouble(this.jTextFieldHumiMin.getText());
            }
            catch (NullPointerException | ParseException ext) {
                min = 0.0;
            }
        }
        if (!this.jTextFieldHumiMax.getText().isEmpty()) {
            try {
                max = tool.SetAsABigdouble(this.jTextFieldHumiMax.getText());
            }
            catch (NullPointerException | ParseException ext) {
                max = 0.0;
            }
        }
        if (Statut = this.jTextFieldHumiMax.getText().isEmpty() ? true : max > min) {
            this.jTextFieldHumiMax.setForeground(Color.GREEN);
            this.jTextFieldHumiMin.setForeground(Color.GREEN);
        } else {
            this.jTextFieldHumiMax.setForeground(Color.red);
            this.jTextFieldHumiMin.setForeground(Color.red);
        }
        return Statut;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT f FROM Fraissechagemais f");
        this.querycrop = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT c FROM Crop c ORDER BY c.name");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.listcrop = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.querycrop.getResultList());
        this.masterScrollPaneCrop = new JScrollPane();
        this.masterTableA = new JTable();
        this.masterScrollPane = new JScrollPane();
        this.masterTableB = new JTable();
        this.saveButton = new JButton();
        this.refreshButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.jTextFieldHumiMin = new JTextField();
        this.jTextFieldHumiMax = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabelCICTitle = new JLabel();
        this.jTextFieldPrix = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabelInfoHumiRef = new JLabel();
        this.jScrollPaneInfo = new JScrollPane();
        this.jTextPaneInfo = new JTextPane();
        FormListener formListener = new FormListener();
        this.setBackground(new Color(-13421773, true));
        this.setName("S\u00e9chage grain");
        this.masterScrollPaneCrop.setName("masterScrollPaneCrop");
        this.masterTableA.setCursor(new Cursor(12));
        this.masterTableA.setName("masterTableA");
        this.masterTableA.setSelectionMode(0);
        this.masterTableA.getTableHeader().setReorderingAllowed(false);
        JTableBinding<Serializable, List<Serializable>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.listcrop, this.masterTableA);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${name}"));
        columnBinding.setColumnName("Culture");
        columnBinding.setColumnClass(String.class);
        columnBinding.setEditable(false);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idcult}"));
        columnBinding.setColumnName("id");
        columnBinding.setColumnClass(Integer.class);
        columnBinding.setEditable(false);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTableA.addMouseListener(formListener);
        this.masterScrollPaneCrop.setViewportView(this.masterTableA);
        this.masterTableA.getColumnModel().getColumn(1).setMinWidth(1);
        this.masterTableA.getColumnModel().getColumn(1).setPreferredWidth(1);
        this.masterTableA.getColumnModel().getColumn(1).setMaxWidth(1);
        this.masterTableB.setCursor(new Cursor(12));
        this.masterTableB.setSelectionMode(0);
        this.masterTableB.getTableHeader().setReorderingAllowed(false);
        jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTableB);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${fraissechagemaisHummin}"));
        columnBinding.setColumnName("Humidit\u00e9 minimum ");
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${fraissechagemaisHummax}"));
        columnBinding.setColumnName("Humidit\u00e9 maximum ");
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${fraissechagemaisPrix}"));
        columnBinding.setColumnName("Co\u00fbt s\u00e9chage");
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${id}"));
        columnBinding.setColumnName("id");
        columnBinding.setColumnClass(Integer.class);
        columnBinding.setEditable(false);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${crop}"));
        columnBinding.setColumnName("crop");
        columnBinding.setColumnClass(Crop.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTableB.addMouseListener(formListener);
        this.masterScrollPane.setViewportView(this.masterTableB);
        this.masterTableB.getColumnModel().getColumn(0).setMinWidth(125);
        this.masterTableB.getColumnModel().getColumn(0).setPreferredWidth(125);
        this.masterTableB.getColumnModel().getColumn(0).setMaxWidth(125);
        this.masterTableB.getColumnModel().getColumn(1).setMinWidth(125);
        this.masterTableB.getColumnModel().getColumn(1).setPreferredWidth(125);
        this.masterTableB.getColumnModel().getColumn(1).setMaxWidth(125);
        this.masterTableB.getColumnModel().getColumn(3).setMinWidth(1);
        this.masterTableB.getColumnModel().getColumn(3).setPreferredWidth(1);
        this.masterTableB.getColumnModel().getColumn(3).setMaxWidth(1);
        this.masterTableB.getColumnModel().getColumn(4).setMinWidth(1);
        this.masterTableB.getColumnModel().getColumn(4).setPreferredWidth(1);
        this.masterTableB.getColumnModel().getColumn(4).setMaxWidth(1);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.addActionListener(formListener);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.refreshButton.setText(bundle.getString("ANNULER"));
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(formListener);
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.newButton.setText(bundle.getString("AJOUTER"));
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.addActionListener(formListener);
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.deleteButton.setText(bundle.getString("SUPPRIMER"));
        this.deleteButton.setHorizontalTextPosition(0);
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.masterTableB, ELProperty.create("${selectedElement != null}"), this.deleteButton, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.deleteButton.addActionListener(formListener);
        this.jTextFieldHumiMin.setName("jTextFieldHumiMin");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTableB, ELProperty.create("${selectedElement.fraissechagemaisHummin}"), this.jTextFieldHumiMin, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.jTextFieldHumiMin.addCaretListener(formListener);
        this.jTextFieldHumiMin.addFocusListener(formListener);
        this.jTextFieldHumiMax.setName("jTextFieldHumiMax");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTableB, ELProperty.create("${selectedElement.fraissechagemaisHummax}"), this.jTextFieldHumiMax, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.jTextFieldHumiMax.addCaretListener(formListener);
        this.jTextFieldHumiMax.addFocusListener(formListener);
        this.jSeparator1.setName("jSeparator1");
        this.jLabel2.setForeground(new Color(-1, true));
        this.jLabel2.setText(bundle.getString("MINIMUM"));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setForeground(new Color(-1, true));
        this.jLabel3.setText(bundle.getString("MAXIMUM"));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setForeground(new Color(-1, true));
        this.jLabel4.setText(bundle.getString("HUMIDIT\u00c9 (%)"));
        this.jLabel4.setName("jLabel4");
        this.jLabelCICTitle.setFont(new Font("Arial", 1, 13));
        this.jLabelCICTitle.setForeground(new Color(255, 255, 255));
        this.jLabelCICTitle.setHorizontalAlignment(0);
        this.jLabelCICTitle.setText(bundle.getString("S\u00c9CHAGE GRAIN"));
        this.jLabelCICTitle.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelCICTitle.setHorizontalTextPosition(0);
        this.jLabelCICTitle.setName("jLabelCICTitle");
        this.jTextFieldPrix.setName("jTextFieldPrix");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTableB, ELProperty.create("${selectedElement.fraissechagemaisPrix}"), this.jTextFieldPrix, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.jTextFieldPrix.addCaretListener(formListener);
        this.jTextFieldPrix.addFocusListener(formListener);
        this.jLabel5.setFont(new Font("Dialog", 0, 10));
        this.jLabel5.setForeground(new Color(-1, true));
        this.jLabel5.setText(bundle.getString("CO\u00dbT DE S\u00c9CHAGE : (\u20ac/T, POUR ATTEINDRE LE % D'HUMIDIT\u00c9 DE R\u00c9F\u00c9RENCE) "));
        this.jLabel5.setName("jLabel5");
        this.jLabelInfoHumiRef.setFont(new Font("Serif", 2, 12));
        this.jLabelInfoHumiRef.setText("jLabel1");
        this.jLabelInfoHumiRef.setName("jLabelInfoHumiRef");
        this.jScrollPaneInfo.setBackground(new Color(51, 51, 51));
        this.jScrollPaneInfo.setBorder(null);
        this.jScrollPaneInfo.setForeground(new Color(-1, true));
        this.jScrollPaneInfo.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneInfo.setCursor(new Cursor(0));
        this.jScrollPaneInfo.setFocusable(false);
        this.jScrollPaneInfo.setName("jScrollPaneInfo");
        this.jScrollPaneInfo.setOpaque(false);
        this.jTextPaneInfo.setBackground(new Color(51, 51, 51));
        this.jTextPaneInfo.setEditable(false);
        this.jTextPaneInfo.setFont(new Font("Monospaced", 0, 10));
        this.jTextPaneInfo.setForeground(new Color(-1, true));
        this.jTextPaneInfo.setAutoscrolls(false);
        this.jTextPaneInfo.setFocusable(false);
        this.jTextPaneInfo.setName("jTextPaneInfo");
        this.jTextPaneInfo.setRequestFocusEnabled(false);
        this.jScrollPaneInfo.setViewportView(this.jTextPaneInfo);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(189, 189, 189).addComponent(this.deleteButton, -2, 110, -2).addGap(42, 42, 42).addComponent(this.refreshButton, -2, 110, -2).addGap(39, 39, 39).addComponent(this.saveButton, -2, 110, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.masterScrollPaneCrop, -1, 202, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.masterScrollPane, -2, 397, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPrix, -2, 45, -2).addComponent(this.jLabel5, -2, 342, -2).addComponent(this.jLabelInfoHumiRef, -2, 316, -2))))))).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldHumiMin, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldHumiMax, -2, 48, -2)).addComponent(this.jSeparator1, -2, 125, -2)).addGroup(layout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jLabel4)))).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.newButton, -2, 110, -2)).addGroup(layout.createSequentialGroup().addGap(157, 157, 157).addComponent(this.jLabelCICTitle, -2, 296, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneInfo, -2, 589, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelCICTitle, -2, 32, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.masterScrollPane, 0, 0, Short.MAX_VALUE).addComponent(this.masterScrollPaneCrop, -1, 162, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1, -2, -1, -2).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldHumiMin, -2, -1, -2).addComponent(this.jTextFieldHumiMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3))).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldPrix, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelInfoHumiRef))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneInfo, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton, -2, 20, -2).addComponent(this.deleteButton, -2, 20, -2).addComponent(this.saveButton, -2, 20, -2).addComponent(this.refreshButton, -2, 20, -2)).addContainerGap()));
        this.getAccessibleContext().setAccessibleName("S\u00e9chage grain");
        this.getAccessibleContext().setAccessibleDescription("S\u00e9chage grain");
        this.bindingGroup.bind();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.deleteButton.isEnabled()) {
            this.Delete();
            this.Refresh();
            this.SetCurrentData();
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        if (this.LimitMax) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VOUS AVEZ ATTEINT LE NOMBRE LIMITE D'ENREGISTREMENTS (85) POUR CETTE CULTURE."), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("LIMITATION DES ENREGISTREMENTS"), 1);
            this.Refresh();
            this.ReinitElements();
            this.EnableElements(false);
            this.newButton.setEnabled(true);
        } else {
            this.New();
            this.jTextFieldHumiMin.requestFocus();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        FraisSechageMod frsMod = new FraisSechageMod();
        LasyTools tool = new LasyTools();
        double MyMinValue = 0.0;
        double MyMaxValue = 0.0;
        int idcrop = 0;
        if (this.IsMax() && this.CoutIsHumiditeOk()) {
            if (this.jTextFieldHumiMin.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VEUILLEZ SAISIR UNE VALEUR MINIMALE"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("INFORMATION MANQUANTE"), -1);
                this.jTextFieldHumiMin.requestFocus();
            } else if (this.jTextFieldHumiMax.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VEUILLEZ SAISIR UNE VALEUR MAXIMALE"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("INFORMATION MANQUANTE"), -1);
                this.jTextFieldHumiMax.requestFocus();
            } else if (this.jTextFieldPrix.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VEUILLEZ SAISIR UNE VALEUR POUR LE CHAMPS [CO\u00dbT S\u00c9CHAGE]"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("INFORMATION MANQUANTE"), -1);
                this.jTextFieldPrix.requestFocus();
            } else {
                try {
                    MyMinValue = tool.SetAsABigdouble(this.jTextFieldHumiMin.getText());
                }
                catch (NullPointerException | ParseException ext) {
                    MyMinValue = 0.0;
                }
                try {
                    MyMaxValue = tool.SetAsABigdouble(this.jTextFieldHumiMax.getText());
                }
                catch (NullPointerException | ParseException ext) {
                    MyMaxValue = 0.0;
                }
                try {
                    idcrop = tool.SetAsA_Int(this.masterTableA.getValueAt(this.masterTableA.getSelectedRow(), 1).toString());
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException | ParseException ext) {
                    idcrop = 0;
                }
                if (frsMod.AuthorizeRecord(MyMinValue, MyMaxValue, idcrop)) {
                    this.Save();
                    this.Refresh();
                    this.SetCurrentData();
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("LA PLAGE DE DONN\u00c9E (MINIMALE/MAXIMALE) RENSEIGN\u00c9E EST INCORRECTE"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("INFORMATION INCOH\u00c9RENTE"), -1);
                    this.Refresh();
                    this.ReinitElements();
                    this.EnableElements(false);
                    this.newButton.setEnabled(true);
                }
            }
        }
    }

    private void masterTableBMouseClicked(MouseEvent evt) {
        this.EnableElements(true);
    }

    private void masterTableAMouseClicked(MouseEvent evt) {
        this.ReinitElements();
        this.SetCurrentData();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.Refresh();
        this.ReinitElements();
        this.EnableElements(false);
        this.newButton.setEnabled(true);
    }

    private void jTextFieldHumiMaxCaretUpdate(CaretEvent evt) {
        this.TestContentField();
    }

    private void jTextFieldHumiMinCaretUpdate(CaretEvent evt) {
        this.TestContentField();
    }

    private void jTextFieldHumiMinFocusLost(FocusEvent evt) {
        if (!this.IsMax()) {
            String msg = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("L'HUMIDIT\u00c9 MAXIMUM DOIT \u00caTRE SUP\u00c9RIEURE OU \u00c9GALE \u00c0 L'HUMIDIT\u00c9 MINIMUM");
            JOptionPane.showMessageDialog(this, msg, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("INFORMATION ERRON\u00c9E"), -1);
        }
    }

    private void jTextFieldHumiMaxFocusLost(FocusEvent evt) {
        if (!this.IsMax()) {
            String msg = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("L'HUMIDIT\u00c9 MAXIMUM DOIT \u00caTRE SUP\u00c9RIEURE OU \u00c9GALE \u00c0 L'HUMIDIT\u00c9 MINIMUM");
            JOptionPane.showMessageDialog(this, msg, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("INFORMATION ERRON\u00c9E"), -1);
        }
    }

    private void jTextFieldPrixCaretUpdate(CaretEvent evt) {
        this.TestContentField();
    }

    private void jTextFieldPrixFocusLost(FocusEvent evt) {
        this.CoutIsHumiditeOk();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SechageGrainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SechageGrainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SechageGrainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SechageGrainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setContentPane(new SechageGrainPanel());
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    MouseListener,
    CaretListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SechageGrainPanel.this.saveButton) {
                SechageGrainPanel.this.saveButtonActionPerformed(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.refreshButton) {
                SechageGrainPanel.this.refreshButtonActionPerformed(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.newButton) {
                SechageGrainPanel.this.newButtonActionPerformed(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.deleteButton) {
                SechageGrainPanel.this.deleteButtonActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == SechageGrainPanel.this.jTextFieldHumiMin) {
                SechageGrainPanel.this.jTextFieldHumiMinFocusLost(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.jTextFieldHumiMax) {
                SechageGrainPanel.this.jTextFieldHumiMaxFocusLost(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.jTextFieldPrix) {
                SechageGrainPanel.this.jTextFieldPrixFocusLost(evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == SechageGrainPanel.this.masterTableA) {
                SechageGrainPanel.this.masterTableAMouseClicked(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.masterTableB) {
                SechageGrainPanel.this.masterTableBMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void caretUpdate(CaretEvent evt) {
            if (evt.getSource() == SechageGrainPanel.this.jTextFieldHumiMin) {
                SechageGrainPanel.this.jTextFieldHumiMinCaretUpdate(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.jTextFieldHumiMax) {
                SechageGrainPanel.this.jTextFieldHumiMaxCaretUpdate(evt);
            } else if (evt.getSource() == SechageGrainPanel.this.jTextFieldPrix) {
                SechageGrainPanel.this.jTextFieldPrixCaretUpdate(evt);
            }
        }
    }
}

