/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Crop;
import DataBase.Dh;
import DataBase.Pesticides;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import modules.DhDatabaseMod;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class DhForm
extends JPanel {
    private JComboBox CultureDHjComboBox;
    private JLabel CultureDHjLabel;
    private JButton DHdeleteButton;
    private List<Dh> DHlist;
    private JTable DHmasterTable;
    private JButton DHnewButton;
    private Query DHquery;
    private JButton DHsaveButton;
    private JComboBox PesticideDHjComboBox;
    private JLabel PesticideDHjLabel;
    private JComboBox UniteDHjComboBox;
    private JTextField dhField;
    private JLabel dhLabel;
    private EntityManager entityManager;
    private JScrollPane masterScrollPaneDH;
    private JButton refreshButton;
    private JLabel uniteLabel;
    private BindingGroup bindingGroup;

    public DhForm() {
        this.initComponents();
        if (!Beans.isDesignTime()) {
            this.entityManager.getTransaction().begin();
        }
        this.InitListDHUnit();
        this.InitListIphyDH();
        this.InitCropDHList();
    }

    private void InitListDHUnit() {
        DhDatabaseMod DHtoolDB = new DhDatabaseMod();
        List DHDataView = DHtoolDB.GetDhUnitList();
        this.UniteDHjComboBox.removeAll();
        if (!DHDataView.isEmpty()) {
            for (Object D : DHDataView) {
                this.UniteDHjComboBox.addItem(D);
            }
        }
    }

    private void InitCropDHList() {
        this.CultureDHjComboBox.removeAllItems();
        this.CultureDHjComboBox.addItem("");
        List CropList = this.entityManager.createQuery("SELECT c FROM Crop c").getResultList();
        if (!CropList.isEmpty()) {
            for (Crop Cr : CropList) {
                this.CultureDHjComboBox.addItem(Cr.getName());
            }
        }
        this.CultureDHjComboBox.setSelectedIndex(0);
    }

    private void InitListIphyDH() {
        Query MyQuery = this.entityManager.createNamedQuery("Pesticides.findAll");
        this.PesticideDHjComboBox.removeAllItems();
        this.PesticideDHjComboBox.addItem("");
        List IphyList = MyQuery.getResultList();
        if (!IphyList.isEmpty()) {
            for (Pesticides Iphy : IphyList) {
                this.PesticideDHjComboBox.addItem(Iphy.getNompesticide());
            }
        }
        this.PesticideDHjComboBox.setSelectedIndex(0);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.DHquery = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT d FROM Dh d");
        this.DHlist = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.DHquery.getResultList());
        this.masterScrollPaneDH = new JScrollPane();
        this.DHmasterTable = new JTable();
        this.dhLabel = new JLabel();
        this.uniteLabel = new JLabel();
        this.dhField = new JTextField();
        this.DHsaveButton = new JButton();
        this.refreshButton = new JButton();
        this.DHnewButton = new JButton();
        this.DHdeleteButton = new JButton();
        this.PesticideDHjComboBox = new JComboBox();
        this.CultureDHjComboBox = new JComboBox();
        this.UniteDHjComboBox = new JComboBox();
        this.PesticideDHjLabel = new JLabel();
        this.CultureDHjLabel = new JLabel();
        FormListener formListener = new FormListener();
        this.DHmasterTable.setFont(new Font("Arial", 0, 13));
        JTableBinding<Dh, List<Dh>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.DHlist, this.DHmasterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idpest.nompesticide}"));
        columnBinding.setColumnName("Pesticide");
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${dh}"));
        columnBinding.setColumnName("Doses homologu\u00e9es");
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${unite}"));
        columnBinding.setColumnName("Unite");
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idcult.name}"));
        columnBinding.setColumnName("Culture");
        columnBinding.setColumnClass(String.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterScrollPaneDH.setViewportView(this.DHmasterTable);
        this.DHmasterTable.getColumnModel().getColumn(1).setMinWidth(110);
        this.DHmasterTable.getColumnModel().getColumn(1).setPreferredWidth(110);
        this.DHmasterTable.getColumnModel().getColumn(1).setMaxWidth(110);
        this.DHmasterTable.getColumnModel().getColumn(2).setMinWidth(50);
        this.DHmasterTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.DHmasterTable.getColumnModel().getColumn(2).setMaxWidth(50);
        this.dhLabel.setFont(new Font("Arial", 0, 13));
        this.dhLabel.setText(bundle.getString("DOSE HOMOLOGU\u00c9E:"));
        this.uniteLabel.setFont(new Font("Arial", 0, 13));
        this.uniteLabel.setText(bundle.getString("UNITE:"));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.DHmasterTable, ELProperty.create("${selectedElement.dh}"), this.dhField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.DHmasterTable, ELProperty.create("${selectedElement != null}"), this.dhField, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.DHsaveButton.setText(bundle.getString("SAVE"));
        this.DHsaveButton.addActionListener(formListener);
        this.refreshButton.setText(bundle.getString("REFRESH"));
        this.refreshButton.addActionListener(formListener);
        this.DHnewButton.setText(bundle.getString("NEW"));
        this.DHnewButton.addActionListener(formListener);
        this.DHdeleteButton.setText(bundle.getString("DELETE"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.DHmasterTable, ELProperty.create("${selectedElement != null}"), this.DHdeleteButton, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.DHdeleteButton.addActionListener(formListener);
        this.PesticideDHjComboBox.setName("PesticideDHjComboBox");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.DHmasterTable, ELProperty.create("${selectedElement.idpest.nompesticide}"), this.PesticideDHjComboBox, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.CultureDHjComboBox.setName("CultureDHjComboBox");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.DHmasterTable, ELProperty.create("${selectedElement.idcult.name}"), this.CultureDHjComboBox, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.UniteDHjComboBox.setName("UniteDHjComboBox");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.DHmasterTable, ELProperty.create("${selectedElement.unite}"), this.UniteDHjComboBox, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.PesticideDHjLabel.setFont(new Font("Arial", 0, 13));
        this.PesticideDHjLabel.setText(bundle.getString("PESTICIDE :"));
        this.PesticideDHjLabel.setName("PesticideDHjLabel");
        this.CultureDHjLabel.setFont(new Font("Arial", 0, 13));
        this.CultureDHjLabel.setText(bundle.getString("CULTURE :"));
        this.CultureDHjLabel.setName("CultureDHjLabel");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.PesticideDHjLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.PesticideDHjComboBox, 0, 332, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DHsaveButton).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(221, Short.MAX_VALUE).addComponent(this.DHnewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DHdeleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshButton).addGap(87, 87, 87)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.dhLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dhField, -2, 34, -2).addGap(12, 12, 12).addComponent(this.uniteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UniteDHjComboBox, -2, 69, -2).addContainerGap(203, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.masterScrollPaneDH, -1, 444, Short.MAX_VALUE).addContainerGap(40, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.CultureDHjLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.CultureDHjComboBox, 0, 334, Short.MAX_VALUE).addGap(87, 87, 87)));
        layout.linkSize(0, this.DHdeleteButton, this.DHnewButton, this.DHsaveButton, this.refreshButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.masterScrollPaneDH, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PesticideDHjLabel).addComponent(this.PesticideDHjComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uniteLabel).addComponent(this.UniteDHjComboBox, -2, -1, -2).addComponent(this.dhLabel).addComponent(this.dhField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CultureDHjComboBox, -2, -1, -2).addComponent(this.CultureDHjLabel)).addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.DHsaveButton).addComponent(this.refreshButton).addComponent(this.DHdeleteButton).addComponent(this.DHnewButton)).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.DHquery.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.DHlist.clear();
        this.DHlist.addAll(data);
    }

    private void DHdeleteButtonActionPerformed(ActionEvent evt) {
        int[] selected = this.DHmasterTable.getSelectedRows();
        ArrayList<Dh> toRemove = new ArrayList<Dh>(selected.length);
        for (int idx = 0; idx < selected.length; ++idx) {
            Dh d = this.DHlist.get(this.DHmasterTable.convertRowIndexToModel(selected[idx]));
            toRemove.add(d);
            this.entityManager.remove((Object)d);
        }
        this.DHlist.removeAll(toRemove);
    }

    private void DHnewButtonActionPerformed(ActionEvent evt) {
        Dh d = new Dh();
        this.entityManager.persist((Object)d);
        this.DHlist.add(d);
        int row = this.DHlist.size() - 1;
        this.DHmasterTable.setRowSelectionInterval(row, row);
        this.DHmasterTable.scrollRectToVisible(this.DHmasterTable.getCellRect(row, 0, true));
    }

    private void DHsaveButtonActionPerformed(ActionEvent evt) {
        try {
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
        }
        catch (RollbackException rex) {
            rex.printStackTrace();
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.DHlist.size());
            for (Dh d : this.DHlist) {
                merged.add(this.entityManager.merge((Object)d));
            }
            this.DHlist.clear();
            this.DHlist.addAll(merged);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setContentPane(new DhForm());
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DhForm.this.DHsaveButton) {
                DhForm.this.DHsaveButtonActionPerformed(evt);
            } else if (evt.getSource() == DhForm.this.refreshButton) {
                DhForm.this.refreshButtonActionPerformed(evt);
            } else if (evt.getSource() == DhForm.this.DHnewButton) {
                DhForm.this.DHnewButtonActionPerformed(evt);
            } else if (evt.getSource() == DhForm.this.DHdeleteButton) {
                DhForm.this.DHdeleteButtonActionPerformed(evt);
            }
        }
    }
}

