/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Crop;
import DataBase.Nmr;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.Beans;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modules.CultureMod;
import modules.LasyTools;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class NmrPanel
extends JPanel {
    private JButton deleteButton;
    private EntityManager entityManager;
    private JComboBox jComboBoxDevRes;
    private JComboBox jComboBoxdateNres;
    private JLabel jLabel1;
    private JLabel jLabelDevRes;
    private JLabel jLabelValeurNres;
    private JLabel jLabeldateNres;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldValeurNres;
    private List<Nmr> list;
    private List<Crop> listcrop;
    private JScrollPane masterScrollPaneCrop;
    private JTable masterTableA;
    private JTable masterTableB;
    private JButton newButton;
    private Query query;
    private Query querycrop;
    private JButton refreshButton;
    private JButton saveButton;
    private BindingGroup bindingGroup;

    public NmrPanel() {
        this.initComponents();
        if (!Beans.isDesignTime()) {
            this.entityManager.getTransaction().begin();
        }
        this.SetTableData(-1);
        this.InitListDateNRes();
        this.EnableElements(false);
        this.newButton.setEnabled(false);
    }

    private void InitListDateNRes() {
        Query MyQuery = this.entityManager.createQuery("SELECT DISTINCT n.datenres FROM Nmr n");
        List NmrDataView = MyQuery.getResultList();
        this.jComboBoxdateNres.removeAllItems();
        for (Object Nres : NmrDataView) {
            if (Nres.equals("Export\u00e9s")) continue;
            this.jComboBoxdateNres.addItem(Nres);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT n FROM Nmr n ORDER BY n.culture");
        this.querycrop = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT c FROM Crop c ORDER BY c.name");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.listcrop = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.querycrop.getResultList());
        this.masterScrollPaneCrop = new JScrollPane();
        this.masterTableA = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.masterTableB = new JTable();
        this.jComboBoxDevRes = new JComboBox();
        this.jLabelDevRes = new JLabel();
        this.jComboBoxdateNres = new JComboBox();
        this.jLabeldateNres = new JLabel();
        this.jTextFieldValeurNres = new JTextField();
        this.jLabelValeurNres = new JLabel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.saveButton = new JButton();
        this.refreshButton = new JButton();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(76, 76, 76));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                NmrPanel.this.formComponentShown(evt);
            }
        });
        this.masterScrollPaneCrop.setName("masterScrollPaneCrop");
        this.masterTableA.setCursor(new Cursor(12));
        this.masterTableA.setName("masterTableA");
        this.masterTableA.setSelectionMode(0);
        this.masterTableA.getTableHeader().setReorderingAllowed(false);
        JTableBinding<Serializable, List<Serializable>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.listcrop, this.masterTableA);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${name}"));
        columnBinding.setColumnName("Culture");
        columnBinding.setColumnClass(String.class);
        columnBinding.setEditable(false);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idcult}"));
        columnBinding.setColumnName("id");
        columnBinding.setColumnClass(Integer.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTableA.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NmrPanel.this.masterTableAMouseClicked(evt);
            }
        });
        this.masterTableA.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                NmrPanel.this.masterTableAMouseMoved(evt);
            }
        });
        this.masterScrollPaneCrop.setViewportView(this.masterTableA);
        this.masterTableA.getColumnModel().getColumn(1).setMinWidth(1);
        this.masterTableA.getColumnModel().getColumn(1).setPreferredWidth(1);
        this.masterTableA.getColumnModel().getColumn(1).setMaxWidth(1);
        this.jScrollPane1.setName("jScrollPane1");
        this.masterTableB.setCursor(new Cursor(12));
        this.masterTableB.setName("masterTableB");
        this.masterTableB.setSelectionMode(0);
        this.masterTableB.getTableHeader().setReorderingAllowed(false);
        jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTableB);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${devenirresidus}"));
        columnBinding.setColumnName("Devenir des r\u00e9sidus ");
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${datenres}"));
        columnBinding.setColumnName("Date de gestion ");
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${valeurnres}"));
        columnBinding.setColumnName("N restitu\u00e9 ");
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${culture}"));
        columnBinding.setColumnName("crop");
        columnBinding.setColumnClass(String.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTableB.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NmrPanel.this.masterTableBMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.masterTableB);
        this.masterTableB.getColumnModel().getColumn(3).setMinWidth(1);
        this.masterTableB.getColumnModel().getColumn(3).setPreferredWidth(1);
        this.masterTableB.getColumnModel().getColumn(3).setMaxWidth(1);
        this.jComboBoxDevRes.setFont(new Font("Verdana", 0, 12));
        this.jComboBoxDevRes.setModel(new DefaultComboBoxModel<String>(new String[]{"Br\u00fbl\u00e9s", "Enfouis", "Enfouis broy\u00e9s", "Enfouis, repousses favoris\u00e9es", "Export\u00e9s", "Export\u00e9s, repousses favoris\u00e9es", "Fauch\u00e9s", "Fauch\u00e9s ou p\u00e2tur\u00e9s", "Jach\u00e8re enfouie", "Jach\u00e8re mulch\u00e9e", "Mulch "}));
        this.jComboBoxDevRes.setName("jComboBoxDevRes");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTableB, ELProperty.create("${selectedElement.devenirresidus}"), this.jComboBoxDevRes, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxDevRes.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                NmrPanel.this.jComboBoxDevResPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.jLabelDevRes.setFont(new Font("Arial", 0, 12));
        this.jLabelDevRes.setForeground(Color.white);
        this.jLabelDevRes.setText(bundle.getString("DEVENIR DES R\u00c9SIDUS "));
        this.jLabelDevRes.setName("jLabelDevRes");
        this.jComboBoxdateNres.setFont(new Font("Verdana", 0, 12));
        this.jComboBoxdateNres.setModel(new DefaultComboBoxModel<String>(new String[]{"Sans incidence", "Printemps", "Avant 1/9", "Apr\u00e8s 1/10"}));
        this.jComboBoxdateNres.setName("jComboBoxdateNres");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTableB, ELProperty.create("${selectedElement.datenres}"), this.jComboBoxdateNres, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxdateNres.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                NmrPanel.this.jComboBoxdateNresPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.jLabeldateNres.setFont(new Font("Arial", 0, 12));
        this.jLabeldateNres.setForeground(Color.white);
        this.jLabeldateNres.setText(bundle.getString("DATE DE GESTION "));
        this.jLabeldateNres.setName("jLabeldateNres");
        this.jTextFieldValeurNres.setFont(new Font("Verdana", 0, 12));
        this.jTextFieldValeurNres.setName("jTextFieldValeurNres");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTableB, ELProperty.create("${selectedElement.valeurnres}"), this.jTextFieldValeurNres, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.jTextFieldValeurNres.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                NmrPanel.this.jTextFieldValeurNresCaretUpdate(evt);
            }
        });
        this.jTextFieldValeurNres.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NmrPanel.this.jTextFieldValeurNresFocusLost(evt);
            }
        });
        this.jLabelValeurNres.setFont(new Font("Arial", 0, 12));
        this.jLabelValeurNres.setForeground(Color.white);
        this.jLabelValeurNres.setText(bundle.getString("N RESTITU\u00c9 (KG N/HA)"));
        this.jLabelValeurNres.setName("jLabelValeurNres");
        this.newButton.setFont(new Font("Verdana", 1, 12));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.newButton.setText(bundle.getString("AJOUTER"));
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.setName("newButton");
        this.newButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NmrPanel.this.newButtonMouseReleased(evt);
            }
        });
        this.deleteButton.setFont(new Font("Verdana", 1, 12));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.deleteButton.setText(bundle.getString("SUPPRIMER"));
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NmrPanel.this.deleteButtonMouseReleased(evt);
            }
        });
        this.saveButton.setFont(new Font("Verdana", 1, 12));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setName("saveButton");
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NmrPanel.this.saveButtonMouseReleased(evt);
            }
        });
        this.refreshButton.setFont(new Font("Verdana", 1, 12));
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome 2.png")));
        this.refreshButton.setText(bundle.getString("ANNULER"));
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NmrPanel.this.refreshButtonMouseReleased(evt);
            }
        });
        this.jLabel1.setFont(new Font("Verdana", 1, 14));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(bundle.getString("MIN\u00c9RALISATION DES R\u00c9SIDUS"));
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setName("jLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDevRes).addComponent(this.jLabeldateNres)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxdateNres, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxDevRes, -2, 151, -2)).addGap(18, 18, 18).addComponent(this.jLabelValeurNres).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldValeurNres, -2, 44, -2)).addGroup(layout.createSequentialGroup().addComponent(this.masterScrollPaneCrop, -2, 175, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 337, -2)))).addGroup(layout.createSequentialGroup().addGap(80, 80, 80).addComponent(this.jLabel1, -2, 358, -2))).addContainerGap(15, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.newButton, -2, 110, -2).addGap(18, 18, 18).addComponent(this.deleteButton, -2, 110, -2).addGap(18, 18, 18).addComponent(this.refreshButton, -2, 110, -2).addGap(18, 18, 18).addComponent(this.saveButton, -2, 110, -2).addContainerGap(27, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jLabel1, -2, 27, -2).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.masterScrollPaneCrop, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 224, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxDevRes, -2, 20, -2).addComponent(this.jLabelDevRes)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxdateNres, -2, 20, -2).addComponent(this.jLabeldateNres).addComponent(this.jTextFieldValeurNres, -2, 20, -2).addComponent(this.jLabelValeurNres)).addContainerGap(57, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(387, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton, -2, 20, -2).addComponent(this.deleteButton, -2, 20, -2).addComponent(this.refreshButton, -2, 20, -2).addComponent(this.saveButton, -2, 20, -2)).addContainerGap())));
        this.bindingGroup.bind();
    }

    private void jTextFieldValeurNresFocusLost(FocusEvent evt) {
        this.TestContentField();
    }

    private void newButtonMouseReleased(MouseEvent evt) {
        if (this.newButton.isEnabled()) {
            this.New();
            this.jComboBoxDevRes.requestFocus();
        }
    }

    private void deleteButtonMouseReleased(MouseEvent evt) {
        if (this.deleteButton.isEnabled()) {
            this.Delete();
        }
    }

    private void saveButtonMouseReleased(MouseEvent evt) {
        if (this.saveButton.isEnabled()) {
            this.Save();
            this.ReinitElements();
            this.EnableElements(false);
            this.masterTableB.requestFocus();
            this.newButton.setEnabled(false);
            this.masterTableA.getSelectionModel().clearSelection();
            this.list.clear();
        }
    }

    private void refreshButtonMouseReleased(MouseEvent evt) {
        this.Refresh();
        this.ReinitElements();
        this.EnableElements(false);
        this.newButton.setEnabled(false);
    }

    private void masterTableAMouseClicked(MouseEvent evt) {
        this.list.clear();
        this.ReinitElements();
        this.SetCurrentData();
        this.Update();
        this.EnableElements(false);
        this.newButton.setEnabled(true);
    }

    private void masterTableBMouseClicked(MouseEvent evt) {
        this.EnableElements(true);
    }

    private void jComboBoxDevResPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        try {
            if (this.masterTableB.getSelectedRow() >= 0 && !this.jComboBoxDevRes.getSelectedItem().toString().isEmpty()) {
                this.masterTableB.setValueAt(this.jComboBoxDevRes.getSelectedItem().toString(), this.masterTableB.getSelectedRow(), 0);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private void jComboBoxdateNresPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        try {
            if (this.masterTableB.getSelectedRow() >= 0 && !this.jComboBoxdateNres.getSelectedItem().toString().isEmpty()) {
                this.masterTableB.setValueAt(this.jComboBoxdateNres.getSelectedItem().toString(), this.masterTableB.getSelectedRow(), 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private void jTextFieldValeurNresCaretUpdate(CaretEvent evt) {
        try {
            if (this.masterTableB.getSelectedRow() >= 0 && !this.jTextFieldValeurNres.getText().isEmpty()) {
                this.masterTableB.setValueAt(this.jTextFieldValeurNres.getText().toString(), this.masterTableB.getSelectedRow(), 2);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private void masterTableAMouseMoved(MouseEvent evt) {
    }

    private void formComponentShown(ComponentEvent evt) {
        this.EnableElements(false);
    }

    private void ReinitElements() {
        this.jComboBoxDevRes.setSelectedItem("");
        this.jComboBoxdateNres.setSelectedItem("");
        this.jTextFieldValeurNres.setText("");
    }

    private void EnableElements(boolean Statut) {
        this.jComboBoxDevRes.setEnabled(Statut);
        this.jComboBoxdateNres.setEnabled(Statut);
        this.jTextFieldValeurNres.setEnabled(Statut);
        this.newButton.setEnabled(true);
        this.refreshButton.setEnabled(Statut);
        this.saveButton.setEnabled(Statut);
        this.deleteButton.setEnabled(Statut);
    }

    private void TestContentField() {
        LasyTools tool = new LasyTools();
        String msgNumeric = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CHAMPS_NUM\u00c9RIQUE");
        String msgStr = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CHAMPS_CARACTERES");
        if (!this.jTextFieldValeurNres.getText().isEmpty()) {
            if (!tool.ThisFieldIsNumeric(this.jTextFieldValeurNres)) {
                JOptionPane.showMessageDialog(this, msgStr, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("FORMAT INCORRECT"), 0);
                this.jTextFieldValeurNres.setForeground(Color.red);
                this.jTextFieldValeurNres.requestFocus();
            } else {
                this.jTextFieldValeurNres.setForeground(Color.BLACK);
            }
        }
    }

    private void SetCurrentData() {
        String CropSelected = "";
        try {
            CropSelected = this.masterTableA.getValueAt(this.masterTableA.getSelectedRow(), 0).toString();
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException ext) {
            CropSelected = "";
        }
        if (!CropSelected.isEmpty() && CropSelected.length() > 0) {
            CultureMod CropMod = new CultureMod();
            String Abrev = "";
            Abrev = CropMod.ReturnCultureAbrev(CropSelected);
            String SQL = "SELECT n FROM Nmr n WHERE n.culture = '" + Abrev + "'";
            this.query = this.entityManager.createQuery(SQL);
        }
    }

    private void SetTableData(int CropIdSelected) {
        int CurrentIdCrop = 0;
        int compteur = 0;
        boolean FirstBoucleOk = false;
        CultureMod CropMod = new CultureMod();
        List Selection = new ArrayList();
        String SQL = "SELECT n FROM Nmr n";
        Selection = this.entityManager.createQuery(SQL).getResultList();
        for (Nmr f : Selection) {
            try {
                CurrentIdCrop = CropMod.GetIdCultByAbrevCult(f.getCulture());
                if (CurrentIdCrop == 0) {
                    CurrentIdCrop = CropMod.GetIdCultByNameCult(f.getCulture());
                }
                if (CurrentIdCrop == 0) {
                    System.out.println("La culture ne contient pas d'abreviation (Interface Min\u00e9ralisation des r\u00e9sidus)\n Veuillez renseigner l'abreviation pour l'enregistrement [idNres=" + f.getIdnres() + "]");
                    CurrentIdCrop = -1;
                }
            }
            catch (NullPointerException exe) {
                CurrentIdCrop = -1;
            }
            if (CurrentIdCrop == CropIdSelected && CurrentIdCrop > 0) {
                if (compteur >= 86) break;
                if (Selection.size() == 1) {
                    SQL = SQL + " WHERE n.idnres = " + f.getIdnres();
                    FirstBoucleOk = true;
                } else if (!FirstBoucleOk) {
                    SQL = SQL + " WHERE n.idnres = " + f.getIdnres();
                    FirstBoucleOk = true;
                } else {
                    SQL = SQL + " OR n.idnres = " + f.getIdnres();
                }
                ++compteur;
            }
            CurrentIdCrop = -1;
        }
        if (!FirstBoucleOk) {
            SQL = "SELECT n FROM Nmr n WHERE n.idnres = -1";
            this.EnableElements(false);
        }
        SQL = SQL + " ORDER BY n.culture";
        this.newButton.setEnabled(true);
        this.query = this.entityManager.createQuery(SQL);
        this.Refresh();
    }

    private void Refresh() {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void Update() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void Save() {
        try {
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            this.Refresh();
            this.SetCurrentData();
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ENREGISTREMENT REUSSI !"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CONFIRMATION DE SAUVEGARDE"), 1);
        }
        catch (RollbackException rex) {
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
            for (Nmr n : this.list) {
                merged.add(this.entityManager.merge((Object)n));
            }
            this.list.clear();
            this.list.addAll(merged);
        }
    }

    private void New() {
        Nmr n = new Nmr();
        this.entityManager.persist((Object)n);
        this.list.add(n);
        int row = this.list.size() - 1;
        this.masterTableB.setRowSelectionInterval(row, row);
        this.masterTableB.scrollRectToVisible(this.masterTableB.getCellRect(row, 0, true));
        int idcrop = 0;
        try {
            LasyTools tools = new LasyTools();
            idcrop = tools.SetAsA_Int(this.masterTableA.getValueAt(this.masterTableA.getSelectedRow(), 1).toString());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException | ParseException ext) {
            idcrop = 0;
        }
        if (idcrop != 0) {
            CultureMod CropT = new CultureMod();
            Crop Crop2 = (Crop)this.entityManager.find(Crop.class, (Object)idcrop);
            try {
                this.masterTableB.setValueAt(Crop2.getAbreviation(), row, 3);
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException ext) {
                System.out.println("La culture n'a pas \u00e9t\u00e9 r\u00e9cup\u00e9r\u00e9e lors de la selection (Interface Min\u00e9ralisation des r\u00e9sidus)");
            }
        }
        this.EnableElements(true);
    }

    private void Delete() {
        int choix;
        if (this.deleteButton.isEnabled() && (choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VEUILLEZ CONFIRMER LA SUPPRESSION DE CET ENREGISTREMENT"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("SUPPRESSION"), 2)) == 0) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            int[] selected = this.masterTableB.getSelectedRows();
            ArrayList<Nmr> toRemove = new ArrayList<Nmr>(selected.length);
            for (int idx = 0; idx < selected.length; ++idx) {
                Nmr r = this.list.get(this.masterTableB.convertRowIndexToModel(selected[idx]));
                toRemove.add(r);
                this.entityManager.remove((Object)r);
            }
            this.list.removeAll(toRemove);
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            this.EnableElements(false);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NmrPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(NmrPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NmrPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(NmrPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setContentPane(new NmrPanel());
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

