/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.exceptions;

import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.exceptions.i18n.ExceptionMessageGenerator;

public class EntityManagerSetupException
extends TopLinkException {
    public static final int SESSIONS_XML_VALIDATION_EXCEPTION = 28001;
    public static final int WRONG_SESSION_TYPE_EXCEPTION = 28002;
    public static final int MISSING_SERVER_PLATFORM_EXCEPTION = 28003;
    public static final int ERROR_IN_SETUP_OF_EM = 28004;
    public static final int EXCEPTION_IN_SETUP_OF_EM = 28005;
    public static final int CLASS_NOT_FOUND_FOR_PROPERTY = 28006;
    public static final int FAILED_TO_INSTANTIATE_SERVER_PLATFORM = 28007;
    public static final int CLASS_NOT_FOUND_WHILE_PROCESSING_ANNOTATIONS = 28008;
    public static final int ATTEMPTED_REDEPLOY_WITHOUT_CLOSE = 28009;
    public static final int JTA_PERSISTENCE_UNIT_INFO_MISSING_JTA_DATA_SOURCE = 28010;
    public static final int SESSION_REMOVED_DURING_DEPLOYMENT = 28011;
    public static final int WRONG_PROPERTY_VALUE_TYPE = 28012;
    public static final int CANNOT_DEPLOY_WITHOUT_PREDEPLOY = 28013;
    public static final int FAILED_WHILE_PROCESSING_PROPERTY = 28014;
    public static final int FAILED_TO_INSTANTIATE_LOGGER = 28015;
    public static final int PU_NOT_EXIST = 28016;
    public static final int CANNOT_PREDEPLOY = 28017;
    public static final int PREDEPLOY_FAILED = 28018;
    public static final int DEPLOY_FAILED = 28019;
    public static final int WRONG_WEAVING_PROPERTY_VALUE = 28020;

    public EntityManagerSetupException() {
    }

    protected EntityManagerSetupException(String message) {
        super(message);
    }

    protected EntityManagerSetupException(String message, Throwable internalException) {
        super(message);
        this.setInternalException(internalException);
    }

    public static EntityManagerSetupException attemptedRedeployWithoutClose(String sessionName) {
        Object[] args = new Object[]{sessionName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28009, args));
        setupException.setErrorCode(28009);
        return setupException;
    }

    public static EntityManagerSetupException missingServerPlatformException(String sessionName, String xmlFileName) {
        Object[] args = new Object[]{sessionName, xmlFileName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28003, args));
        setupException.setErrorCode(28003);
        return setupException;
    }

    public static EntityManagerSetupException sessionRemovedDuringDeployment(String sessionName) {
        Object[] args = new Object[]{sessionName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28011, args));
        setupException.setErrorCode(28011);
        return setupException;
    }

    public static EntityManagerSetupException sessionXMLValidationException(String sessionName, String xmlFileName, ValidationException exception) {
        Object[] args = new Object[]{sessionName, xmlFileName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28001, args), exception);
        setupException.setErrorCode(28001);
        return setupException;
    }

    public static EntityManagerSetupException wrongSessionTypeException(String sessionName, String xmlFileName, Exception exception) {
        Object[] args = new Object[]{sessionName, xmlFileName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28002, args), exception);
        setupException.setErrorCode(28002);
        return setupException;
    }

    public static EntityManagerSetupException errorInSetupOfEM() {
        Object[] args = new Object[]{};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28004, args));
        setupException.setErrorCode(28004);
        return setupException;
    }

    public static EntityManagerSetupException exceptionInSetupOfEM(Exception exception) {
        Object[] args = new Object[]{};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28005, args), exception);
        setupException.setErrorCode(28005);
        return setupException;
    }

    public static EntityManagerSetupException classNotFoundForProperty(String className, String propertyName, Exception exception) {
        Object[] args = new Object[]{className, propertyName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28006, args), exception);
        setupException.setErrorCode(28006);
        return setupException;
    }

    public static EntityManagerSetupException failedToInstantiateServerPlatform(String serverPlatformClass, String serverPlatformString, Exception exception) {
        Object[] args = new Object[]{serverPlatformClass, serverPlatformString};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28007, args), exception);
        setupException.setErrorCode(28007);
        return setupException;
    }

    public static EntityManagerSetupException classNotFoundWhileProcessingAnnotations(String className, Exception exception) {
        Object[] args = new Object[]{className};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28008, args), exception);
        setupException.setErrorCode(28008);
        return setupException;
    }

    public static EntityManagerSetupException jtaPersistenceUnitInfoMissingJtaDataSource(String persistenceUnitInfoName) {
        Object[] args = new Object[]{persistenceUnitInfoName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28010, args));
        setupException.setErrorCode(28010);
        return setupException;
    }

    public static EntityManagerSetupException wrongPropertyValueType(String value, String expectedType, String propertyName) {
        Object[] args = new Object[]{value, expectedType, propertyName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28012, args));
        setupException.setErrorCode(28012);
        return setupException;
    }

    public static EntityManagerSetupException cannotDeployWithoutPredeploy(String persistenceUnitName, String state) {
        Object[] args = new Object[]{persistenceUnitName, state};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28013, args));
        setupException.setErrorCode(28013);
        return setupException;
    }

    public static EntityManagerSetupException failedWhileProcessingProperty(String propertyName, String propertyValue, Exception exception) {
        Object[] args = new Object[]{propertyName, propertyValue};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28014, args), exception);
        setupException.setErrorCode(28014);
        return setupException;
    }

    public static EntityManagerSetupException failedToInstantiateLogger(String loggerClassName, String propertyName, Exception exception) {
        Object[] args = new Object[]{loggerClassName, propertyName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28015, args), exception);
        setupException.setErrorCode(28015);
        return setupException;
    }

    public static EntityManagerSetupException puNotExist(String puName) {
        Object[] args = new Object[]{puName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28016, args));
        setupException.setErrorCode(28016);
        return setupException;
    }

    public static EntityManagerSetupException cannotPredeploy(String persistenceUnitName, String state) {
        Object[] args = new Object[]{persistenceUnitName, state};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28017, args));
        setupException.setErrorCode(28017);
        return setupException;
    }

    public static EntityManagerSetupException predeployFailed(String persistenceUnitName, RuntimeException exception) {
        Object[] args = new Object[]{persistenceUnitName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28018, args), exception);
        setupException.setErrorCode(28018);
        return setupException;
    }

    public static EntityManagerSetupException deployFailed(String persistenceUnitName, RuntimeException exception) {
        Object[] args = new Object[]{persistenceUnitName};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28019, args), exception);
        setupException.setErrorCode(28019);
        return setupException;
    }

    public static EntityManagerSetupException wrongWeavingPropertyValue() {
        Object[] args = new Object[]{};
        EntityManagerSetupException setupException = new EntityManagerSetupException(ExceptionMessageGenerator.buildMessage(EntityManagerSetupException.class, 28020, args));
        setupException.setErrorCode(28020);
        return setupException;
    }
}

