/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables;

import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataTable;

public class MetadataSecondaryTable
extends MetadataTable {
    private PrimaryKeyJoinColumn[] m_pkJoinColumns;
    protected MetadataPrimaryKeyJoinColumns m_primaryKeyJoinColumns = null;

    public MetadataSecondaryTable(MetadataLogger logger) {
        super(logger);
    }

    public MetadataSecondaryTable(SecondaryTable secondaryTable, MetadataLogger logger) {
        this(logger);
        if (secondaryTable != null) {
            this.m_name = secondaryTable.name();
            this.m_schema = secondaryTable.schema();
            this.m_catalog = secondaryTable.catalog();
            this.m_pkJoinColumns = secondaryTable.pkJoinColumns();
            this.processName();
            this.processUniqueConstraints(secondaryTable.uniqueConstraints());
        }
    }

    public String getCatalogContext() {
        return "metadata_default_secondary_table_catalog";
    }

    public String getNameContext() {
        return "metadata_default_secondary_table_name";
    }

    public MetadataPrimaryKeyJoinColumns getPrimaryKeyJoinColumns(String sourceTableName) {
        if (this.m_primaryKeyJoinColumns == null) {
            this.processPrimaryKeyJoinColumns(sourceTableName);
        }
        return this.m_primaryKeyJoinColumns;
    }

    public String getSchemaContext() {
        return "metadata_default_secondary_table_schema";
    }

    protected void processPrimaryKeyJoinColumns(String sourceTableName) {
        this.m_primaryKeyJoinColumns = new MetadataPrimaryKeyJoinColumns(this.m_pkJoinColumns, sourceTableName, this.m_databaseTable.getQualifiedName());
    }
}

