/*
 * Decompiled with CFR 0.152.
 */
package modules;

import DataBase.Conduites;
import DataBase.Crop;
import DataBase.Dataconduite;
import DataBase.Dpu;
import DataBase.Herbicideintercropapp;
import DataBase.Ilot;
import DataBase.Meteo;
import DataBase.Parcelle;
import DataBase.Soil;
import DataBase.Sowing;
import DataBase.Technicaloperations;
import DataBase.Tillage;
import DataBase.Tillageintercrop;
import DataBase.Varsglobales;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import modules.LasyTools;

public class ExportSystem {
    EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("CRITERBASE.DB3PU"));
    List NoRedundancySolList = new ArrayList();
    List<Object> CalculSet = new ArrayList<Object>();
    String CurrentPath = System.getProperty("user.dir").toString();
    String DesktopPath = System.getProperty("user.home").toString();
    String templateFileName = this.CurrentPath + "\\System\\Export_Template.xls";
    WritableSheet SelectedSheet;
    WritableWorkbook outWorkbook;
    int lineSoilData = 0;
    int lineIlotData = 0;
    int linePlotData = 0;
    int lineCdtData = 0;
    int lineItineraire = 0;
    int lineResults = 0;

    public boolean ExportSystem(String CurrentDir, int ilotId, List OptionList, boolean redondancy) {
        EntityManager entityManager = this.emf.createEntityManager();
        List ParcelleDataView = entityManager.createQuery("SELECT p FROM Parcelle p WHERE p.idparcelle = -1").getResultList();
        ParcelleDataView.clear();
        ParcelleDataView.addAll(((Ilot)entityManager.find(Ilot.class, (Object)ilotId)).getParcelleCollection());
        this.DesktopPath = CurrentDir;
        String destFileName = this.DesktopPath + "\\Exportsystem.xls";
        Workbook ThisWorkbook = null;
        File fileXls = null;
        boolean addLine = false;
        int item = 0;
        try {
            WorkbookSettings ws = new WorkbookSettings();
            ws.setEncoding("Cp1252");
            FileInputStream xlsRefStream = new FileInputStream(this.templateFileName);
            ThisWorkbook = Workbook.getWorkbook((InputStream)xlsRefStream, (WorkbookSettings)ws);
            fileXls = new File(destFileName);
            this.outWorkbook = Workbook.createWorkbook((File)fileXls, (Workbook)ThisWorkbook);
        }
        catch (IOException | BiffException ex) {
            // empty catch block
        }
        item = 0;
        try {
            if (this.outWorkbook.getSheet(0) == null) {
                return false;
            }
        }
        catch (NullPointerException ex) {
            return false;
        }
        ArrayList<String> SheetListNames = new ArrayList<String>();
        SheetListNames.add("R\u00e9sultats");
        SheetListNames.add("Itin\u00e9raire technique");
        SheetListNames.add("Informations g\u00e9n\u00e9rales");
        SheetListNames.add("Information Syst\u00e8me-Sol");
        SheetListNames.add("Informations Exploitation-Territoire");
        SheetListNames.add("Contexte p\u00e9dologique");
        SheetListNames.add("Lexique");
        for (Object e : SheetListNames) {
            this.SelectedSheet = this.outWorkbook.getSheet(item);
            this.SelectedSheet.setName(e.toString());
            ++item;
        }
        if (OptionList.contains("Informations Exploitation-Territoire")) {
            this.InsertIlotData(ilotId);
        }
        if (!ParcelleDataView.isEmpty()) {
            for (Parcelle parcelle : ParcelleDataView) {
                List CdtView;
                Soil S = parcelle.getSoil();
                if (OptionList.contains("Contexte p\u00e9dologique")) {
                    this.InsertSoilData(S);
                }
                if (OptionList.contains("Informations Syst\u00e8me-Sol")) {
                    this.InsertPlotData(parcelle.getIdparcelle());
                }
                if (OptionList.contains("Informations g\u00e9n\u00e9rales")) {
                    CdtView = entityManager.createQuery("SELECT c FROM Conduites c WHERE c.idcdt = -1").getResultList();
                    CdtView.clear();
                    CdtView.addAll(parcelle.getConduitesCollection());
                    for (Conduites cdt : CdtView) {
                        this.InsertCdtData(cdt.getIdcdt());
                    }
                }
                if (OptionList.contains("Itin\u00e9raire technique")) {
                    CdtView = entityManager.createQuery("SELECT c FROM Conduites c WHERE c.idcdt = -1").getResultList();
                    CdtView.clear();
                    CdtView.addAll(parcelle.getConduitesCollection());
                    for (Conduites cdt : CdtView) {
                        this.InsertItineraireData(cdt.getIdcdt(), redondancy);
                    }
                }
                if (!OptionList.contains("R\u00e9sultats")) continue;
                this.InsertResultsData(parcelle, redondancy, addLine);
                if (addLine) continue;
                addLine = true;
            }
        }
        try {
            ThisWorkbook.close();
            this.outWorkbook.write();
            this.outWorkbook.close();
        }
        catch (IOException | WriteException ex) {
            // empty catch block
        }
        entityManager.clear();
        entityManager.close();
        this.NoRedundancySolList.clear();
        this.CalculSet.clear();
        return true;
    }

    private void InsertSoilData(Soil Sol) {
        int col = 0;
        String Val = "";
        HashMap DataSet = new HashMap();
        if (this.lineSoilData == 0) {
            this.lineSoilData = 2;
        }
        DataSet.putAll(this.GenerateDataSet(Sol.getIdsoil(), 1));
        this.SelectedSheet = this.outWorkbook.getSheet(5);
        Val = this.SelectedSheet.getCell(col, this.lineSoilData).getContents();
        if (Val.isEmpty()) {
            Iterator keySetIterator = DataSet.keySet().iterator();
            try {
                while (keySetIterator.hasNext()) {
                    Integer key = (Integer)keySetIterator.next();
                    try {
                        Label label = new Label(col, this.lineSoilData, DataSet.get(key).toString());
                        this.SelectedSheet.addCell((WritableCell)label);
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    ++col;
                }
            }
            catch (WriteException ex) {
                // empty catch block
            }
        }
        if (!DataSet.isEmpty()) {
            ++this.lineSoilData;
        }
    }

    private void InsertIlotData(int ilot_Id) {
        int col = 0;
        String Val = "";
        HashMap DataSet = new HashMap();
        if (this.lineIlotData == 0) {
            this.lineIlotData = 2;
        }
        DataSet.putAll(this.GenerateDataSet(ilot_Id, 2));
        this.SelectedSheet = this.outWorkbook.getSheet(4);
        Val = this.SelectedSheet.getCell(col, this.lineIlotData).getContents();
        if (Val.isEmpty()) {
            Iterator keySetIterator = DataSet.keySet().iterator();
            try {
                while (keySetIterator.hasNext()) {
                    Integer key = (Integer)keySetIterator.next();
                    try {
                        if (!DataSet.get(key).toString().isEmpty()) {
                            Label label = new Label(col, this.lineIlotData, DataSet.get(key).toString());
                            this.SelectedSheet.addCell((WritableCell)label);
                        }
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    ++col;
                }
            }
            catch (WriteException ex) {
                // empty catch block
            }
        }
        ++this.lineIlotData;
    }

    private void InsertPlotData(int plot_Id) {
        int col = 0;
        String Val = "";
        HashMap DataSet = new HashMap();
        if (this.linePlotData == 0) {
            this.linePlotData = 2;
        }
        DataSet.putAll(this.GenerateDataSet(plot_Id, 3));
        this.SelectedSheet = this.outWorkbook.getSheet(3);
        Val = this.SelectedSheet.getCell(col, this.linePlotData).getContents();
        if (Val.isEmpty()) {
            Iterator keySetIterator = DataSet.keySet().iterator();
            try {
                while (keySetIterator.hasNext()) {
                    Integer key = (Integer)keySetIterator.next();
                    try {
                        if (!DataSet.get(key).toString().isEmpty()) {
                            Label label = new Label(col, this.linePlotData, DataSet.get(key).toString());
                            this.SelectedSheet.addCell((WritableCell)label);
                        }
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    ++col;
                }
            }
            catch (WriteException ex) {
                // empty catch block
            }
        }
        ++this.linePlotData;
    }

    private void InsertCdtData(int cdt_Id) {
        int col = 0;
        String Val = "";
        HashMap DataSet = new HashMap();
        if (this.lineCdtData == 0) {
            this.lineCdtData = 2;
        }
        DataSet.putAll(this.GenerateDataSet(cdt_Id, 4));
        this.SelectedSheet = this.outWorkbook.getSheet(2);
        Val = this.SelectedSheet.getCell(col, this.lineCdtData).getContents();
        if (Val.isEmpty()) {
            Iterator keySetIterator = DataSet.keySet().iterator();
            try {
                while (keySetIterator.hasNext()) {
                    Integer key = (Integer)keySetIterator.next();
                    try {
                        if (!DataSet.get(key).toString().isEmpty()) {
                            Label label = new Label(col, this.lineCdtData, DataSet.get(key).toString());
                            this.SelectedSheet.addCell((WritableCell)label);
                        }
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    ++col;
                }
            }
            catch (WriteException ex) {
                // empty catch block
            }
        }
        ++this.lineCdtData;
    }

    private void InsertItineraireData(int cdt_Id, boolean redondancy) {
        int col = 1;
        int item = 1;
        String Val = "";
        HashMap DataSet = new HashMap();
        if (this.lineItineraire == 0) {
            this.lineItineraire = 2;
        }
        DataSet.putAll(this.GenerateDataSet(cdt_Id, 5));
        this.SelectedSheet = this.outWorkbook.getSheet(1);
        Val = this.SelectedSheet.getCell(col, this.lineItineraire).getContents();
        if (Val.isEmpty()) {
            Iterator keySetIterator = DataSet.keySet().iterator();
            try {
                while (keySetIterator.hasNext()) {
                    Integer key = (Integer)keySetIterator.next();
                    try {
                        if (!DataSet.get(item).toString().isEmpty()) {
                            Label label;
                            if (!redondancy) {
                                if (col == 1 && item > 28 && DataSet.get(item).equals(DataSet.get(item - 29).toString())) {
                                    label = new Label(col, this.lineItineraire, "");
                                    this.SelectedSheet.addCell((WritableCell)label);
                                } else if (col == 2 && item > 29 && DataSet.get(item).equals(DataSet.get(item - 29).toString())) {
                                    label = new Label(col, this.lineItineraire, "");
                                    this.SelectedSheet.addCell((WritableCell)label);
                                } else {
                                    label = new Label(col, this.lineItineraire, DataSet.get(item).toString());
                                    this.SelectedSheet.addCell((WritableCell)label);
                                }
                            } else {
                                label = new Label(col, this.lineItineraire, DataSet.get(item).toString());
                                this.SelectedSheet.addCell((WritableCell)label);
                            }
                        }
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    if (++col == 30) {
                        col = 1;
                        ++this.lineItineraire;
                    }
                    ++item;
                }
            }
            catch (WriteException ex) {
                // empty catch block
            }
        }
    }

    private void InsertResultsData(Parcelle P, boolean redondancy, boolean AddLine) {
        int col = 0;
        int item = 0;
        String Val = "";
        HashMap DataSet = new HashMap();
        boolean InsertLine = false;
        InsertLine = AddLine;
        if (this.lineResults == 0) {
            this.lineResults = 4;
        }
        DataSet.putAll(this.GenerateResults(P));
        this.SelectedSheet = this.outWorkbook.getSheet(0);
        Val = this.SelectedSheet.getCell(col, this.lineResults).getContents();
        if (Val.isEmpty()) {
            Iterator keySetIterator = DataSet.keySet().iterator();
            try {
                while (keySetIterator.hasNext()) {
                    Integer key = (Integer)keySetIterator.next();
                    try {
                        if (!DataSet.get(item).toString().isEmpty()) {
                            Label label;
                            if (!redondancy) {
                                if (col == 0 && item > 66 && DataSet.get(item).equals(DataSet.get(item - 67).toString())) {
                                    if (InsertLine) {
                                        ++this.lineResults;
                                    }
                                    label = new Label(col, this.lineResults, "");
                                    this.SelectedSheet.addCell((WritableCell)label);
                                } else if (col == 1 && item > 69 && DataSet.get(item).equals(DataSet.get(item - 69).toString())) {
                                    label = new Label(col, this.lineResults, "");
                                    this.SelectedSheet.addCell((WritableCell)label);
                                } else {
                                    label = new Label(col, this.lineResults, DataSet.get(item).toString());
                                    this.SelectedSheet.addCell((WritableCell)label);
                                }
                            } else {
                                if (col == 0 && InsertLine) {
                                    ++this.lineResults;
                                }
                                label = new Label(col, this.lineResults, DataSet.get(item).toString());
                                this.SelectedSheet.addCell((WritableCell)label);
                            }
                        }
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    if (++col == 67) {
                        col = 0;
                        ++this.lineResults;
                        if (InsertLine) {
                            InsertLine = false;
                            ++this.lineResults;
                        }
                    }
                    ++item;
                }
            }
            catch (WriteException ex) {
                // empty catch block
            }
        }
    }

    private HashMap GenerateDataSet(int id, int CaseNumber) {
        EntityManager entityManager = this.emf.createEntityManager();
        List ListDataConduite = new ArrayList();
        HashMap<Integer, Object> DataSet = new HashMap<Integer, Object>();
        HashMap TempDataSet = new HashMap();
        int count = 0;
        int Item = 0;
        switch (CaseNumber) {
            case 1: {
                Soil S = (Soil)entityManager.find(Soil.class, (Object)id);
                if (this.NoRedundancySolList.contains(S)) break;
                this.NoRedundancySolList.add(S);
                DataSet.put(1, S.getName());
                DataSet.put(2, S.getTexture());
                DataSet.put(3, S.getApparentdensity());
                DataSet.put(4, S.getBattance());
                DataSet.put(5, S.getDraine());
                DataSet.put(6, S.getHydromorphy());
                DataSet.put(7, S.getRealdepth());
                DataSet.put(8, S.getRu());
                DataSet.put(9, S.getRealclay());
                DataSet.put(10, S.getReallimestone());
                DataSet.put(11, S.getRealorganicmatter());
                DataSet.put(12, S.getPebbles());
                break;
            }
            case 2: {
                Ilot item = (Ilot)entityManager.find(Ilot.class, (Object)id);
                DataSet.put(1, item.getName());
                DataSet.put(2, item.getDepartement());
                DataSet.put(3, item.getDatepsechedebut());
                DataSet.put(4, item.getDatepsechefin());
                DataSet.put(5, item.getStationmeteo().getNamestation());
                DataSet.put(6, item.getStationmeteo().getIndice());
                break;
            }
            case 3: {
                Parcelle parcelle = (Parcelle)entityManager.find(Parcelle.class, (Object)id);
                DataSet.put(1, parcelle.getIlot().getName());
                DataSet.put(2, parcelle.getNomparcelle());
                DataSet.put(3, parcelle.getSoil().getName());
                DataSet.put(4, parcelle.getSurface());
                DataSet.put(5, parcelle.getNbanneesrotation());
                DataSet.put(6, parcelle.getGradient());
                DataSet.put(7, parcelle.getDistancetoriver());
                DataSet.put(8, parcelle.getLargeurbandeenherbee());
                DataSet.put(9, parcelle.getErodabilite());
                break;
            }
            case 4: {
                Conduites InfoGeneral = (Conduites)entityManager.find(Conduites.class, (Object)id);
                HashMap DataSetVarsGlobales = new HashMap();
                DataSetVarsGlobales = this.GenerateVarsGlobales();
                DataSet.put(1, InfoGeneral.getParcelle().getIlot().getName());
                DataSet.put(2, InfoGeneral.getParcelle().getNomparcelle());
                DataSet.put(3, InfoGeneral.getNomcdt());
                DataSet.put(4, ((Crop)entityManager.find(Crop.class, (Object)InfoGeneral.getIdculture())).getName());
                DataSet.put(5, "");
                DataSet.put(6, InfoGeneral.getProfondeurtravsol());
                ListDataConduite = this.GenerateDataConduite(InfoGeneral);
                DataSet.put(7, ListDataConduite.get(0));
                DataSet.put(8, InfoGeneral.getParcelle().getIlot().getDepartement());
                if (!ListDataConduite.get(1).toString().isEmpty()) {
                    DataSet.put(9, ListDataConduite.get(1));
                } else {
                    String Dpt = "";
                    Dpt = InfoGeneral.getParcelle().getIlot().getDepartement();
                    if (!Dpt.isEmpty() && !Dpt.equals("")) {
                        DataSet.put(9, this.GetDPU(Dpt));
                    }
                }
                DataSet.put(10, ListDataConduite.get(2));
                if (!ListDataConduite.get(3).toString().isEmpty()) {
                    DataSet.put(11, ListDataConduite.get(3));
                } else {
                    DataSet.put(11, DataSetVarsGlobales.get("Prixessence"));
                }
                DataSet.put(12, DataSetVarsGlobales.get("LaborCost"));
                DataSet.put(13, DataSetVarsGlobales.get("Prixeau"));
                DataSet.put(14, ListDataConduite.get(4));
                DataSet.put(15, ListDataConduite.get(5));
                DataSet.put(16, ListDataConduite.get(6));
                ListDataConduite.clear();
                break;
            }
            case 5: {
                Conduites InfoCdt = (Conduites)entityManager.find(Conduites.class, (Object)id);
                List oplist = entityManager.createQuery("SELECT t FROM Technicaloperations t WHERE t.idtechop = -1").getResultList();
                oplist.clear();
                oplist.addAll(((Conduites)entityManager.find(Conduites.class, (Object)id)).getTechnicaloperationsCollection());
                count = 1;
                for (Technicaloperations o : oplist) {
                    if (o.getIntermediatecrop() == null) {
                        if (InfoCdt.getIdculture() != 0) {
                            TempDataSet = this.GenerateInterventions(o.getIdtechop(), InfoCdt.getIdculture());
                        }
                        if (!TempDataSet.isEmpty()) {
                            DataSet.put(count, InfoCdt.getParcelle().getIlot().getName());
                            DataSet.put(++count, InfoCdt.getParcelle().getNomparcelle());
                            DataSet.put(++count, InfoCdt.getNomcdt());
                            DataSet.put(++count, ((Crop)entityManager.find(Crop.class, (Object)InfoCdt.getIdculture())).getName());
                            DataSet.put(++count, "");
                            ++count;
                            Item = 5;
                            for (Object b : TempDataSet.keySet()) {
                                try {
                                    DataSet.put(count, TempDataSet.get(Item).toString());
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                ++Item;
                                ++count;
                            }
                        }
                        TempDataSet.clear();
                        continue;
                    }
                    if (o.getIntermediatecrop().getSowing() != null) {
                        DataSet.put(count, InfoCdt.getParcelle().getIlot().getName());
                        DataSet.put(++count, InfoCdt.getParcelle().getNomparcelle());
                        DataSet.put(++count, InfoCdt.getNomcdt());
                        DataSet.put(++count, ((Crop)entityManager.find(Crop.class, (Object)InfoCdt.getIdculture())).getName());
                        DataSet.put(++count, "");
                        ++count;
                        int IntercropId = 0;
                        if (o.getIntermediatecrop().getCrop() != null) {
                            IntercropId = o.getIntermediatecrop().getCrop().getIdcult();
                        }
                        TempDataSet = this.GenerateInterCropSemis(o.getIntermediatecrop().getSowing().getId(), IntercropId);
                        for (Integer key : TempDataSet.keySet()) {
                            try {
                                DataSet.put(count, TempDataSet.get(key).toString());
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                            ++count;
                        }
                        TempDataSet.clear();
                    }
                    if (!o.getIntermediatecrop().getHerbicideintercropappCollection().isEmpty()) {
                        List Hblist = entityManager.createQuery("SELECT h FROM Herbicideintercropapp h WHERE h.idherbicideapp = -1").getResultList();
                        Hblist.addAll(o.getIntermediatecrop().getHerbicideintercropappCollection());
                        for (Herbicideintercropapp h : Hblist) {
                            String StrOutil = "j" + h.getJour() + "m" + h.getMois() + "outil" + h.getIdequip().getName();
                            if (this.CalculSet.contains(StrOutil)) continue;
                            this.CalculSet.add(StrOutil);
                            DataSet.put(count, InfoCdt.getParcelle().getIlot().getName());
                            DataSet.put(++count, InfoCdt.getParcelle().getNomparcelle());
                            DataSet.put(++count, InfoCdt.getNomcdt());
                            DataSet.put(++count, ((Crop)entityManager.find(Crop.class, (Object)InfoCdt.getIdculture())).getName());
                            DataSet.put(++count, "");
                            ++count;
                            TempDataSet = this.GenerateInterCropHerbicides(h.getIdherbicideapp());
                            Iterator keySetIterator = TempDataSet.keySet().iterator();
                            keySetIterator = TempDataSet.keySet().iterator();
                            int StartItemkey = (Integer)keySetIterator.next();
                            int EndItemkey = StartItemkey + TempDataSet.size();
                            for (int k = StartItemkey; k < EndItemkey; ++k) {
                                try {
                                    DataSet.put(count, TempDataSet.get(k).toString());
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                ++count;
                            }
                            TempDataSet.clear();
                        }
                    }
                    if (o.getIntermediatecrop().getTillageintercropCollection().isEmpty()) continue;
                    List Tlist = entityManager.createQuery("SELECT t FROM Tillageintercrop t WHERE t.idtillageinter = -1").getResultList();
                    Tlist.addAll(o.getIntermediatecrop().getTillageintercropCollection());
                    for (Tillageintercrop t : Tlist) {
                        DataSet.put(count, InfoCdt.getParcelle().getIlot().getName());
                        DataSet.put(++count, InfoCdt.getParcelle().getNomparcelle());
                        DataSet.put(++count, InfoCdt.getNomcdt());
                        DataSet.put(++count, ((Crop)entityManager.find(Crop.class, (Object)InfoCdt.getIdculture())).getName());
                        DataSet.put(++count, "");
                        ++count;
                        TempDataSet = this.GenerateInterCropTillage(t.getTillage().getIdtillage());
                        Iterator keySetIterator = TempDataSet.keySet().iterator();
                        keySetIterator = TempDataSet.keySet().iterator();
                        int StartItemkey = (Integer)keySetIterator.next();
                        int EndItemkey = StartItemkey + TempDataSet.size();
                        for (int k = StartItemkey; k < EndItemkey; ++k) {
                            try {
                                DataSet.put(count, TempDataSet.get(k).toString());
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                            ++count;
                        }
                        TempDataSet.clear();
                    }
                }
                this.CalculSet.clear();
                break;
            }
        }
        entityManager.close();
        return DataSet;
    }

    private HashMap GenerateResults(Parcelle N) {
        String[] parts;
        EntityManager entityManager = this.emf.createEntityManager();
        HashMap<Integer, String> ResultList = new HashMap<Integer, String>();
        String IlotName = "";
        String StationName = "";
        String sol = "";
        int AnneeMeteo = 0;
        int i = 0;
        try {
            IlotName = N.getIlot().getName();
        }
        catch (NullPointerException rex) {
            IlotName = "";
        }
        try {
            StationName = N.getIlot().getStationmeteo().getNamestation();
        }
        catch (NullPointerException rex) {
            StationName = "";
        }
        try {
            List Meteolist = entityManager.createQuery("SELECT m FROM Meteo m WHERE m.id = -1").getResultList();
            Meteolist.clear();
            Meteolist.addAll(N.getIlot().getStationmeteo().getMeteoCollection());
            if (!Meteolist.isEmpty()) {
                Meteo M = (Meteo)Meteolist.get(Meteolist.size() - 1);
                AnneeMeteo = M.getAnnee();
            } else {
                AnneeMeteo = 0;
            }
        }
        catch (NullPointerException rex) {
            AnneeMeteo = 0;
        }
        try {
            sol = N.getSoil().getName();
        }
        catch (NullPointerException rex) {
            sol = "";
        }
        List CdtDataView = entityManager.createQuery("SELECT c FROM Conduites c WHERE c.idcdt = -1").getResultList();
        CdtDataView.clear();
        CdtDataView.addAll(N.getConduitesCollection());
        String Str = "";
        Str = IlotName + ";" + StationName + ";" + AnneeMeteo + ";" + N.getNomparcelle() + ";" + sol + "; ~ ;;" + N.getMsn() + ";" + N.getInd() + ";" + N.getEff() + ";" + N.getQs() + ";" + N.getEmp() + ";" + N.getFmp() + ";" + N.getFmpmo() + ";" + N.getCic() + ";" + N.getTvte() + ";" + N.getTox() + ";" + N.getMPep() + ";" + N.getMPes() + ";" + N.getMpno3b() + ";" + N.getMnh3b() + ";" + N.getMn2ob() + ";" + N.getMpa() + ";" + N.getMso() + ";" + N.getIrrc() + ";" + N.getCenb() + ";" + N.getEen() + ";" + N.getPsph() + ";" + N.getEpa() + ";" + N.getEab() + ";" + N.getBcap() + ";" + N.getRip() + ";" + N.getBcak() + ";" + N.getRik() + ";" + N.getQap() + ";" + N.getSens() + ";" + N.getDmeau() + ";" + N.getAutea() + ";" + N.getIfti() + ";" + N.getEpi() + ";" + N.getUhsl() + ";" + N.getIftt() + ";" + N.getDfc() + ";" + N.getCt() + ";" + N.getCo() + ";" + N.getCm() + ";" + N.getPb() + ";" + N.getAd() + ";" + N.getNp() + ";" + N.getPen() + ";" + N.getCen() + ";" + N.getCenmecab() + ";" + N.getCenfertib() + ";" + N.getCenphytob() + ";" + N.getCensecb() + ";" + N.getCenirrb() + ";" + N.getIfth() + ";" + N.getIfti() + ";" + N.getIftf() + ";" + N.getIftregul() + ";" + N.getBcan() + ";" + N.getQantot() + ";" + N.getQanmin() + ";" + N.getMpno3() + ";" + N.getMnh3() + ";" + N.getMn2o() + ";" + N.getNc() + "";
        Str = Str.replace("null", " ");
        for (String o : parts = Str.split(";")) {
            ResultList.put(i, o);
            ++i;
        }
        if (!CdtDataView.isEmpty()) {
            for (Conduites c : CdtDataView) {
                String[] partsCdt;
                Str = IlotName + ";" + StationName + ";" + AnneeMeteo + ";" + N.getNomparcelle() + ";" + sol + ";" + c.getNomcdt() + ";;" + c.getMsn() + ";" + c.getInd() + ";" + c.getEff() + ";" + c.getQs() + ";" + c.getEmp() + ";" + c.getFmp() + ";" + c.getFmpmo() + ";" + c.getCic() + ";" + c.getTvte() + ";" + c.getTox() + ";" + c.getMPep() + ";" + c.getMPes() + ";" + c.getMpno3b() + ";" + c.getMnh3b() + ";" + c.getMn2ob() + ";" + c.getMpa() + ";" + c.getMso() + ";" + c.getIrrc() + ";" + c.getCenb() + ";" + c.getEen() + ";" + c.getPsph() + "; ~ " + "; ~ ;" + c.getBcap() + ";" + c.getRip() + ";" + c.getBcak() + ";" + c.getRik() + ";" + c.getQap() + "; ~ ;" + c.getDmeau() + ";" + c.getAutea() + ";" + c.getIfti() + "; ~ ;" + c.getUhsl() + ";" + c.getIftt() + "; ~ ;" + c.getCt() + ";" + c.getCo() + ";" + c.getCm() + ";" + c.getPb() + ";" + c.getAd() + ";" + c.getNp() + ";" + c.getPen() + ";" + c.getCen() + ";" + c.getCenmecab() + ";" + c.getCenfertib() + ";" + c.getCenphytob() + ";" + c.getCensecb() + ";" + c.getCenirrb() + ";" + c.getIfth() + ";" + c.getIfti() + ";" + c.getIftf() + ";" + c.getIftregul() + ";" + c.getBcan() + ";" + c.getQantot() + ";" + c.getQanmin() + ";" + c.getMpno3() + ";" + c.getMnh3() + ";" + c.getN2o() + "; ~ ;" + "";
                Str = Str.replace("null", " ");
                for (String o : partsCdt = Str.split(";")) {
                    ResultList.put(i, o);
                    ++i;
                }
            }
        }
        return ResultList;
    }

    private List GenerateDataConduite(Conduites InfoGeneral) {
        EntityManager entityManager = this.emf.createEntityManager();
        ArrayList<Object> DataList = new ArrayList<Object>();
        List CdtDataView = entityManager.createQuery("SELECT d FROM Dataconduite d WHERE d.iddata = -1").getResultList();
        CdtDataView.clear();
        CdtDataView.addAll(InfoGeneral.getDataconduiteCollection());
        for (Dataconduite d : CdtDataView) {
            if (d.getNbhCasualLabor() != null) {
                DataList.add(d.getNbhCasualLabor());
            } else {
                DataList.add("");
            }
            if (d.getDpu() != null) {
                DataList.add(d.getDpu());
            } else {
                DataList.add("");
            }
            if (d.getAideSpec() != null) {
                DataList.add(d.getAideSpec());
            } else {
                DataList.add("");
            }
            if (d.getPrixessence() != null) {
                DataList.add(d.getPrixessence());
            } else {
                DataList.add("");
            }
            if (d.getIri() != null) {
                DataList.add(d.getIri());
            } else {
                DataList.add("");
            }
            if (d.getNbhJobReq() != null) {
                DataList.add(d.getNbhJobReq());
            } else {
                DataList.add("");
            }
            if (d.getClimatperiod() != null) {
                DataList.add(d.getClimatperiod());
                continue;
            }
            DataList.add("");
        }
        if (CdtDataView.isEmpty()) {
            DataList.add("");
            DataList.add("");
            DataList.add("");
            DataList.add("");
            DataList.add("");
            DataList.add("");
            DataList.add("");
        }
        entityManager.close();
        return DataList;
    }

    private HashMap GenerateVarsGlobales() {
        EntityManager entityManager = this.emf.createEntityManager();
        HashMap<String, Double> DataList = new HashMap<String, Double>();
        List VarsGlobalesView = entityManager.createQuery("SELECT v FROM Varsglobales v").getResultList();
        for (Varsglobales d : VarsGlobalesView) {
            DataList.put("LaborCost", d.getLaborCost());
            DataList.put("Prixeau", d.getPrixeau());
            DataList.put("Prixessence", d.getPrixessence());
        }
        entityManager.close();
        return DataList;
    }

    private HashMap GenerateInterventions(int id, int idCrop) {
        EntityManager entityManager = this.emf.createEntityManager();
        HashMap<Integer, String> DataList = new HashMap<Integer, String>();
        HashMap VarsGlobalesList = new HashMap();
        LasyTools Tool = new LasyTools();
        VarsGlobalesList = this.GenerateVarsGlobales();
        List oplist = entityManager.createQuery("SELECT t FROM Technicaloperations t WHERE t.idtechop = " + id).getResultList();
        double Humidite_ref = 0.0;
        double Prixeau = 0.0;
        if (!VarsGlobalesList.get("Prixeau").toString().isEmpty()) {
            try {
                Prixeau = Tool.SetAsABigdouble(VarsGlobalesList.get("Prixeau").toString());
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        for (Technicaloperations o : oplist) {
            String StrOutil;
            if (o.getSowing() != null) {
                DataList.put(5, "Semis culture principale");
                DataList.put(6, "1");
                DataList.put(7, "" + o.getSowing().getIdequip().getName());
                DataList.put(8, "" + o.getSowing().getJour());
                DataList.put(9, "" + o.getSowing().getMois());
                DataList.put(10, "");
                DataList.put(11, "" + o.getSowing().getDensite());
                DataList.put(12, "" + ((Crop)entityManager.find(Crop.class, (Object)idCrop)).getUnitesemence());
                DataList.put(13, "" + o.getSowing().getPrixsemencesparha());
                DataList.put(14, "" + o.getSowing().getObjectifrdt());
                DataList.put(15, "" + o.getSowing().getVariete());
                DataList.put(16, "");
                DataList.put(17, "");
                DataList.put(18, "");
                DataList.put(19, "");
                DataList.put(20, "");
                DataList.put(21, "");
                DataList.put(22, "");
                DataList.put(23, "");
                DataList.put(24, "");
                DataList.put(25, "");
                DataList.put(26, "");
                DataList.put(27, "");
                DataList.put(28, "");
                continue;
            }
            if (o.getTillage() != null) {
                DataList.put(5, "Travail du sol");
                DataList.put(6, "" + o.getTillage().getFrequencedintervention());
                DataList.put(7, "" + o.getTillage().getIdequipment().getName());
                DataList.put(8, "" + o.getTillage().getJour());
                DataList.put(9, "" + o.getTillage().getMois());
                DataList.put(10, "");
                DataList.put(11, "");
                DataList.put(12, "");
                DataList.put(13, "");
                DataList.put(14, "");
                DataList.put(15, "");
                DataList.put(16, "");
                DataList.put(17, "");
                DataList.put(18, "");
                DataList.put(19, "");
                DataList.put(20, "");
                DataList.put(21, "");
                DataList.put(22, "");
                DataList.put(23, "");
                DataList.put(24, "");
                DataList.put(25, "");
                DataList.put(26, "");
                DataList.put(27, "");
                DataList.put(28, "");
                continue;
            }
            if (o.getPesticideapp() != null) {
                StrOutil = "j" + o.getPesticideapp().getJour() + "m" + o.getPesticideapp().getMois() + "outil" + o.getPesticideapp().getOutil().getName();
                DataList.put(5, "Lutte chimique");
                DataList.put(6, "" + o.getPesticideapp().getFrequencedintervention());
                if (!this.CalculSet.contains(StrOutil)) {
                    this.CalculSet.add(StrOutil);
                    DataList.put(7, "" + o.getPesticideapp().getOutil().getName());
                } else {
                    DataList.put(7, "*Aucun outil");
                }
                DataList.put(8, "" + o.getPesticideapp().getJour());
                DataList.put(9, "" + o.getPesticideapp().getMois());
                DataList.put(10, "" + o.getPesticideapp().getPesticide().getNompesticide());
                DataList.put(11, "" + o.getPesticideapp().getDose());
                DataList.put(12, "" + o.getPesticideapp().getUnite());
                DataList.put(13, "" + o.getPesticideapp().getPesticide().getPrix());
                DataList.put(14, "");
                DataList.put(15, "");
                DataList.put(16, "" + o.getPesticideapp().getTypepest().getNomtypepest());
                DataList.put(17, "" + o.getPesticideapp().getDh());
                DataList.put(18, "" + o.getPesticideapp().getTotalepartielle());
                DataList.put(19, "" + o.getPesticideapp().getTraitement());
                DataList.put(20, "");
                DataList.put(21, "");
                DataList.put(22, "");
                DataList.put(23, "");
                DataList.put(24, "");
                DataList.put(25, "");
                DataList.put(26, "");
                DataList.put(27, "");
                DataList.put(28, "");
                continue;
            }
            if (o.getProduitbioapp() != null) {
                StrOutil = "j" + o.getProduitbioapp().getJour() + "m" + o.getProduitbioapp().getMois() + "outil" + o.getProduitbioapp().getIdequip().getName();
                DataList.put(5, "Lutte biologique");
                DataList.put(6, "" + o.getProduitbioapp().getFrequence());
                if (!this.CalculSet.contains(StrOutil)) {
                    this.CalculSet.add(StrOutil);
                    DataList.put(7, "" + o.getProduitbioapp().getIdequip().getName());
                } else {
                    DataList.put(7, "*Aucun outil");
                }
                DataList.put(8, "" + o.getProduitbioapp().getJour());
                DataList.put(9, "" + o.getProduitbioapp().getMois());
                DataList.put(10, "" + o.getProduitbioapp().getProduitbio().getNomproduit());
                DataList.put(11, "" + o.getProduitbioapp().getQuantite());
                DataList.put(12, "" + o.getProduitbioapp().getUnitemesure());
                DataList.put(13, "" + o.getProduitbioapp().getProduitbio().getCouteuros());
                DataList.put(14, "");
                DataList.put(15, "");
                DataList.put(16, "");
                DataList.put(17, "");
                DataList.put(18, "");
                DataList.put(19, "");
                DataList.put(20, "");
                DataList.put(21, "");
                DataList.put(22, "");
                DataList.put(23, "");
                DataList.put(24, "");
                DataList.put(25, "");
                DataList.put(26, "");
                DataList.put(27, "");
                DataList.put(28, "");
                continue;
            }
            if (o.getFertilization() != null) {
                StrOutil = "j" + o.getFertilization().getJour() + "m" + o.getFertilization().getMois() + "outil" + o.getFertilization().getEquipment().getName();
                DataList.put(5, "Fertilisation");
                DataList.put(6, "" + o.getFertilization().getFrequencedintervention());
                if (!this.CalculSet.contains(StrOutil)) {
                    this.CalculSet.add(StrOutil);
                    DataList.put(7, "" + o.getFertilization().getEquipment().getName());
                } else {
                    DataList.put(7, "*Aucun outil");
                }
                DataList.put(8, "" + o.getFertilization().getJour());
                DataList.put(9, "" + o.getFertilization().getMois());
                DataList.put(10, "" + o.getFertilization().getFertilizer1().getNomfertil());
                DataList.put(11, "" + o.getFertilization().getDose());
                DataList.put(12, "" + o.getFertilization().getFertilizer1().getUnite());
                DataList.put(13, "" + o.getFertilization().getFertilizer1().getPrix());
                DataList.put(14, "");
                DataList.put(15, "");
                DataList.put(16, "");
                DataList.put(17, "");
                DataList.put(18, "");
                DataList.put(19, "");
                if (o.getFertilization().getEnfouisdans24h().equals("false")) {
                    DataList.put(20, "Non");
                } else {
                    DataList.put(20, "Oui");
                }
                DataList.put(21, "");
                DataList.put(22, "");
                DataList.put(23, "");
                DataList.put(24, "");
                DataList.put(25, "");
                DataList.put(26, "");
                DataList.put(27, "");
                DataList.put(28, "");
                continue;
            }
            if (o.getIrrigation() != null) {
                DataList.put(5, "Irrigation");
                DataList.put(6, "" + o.getIrrigation().getFrequence());
                DataList.put(7, "" + o.getIrrigation().getEquipment().getName());
                DataList.put(8, "" + o.getIrrigation().getJour());
                DataList.put(9, "" + o.getIrrigation().getMois());
                DataList.put(10, "");
                DataList.put(11, "" + o.getIrrigation().getQuantite());
                DataList.put(12, "");
                if (Prixeau > 0.0) {
                    DataList.put(13, "" + Prixeau / 10.0);
                } else {
                    DataList.put(13, "");
                }
                DataList.put(14, "");
                DataList.put(15, "");
                DataList.put(16, "");
                DataList.put(17, "");
                DataList.put(18, "");
                DataList.put(19, "");
                DataList.put(20, "");
                DataList.put(21, "");
                DataList.put(22, "");
                DataList.put(23, "");
                DataList.put(24, "");
                DataList.put(25, "");
                DataList.put(26, "");
                DataList.put(27, "");
                DataList.put(28, "");
                continue;
            }
            if (o.getHarvesting() == null || o.getHarvesting().getEquipment() == null) continue;
            DataList.put(5, "R\u00e9colte");
            DataList.put(6, "1");
            DataList.put(7, "" + o.getHarvesting().getEquipment().getName());
            DataList.put(8, "" + o.getHarvesting().getJour());
            DataList.put(9, "" + o.getHarvesting().getMois());
            DataList.put(10, "");
            DataList.put(11, "");
            DataList.put(12, "");
            DataList.put(13, "");
            DataList.put(14, "");
            DataList.put(15, "");
            DataList.put(16, "");
            DataList.put(17, "");
            DataList.put(18, "");
            DataList.put(19, "");
            DataList.put(20, "");
            if (!o.getHarvesting().getCategorie().equals("R\u00e9colte paille") && !o.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) {
                DataList.put(21, "" + o.getHarvesting().getResidus());
                DataList.put(22, "" + o.getHarvesting().getDateResidu());
                DataList.put(23, "" + o.getHarvesting().getIdcrop().getName());
                DataList.put(24, "" + o.getHarvesting().getCategorie());
                DataList.put(25, "" + o.getHarvesting().getRendement());
                DataList.put(26, "" + o.getHarvesting().getHumiditeRecolte());
                if (o.getHarvesting().getIdcrop().getRefMsGrainPourcent() != null) {
                    Humidite_ref = o.getHarvesting().getIdcrop().getRefMsGrainPourcent();
                    Humidite_ref = 100.0 - Humidite_ref;
                    DataList.put(27, "" + Humidite_ref);
                } else {
                    DataList.put(27, "");
                }
                if (o.getHarvesting().getCategorie().equals("R\u00e9colte plante enti\u00e8re")) {
                    DataList.put(28, "" + o.getHarvesting().getIdcrop().getPrixPlanteEntiere());
                    continue;
                }
                DataList.put(28, "" + o.getHarvesting().getIdcrop().getReferenceprix());
                continue;
            }
            if (o.getHarvesting().getEquipment().getPerformancedetravail() != null && o.getHarvesting().getEquipment().getPerformancedetravail() > 0.0) {
                DataList.put(21, "" + o.getHarvesting().getResidus());
                DataList.put(22, "" + o.getHarvesting().getDateResidu());
                DataList.put(23, "" + o.getHarvesting().getIdcrop().getName());
                DataList.put(24, "" + o.getHarvesting().getCategorie());
                DataList.put(25, "" + o.getHarvesting().getRendement());
                DataList.put(26, "" + o.getHarvesting().getHumiditeRecolte());
                DataList.put(27, "0.0");
                DataList.put(28, "" + o.getHarvesting().getIdcrop().getPrixRef());
                continue;
            }
            DataList.put(21, "");
            DataList.put(22, "");
            DataList.put(23, "");
            DataList.put(24, "");
            DataList.put(25, "");
            DataList.put(26, "");
            DataList.put(27, "");
            DataList.put(28, "");
        }
        entityManager.close();
        return DataList;
    }

    private HashMap GenerateInterCropSemis(int id, int idCrop) {
        EntityManager entityManager = this.emf.createEntityManager();
        HashMap<Integer, String> DataList = new HashMap<Integer, String>();
        Sowing S = (Sowing)entityManager.find(Sowing.class, (Object)id);
        DataList.put(5, "Semis interculture");
        DataList.put(6, "1");
        DataList.put(7, "" + S.getIdequip().getName());
        DataList.put(8, "" + S.getJour());
        DataList.put(9, "" + S.getMois());
        if (idCrop > 0) {
            DataList.put(10, "" + ((Crop)entityManager.find(Crop.class, (Object)idCrop)).getName());
        } else {
            DataList.put(10, "No def");
        }
        DataList.put(11, "" + S.getDensite());
        if (idCrop > 0) {
            DataList.put(12, "" + ((Crop)entityManager.find(Crop.class, (Object)idCrop)).getUnitesemence());
        } else {
            DataList.put(12, "");
        }
        DataList.put(13, "" + S.getPrixsemencesparha());
        DataList.put(14, "");
        DataList.put(15, "");
        DataList.put(16, "");
        DataList.put(17, "");
        DataList.put(18, "");
        DataList.put(19, "");
        DataList.put(20, "");
        DataList.put(21, "");
        DataList.put(22, "");
        DataList.put(23, "");
        DataList.put(24, "");
        DataList.put(25, "");
        DataList.put(26, "");
        DataList.put(27, "");
        DataList.put(28, "");
        entityManager.close();
        return DataList;
    }

    private HashMap GenerateInterCropTillage(int id) {
        EntityManager entityManager = this.emf.createEntityManager();
        HashMap<Integer, String> DataList = new HashMap<Integer, String>();
        List oplist = entityManager.createQuery("SELECT t FROM Tillage t WHERE t.idtillage = " + id).getResultList();
        for (Tillage o : oplist) {
            DataList.put(5, "Travail du sol");
            DataList.put(6, "" + o.getFrequencedintervention());
            DataList.put(7, "" + o.getIdequipment().getName());
            DataList.put(8, "" + o.getJour());
            DataList.put(9, "" + o.getMois());
            DataList.put(10, "");
            DataList.put(11, "");
            DataList.put(12, "");
            DataList.put(13, "");
            DataList.put(14, "");
            DataList.put(15, "");
            DataList.put(16, "");
            DataList.put(17, "");
            DataList.put(18, "");
            DataList.put(19, "");
            DataList.put(20, "");
            DataList.put(21, "");
            DataList.put(22, "");
            DataList.put(23, "");
            DataList.put(24, "");
            DataList.put(25, "");
            DataList.put(26, "");
            DataList.put(27, "");
            DataList.put(28, "");
        }
        entityManager.close();
        return DataList;
    }

    private HashMap GenerateInterCropHerbicides(int id) {
        EntityManager entityManager = this.emf.createEntityManager();
        HashMap<Integer, String> DataList = new HashMap<Integer, String>();
        List oplist = entityManager.createQuery("SELECT h FROM Herbicideintercropapp h WHERE h.idherbicideapp = " + id).getResultList();
        for (Herbicideintercropapp o : oplist) {
            DataList.put(5, "Lutte chimique");
            DataList.put(6, "" + o.getFrequencedintervention());
            DataList.put(7, "" + o.getIdequip().getName());
            DataList.put(8, "" + o.getJour());
            DataList.put(9, "" + o.getMois());
            DataList.put(10, "" + o.getIdpest().getNompesticide());
            DataList.put(11, "" + o.getDose());
            DataList.put(12, "" + o.getUnite());
            DataList.put(13, "" + o.getIdpest().getPrix());
            DataList.put(14, "");
            DataList.put(15, "");
            DataList.put(16, "" + o.getIdpest().getPesticidetype().getNomtypepest());
            DataList.put(17, "" + o.getDh());
            DataList.put(18, "" + o.getTotalepartielle());
            DataList.put(19, "" + o.getTraitement());
            DataList.put(20, "");
            DataList.put(21, "");
            DataList.put(22, "");
            DataList.put(23, "");
            DataList.put(24, "");
            DataList.put(25, "");
            DataList.put(26, "");
            DataList.put(27, "");
            DataList.put(28, "");
        }
        entityManager.close();
        return DataList;
    }

    private double GetDPU(String department) {
        EntityManager entityManager = this.emf.createEntityManager();
        double DPU = 0.0;
        List DpuView = entityManager.createQuery("SELECT d FROM Dpu d WHERE d.department =" + department).getResultList();
        for (Dpu d : DpuView) {
            DPU = d.getDpu();
        }
        entityManager.close();
        return DPU;
    }
}

