/*
 * Decompiled with CFR 0.152.
 */
package com.imagine.component.calendar.renderers.tablecellrenderers;

import com.imagine.component.calendar.CalendarComponent;
import com.imagine.component.calendar.data.CalendarMonthType;
import com.imagine.component.calendar.data.CalendarTableCellInfo;
import com.imagine.component.calendar.renderers.tablecellrenderers.CalendarTableCellRenderer;
import com.imagine.component.calendar.skins.CalendarSkin;
import com.imagine.component.calendar.util.GUIUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class CalendarTableCellRendererDottedRect
implements CalendarTableCellRenderer {
    Stroke g = null;
    BasicStroke f = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);

    public void paint(Graphics graphics, CalendarComponent calendarComponent, CalendarTableCellInfo calendarTableCellInfo) {
        if (!calendarComponent.getCalendarRendererProvider().hasBackgroundRenderer()) {
            graphics.setColor(calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.CELL_FILL_COLOR));
            graphics.fillRect(0, 0, calendarTableCellInfo.getWidth(), calendarTableCellInfo.getHeight());
        }
        Color color = null;
        color = calendarTableCellInfo.getMonthType() != CalendarMonthType.CURRENT_MONTH ? calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.EXTRA_MONTH_CELL_TEXT_COLOR) : (calendarTableCellInfo.isFromWeekend() ? calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.WEEKEND_CELL_TEXT_COLOR) : calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.CELL_TEXT_COLOR));
        graphics.setColor(color);
        Font font = null;
        font = calendarTableCellInfo.getMonthType() != CalendarMonthType.CURRENT_MONTH ? calendarComponent.getCalendarSkin().getFontSkinProperty(CalendarSkin.EXTRA_MONTH_CELL_FONT) : (calendarTableCellInfo.isFromWeekend() ? calendarComponent.getCalendarSkin().getFontSkinProperty(CalendarSkin.WEEKEND_CELL_FONT) : calendarComponent.getCalendarSkin().getFontSkinProperty(CalendarSkin.CELL_FONT));
        graphics.setFont(font);
        GUIUtilities.drawCenteredString(graphics, calendarTableCellInfo.getWidth(), calendarTableCellInfo.getHeight(), calendarTableCellInfo.getValue().toString());
        if (calendarTableCellInfo.isDisabled()) {
            graphics.setColor(calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.DISABLED_COLOR));
            int n = 3;
            graphics.drawLine(n, n, calendarTableCellInfo.getWidth() - n, calendarTableCellInfo.getHeight() - n);
            graphics.drawLine(n, calendarTableCellInfo.getHeight() - n, calendarTableCellInfo.getWidth() - n, n);
        }
        graphics.setColor(calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.HOVERED_CELL_FILL_COLOR));
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.g = graphics2D.getStroke();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, calendarTableCellInfo.getWidth() - 1, calendarTableCellInfo.getHeight() - 1);
        graphics2D.setStroke(this.f);
        graphics2D.draw(double_);
        graphics2D.setStroke(this.g);
    }
}

