/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MetadataAccessor {
    protected Class m_referenceClass;

    protected RelationshipAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    public abstract List<String> getCascadeTypes();

    public ArrayList<String> getCascadeTypes(CascadeType[] cascadeTypes) {
        ArrayList<String> cTypes = new ArrayList<String>();
        for (CascadeType cascadeType : cascadeTypes) {
            cTypes.add(cascadeType.name());
        }
        return cTypes;
    }

    protected MetadataJoinColumns getJoinColumns() {
        JoinColumn joinColumn = (JoinColumn)this.getAnnotation(JoinColumn.class);
        JoinColumns joinColumns = (JoinColumns)this.getAnnotation(JoinColumns.class);
        return new MetadataJoinColumns(joinColumns, joinColumn);
    }

    protected abstract String getLoggingContext();

    public String getMappedBy() {
        throw new RuntimeException("Development exception. The accessor: [" + this + "] should not call the getMappedBy method unless it overrides it.");
    }

    protected DatabaseMapping getOwningMapping() {
        String ownerAttributeName = this.getMappedBy();
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = ownerDescriptor.getMappingForAttributeName(ownerAttributeName, this);
        if (mapping == null) {
            this.m_validator.throwNoMappedByAttributeFound(ownerDescriptor.getJavaClass(), ownerAttributeName, this.getJavaClass(), this.getAttributeName());
        }
        return mapping;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor descriptor;
        try {
            descriptor = super.getReferenceDescriptor();
        }
        catch (Exception exception) {
            descriptor = null;
        }
        if (descriptor == null || descriptor.isEmbeddable() || descriptor.isEmbeddableCollection()) {
            this.m_validator.throwNonEntityTargetInRelationship(this.getJavaClass(), this.getReferenceClass(), this.getAnnotatedElement());
        }
        return descriptor;
    }

    public abstract Class getTargetEntity();

    public boolean hasJoinColumn() {
        return this.isAnnotationPresent(JoinColumn.class);
    }

    public boolean hasJoinColumns() {
        return this.isAnnotationPresent(JoinColumns.class);
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return this.isAnnotationPresent(PrimaryKeyJoinColumns.class) || this.isAnnotationPresent(PrimaryKeyJoinColumn.class);
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && this.hasPrimaryKeyJoinColumns();
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        for (String cascadeType : this.getCascadeTypes()) {
            this.setCascadeType(cascadeType, mapping);
        }
        if (this.m_descriptor.isCascadePersist() && !mapping.isCascadePersist()) {
            this.setCascadeType(CascadeType.PERSIST.name(), mapping);
        }
    }

    protected List<MetadataJoinColumn> processJoinColumns() {
        if (this.m_descriptor.hasAssociationOverrideFor(this.getAttributeName())) {
            return this.processJoinColumns(this.m_descriptor.getAssociationOverrideFor(this.getAttributeName()), this.getReferenceDescriptor());
        }
        return this.processJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor());
    }

    protected List<MetadataJoinColumn> processJoinColumns(MetadataJoinColumns joinColumns, MetadataDescriptor descriptor) {
        List<MetadataJoinColumn> jColumns = joinColumns.values(descriptor);
        if (descriptor.hasCompositePrimaryKey()) {
            if (jColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                this.m_validator.throwIncompleteJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
            }
            for (MetadataJoinColumn jColumn : jColumns) {
                if (!jColumn.isPrimaryKeyFieldNotSpecified() && !jColumn.isForeignKeyFieldNotSpecified()) continue;
                this.m_validator.throwIncompleteJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
            }
        } else if (jColumns.size() > 1) {
            this.m_validator.throwExcessiveJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
        }
        return jColumns;
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.m_descriptor.hasMappingForAttributeName(this.getAttributeName())) {
                this.m_logger.logWarningMessage("metadata_warning_ignore_mapping", this);
            } else {
                if (this.hasColumn()) {
                    this.m_validator.throwRelationshipHasColumnSpecified(this.getJavaClass(), this.getAttributeName());
                }
                if (this.getTargetEntity() != ValueHolderInterface.class && (this.getTargetEntity() != Void.TYPE || this.getReferenceClass() != ValueHolderInterface.class)) {
                    this.process();
                }
            }
            this.setIsProcessed();
        }
    }

    protected void setCascadeType(String type, ForeignReferenceMapping mapping) {
        if (type.equals("cascade-all") || type.equals(CascadeType.ALL.name())) {
            mapping.setCascadeAll(true);
        } else if (type.equals("cascade-merge") || type.equals(CascadeType.MERGE.name())) {
            mapping.setCascadeMerge(true);
        } else if (type.equals("cascade-persist") || type.equals(CascadeType.PERSIST.name())) {
            mapping.setCascadePersist(true);
        } else if (type.equals("cascade-refresh") || type.equals(CascadeType.REFRESH.name())) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals("cascade-remove") || type.equals(CascadeType.REMOVE.name())) {
            mapping.setCascadeRemove(true);
        }
    }
}

