/*
 * Decompiled with CFR 0.152.
 */
package modules;

import DataBase.Cic;
import DataBase.Conduites;
import DataBase.Crop;
import DataBase.Dataconduite;
import DataBase.Epi;
import DataBase.Harvesting;
import DataBase.Herbicideintercropapp;
import DataBase.Ilot;
import DataBase.Irrigation;
import DataBase.Parcelle;
import DataBase.Pesticideapp;
import DataBase.PluriCrop;
import DataBase.Sowing;
import DataBase.Technicaloperations;
import DataBase.Tillageintercrop;
import java.beans.Beans;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import modules.ConduiteMod;
import modules.CultureMod;
import modules.EngraisEquivMod;
import modules.IntermediateCalc;
import modules.ItkMod;
import modules.LasyTools;
import modules.OutilMod;
import modules.VarsGlobalMod;
import modules.infoCdtMod;

public class Indicator {
    EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("CRITERBASE.DB3PU"));
    OutilMod Tool = new OutilMod();
    LasyTools ToolBox = new LasyTools();
    public Double VarIFTI = 0.0;
    public Double VarIFTH = 0.0;
    public Double VarIFTHInter = 0.0;
    public Double VarIFTREG = 0.0;
    public Double VarIFTF = 0.0;
    public Double VarIFTMoll = 0.0;
    public Double valAP = 0.0;
    public Double lp = 0.0;
    public Double lh = 0.0;
    public Double QANMIN = 0.0;
    public Double QANTOT = 0.0;
    public Double PEN = 0.0;
    public Double NX = 0.0;
    public Double MineralRes = 0.0;
    public Double MineralSol = 0.0;
    public Double Nabs = 0.0;
    public double CCetoile = 0.0;
    public double BilanI = 0.0;
    public double MyThread = 0.0;
    public double D = 0.0;
    public double NbTx = 0.0;
    public int MsgOption = 0;
    public List<Object> DateAppList = new ArrayList<Object>();

    public double GetValueMNH3(int IDcdt) {
        IntermediateCalc IntCalc = new IntermediateCalc();
        double Indicateur = 0.0;
        Indicateur = IntCalc.GetSommeAzoteVolat(IDcdt);
        return Indicateur;
    }

    public void SetValuesIFT(int IndexPestApp, int idType) throws ParseException {
        Query MyQuery = null;
        EntityManager entityManager = this.emf.createEntityManager();
        MyQuery = entityManager.createNamedQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("PESTICIDEAPP.FINDBYIDPESTAPP"));
        List IphyView = MyQuery.setParameter(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("IDPESTAPP"), (Object)IndexPestApp).getResultList();
        double TTp = 0.0;
        double Dose = 0.0;
        double Dh2 = 0.0;
        double SurfaceTT = 0.0;
        if (!IphyView.isEmpty()) {
            for (Pesticideapp Ip : IphyView) {
                if (Ip.getTotalepartielle() == null || Ip.getDose() == null || Ip.getDh() == null) continue;
                try {
                    TTp = Ip.getTotalepartielle().intValue();
                    SurfaceTT = TTp / 100.0;
                }
                catch (NullPointerException ex) {
                    SurfaceTT = 1.0;
                    this.MsgOption = 2;
                }
                try {
                    Dose = Ip.getDose() * Ip.getFrequencedintervention();
                }
                catch (NullPointerException ex) {
                    Dose = 0.0;
                    this.MsgOption = 3;
                }
                try {
                    Dh2 = Ip.getDh();
                    if (Dh2 == 0.0) {
                        this.MsgOption = 1;
                        Dh2 = 1.0;
                    }
                }
                catch (NullPointerException ex) {
                    Dh2 = 0.0;
                    this.MsgOption = 1;
                }
                this.VarIFTI = 0.0;
                this.VarIFTH = 0.0;
                this.VarIFTF = 0.0;
                this.VarIFTREG = 0.0;
                this.VarIFTMoll = 0.0;
                switch (idType) {
                    case 1: {
                        this.VarIFTI = this.VarIFTI + SurfaceTT * Dose / Dh2;
                        break;
                    }
                    case 2: {
                        this.VarIFTH = this.VarIFTH + SurfaceTT * Dose / Dh2;
                        break;
                    }
                    case 3: {
                        this.VarIFTF = this.VarIFTF + SurfaceTT * Dose / Dh2;
                        break;
                    }
                    case 4: {
                        this.VarIFTREG = this.VarIFTREG + SurfaceTT * Dose / Dh2;
                        break;
                    }
                    case 5: {
                        this.VarIFTMoll = this.VarIFTMoll + SurfaceTT * Dose / Dh2;
                    }
                }
            }
        }
        entityManager.clear();
        entityManager.close();
    }

    public void SetValuesIftInter(int IndexHerbicideApp) throws ParseException {
        Query MyQuery = null;
        EntityManager entityManager = this.emf.createEntityManager();
        MyQuery = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT H FROM HERBICIDEINTERCROPAPP H WHERE H.IDHERBICIDEAPP = ") + IndexHerbicideApp);
        List IphyView = MyQuery.getResultList();
        double TTp = 0.0;
        double SurfaceTT = 0.0;
        double Dose = 0.0;
        double Dh2 = 0.0;
        double freq = 1.0;
        double VarIFTHIntertemp = 0.0;
        if (!IphyView.isEmpty()) {
            for (Herbicideintercropapp h : IphyView) {
                if (h.getTotalepartielle() == null || h.getDose() == null || h.getDh() == null) continue;
                try {
                    TTp = h.getTotalepartielle().intValue();
                    SurfaceTT = TTp / 100.0;
                }
                catch (NullPointerException ex) {
                    SurfaceTT = 1.0;
                    this.MsgOption = 2;
                }
                try {
                    freq = h.getFrequencedintervention();
                    if (freq == 0.0) {
                        freq = 1.0;
                    }
                }
                catch (NullPointerException ex) {
                    freq = 1.0;
                }
                try {
                    Dose = h.getDose();
                    Dose *= freq;
                }
                catch (NullPointerException ex) {
                    Dose = 0.0;
                    this.MsgOption = 3;
                }
                try {
                    Dh2 = h.getDh();
                }
                catch (NullPointerException ex) {
                    Dh2 = 0.0;
                    this.MsgOption = 1;
                }
                if (Dh2 == 0.0) {
                    Dh2 = Dose > 0.0 ? Dose : 1.0;
                }
                VarIFTHIntertemp = SurfaceTT * Dose / Dh2;
                this.VarIFTHInter = this.VarIFTHInter + VarIFTHIntertemp;
                VarIFTHIntertemp = 0.0;
            }
        }
        entityManager.clear();
        entityManager.close();
    }

    public double GetValuesIFTInter(int IndexHerbicideApp) throws ParseException {
        double Indicateur = 0.0;
        this.SetValuesIftInter(IndexHerbicideApp);
        Indicateur = this.VarIFTHInter;
        this.VarIFTHInter = 0.0;
        return Indicateur;
    }

    public double GetValuesIFT(int IndexPestApp, int idType) throws ParseException {
        double Indicateur = 0.0;
        this.SetValuesIFT(IndexPestApp, idType);
        switch (idType) {
            case 1: {
                Indicateur = this.VarIFTI;
                break;
            }
            case 2: {
                Indicateur = this.VarIFTH;
                break;
            }
            case 3: {
                Indicateur = this.VarIFTF;
                break;
            }
            case 4: {
                Indicateur = this.VarIFTREG;
                break;
            }
            case 5: {
                Indicateur = this.VarIFTMoll;
            }
        }
        return Indicateur;
    }

    public double GetValuePTSU(int IndexPlot) throws ParseException {
        EntityManager entityManager = this.emf.createEntityManager();
        double Indicateur = 0.0;
        boolean IdStock = false;
        int IndexCdt = 0;
        Parcelle P = (Parcelle)entityManager.find(Parcelle.class, (Object)IndexPlot);
        Collection<Conduites> lc = P.getConduitesCollection();
        List CdtView = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT C FROM CONDUITES C WHERE C.IDCDT = -1")).getResultList();
        List MyListOp = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT T FROM TECHNICALOPERATIONS T WHERE T.IDTECHOP = -1")).getResultList();
        CdtView.clear();
        CdtView.addAll(lc);
        for (Conduites C : CdtView) {
            IndexCdt = C.getIdcdt();
            MyListOp.clear();
            MyListOp.addAll(C.getTechnicaloperationsCollection());
            for (Technicaloperations Op : MyListOp) {
                if (Op.getPesticideapp() == null || IdStock) continue;
                Indicateur += 1.0;
                IdStock = true;
            }
            for (Technicaloperations Op : MyListOp) {
                Collection<Herbicideintercropapp> IcHerb;
                if (Op.getIntermediatecrop() == null || IdStock || (IcHerb = Op.getIntermediatecrop().getHerbicideintercropappCollection()).isEmpty()) continue;
                Indicateur += 1.0;
            }
            IdStock = false;
        }
        Indicateur = Indicateur / (double)CdtView.size() * 100.0;
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    public double GetEPI(int IndexPlot) throws ParseException {
        IntermediateCalc InterCalc = new IntermediateCalc();
        LasyTools t = new LasyTools();
        EntityManager entityManager = this.emf.createEntityManager();
        ConduiteMod CdtTool = new ConduiteMod();
        Parcelle P = (Parcelle)entityManager.find(Parcelle.class, (Object)IndexPlot);
        List MyListOp = entityManager.createQuery("SELECT t FROM Technicaloperations t WHERE t.idtechop = -1").getResultList();
        ItkMod ItkTool = new ItkMod();
        ArrayList<String> ClassList = new ArrayList<String>();
        ArrayList CropList = new ArrayList();
        ArrayList<Integer> pluriannuellesList = new ArrayList<Integer>();
        List OpList = null;
        double Indicateur = 0.0;
        int jourSemi = 0;
        int moisSemi = 0;
        int DateEpiDebut = 0;
        int DateEpiFin = 0;
        int Datesemi = 0;
        String Classe = "";
        int IndexCdt = 0;
        int IndexFirstCdt = 0;
        int RotationNumber = 0;
        int LastCropID = 0;
        int cropID = 0;
        IndexCdt = RotationNumber = CdtTool.getFirstCdtIndex(IndexPlot);
        IndexFirstCdt = RotationNumber;
        for (int i = 0; i < P.getConduitesCollection().size(); ++i) {
            List ListOp = OpList = ItkTool.GetListOfOP(IndexCdt);
            jourSemi = 0;
            moisSemi = 0;
            for (Technicaloperations Op : ListOp) {
                cropID = Op.getConduites().getIdculture();
                if (Op.getSowing() == null) continue;
                jourSemi = Op.getSowing().getJour();
                moisSemi = Op.getSowing().getMois();
            }
            if (LastCropID != cropID && moisSemi != 0) {
                LastCropID = cropID;
            } else if (moisSemi != 0 && LastCropID == cropID) {
                try {
                    if (pluriannuellesList.contains(cropID)) {
                        pluriannuellesList.remove(cropID);
                    }
                }
                catch (NullPointerException ex) {}
            } else if (moisSemi == 0 && LastCropID == cropID && !pluriannuellesList.contains(cropID)) {
                pluriannuellesList.add(cropID);
                Indicateur += 1.0;
            }
            if (moisSemi != 0 && cropID != 0) {
                if (!Beans.isDesignTime() && !entityManager.getTransaction().isActive()) {
                    entityManager.getTransaction().begin();
                }
                List ListEPI = entityManager.createNamedQuery("Epi.findAll").getResultList();
                Datesemi = t.GetActualDayCalendar(jourSemi, moisSemi);
                for (Epi EPI : ListEPI) {
                    Classe = "";
                    DateEpiDebut = t.GetActualDayCalendar(EPI.getJourdebut(), EPI.getMoisdebut());
                    if (DateEpiDebut < (DateEpiFin = t.GetActualDayCalendar(EPI.getJourfin(), EPI.getMoisfin()))) {
                        if (DateEpiDebut >= Datesemi || Datesemi > DateEpiFin) continue;
                        try {
                            Classe = EPI.getClasse();
                            if (ClassList.contains(Classe)) continue;
                            ClassList.add(Classe);
                            Indicateur += 1.0;
                        }
                        catch (NullPointerException ex) {}
                        continue;
                    }
                    if (DateEpiDebut >= Datesemi && Datesemi > DateEpiFin) continue;
                    try {
                        Classe = EPI.getClasse();
                        if (ClassList.contains(Classe)) continue;
                        ClassList.add(Classe);
                        Indicateur += 1.0;
                    }
                    catch (NullPointerException ex) {}
                }
            }
            moisSemi = 0;
            cropID = 0;
            RotationNumber = IndexCdt;
            if ((IndexCdt = CdtTool.findNextIdCdt(IndexPlot, RotationNumber)) == IndexFirstCdt || IndexCdt == 0) break;
        }
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    public double GetDFC(int IndexPlot) throws ParseException {
        IntermediateCalc IntCalc = new IntermediateCalc();
        ItkMod ItkTool = new ItkMod();
        EntityManager entityManager = this.emf.createEntityManager();
        ArrayList<Integer> FamilyList = new ArrayList<Integer>();
        ArrayList CdtList = new ArrayList();
        String ThisCrop = "";
        double Indicateur = 0.0;
        double FC = 0.0;
        double FC_InterCrop = 0.0;
        double FC_Cdt = 0.0;
        double N = 0.0;
        double FcGlobal = 0.0;
        int IndexCdt = 0;
        int IdFamily = 0;
        Parcelle P = (Parcelle)entityManager.find(Parcelle.class, (Object)IndexPlot);
        Collection<Conduites> lc = P.getConduitesCollection();
        List CdtView = entityManager.createQuery("SELECT c FROM Conduites c WHERE c.idcdt = -1").getResultList();
        CdtView.clear();
        CdtView.addAll(lc);
        N = IntCalc.GetN(IndexPlot, true);
        for (Conduites conduites : CdtView) {
            IndexCdt = conduites.getIdcdt();
            ThisCrop = ((Crop)entityManager.find(Crop.class, (Object)conduites.getIdculture())).getName();
            ThisCrop = ThisCrop.replace("\u00e8", "%");
            ThisCrop = ThisCrop.replace("'", "''");
            List CdtPluriCropList = entityManager.createQuery("SELECT p FROM PluriCrop p WHERE p.crop LIKE '" + ThisCrop + "'").getResultList();
            for (PluriCrop p : CdtPluriCropList) {
                IdFamily = p.getIdFamily().getIdfa();
                if (FamilyList.contains(IdFamily)) continue;
                FamilyList.add(IdFamily);
            }
            CdtPluriCropList.clear();
            List ListOp = entityManager.createQuery("SELECT t FROM Technicaloperations t WHERE t.idtechop = -1").getResultList();
            ListOp.addAll(conduites.getTechnicaloperationsCollection());
            for (Technicaloperations Op : ListOp) {
                if (Op.getIntermediatecrop() == null || Op.getIntermediatecrop().getCrop() == null) continue;
                ThisCrop = Op.getIntermediatecrop().getCrop().getName();
                ThisCrop = ThisCrop.replace("\u00e8", "%");
                ThisCrop = ThisCrop.replace("'", "''");
                CdtPluriCropList = entityManager.createQuery("SELECT p FROM PluriCrop p WHERE p.crop LIKE '" + ThisCrop + "'").getResultList();
                for (PluriCrop p : CdtPluriCropList) {
                    IdFamily = p.getIdFamily().getIdfa();
                    if (FamilyList.contains(IdFamily)) continue;
                    FamilyList.add(IdFamily);
                }
                CdtPluriCropList.clear();
            }
        }
        for (Object e : FamilyList) {
            IdFamily = this.ToolBox.SetAsA_Int(e.toString());
            FC = IntCalc.GetFC(IndexPlot, IdFamily);
            FC_InterCrop = 0.0;
            FC_InterCrop = IntCalc.GetFC_InterCrop(IndexPlot, IdFamily);
            FC += FC_InterCrop;
            FC /= N;
            FC = Math.pow(FC, 2.0);
            FcGlobal += FC;
        }
        Indicateur = 1.0 / FcGlobal;
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    private boolean familyInCrop(String Crop2, int IdFamily) {
        EntityManager entityManager = this.emf.createEntityManager();
        boolean In = false;
        List CdtPluriCropList = entityManager.createQuery("SELECT p FROM PluriCrop p WHERE p.crop LIKE '" + Crop2 + "'").getResultList();
        for (PluriCrop p : CdtPluriCropList) {
            if (IdFamily != p.getIdFamily().getIdfa()) continue;
            In = true;
        }
        return In;
    }

    public double GetValueDFC(int IndexPlot) throws ParseException {
        IntermediateCalc IntCalc = new IntermediateCalc();
        EntityManager entityManager = this.emf.createEntityManager();
        ArrayList<Integer> FamilyList = new ArrayList<Integer>();
        ArrayList<Integer> FamilyInterCropList = new ArrayList<Integer>();
        ItkMod ItkTool = new ItkMod();
        List OpList = null;
        String ThisCrop = "";
        double Indicateur = 0.0;
        double FC = 0.0;
        double FC_InterCrop = 0.0;
        double FC_Cdt = 0.0;
        double N = 0.0;
        double FcGlobal = 0.0;
        int IndexCdt = 0;
        int IdFamily = 0;
        Parcelle P = (Parcelle)entityManager.find(Parcelle.class, (Object)IndexPlot);
        Collection<Conduites> lc = P.getConduitesCollection();
        List CdtView = entityManager.createQuery("SELECT c FROM Conduites c WHERE c.idcdt = -1").getResultList();
        CdtView.clear();
        CdtView.addAll(lc);
        N = IntCalc.GetN(IndexPlot, true);
        for (Conduites C : CdtView) {
            IndexCdt = C.getIdcdt();
            ThisCrop = ((Crop)entityManager.find(Crop.class, (Object)C.getIdculture())).getName();
            ThisCrop = ThisCrop.replace("\u00e8", "%");
            ThisCrop = ThisCrop.replace("'", "''");
            List ListOp = OpList = ItkTool.GetListOfOP(C.getIdcdt());
            List CdtPluriCropList = entityManager.createQuery("SELECT p FROM PluriCrop p WHERE p.crop LIKE '" + ThisCrop + "'").getResultList();
            for (PluriCrop p : CdtPluriCropList) {
                IdFamily = p.getIdFamily().getIdfa();
                if (FamilyList.contains(IdFamily) && FamilyInterCropList.contains(IdFamily)) continue;
                if (!FamilyList.contains(IdFamily)) {
                    FC = IntCalc.GetFC(IndexPlot, IdFamily);
                    FamilyList.add(IdFamily);
                }
                if (!FamilyInterCropList.contains(IdFamily)) {
                    for (Technicaloperations Op : ListOp) {
                        if (Op.getIntermediatecrop() == null || Op.getIntermediatecrop().getCrop() == null) continue;
                        String ThisInterCrop = Op.getIntermediatecrop().getCrop().getName();
                        FC += (FC_InterCrop += this.DefineFC(false, ThisInterCrop, IdFamily, IndexPlot));
                        FC_InterCrop = 0.0;
                        FamilyInterCropList.add(IdFamily);
                    }
                }
                FC_Cdt += FC;
                FC = 0.0;
            }
            for (Technicaloperations Op : ListOp) {
                if (Op.getIntermediatecrop() == null || Op.getIntermediatecrop().getCrop() == null) continue;
                String ThisInterCrop = Op.getIntermediatecrop().getCrop().getName();
                ThisInterCrop = ThisInterCrop.replace("\u00e8", "%");
                ThisInterCrop = ThisInterCrop.replace("'", "''");
                List CdtPluriInterCropList = entityManager.createQuery("SELECT p FROM PluriCrop p WHERE p.crop LIKE '" + ThisInterCrop + "'").getResultList();
                IdFamily = 0;
                for (PluriCrop pInt : CdtPluriInterCropList) {
                    IdFamily = pInt.getIdFamily().getIdfa();
                    if (FamilyInterCropList.contains(IdFamily)) continue;
                    FC_InterCrop = IntCalc.GetFC_InterCrop(IndexPlot, IdFamily);
                    FamilyInterCropList.add(IdFamily);
                    if (!FamilyList.contains(IdFamily)) {
                        FamilyList.add(IdFamily);
                        for (Conduites Cdt : CdtView) {
                            FC_InterCrop += this.DefineFC(true, ((Crop)entityManager.find(Crop.class, (Object)Cdt.getIdculture())).getName(), IdFamily, IndexPlot);
                        }
                    }
                    FC_Cdt += FC_InterCrop;
                    FC_InterCrop = 0.0;
                }
            }
            ThisCrop = "";
            FC_Cdt /= N;
            FC_Cdt = Math.pow(FC_Cdt, 2.0);
            FcGlobal += FC_Cdt;
            FC_Cdt = 0.0;
        }
        Indicateur = 1.0 / FcGlobal;
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    private double DefineFC(boolean MainCrop, String Crop2, int IdFamily, int IndexPlot) {
        IntermediateCalc IntCalc = new IntermediateCalc();
        EntityManager entityManager = this.emf.createEntityManager();
        String ThisCrop = Crop2.replace("\u00e8", "%");
        ThisCrop = ThisCrop.replace("'", "''");
        List CdtPluriCropList = entityManager.createQuery("SELECT p FROM PluriCrop p WHERE p.crop LIKE '" + ThisCrop + "'").getResultList();
        double diversity = 0.0;
        for (PluriCrop p : CdtPluriCropList) {
            if (p.getIdFamily().getIdfa() != IdFamily) continue;
            if (MainCrop) {
                diversity = IntCalc.GetFC(IndexPlot, IdFamily);
                continue;
            }
            diversity = IntCalc.GetFC_InterCrop(IndexPlot, IdFamily);
        }
        return diversity;
    }

    public double GetValueMN2OB(int IDcdt) throws ParseException {
        EntityManager entityManager = this.emf.createEntityManager();
        IntermediateCalc IntCalc = new IntermediateCalc();
        Conduites C = (Conduites)entityManager.find(Conduites.class, (Object)IDcdt);
        List TecOpList = entityManager.createQuery("SELECT t FROM Technicaloperations t WHERE t.idtechop = -1").getResultList();
        double Indicateur = 0.0;
        double doseapporteetotale = 0.0;
        double dosecultTotale = 0.0;
        double sommeazotevolat = 0.0;
        double Csol = 0.0;
        double Cirr = 0.0;
        double Cmodeapport = 0.0;
        double XRN = 0.0;
        String Famille2 = "";
        boolean Cminwsol = true;
        int countFertil = 0;
        int countFamily = 0;
        int countFamilyFabacee = 0;
        Cmodeapport = 1.0;
        List CdtPluriCropList = entityManager.createQuery("SELECT p FROM PluriCrop p").getResultList();
        for (PluriCrop pl : CdtPluriCropList) {
            Famille2 = pl.getIdFamily().getNamef();
            Famille2 = Famille2.toLowerCase();
            if (pl.getIdCrop().getIdcult().intValue() != C.getIdculture()) continue;
            if (Famille2.equals("fabac\u00e9es") || Famille2.equals("fabacees")) {
                ++countFamilyFabacee;
            }
            ++countFamily;
        }
        if (Famille2.equals("Aucune")) {
            this.MsgOption = 14;
        }
        try {
            Csol = IntCalc.GetCsol(IDcdt);
        }
        catch (NullPointerException rex) {
            Csol = 0.0;
        }
        try {
            Cirr = IntCalc.GetCirr(IDcdt);
        }
        catch (NullPointerException rex) {
            Cirr = 0.0;
        }
        try {
            this.lp = IntCalc.GetLp(IDcdt);
        }
        catch (NullPointerException rex) {
            this.lp = 0.0;
        }
        sommeazotevolat = IntCalc.GetSommeAzoteVolat(IDcdt);
        doseapporteetotale = IntCalc.GetDoseAppTT(IDcdt, true);
        dosecultTotale = IntCalc.GetDoseAppTT(IDcdt, false);
        XRN = IntCalc.GetXRN(IDcdt);
        TecOpList.clear();
        TecOpList.addAll(C.getTechnicaloperationsCollection());
        for (Technicaloperations Op : TecOpList) {
            if (Op.getFertilization() != null && Op.getFertilization().getFertilizer1().getPn() > 0.0) {
                ++countFertil;
            }
            if (Op.getFertilization() == null || Cmodeapport == 1.1 || Op.getFertilization().getIdfertilization() == null) continue;
            Cmodeapport = IntCalc.GetCmodeapport(Op.getFertilization().getIdfertilization(), IDcdt);
        }
        if (countFertil == 0) {
            this.MsgOption = 6;
        }
        Indicateur = dosecultTotale <= XRN ? (doseapporteetotale - sommeazotevolat) * 0.0125 * Csol * (double)Cminwsol * Cmodeapport * Cirr : (Indicateur += ((doseapporteetotale - sommeazotevolat) * 0.0125 + 0.5 * (dosecultTotale - sommeazotevolat - this.lp - XRN) * 0.0175) * Csol * (double)Cminwsol * Cmodeapport * Cirr);
        if (countFamilyFabacee != 0 && countFamilyFabacee != countFamily && countFertil == 0) {
            Indicateur = 3.0;
        } else if (countFamilyFabacee == countFamily && countFamily > 0) {
            Indicateur = 3.0;
        }
        if (this.MsgOption == 0) {
            this.MsgOption = IntCalc.MsgOption;
        }
        try {
            this.D += IntCalc.Drainage;
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    public double GetValueEEN(int IndexHarvesting, Double CENB) throws ParseException {
        double Indicateur = 0.0;
        double Pouvoircalorifique = 0.0;
        double rdt = 0.0;
        Query MyQuery = null;
        EntityManager entityManager = this.emf.createEntityManager();
        MyQuery = entityManager.createNamedQuery("Harvesting.findByIdharvest");
        List HaView = MyQuery.setParameter("idHarvest", (Object)IndexHarvesting).getResultList();
        if (!HaView.isEmpty()) {
            for (Harvesting H : HaView) {
                try {
                    Pouvoircalorifique = H.getCategorie().equals("R\u00e9colte plante enti\u00e8re") ? ((Crop)entityManager.find(Crop.class, (Object)H.getIdcrop().getIdcult())).getpcipe() : (H.getCategorie().equals("R\u00e9colte grain/racine/tubercule") || H.getCategorie().equals("R\u00e9colte grain 2") ? ((Crop)entityManager.find(Crop.class, (Object)H.getIdcrop().getIdcult())).getpcigrain().doubleValue() : ((Crop)entityManager.find(Crop.class, (Object)H.getIdcrop().getIdcult())).getpcipaille().doubleValue());
                }
                catch (NullPointerException ex) {
                    Pouvoircalorifique = 0.0;
                }
                if (H.getCategorie().equals("R\u00e9colte grain/racine/tubercule") || H.getCategorie().equals("R\u00e9colte grain 2")) {
                    double Humiref = 0.0;
                    CultureMod CropTools = new CultureMod();
                    try {
                        Humiref = CropTools.GetHumiditeRef(H.getIdcrop().getIdcult());
                    }
                    catch (ParseException ex) {
                        Humiref = 0.0;
                    }
                    try {
                        rdt = H.getRendement() * (100.0 - H.getHumiditeRecolte()) / (100.0 - Humiref);
                    }
                    catch (NullPointerException ex) {
                        rdt = 0.0;
                    }
                } else {
                    try {
                        rdt = H.getRendement();
                    }
                    catch (NullPointerException ex) {
                        rdt = 0.0;
                    }
                }
                if (H.getEquipment().getPerformancedetravail() > 0.0 && !H.getCategorie().equals("R\u00e9colte plante enti\u00e8re") && !H.getCategorie().equals("R\u00e9colte grain/racine/tubercule") && !H.getCategorie().equals("R\u00e9colte grain 2")) {
                    this.PEN = this.PEN + Pouvoircalorifique * rdt * 1000.0;
                    continue;
                }
                if (!H.getCategorie().equals("R\u00e9colte plante enti\u00e8re") && !H.getCategorie().equals("R\u00e9colte grain/racine/tubercule") && !H.getCategorie().equals("R\u00e9colte grain 2")) continue;
                this.PEN = this.PEN + Pouvoircalorifique * rdt * 1000.0;
            }
        }
        entityManager.clear();
        entityManager.close();
        Indicateur = this.PEN == 0.0 ? 0.0 : this.PEN / CENB;
        return Indicateur;
    }

    public double GetValueEEN_Parcelle(int Idcdt, int Rotation) throws ParseException {
        double Indicateur = 0.0;
        IntermediateCalc IntCalc = new IntermediateCalc();
        Indicateur = IntCalc.CM;
        return Indicateur;
    }

    public double GetDMEAU(int IndexSowing, int IndexRecolte, String Culture, int IdStation, int cdtId) throws ParseException {
        double DMEAU = 0.0;
        int jourSemi = 0;
        int monthSemi = 0;
        int jourRecolte = 0;
        int monthRecolte = 0;
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            Sowing Sw = (Sowing)entityManager.find(Sowing.class, (Object)IndexSowing);
            jourSemi = Sw.getJour();
            monthSemi = Sw.getMois();
        }
        catch (NullPointerException ex) {
            jourSemi = 0;
            monthSemi = 0;
            System.out.println("valeur sowing pour DMEAU = null");
        }
        try {
            Harvesting Hrs = (Harvesting)entityManager.find(Harvesting.class, (Object)IndexRecolte);
            jourRecolte = Hrs.getJour();
            monthRecolte = Hrs.getMois();
        }
        catch (NullPointerException ext) {
            jourRecolte = 0;
            monthRecolte = 0;
            System.out.println("valeur recolte pour DMEAU = null");
        }
        IntermediateCalc IntCalc = new IntermediateCalc();
        DMEAU = IntCalc.GetSommeETM(jourSemi, monthSemi, jourRecolte, monthRecolte, Culture, IdStation, cdtId);
        IntCalc = null;
        entityManager.clear();
        entityManager.close();
        return DMEAU;
    }

    public double GetValueAUTEA(int idIRRIG) {
        double Indicateur = 0.0;
        boolean i = false;
        EntityManager entityManager = this.emf.createEntityManager();
        IntermediateCalc IntCalc = new IntermediateCalc();
        Query MyQuery = entityManager.createNamedQuery("Irrigation.findByIdirr");
        List IrrList = MyQuery.setParameter("idirr", (Object)idIRRIG).getResultList();
        if (IrrList.isEmpty()) {
            this.MsgOption = 1;
        }
        for (Irrigation Ir : IrrList) {
            if (Ir.getQuantite() == null || Ir.getQuantite() == 0.0) continue;
            Indicateur += Ir.getQuantite().doubleValue();
        }
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    public double GetValueAUTEA_Parcelle(int idtIrrigation) {
        double Indicateur = 0.0;
        Indicateur = this.GetValueAUTEA(idtIrrigation);
        return Indicateur;
    }

    public double GetValueTOX(int IndexIpest) {
        boolean countTnx = false;
        String AppDate = "";
        double Indicateur = 0.0;
        this.NbTx = 0.0;
        String ClassTnx = "";
        Query MyQuery = null;
        EntityManager entityManager = this.emf.createEntityManager();
        MyQuery = entityManager.createQuery("SELECT p FROM Pesticideapp p WHERE p.idpestapp = " + IndexIpest);
        List IphyView = MyQuery.getResultList();
        if (!IphyView.isEmpty()) {
            for (Pesticideapp Ip : IphyView) {
                try {
                    AppDate = "Date" + Ip.getJour() + "," + Ip.getMois();
                }
                catch (NullPointerException ex) {
                    AppDate = "";
                }
                try {
                    ClassTnx = Ip.getPesticide().getClassetnx();
                    ClassTnx = ClassTnx.toLowerCase();
                }
                catch (NullPointerException ex) {
                    ClassTnx = "non";
                }
                if (!ClassTnx.equals("oui") || this.DateAppList.indexOf(AppDate) >= 0) continue;
                this.DateAppList.add(AppDate);
                this.NbTx += 1.0 * Ip.getFrequencedintervention();
            }
        }
        entityManager.clear();
        entityManager.close();
        Indicateur = this.NbTx;
        return Indicateur;
    }

    public double GetValueInterCropTOX(int IndexIpest) {
        boolean countTnx = false;
        String AppDate = "";
        double Indicateur = 0.0;
        this.NbTx = 0.0;
        String ClassTnx = "";
        Query MyQuery = null;
        EntityManager entityManager = this.emf.createEntityManager();
        MyQuery = entityManager.createQuery("SELECT h FROM Herbicideintercropapp h WHERE h.idherbicideapp = " + IndexIpest);
        List IphyView = MyQuery.getResultList();
        if (!IphyView.isEmpty()) {
            for (Herbicideintercropapp Ip : IphyView) {
                try {
                    AppDate = "Date" + Ip.getJour() + "," + Ip.getMois();
                }
                catch (NullPointerException ex) {
                    AppDate = "";
                }
                try {
                    ClassTnx = Ip.getIdpest().getClassetnx();
                    ClassTnx = ClassTnx.toLowerCase();
                }
                catch (NullPointerException ex) {
                    ClassTnx = "non";
                }
                if (!ClassTnx.equals("oui") || this.DateAppList.indexOf(AppDate) >= 0) continue;
                this.DateAppList.add(AppDate);
                this.NbTx += 1.0 * Ip.getFrequencedintervention();
            }
        }
        entityManager.clear();
        entityManager.close();
        Indicateur = this.NbTx;
        return Indicateur;
    }

    public double GetValueTOX_Parcelle(int IndexIpest) {
        double Indicateur = 0.0;
        Indicateur = this.GetValueTOX(IndexIpest);
        return Indicateur;
    }

    public double GetValueTVTE(int IndexCdt) {
        EntityManager entityManager = this.emf.createEntityManager();
        Conduites cdt = (Conduites)entityManager.find(Conduites.class, (Object)IndexCdt);
        List CdtList = entityManager.createQuery("SELECT c FROM Conduites c WHERE c.idcdt = -1").getResultList();
        ArrayList<Integer> culture = new ArrayList<Integer>();
        double ValSUC = 0.0;
        int IdParcelle = 0;
        try {
            IdParcelle = cdt.getParcelle().getIdparcelle();
        }
        catch (NullPointerException ex) {
            IdParcelle = 0;
            System.out.println("L'identifiant parcelle est null pour la recherche de la valeur PC (methode GetPC)");
        }
        Parcelle P = (Parcelle)entityManager.find(Parcelle.class, (Object)IdParcelle);
        CdtList.clear();
        CdtList.addAll(P.getConduitesCollection());
        for (Conduites C : CdtList) {
            int IdTempCult = C.getIdculture();
            if (culture.contains(IdTempCult)) continue;
            culture.add(IdTempCult);
            ValSUC += 1.0;
        }
        entityManager.clear();
        entityManager.close();
        return ValSUC;
    }

    public double GetValueMSN(double AD, double PB, double CO, double CM, int Rotation) {
        double Indicateur = 0.0;
        if (AD + PB != 0.0) {
            Indicateur = AD + PB - CO - CM;
        }
        return Indicateur;
    }

    public double GetValueIND(double AD, double MSN, int Rotation) {
        double Indicateur = 0.0;
        if (MSN > 0.0) {
            Indicateur = (1.0 - AD / MSN) * 100.0;
        }
        return Indicateur;
    }

    public double GetValueEFF(double AD, double PB, double CT) {
        double Indicateur = 0.0;
        Indicateur = CT > 0.0 ? PB / CT * 100.0 : 100.0;
        return Indicateur;
    }

    public double GetValueEFF_Parcelle(double AD, double PB, double CO) {
        double Indicateur = 0.0;
        Indicateur = this.GetValueEFF(AD, PB, CO);
        Indicateur = (1.0 - Indicateur) * 100.0;
        return Indicateur;
    }

    public double GetValueQAP(Technicaloperations Op, int Crop_id) {
        double Indicateur = 0.0;
        double SommeE = 0.0;
        double P2o5 = 0.0;
        double Dose = 0.0;
        double Factp = 0.0;
        double freq = 0.0;
        EngraisEquivMod Equiv = new EngraisEquivMod();
        try {
            P2o5 = Op.getFertilization().getFertilizer1().getP2o5() / 100.0;
        }
        catch (NullPointerException ex) {
            P2o5 = 0.0;
        }
        try {
            Dose = Op.getFertilization().getDose();
        }
        catch (NullPointerException ex) {
            Dose = 0.0;
        }
        try {
            freq = Op.getFertilization().getFrequencedintervention();
        }
        catch (NullPointerException ex) {
            freq = 0.0;
        }
        Indicateur = SommeE = P2o5 * (Dose *= freq);
        return Indicateur;
    }

    public double GetValuePSPH(Technicaloperations Op) {
        double Indicateur = 0.0;
        double SommeE = 0.0;
        double P2o5 = 0.0;
        double Dose = 0.0;
        double freq = 0.0;
        String formeP = "";
        boolean formpIsOk = false;
        try {
            P2o5 = Op.getFertilization().getFertilizer1().getP2o5() / 100.0;
        }
        catch (NullPointerException ex) {
            P2o5 = 0.0;
        }
        try {
            Dose = Op.getFertilization().getDose();
        }
        catch (NullPointerException ex) {
            Dose = 0.0;
        }
        try {
            freq = Op.getFertilization().getFrequencedintervention();
        }
        catch (NullPointerException ex) {
            freq = 0.0;
        }
        Dose *= freq;
        try {
            formeP = Op.getFertilization().getFertilizer1().getFormep().toLowerCase();
        }
        catch (NullPointerException ex) {
            formeP = "";
        }
        switch (formeP = formeP.replace('\u00e9', 'e')) {
            case "soluble ": {
                formpIsOk = true;
                break;
            }
            case "p naturelles": {
                formpIsOk = true;
                break;
            }
            case "scories": {
                formpIsOk = true;
                break;
            }
            case "minerale": {
                formpIsOk = true;
                break;
            }
            case "mineral": {
                formpIsOk = true;
                break;
            }
            case "organo-mineral": {
                formpIsOk = true;
                break;
            }
            default: {
                formpIsOk = false;
            }
        }
        if (formpIsOk) {
            try {
                SommeE = P2o5 * Dose;
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
        }
        Indicateur = SommeE;
        return Indicateur;
    }

    public double GetValueMSO(int IdParcelle, int Idcdt) {
        double Indicateur = 0.0;
        double Par = 0.0;
        double PebblesP = 0.0;
        double Ax2 = 0.0;
        double Ar2 = 0.0;
        double FactIrr = 0.0;
        double FactTravSol = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        IntermediateCalc VariableInter = new IntermediateCalc();
        try {
            VariableInter.MsgOption = 0;
            Par = VariableInter.GetPar(IdParcelle);
        }
        catch (NullPointerException rex) {
            this.MsgOption = VariableInter.MsgOption;
            System.out.println(rex + " sur calcul Par");
        }
        try {
            PebblesP = ((Parcelle)entityManager.find(Parcelle.class, (Object)IdParcelle)).getSoil().getPebbles();
        }
        catch (NullPointerException rex) {
            this.MsgOption = 3;
            System.out.println(rex + " sur la recherche du % cailloux");
        }
        Ar2 = VariableInter.GetAr(Par, PebblesP);
        FactIrr = VariableInter.GetFacteurIrr(Idcdt, IdParcelle);
        FactTravSol = VariableInter.GetFacteurTravailSol(Idcdt, IdParcelle);
        Ar2 = Ar2 * FactIrr * FactTravSol;
        Ax2 = VariableInter.GetAx(Idcdt, IdParcelle);
        Indicateur = 7.0 * Ax2 / Ar2;
        Indicateur = Math.min(10.0, Indicateur);
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    public double GetValueIRRC(int IlotId, int Idcdt) {
        String DateCritiqueD = "";
        String d = "";
        int D1 = 0;
        int D2 = 0;
        int M1 = 0;
        int M2 = 0;
        int countIr = 0;
        int DateDebut = 0;
        int DateFin = 0;
        int DateIrrc = 0;
        String DateCritiqueFin = "";
        double Indicateur = 0.0;
        boolean DateCritikNotOk = false;
        EntityManager entityManager = this.emf.createEntityManager();
        LasyTools Tools = new LasyTools();
        Ilot Il = (Ilot)entityManager.find(Ilot.class, (Object)IlotId);
        try {
            DateCritiqueD = Il.getDatepsechedebut();
            d = DateCritiqueD.substring(0, 2);
            D1 = Tools.SetAsA_Int(d);
            d = DateCritiqueD.substring(3, 5);
            M1 = Tools.SetAsA_Int(d);
            DateDebut = Tools.GetActualDayCalendar(D1, M1);
        }
        catch (ParseException rex) {
            DateCritikNotOk = true;
        }
        catch (NullPointerException rex) {
            DateCritikNotOk = true;
        }
        try {
            DateCritiqueFin = Il.getDatepsechefin();
            d = DateCritiqueFin.substring(0, 2);
            D2 = Tools.SetAsA_Int(d);
            d = DateCritiqueFin.substring(3, 5);
            M2 = Tools.SetAsA_Int(d);
            DateFin = Tools.GetActualDayCalendar(D2, M2);
        }
        catch (ParseException rex) {
            DateCritikNotOk = true;
        }
        catch (NullPointerException rex) {
            DateCritikNotOk = true;
        }
        if (!DateCritikNotOk) {
            List OpTecList = entityManager.createQuery("SELECT t FROM Technicaloperations t WHERE t.idtechop = -1").getResultList();
            Collection<Technicaloperations> OpTecCollection = ((Conduites)entityManager.find(Conduites.class, (Object)Idcdt)).getTechnicaloperationsCollection();
            OpTecList.clear();
            OpTecList.addAll(OpTecCollection);
            for (Technicaloperations Tec : OpTecList) {
                if (Tec.getIrrigation() == null) continue;
                DateIrrc = Tools.GetActualDayCalendar(Tec.getIrrigation().getJour(), Tec.getIrrigation().getMois());
                if (DateIrrc >= DateDebut && DateIrrc <= DateFin) {
                    Indicateur += Tec.getIrrigation().getQuantite() * Tec.getIrrigation().getFrequence();
                }
                ++countIr;
            }
            if (countIr == 0) {
                this.MsgOption = 1;
            }
        } else {
            Indicateur = 0.0;
            this.MsgOption = 2;
        }
        entityManager.clear();
        entityManager.close();
        Tools = null;
        return Indicateur;
    }

    public double GetEMP(int idCdte) {
        VarsGlobalMod VG = new VarsGlobalMod();
        String EquipOutil = "";
        double EMP = 0.0;
        boolean ExecuteCO = false;
        boolean error = false;
        boolean noOp = true;
        List OpList = null;
        double NH = 0.0;
        ArrayList<String> CalculSet = new ArrayList<String>();
        EntityManager entityManager = this.emf.createEntityManager();
        if (idCdte != 0) {
            ItkMod ItkTool = new ItkMod();
            OutilMod Outil = new OutilMod();
            OpList = ItkTool.GetListOfOP(idCdte);
            List ListOp = OpList;
            if (!ListOp.isEmpty()) {
                for (Technicaloperations T : ListOp) {
                    String StrOutil;
                    int Crop2 = T.getConduites().getIdculture();
                    String thisCrop = ((Crop)entityManager.find(Crop.class, (Object)Crop2)).getName();
                    if (T.getHarvesting() != null) {
                        noOp = false;
                        try {
                            error = false;
                            EquipOutil = T.getHarvesting().getEquipment().getName();
                        }
                        catch (NullPointerException ex) {
                            EquipOutil = "";
                            error = true;
                        }
                        try {
                            StrOutil = "j" + T.getHarvesting().getJour() + "m" + T.getHarvesting().getMois() + "outil" + T.getHarvesting().getEquipment().getName();
                            if (!CalculSet.contains(StrOutil) && !error) {
                                CalculSet.add(StrOutil);
                                ExecuteCO = true;
                            } else {
                                ExecuteCO = false;
                            }
                        }
                        catch (NullPointerException ex) {
                            ExecuteCO = false;
                        }
                        String LowCaseData = "";
                        LowCaseData = thisCrop.toLowerCase();
                        LowCaseData = LowCaseData.replace("\u00ef", "i");
                        if (ExecuteCO) {
                            try {
                                NH = T.getHarvesting().getEquipment().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getHarvesting().getEquipment().getPerformancedetravail()) : (NH += 0.0);
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (T.getTillage() != null) {
                        noOp = false;
                        try {
                            error = false;
                            EquipOutil = T.getTillage().getIdequipment().getName();
                        }
                        catch (NullPointerException ex) {
                            EquipOutil = "";
                            error = true;
                        }
                        try {
                            StrOutil = "j" + T.getTillage().getJour() + "m" + T.getTillage().getMois() + "outil" + T.getTillage().getIdequipment().getName();
                            if (!CalculSet.contains(StrOutil) && !error) {
                                CalculSet.add(StrOutil);
                                ExecuteCO = true;
                            } else {
                                ExecuteCO = false;
                            }
                        }
                        catch (NullPointerException ex) {
                            ExecuteCO = false;
                        }
                        if (ExecuteCO) {
                            try {
                                NH = T.getTillage().getIdequipment().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getTillage().getIdequipment().getPerformancedetravail() * T.getTillage().getFrequencedintervention()) : (NH += 0.0);
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (T.getIrrigation() != null) {
                        noOp = false;
                        try {
                            error = false;
                            EquipOutil = T.getIrrigation().getEquipment().getName();
                        }
                        catch (NullPointerException ex) {
                            EquipOutil = "";
                            error = true;
                        }
                        try {
                            StrOutil = "j" + T.getIrrigation().getJour() + "m" + T.getIrrigation().getMois() + "outil" + T.getIrrigation().getEquipment().getName();
                            if (!CalculSet.contains(StrOutil) && !error) {
                                CalculSet.add(StrOutil);
                                ExecuteCO = true;
                            } else {
                                ExecuteCO = false;
                            }
                        }
                        catch (NullPointerException ex) {
                            ExecuteCO = false;
                        }
                        if (ExecuteCO) {
                            try {
                                NH = T.getIrrigation().getEquipment().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getIrrigation().getEquipment().getPerformancedetravail() * T.getIrrigation().getFrequence()) : (NH += 0.0);
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (T.getSowing() != null) {
                        noOp = false;
                        try {
                            error = false;
                            EquipOutil = T.getSowing().getIdequip().getName();
                        }
                        catch (NullPointerException ex) {
                            EquipOutil = "";
                            error = true;
                        }
                        try {
                            StrOutil = "j" + T.getSowing().getJour() + "m" + T.getSowing().getMois() + "outil" + EquipOutil;
                            if (!CalculSet.contains(StrOutil) && !error) {
                                CalculSet.add(StrOutil);
                                ExecuteCO = true;
                            } else {
                                ExecuteCO = false;
                            }
                        }
                        catch (NullPointerException ex) {
                            ExecuteCO = false;
                        }
                        if (ExecuteCO) {
                            try {
                                NH = T.getSowing().getIdequip().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getSowing().getIdequip().getPerformancedetravail()) : (NH += 0.0);
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (T.getFertilization() != null) {
                        noOp = false;
                        try {
                            error = false;
                            EquipOutil = T.getFertilization().getEquipment().getName();
                        }
                        catch (NullPointerException ex) {
                            EquipOutil = "";
                            error = true;
                        }
                        try {
                            StrOutil = "j" + T.getFertilization().getJour() + "m" + T.getFertilization().getMois() + "outil" + T.getFertilization().getEquipment().getName();
                            if (!CalculSet.contains(StrOutil) && !error) {
                                CalculSet.add(StrOutil);
                                ExecuteCO = true;
                            } else {
                                ExecuteCO = false;
                            }
                        }
                        catch (NullPointerException ex) {
                            ExecuteCO = false;
                        }
                        if (ExecuteCO) {
                            try {
                                NH = T.getFertilization().getEquipment().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getFertilization().getEquipment().getPerformancedetravail() * T.getFertilization().getFrequencedintervention()) : (NH += 0.0);
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (T.getPesticideapp() != null) {
                        noOp = false;
                        try {
                            error = false;
                            EquipOutil = T.getPesticideapp().getOutil().getName();
                        }
                        catch (NullPointerException ex) {
                            EquipOutil = "";
                            error = true;
                        }
                        try {
                            StrOutil = "j" + T.getPesticideapp().getJour() + "m" + T.getPesticideapp().getMois() + "outil" + T.getPesticideapp().getOutil().getName();
                            if (!CalculSet.contains(StrOutil) && !error) {
                                CalculSet.add(StrOutil);
                                ExecuteCO = true;
                            } else {
                                ExecuteCO = false;
                            }
                        }
                        catch (NullPointerException ex) {
                            ExecuteCO = false;
                        }
                        if (ExecuteCO) {
                            try {
                                NH = T.getPesticideapp().getOutil().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getPesticideapp().getOutil().getPerformancedetravail() * T.getPesticideapp().getFrequencedintervention()) : (NH += 0.0);
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (T.getProduitbioapp() != null) {
                        noOp = false;
                        try {
                            error = false;
                            EquipOutil = T.getProduitbioapp().getOutil();
                        }
                        catch (NullPointerException ex) {
                            EquipOutil = "";
                            error = true;
                        }
                        try {
                            StrOutil = "j" + T.getProduitbioapp().getJour() + "m" + T.getProduitbioapp().getMois() + "outil" + T.getProduitbioapp().getOutil();
                            if (!CalculSet.contains(StrOutil) && !error) {
                                CalculSet.add(StrOutil);
                                ExecuteCO = true;
                            } else {
                                ExecuteCO = false;
                            }
                        }
                        catch (NullPointerException ex) {
                            ExecuteCO = false;
                        }
                        if (ExecuteCO) {
                            try {
                                NH = T.getProduitbioapp().getIdequip().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getProduitbioapp().getIdequip().getPerformancedetravail() * T.getProduitbioapp().getFrequence()) : (NH += 0.0);
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (T.getIntermediatecrop() != null) {
                        noOp = false;
                        if (T.getIntermediatecrop().getSowing() != null) {
                            try {
                                error = false;
                                EquipOutil = T.getIntermediatecrop().getSowing().getIdequip().getName();
                            }
                            catch (NullPointerException ex) {
                                EquipOutil = "";
                                error = true;
                            }
                            try {
                                StrOutil = "j" + T.getIntermediatecrop().getSowing().getJour() + "m" + T.getIntermediatecrop().getSowing().getMois() + "outil" + EquipOutil;
                                if (!CalculSet.contains(StrOutil) && !error) {
                                    CalculSet.add(StrOutil);
                                    ExecuteCO = true;
                                } else {
                                    ExecuteCO = false;
                                }
                            }
                            catch (NullPointerException ex) {
                                ExecuteCO = false;
                            }
                            if (ExecuteCO) {
                                try {
                                    NH = T.getIntermediatecrop().getSowing().getIdequip().getPerformancedetravail() > 0.0 ? (NH += 1.0 / T.getIntermediatecrop().getSowing().getIdequip().getPerformancedetravail()) : (NH += 0.0);
                                }
                                catch (NullPointerException ex) {
                                    NH += 0.0;
                                }
                            }
                        }
                        List ListHerbi = entityManager.createQuery("SELECT h FROM Herbicideintercropapp h WHERE h.idherbicideapp = -1").getResultList();
                        Collection<Serializable> lc = T.getIntermediatecrop().getHerbicideintercropappCollection();
                        ListHerbi.clear();
                        ListHerbi.addAll(lc);
                        for (Herbicideintercropapp Hb : ListHerbi) {
                            try {
                                error = false;
                                EquipOutil = Hb.getEquipname();
                            }
                            catch (NullPointerException ex) {
                                EquipOutil = "";
                                error = true;
                            }
                            try {
                                String StrOutil2 = "j" + Hb.getJour() + "m" + Hb.getMois() + "outil" + EquipOutil;
                                if (!CalculSet.contains(StrOutil2) && !error) {
                                    CalculSet.add(StrOutil2);
                                    ExecuteCO = true;
                                } else {
                                    ExecuteCO = false;
                                }
                            }
                            catch (NullPointerException ex) {
                                ExecuteCO = false;
                            }
                            if (!ExecuteCO) continue;
                            try {
                                if (Hb.getIdequip().getPerformancedetravail() * Hb.getFrequencedintervention() > 0.0) {
                                    NH += 1.0 / Hb.getIdequip().getPerformancedetravail() * Hb.getFrequencedintervention();
                                    continue;
                                }
                                NH += 0.0;
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                        List ListTillageInter = entityManager.createQuery("SELECT t FROM Tillageintercrop t WHERE t.idtillageinter = -1").getResultList();
                        lc = T.getIntermediatecrop().getTillageintercropCollection();
                        ListTillageInter.clear();
                        ListTillageInter.addAll(lc);
                        for (Tillageintercrop Tl : ListTillageInter) {
                            try {
                                error = false;
                                EquipOutil = Tl.getTillage().getIdequipment().getName();
                            }
                            catch (NullPointerException ex) {
                                EquipOutil = "";
                                error = true;
                            }
                            try {
                                String StrOutil3 = "j" + Tl.getTillage().getJour() + "m" + Tl.getTillage().getMois() + "outil" + EquipOutil;
                                if (!CalculSet.contains(StrOutil3) && !error) {
                                    CalculSet.add(StrOutil3);
                                    ExecuteCO = true;
                                } else {
                                    ExecuteCO = false;
                                }
                            }
                            catch (NullPointerException ex) {
                                ExecuteCO = false;
                            }
                            if (!ExecuteCO) continue;
                            try {
                                if (Tl.getTillage().getIdequipment().getPerformancedetravail() > 0.0) {
                                    NH += 1.0 / Tl.getTillage().getIdequipment().getPerformancedetravail() * Tl.getTillage().getFrequencedintervention();
                                    continue;
                                }
                                NH += 0.0;
                            }
                            catch (NullPointerException ex) {
                                NH += 0.0;
                            }
                        }
                    }
                    if (!noOp) continue;
                    this.MsgOption = 1;
                }
            }
        }
        EMP = NH;
        infoCdtMod infocdt = new infoCdtMod();
        try {
            EMP += infocdt.getLaborNbr(idCdte);
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        entityManager.clear();
        entityManager.close();
        return EMP;
    }

    public double GetFMP(int idCdte) {
        infoCdtMod CdtInfo = new infoCdtMod();
        double FMP = 0.0;
        List OpList = null;
        double ira = 0.0;
        double iri = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        if (idCdte != 0) {
            ItkMod ItkTool = new ItkMod();
            OpList = ItkTool.GetListOfOP(idCdte);
            List ListOp = OpList;
            if (!ListOp.isEmpty()) {
                for (Technicaloperations T : ListOp) {
                    if (T.getHarvesting() == null) continue;
                    try {
                        if (T.getHarvesting().getCategorie().equals("R\u00e9colte paille") || T.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) continue;
                        if (T.getHarvesting().getCategorie().equals("R\u00e9colte plante enti\u00e8re")) {
                            ira += T.getHarvesting().getRendement().doubleValue();
                            continue;
                        }
                        if (T.getHarvesting().getIdcrop().getRefMsGrainPourcent() == 0.0 || T.getHarvesting().getHumiditeRecolte() == 100.0) {
                            ira += T.getHarvesting().getRendement().doubleValue();
                            continue;
                        }
                        ira += T.getHarvesting().getRendement() * ((100.0 - T.getHarvesting().getHumiditeRecolte()) / T.getHarvesting().getIdcrop().getRefMsGrainPourcent());
                    }
                    catch (NullPointerException ex) {}
                }
                if (ira <= 0.0) {
                    for (Technicaloperations T : ListOp) {
                        if (T.getHarvesting() == null) continue;
                        try {
                            if (!(T.getHarvesting().getEquipment().getPerformancedetravail() > 0.0) || !T.getHarvesting().getCategorie().equals("R\u00e9colte paille") && !T.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) continue;
                            ira += T.getHarvesting().getRendement().doubleValue();
                        }
                        catch (NullPointerException ex) {}
                    }
                }
            }
            try {
                iri = CdtInfo.GetRdtCdtIntensive(idCdte);
            }
            catch (NullPointerException ex) {
                iri = 1.0;
                this.MsgOption = 1;
            }
            if (iri == 0.0) {
                iri = 1.0;
                this.MsgOption = 1;
            }
        }
        FMP = this.MsgOption == 0 ? ira / iri * 100.0 : 0.0;
        entityManager.clear();
        entityManager.close();
        return FMP;
    }

    public double GetFMPMO(int idCdte, double FMP, double EMP) {
        infoCdtMod CdtInfo = new infoCdtMod();
        EntityManager entityManager = this.emf.createEntityManager();
        double FMPMO = 0.0;
        double NHi = 0.0;
        if (FMP != 0.0) {
            try {
                List DataconduiteView = entityManager.createQuery("SELECT d FROM Dataconduite d").getResultList();
                for (Dataconduite d : DataconduiteView) {
                    if (d.getIdcdt().getIdcdt() != idCdte) continue;
                    try {
                        NHi = d.getNbhJobReq();
                    }
                    catch (NullPointerException ex) {
                        NHi = 1.0;
                        this.MsgOption = 2;
                    }
                    NHi = d.getNbhJobReq();
                }
            }
            catch (NullPointerException rex) {
                NHi = 0.0;
            }
        } else {
            this.MsgOption = 1;
        }
        if (NHi == 0.0) {
            NHi = 1.0;
            this.MsgOption = 2;
        }
        FMPMO = this.MsgOption == 0 ? FMP / (EMP / NHi) : 0.0;
        return FMPMO;
    }

    public int GetSens(int idParcelle) {
        IntermediateCalc InterCalc = new IntermediateCalc();
        int Sens2 = 0;
        Sens2 = InterCalc.GetSensibility(idParcelle);
        if (InterCalc.MsgOption != 0) {
            this.MsgOption = InterCalc.MsgOption;
        }
        return Sens2;
    }

    public double GetCIC(int idCdte) {
        EntityManager entityManager = this.emf.createEntityManager();
        int IdCrp = 0;
        double k = 0.0;
        try {
            IdCrp = ((Conduites)entityManager.find(Conduites.class, (Object)idCdte)).getIdculture();
            if (!Beans.isDesignTime() && !entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
            }
            List ListCic = entityManager.createNamedQuery("Cic.findAll").getResultList();
            for (Cic CIC : ListCic) {
                if (CIC.getIdcrop() == null || IdCrp != CIC.getIdcrop().getIdcult()) continue;
                try {
                    k = CIC.getK();
                }
                catch (NullPointerException ex) {
                    k = 0.0;
                }
            }
        }
        catch (NullPointerException rex) {
            System.out.println("Erreur sur calcul CIC");
        }
        return k;
    }

    public double GetBCAP(int idCdte) {
        ItkMod ItkTool;
        List ListOp;
        infoCdtMod CdtInfo = new infoCdtMod();
        double BCAP = 0.0;
        double rnd = 0.0;
        List OpList = null;
        double Qapport = 0.0;
        double teneurP2O5Rnd = 0.0;
        double teneurP2O5RndGr1 = 0.0;
        double teneurP2O5RndGr2 = 0.0;
        double teneurP2O5RndPaille = 0.0;
        double teneurP2O5RndPaille2 = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        if (idCdte != 0 && !(ListOp = (OpList = (ItkTool = new ItkMod()).GetListOfOP(idCdte))).isEmpty()) {
            for (Technicaloperations T : ListOp) {
                if (T.getFertilization() != null) {
                    try {
                        Qapport += T.getFertilization().getFertilizer1().getP2o5() * (T.getFertilization().getDose() / 100.0) * T.getFertilization().getFrequencedintervention();
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                }
                if (T.getHarvesting() == null) continue;
                double Humiref = 0.0;
                CultureMod CropTools = new CultureMod();
                Crop thisCrop = T.getHarvesting().getIdcrop();
                try {
                    Humiref = CropTools.GetHumiditeRef(thisCrop.getIdcult());
                }
                catch (ParseException ex) {
                    Humiref = 0.0;
                }
                if (T.getHarvesting().getCategorie().equals("R\u00e9colte grain/racine/tubercule") || T.getHarvesting().getCategorie().equals("R\u00e9colte grain 2")) {
                    try {
                        if (teneurP2O5RndGr1 == 0.0) {
                            teneurP2O5RndGr1 = T.getHarvesting().getRendement() * (100.0 - T.getHarvesting().getHumiditeRecolte()) / (100.0 - Humiref);
                            teneurP2O5RndGr1 *= thisCrop.getKgP2o5Op().doubleValue();
                            continue;
                        }
                        teneurP2O5RndGr2 = T.getHarvesting().getRendement() * (100.0 - T.getHarvesting().getHumiditeRecolte()) / (100.0 - Humiref);
                        teneurP2O5RndGr2 *= thisCrop.getKgP2o5Op().doubleValue();
                    }
                    catch (NullPointerException ex) {}
                    continue;
                }
                if (!T.getHarvesting().getCategorie().equals("R\u00e9colte plante enti\u00e8re")) continue;
                Crop thisCropPe = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                try {
                    teneurP2O5Rnd = T.getHarvesting().getRendement() * thisCropPe.getKgP2o5Pe();
                }
                catch (NullPointerException ex) {}
            }
            for (Technicaloperations T : ListOp) {
                if (T.getHarvesting() == null || !(T.getHarvesting().getEquipment().getPerformancedetravail() > 0.0)) continue;
                if (T.getHarvesting().getCategorie().equals("R\u00e9colte paille")) {
                    Crop thisCropP1 = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                    try {
                        rnd = T.getHarvesting().getRendement();
                        teneurP2O5RndPaille = rnd * thisCropP1.getKgP2o5Re();
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                }
                if (!T.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) continue;
                Crop thisCropP2 = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                try {
                    rnd = T.getHarvesting().getRendement();
                    teneurP2O5RndPaille2 = rnd * thisCropP2.getKgP2o5Re();
                }
                catch (NullPointerException ex) {}
            }
        }
        BCAP = Qapport - teneurP2O5RndGr1 - teneurP2O5RndGr2 - teneurP2O5RndPaille - teneurP2O5Rnd;
        entityManager.clear();
        entityManager.close();
        return BCAP;
    }

    public double GetBCAK(int idCdte) {
        infoCdtMod CdtInfo = new infoCdtMod();
        double BCAK = 0.0;
        double rnd = 0.0;
        List OpList = null;
        double Qapport = 0.0;
        double TeneurK_Rnd = 0.0;
        double teneurK_RndGr1 = 0.0;
        double teneurK_RndGr2 = 0.0;
        double teneurK_RndPaille = 0.0;
        double teneurK_RndPaille2 = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        if (idCdte != 0) {
            ItkMod ItkTool = new ItkMod();
            OpList = ItkTool.GetListOfOP(idCdte);
            List ListOp = OpList;
            if (!ListOp.isEmpty()) {
                for (Technicaloperations T : ListOp) {
                    if (T.getFertilization() != null) {
                        try {
                            Qapport += T.getFertilization().getFertilizer1().getk2o() * (T.getFertilization().getDose() / 100.0) * T.getFertilization().getFrequencedintervention();
                        }
                        catch (NullPointerException ex) {
                            Qapport = 0.0;
                        }
                    }
                    if (T.getHarvesting() == null) continue;
                    double Humiref = 0.0;
                    CultureMod CropTools = new CultureMod();
                    Crop thisCrop = T.getHarvesting().getIdcrop();
                    try {
                        Humiref = CropTools.GetHumiditeRef(thisCrop.getIdcult());
                    }
                    catch (ParseException ex) {
                        Humiref = 0.0;
                    }
                    if (T.getHarvesting().getCategorie().equals("R\u00e9colte grain/racine/tubercule") || T.getHarvesting().getCategorie().equals("R\u00e9colte grain 2")) {
                        try {
                            if (teneurK_RndGr1 == 0.0) {
                                teneurK_RndGr1 = T.getHarvesting().getRendement() * (100.0 - T.getHarvesting().getHumiditeRecolte()) / (100.0 - Humiref);
                                teneurK_RndGr1 *= thisCrop.getKgK2oOp().doubleValue();
                                continue;
                            }
                            teneurK_RndGr2 = T.getHarvesting().getRendement() * (100.0 - T.getHarvesting().getHumiditeRecolte()) / (100.0 - Humiref);
                            teneurK_RndGr2 *= thisCrop.getKgK2oOp().doubleValue();
                        }
                        catch (NullPointerException ex) {}
                        continue;
                    }
                    if (!T.getHarvesting().getCategorie().equals("R\u00e9colte plante enti\u00e8re")) continue;
                    Crop thisCropPe = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                    try {
                        TeneurK_Rnd = T.getHarvesting().getRendement() * thisCropPe.getKgK2oPe();
                    }
                    catch (NullPointerException ex) {}
                }
            }
            for (Technicaloperations T : ListOp) {
                if (T.getHarvesting() == null || !(T.getHarvesting().getEquipment().getPerformancedetravail() > 0.0)) continue;
                rnd = T.getHarvesting().getRendement();
                if (T.getHarvesting().getCategorie().equals("R\u00e9colte paille")) {
                    Crop thisCropP1 = T.getHarvesting().getIdcrop();
                    try {
                        teneurK_RndPaille = rnd * thisCropP1.getKgK2oRe();
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                }
                if (!T.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) continue;
                Crop thisCropP2 = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                try {
                    teneurK_RndPaille2 = rnd * thisCropP2.getKgK2oRe();
                }
                catch (NullPointerException ex) {}
            }
        }
        BCAK = Qapport - teneurK_RndGr1 - teneurK_RndGr2 - teneurK_RndPaille - teneurK_RndPaille2 - TeneurK_Rnd;
        entityManager.clear();
        entityManager.close();
        return BCAK;
    }

    public double GetBCAN(int idCdte) {
        ItkMod ItkTool;
        List ListOp;
        infoCdtMod CdtInfo = new infoCdtMod();
        double BCAN = 0.0;
        double rnd = 0.0;
        List OpList = null;
        double Qapport = 0.0;
        double QapportMin = 0.0;
        double TeneurN_Rnd = 0.0;
        double teneurN_RndGr1 = 0.0;
        double teneurN_RndGr2 = 0.0;
        double teneurN_RndPaille = 0.0;
        double teneurK_RndPaille2 = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        if (idCdte != 0 && !(ListOp = (OpList = (ItkTool = new ItkMod()).GetListOfOP(idCdte))).isEmpty()) {
            for (Technicaloperations T : ListOp) {
                if (T.getFertilization() != null) {
                    try {
                        if (T.getFertilization().getFertilizer1().getMineral().equals("oui")) {
                            QapportMin += T.getFertilization().getFertilizer1().getPn() * (T.getFertilization().getDose() / 100.0) * T.getFertilization().getFrequencedintervention();
                        }
                        Qapport += T.getFertilization().getFertilizer1().getPn() * (T.getFertilization().getDose() / 100.0) * T.getFertilization().getFrequencedintervention();
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                }
                if (T.getHarvesting() == null) continue;
                double Humiref = 0.0;
                CultureMod CropTools = new CultureMod();
                Crop thisCrop = T.getHarvesting().getIdcrop();
                try {
                    Humiref = CropTools.GetHumiditeRef(thisCrop.getIdcult());
                }
                catch (ParseException ex) {
                    Humiref = 0.0;
                }
                if (T.getHarvesting().getCategorie().equals("R\u00e9colte grain/racine/tubercule") || T.getHarvesting().getCategorie().equals("R\u00e9colte grain 2")) {
                    try {
                        if (teneurN_RndGr1 == 0.0) {
                            teneurN_RndGr1 = T.getHarvesting().getRendement() * (100.0 - T.getHarvesting().getHumiditeRecolte()) / (100.0 - Humiref);
                            teneurN_RndGr1 *= thisCrop.getKgNOp().doubleValue();
                            continue;
                        }
                        teneurN_RndGr2 = T.getHarvesting().getRendement() * (100.0 - T.getHarvesting().getHumiditeRecolte()) / (100.0 - Humiref);
                        teneurN_RndGr2 *= thisCrop.getKgNOp().doubleValue();
                    }
                    catch (NullPointerException ex) {}
                    continue;
                }
                if (!T.getHarvesting().getCategorie().equals("R\u00e9colte plante enti\u00e8re")) continue;
                Crop thisCropPe = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                try {
                    TeneurN_Rnd = T.getHarvesting().getRendement() * thisCropPe.getKgNPe();
                }
                catch (NullPointerException ex) {}
            }
            for (Technicaloperations T : ListOp) {
                Crop thisCrop;
                if (T.getHarvesting() == null || !(T.getHarvesting().getEquipment().getPerformancedetravail() > 0.0)) continue;
                rnd = T.getHarvesting().getRendement();
                if (T.getHarvesting().getCategorie().equals("R\u00e9colte paille")) {
                    thisCrop = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                    try {
                        teneurN_RndPaille = rnd * thisCrop.getKgNRe();
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                }
                if (!T.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) continue;
                thisCrop = (Crop)entityManager.find(Crop.class, (Object)T.getConduites().getIdculture());
                try {
                    teneurK_RndPaille2 = rnd * thisCrop.getKgNRe();
                }
                catch (NullPointerException ex) {}
            }
        }
        this.QANTOT = Qapport;
        this.QANMIN = QapportMin;
        BCAN = Qapport - teneurN_RndGr1 - teneurN_RndGr2 - teneurN_RndPaille - teneurK_RndPaille2 - TeneurN_Rnd;
        entityManager.clear();
        entityManager.close();
        return BCAN;
    }

    public double GetRIP(int idCdte) {
        ItkMod ItkTool;
        List ListOp;
        infoCdtMod CdtInfo = new infoCdtMod();
        double RIP = 0.0;
        List OpList = null;
        double QtP = 0.0;
        double RndCrop = 0.0;
        double RIP_Sum = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        if (idCdte != 0 && !(ListOp = (OpList = (ItkTool = new ItkMod()).GetListOfOP(idCdte))).isEmpty()) {
            for (Technicaloperations T : ListOp) {
                if (T.getHarvesting() == null) continue;
                Crop thisCrop = (Crop)entityManager.find(Crop.class, (Object)T.getHarvesting().getIdcrop().getIdcult());
                if (T.getHarvesting().getCoutEnergetiqueH() != null && T.getHarvesting().getCoutEnergetiqueH() != 0.0 && T.getHarvesting().getEquipment().getPerformancedetravail() != 0.0) continue;
                try {
                    if (T.getHarvesting().getCategorie().equals("R\u00e9colte paille") || T.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) {
                        QtP = thisCrop.getKgP2o5Re();
                        try {
                            RndCrop = T.getHarvesting().getRendement();
                        }
                        catch (NullPointerException ex) {}
                    }
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                RIP_Sum += QtP * RndCrop;
                RndCrop = 0.0;
                QtP = 0.0;
            }
        }
        RIP = RIP_Sum;
        entityManager.clear();
        entityManager.close();
        return RIP;
    }

    public double GetRIK(int idCdte) {
        ItkMod ItkTool;
        List ListOp;
        infoCdtMod CdtInfo = new infoCdtMod();
        double RIK = 0.0;
        List OpList = null;
        double QtK = 0.0;
        double RndCrop = 0.0;
        double RIK_Sum = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        if (idCdte != 0 && !(ListOp = (OpList = (ItkTool = new ItkMod()).GetListOfOP(idCdte))).isEmpty()) {
            for (Technicaloperations T : ListOp) {
                if (T.getHarvesting() == null) continue;
                Crop thisCrop = (Crop)entityManager.find(Crop.class, (Object)T.getHarvesting().getIdcrop().getIdcult());
                if (T.getHarvesting().getCoutEnergetiqueH() != null && T.getHarvesting().getCoutEnergetiqueH() != 0.0 && T.getHarvesting().getEquipment().getPerformancedetravail() != 0.0) continue;
                try {
                    if (T.getHarvesting().getCategorie().equals("R\u00e9colte paille") || T.getHarvesting().getCategorie().equals("R\u00e9colte paille 2")) {
                        QtK = thisCrop.getKgK2oRe();
                        try {
                            RndCrop = T.getHarvesting().getRendement();
                        }
                        catch (NullPointerException ex) {}
                    }
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                RIK_Sum += QtK * RndCrop;
                RndCrop = 0.0;
                QtK = 0.0;
            }
        }
        RIK = RIK_Sum;
        entityManager.clear();
        entityManager.close();
        return RIK;
    }

    public double GetQS(int Idcdt, int Idplot) {
        IntermediateCalc InterCalc = new IntermediateCalc();
        EntityManager entityManager = this.emf.createEntityManager();
        Parcelle Plot = (Parcelle)entityManager.find(Parcelle.class, (Object)Idplot);
        ItkMod ItkTool = new ItkMod();
        int IdConduite = 0;
        int IdCrp = 0;
        double Qs2 = 0.0;
        double Risk = 0.0;
        String technique_culturale = "";
        String variete = "";
        List OpList = null;
        IdConduite = InterCalc.GetRotation(Idplot, Idcdt);
        OpList = ItkTool.GetListOfOP(Idcdt);
        List ListOp = OpList;
        if (!ListOp.isEmpty()) {
            try {
                technique_culturale = ((Conduites)entityManager.find(Conduites.class, (Object)Idcdt)).getProfondeurtravsol();
            }
            catch (NullPointerException rex) {
                technique_culturale = "";
                System.out.println("technique culturale non renseign\u00e9e");
            }
            if (technique_culturale == null) {
                technique_culturale = "";
                System.out.println("technique culturale non renseign\u00e9e");
            }
            for (Technicaloperations T : ListOp) {
                if (T.getSowing() == null) continue;
                try {
                    variete = T.getSowing().getVariete();
                    variete = variete.toLowerCase();
                }
                catch (NullPointerException rex) {
                    variete = "";
                }
            }
            if (!technique_culturale.isEmpty() && !variete.isEmpty()) {
                try {
                    IdCrp = ((Conduites)entityManager.find(Conduites.class, (Object)Idcdt)).getIdculture();
                    String Sensitive = ((Crop)entityManager.find(Crop.class, (Object)IdCrp)).getFusarioseSensitive();
                    Sensitive = Sensitive.toLowerCase();
                    if (Sensitive.equals("oui")) {
                        IdCrp = ((Conduites)entityManager.find(Conduites.class, (Object)IdConduite)).getIdculture();
                        Risk = InterCalc.GetRiskQs(technique_culturale, variete, IdCrp);
                    }
                }
                catch (NullPointerException rex) {
                    Risk = 0.0;
                    System.out.println("Sensibilit\u00e9 \u00e0 la fusariose non d\u00e9fini");
                }
            }
        }
        Qs2 = Risk;
        return Qs2;
    }

    public double GetValueMPNO3(int Idcdt, Double LP) {
        double Indicateur = 0.0;
        int idP = 0;
        int AnneeN = 0;
        this.MineralRes = 0.0;
        this.MineralSol = 0.0;
        this.Nabs = 0.0;
        EntityManager entityManager = this.emf.createEntityManager();
        IntermediateCalc VariableInter = new IntermediateCalc();
        if (LP.isNaN()) {
            LP = 0.0;
        }
        try {
            idP = ((Conduites)entityManager.find(Conduites.class, (Object)Idcdt)).getParcelle().getIdparcelle();
        }
        catch (NullPointerException rex) {
            idP = 0;
        }
        try {
            this.lh = VariableInter.GetLh(Idcdt, LP);
            this.BilanI = VariableInter.BilanInterCulture;
            this.NX = VariableInter.XRE;
            this.MineralRes = VariableInter.MineralRes;
            this.MineralSol = VariableInter.MineralSol;
            this.Nabs = VariableInter.ValNabs;
        }
        catch (NullPointerException rex) {
            this.lh = 0.0;
        }
        try {
            this.D += VariableInter.Drainage;
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            AnneeN = ((Parcelle)entityManager.find(Parcelle.class, (Object)idP)).getNbanneesrotation();
            this.MsgOption = VariableInter.MsgOption;
        }
        catch (NullPointerException rex) {
            AnneeN = 1;
            this.MsgOption = VariableInter.MsgOption != 0 ? VariableInter.MsgOption : 5;
        }
        VariableInter = null;
        Indicateur = LP + this.lh;
        this.lp = 0.0;
        this.lh = 0.0;
        entityManager.clear();
        entityManager.close();
        return Indicateur;
    }

    public double getEPA(int IndexPlot) {
        IntermediateCalc InterCalc = new IntermediateCalc();
        double Indicateur = 0.0;
        double BA = 0.0;
        double UEA = 0.0;
        double EXC = 0.0;
        double PLR = 0.0;
        try {
            UEA = InterCalc.getUEA(IndexPlot);
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            EXC = InterCalc.getEXC(IndexPlot);
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            PLR = InterCalc.getPLR(IndexPlot);
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            BA = InterCalc.getBA(IndexPlot);
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        Indicateur = UEA + EXC + PLR + BA;
        return Indicateur;
    }
}

