/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Conduites;
import DataBase.Equipment;
import DataBase.Sowing;
import DataBase.Technicaloperations;
import Interfaces.HarvestFrame;
import Interfaces.InterCultureFrame;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modules.CultureMod;
import modules.ItkMod;
import modules.LasyTools;
import modules.OutilMod;
import modules.SowingMod;
import org.jdesktop.observablecollections.ObservableCollections;

public class SemisFrame
extends JFrame {
    OutilMod Outil = new OutilMod();
    LasyTools Tool = new LasyTools();
    Query MyQuery;
    int ConduiteID;
    int idCulture;
    int IdOutil;
    int idSm;
    double densite;
    double CoutSem;
    double prix;
    double CoutEnergie;
    double CoutEco;
    boolean AddSemis = false;
    boolean OnUpdate = false;
    boolean ExitMsg = false;
    private JButton CloseButton;
    JTextField CoutSemField;
    JLabel CoutSemLabel;
    JTextField DensiteField;
    JLabel DensiteLabel;
    JTextArea JTextAreaInfoNode;
    JTextField ObjRendementField;
    JLabel ObjrendementLabel;
    JTextField PrixField;
    JLabel PrixLabel;
    JTextField UnitSemField;
    JLabel UnitSemLabel;
    private JButton deleteButton;
    private EntityManager entityManager;
    JMenuItem exitMenuItem;
    JMenu fileMenu;
    JComboBox jComboBoxFusariose;
    JComboBox jComboBoxOutil;
    JComboBox jComboBoxTypeSem;
    JLabel jLabelControlDate;
    JLabel jLabelCurrentCdt;
    JLabel jLabelCurrentCrop;
    JLabel jLabelFusariose;
    JLabel jLabelTypSem;
    JTextPane jLabelWarning;
    JPanel jPanel1;
    JScrollPane jScrollPane1;
    JScrollPane jScrollPaneInfoNode;
    JComboBox jourField;
    JLabel jourLabel;
    List list;
    JMenuBar menuBar;
    JComboBox moisField;
    JLabel moisLabel;
    private Query query;
    JLabel rendementLabel1;
    private JButton saveButton;
    JMenuItem saveMenuItem;

    public SemisFrame() {
        this.initComponents();
        this.InitListOutil();
        this.jLabelWarning.setText("");
    }

    public SemisFrame(int idcdt, int idCult) throws ParseException {
        this.initComponents();
        this.InitListOutil();
        this.ConduiteID = idcdt;
        this.idCulture = idCult;
        this.InitSemisData();
        this.setLocation(this.Tool.CentreFrame(this));
        this.AfficheCdtSelect();
        this.jLabelControlDate.setVisible(false);
        ResourceBundle B = ResourceBundle.getBundle("Interfaces/resources/SemisBundle");
        this.jComboBoxTypeSem.setModel(new DefaultComboBoxModel<String>(new String[]{B.getString("Type_semences1"), B.getString("Type_semences2"), B.getString("Type_semences3"), B.getString("Type_semences4"), B.getString("Type_semences5")}));
        this.jComboBoxFusariose.setModel(new DefaultComboBoxModel<String>(new String[]{B.getString("fusariose1"), B.getString("fusariose2"), B.getString("fusariose3")}));
        this.jLabelWarning.setText("");
    }

    private void AfficheCdtSelect() {
        CultureMod CropT = new CultureMod();
        this.jLabelCurrentCdt.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONDUITE : ") + ((Conduites)this.entityManager.find(Conduites.class, (Object)this.ConduiteID)).getNomcdt());
        this.jLabelCurrentCrop.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CULTURE : ") + CropT.GetNameCultByIdCdt(this.ConduiteID));
    }

    private void InitSemisData() throws ParseException {
        CultureMod CropTools = new CultureMod();
        ItkMod ItkTool = new ItkMod();
        String OutilName = "";
        String UnitSem = CropTools.ReturnUnitSemence(this.idCulture);
        int LastSemisId = 0;
        this.idSm = ItkTool.getId_TillageSowingHarv(this.ConduiteID, 5);
        List listSm = this.entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SELECT S FROM SOWING S WHERE S.ID = ") + this.idSm).getResultList();
        this.list.clear();
        this.list.addAll(listSm);
        this.UnitSemField.setText(UnitSem);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRIMER"));
        if (!listSm.isEmpty()) {
            List listItk = ItkTool.GetListOfOP(this.ConduiteID);
            ArrayList<Integer> listElement = new ArrayList<Integer>();
            for (Technicaloperations Itk : listItk) {
                if (Itk.getSowing() == null) continue;
                LastSemisId = Itk.getSowing().getId();
                listElement.add(LastSemisId);
            }
            for (int i = 0; i < listElement.size(); ++i) {
                int identifiantSemis = this.Tool.SetAsA_Int(listElement.get(i).toString());
                if (identifiantSemis == LastSemisId) continue;
                this.DelSemisWithoutPromptMsg(identifiantSemis);
            }
            listSm = this.entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SELECT S FROM SOWING S WHERE S.ID = ") + LastSemisId).getResultList();
            for (Sowing Sm : listSm) {
                this.jourField.setBackground(new Color(255, 255, 255));
                this.jourField.setForeground(new Color(0, 0, 0));
                this.deleteButton.setEnabled(true);
                this.jourField.setSelectedItem(Sm.getJour().toString());
                this.moisField.setSelectedItem(Sm.getMois().toString());
                try {
                    OutilName = Sm.getIdequip().getName();
                }
                catch (NullPointerException ex) {
                    OutilName = "";
                }
                this.jComboBoxOutil.setSelectedItem(OutilName);
                this.ObjRendementField.setText(Sm.getObjectifrdt().toString());
                this.jComboBoxFusariose.setSelectedItem(Sm.getVariete());
                this.jComboBoxTypeSem.setSelectedItem(Sm.getTypedesemoir());
                this.PrixField.setText(Sm.getPrixsemencesparha().toString());
                this.densite = Sm.getDensite();
                this.DensiteField.setText(Sm.getDensite().toString());
                this.CoutSemField.setText(Sm.getCoutsemencesha().toString());
                this.AddSemis = false;
            }
        } else {
            this.jourField.setSelectedIndex(0);
            this.moisField.setSelectedIndex(0);
            this.jComboBoxOutil.setSelectedIndex(this.Outil.GetOutilDefaultIndex(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SEMOIR 4 M")));
            this.ObjRendementField.setText("");
            this.jComboBoxFusariose.setSelectedIndex(0);
            this.jComboBoxTypeSem.setSelectedIndex(0);
            this.PrixField.setText("" + CropTools.GetPriceCulture(this.idCulture));
            this.DensiteField.setText("");
            this.CoutSemField.setText("");
            this.deleteButton.setEnabled(false);
            this.jourField.requestFocus();
            this.AddSemis = true;
        }
        this.saveButton.setEnabled(false);
    }

    private void InitListOutil() {
        List OutilList = this.Outil.GetListOfOutil();
        this.jComboBoxOutil.removeAllItems();
        if (!OutilList.isEmpty()) {
            for (Equipment Eq : OutilList) {
                this.jComboBoxOutil.addItem(Eq.getName());
            }
        }
    }

    private void ControlDate(int j, int m) {
        LasyTools Tool = new LasyTools();
        ItkMod ItkTool = new ItkMod();
        boolean Before = false;
        int j2 = 0;
        int m2 = 0;
        List listItk = ItkTool.GetListOfOP(this.ConduiteID);
        for (Technicaloperations Itk : listItk) {
            if (Itk.getHarvesting() == null) continue;
            j2 = Itk.getHarvesting().getJour();
            m2 = Itk.getHarvesting().getMois();
        }
        Before = Tool.FirstDateIsEarly(j, m, j2, m2);
        if (!Before) {
            this.jLabelControlDate.setVisible(true);
        } else {
            this.jLabelControlDate.setVisible(false);
        }
    }

    private void SaveSemisData() throws ParseException {
        Sowing Sm = new Sowing();
        String OutilN = "";
        int IdCurrentSm = 0;
        double Bio = 0.0;
        double Rdt = 0.0;
        SowingMod SemisTools = new SowingMod();
        ItkMod ItkTool = new ItkMod();
        this.SetCouts();
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        if (this.AddSemis) {
            IdCurrentSm = SemisTools.getLastSemisId() + 1;
            Sm.setId(IdCurrentSm);
            this.idSm = IdCurrentSm;
        } else {
            Sm = (Sowing)this.entityManager.find(Sowing.class, (Object)this.idSm);
        }
        Sm.setJour(this.Tool.SetAsA_Int(this.jourField.getSelectedItem().toString()));
        Sm.setMois(this.Tool.SetAsA_Int(this.moisField.getSelectedItem().toString()));
        try {
            OutilN = this.jComboBoxOutil.getSelectedItem().toString();
        }
        catch (NullPointerException rex) {
            OutilN = "";
        }
        this.IdOutil = this.Outil.GetIdOutilByName(OutilN);
        Equipment OutilE = (Equipment)this.entityManager.find(Equipment.class, (Object)this.IdOutil);
        Sm.setIdequip(OutilE);
        Rdt = this.Tool.SetAsAdouble(this.ObjRendementField.getText());
        Sm.setObjectifrdt(Rdt);
        Sm.setTypedesemoir(this.jComboBoxTypeSem.getSelectedItem().toString());
        this.prix = SemisTools.Getprix(this.PrixField.getText());
        Sm.setPrixsemencesparha(this.prix);
        Sm.setDensite(this.densite);
        Sm.setCoutsemencesha(this.CoutSem);
        Sm.setCoutenergetique(this.CoutEnergie);
        Sm.setVariete(this.jComboBoxFusariose.getSelectedItem().toString());
        this.entityManager.persist((Object)Sm);
        this.entityManager.getTransaction().commit();
        this.entityManager.refresh((Object)Sm);
        if (this.AddSemis) {
            ItkTool.AddNewOp(5, Sm.getId(), this.ConduiteID);
            this.AddSemis = false;
        }
    }

    private void DeleteSemis() throws ParseException {
        int choix = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMER_LA_SUPPRESSION"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRESSION"), 2);
        if (choix == 0) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            this.query = this.entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SELECT S FROM SOWING S WHERE S.ID = ") + this.idSm);
            List SmView = this.query.getResultList();
            if (SmView != null) {
                for (Sowing sm : SmView) {
                    this.entityManager.remove((Object)sm);
                }
                this.list.removeAll(SmView);
                this.entityManager.getTransaction().commit();
                this.deleteButton.setEnabled(false);
            }
        }
    }

    private void DelSemisWithoutPromptMsg(int identifiantSemis) throws ParseException {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.query = this.entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SELECT S FROM SOWING S WHERE S.ID = ") + identifiantSemis);
        List SmView = this.query.getResultList();
        if (SmView != null) {
            for (Sowing sm : SmView) {
                this.entityManager.remove((Object)sm);
            }
            this.list.removeAll(SmView);
            this.entityManager.getTransaction().commit();
            this.deleteButton.setEnabled(false);
        }
    }

    private void SetCouts() {
        block9: {
            try {
                SowingMod SemisTools = new SowingMod();
                ItkMod ItkTool = new ItkMod();
                SemisTools.SetCouts(this.jComboBoxOutil.getSelectedItem().toString());
                boolean AddCout = false;
                int D = this.Tool.SetAsA_Int(this.jourField.getSelectedItem().toString());
                int M = this.Tool.SetAsA_Int(this.moisField.getSelectedItem().toString());
                String OutilN = "";
                try {
                    OutilN = this.jComboBoxOutil.getSelectedItem().toString();
                }
                catch (NullPointerException ex) {
                    OutilN = "";
                }
                AddCout = this.Outil.CalculCout(this.ConduiteID, D, M, OutilN);
                if (AddCout) {
                    try {
                        this.CoutEnergie = SemisTools.CoutEnergie;
                    }
                    catch (NullPointerException ex) {
                        this.CoutEnergie = 0.0;
                    }
                    try {
                        this.CoutEco = SemisTools.CoutEco;
                    }
                    catch (NullPointerException ex) {
                        this.CoutEco = 0.0;
                    }
                    break block9;
                }
                this.CoutEnergie = 0.0;
                this.CoutEco = 0.0;
            }
            catch (ParseException ex) {
                Logger.getLogger(SemisFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void refresh() {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void Onclose() {
        if (this.deleteButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"))) {
            int choix = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("MODIFICATIONS_NON_ENREGISTR\u00c9ES"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRESSION"), 2);
            if (choix == 0) {
                try {
                    this.InitSemisData();
                }
                catch (ParseException ex) {
                    Logger.getLogger(SemisFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.dispose();
            }
        } else {
            try {
                this.InitSemisData();
            }
            catch (ParseException ex) {
                Logger.getLogger(SemisFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.dispose();
        }
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/SemisBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT s FROM Sowing s");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.jPanel1 = new JPanel();
        this.CloseButton = new JButton();
        this.jourField = new JComboBox();
        this.moisLabel = new JLabel();
        this.saveButton = new JButton();
        this.deleteButton = new JButton();
        this.jComboBoxOutil = new JComboBox();
        this.moisField = new JComboBox();
        this.jourLabel = new JLabel();
        this.rendementLabel1 = new JLabel();
        this.ObjrendementLabel = new JLabel();
        this.ObjRendementField = new JTextField();
        this.jComboBoxTypeSem = new JComboBox();
        this.jLabelTypSem = new JLabel();
        this.PrixLabel = new JLabel();
        this.PrixField = new JTextField();
        this.DensiteLabel = new JLabel();
        this.DensiteField = new JTextField();
        this.CoutSemLabel = new JLabel();
        this.CoutSemField = new JTextField();
        this.UnitSemLabel = new JLabel();
        this.UnitSemField = new JTextField();
        this.jLabelCurrentCdt = new JLabel();
        this.jLabelCurrentCrop = new JLabel();
        this.jScrollPaneInfoNode = new JScrollPane();
        this.JTextAreaInfoNode = new JTextArea();
        this.jLabelControlDate = new JLabel();
        this.jLabelFusariose = new JLabel();
        this.jComboBoxFusariose = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jLabelWarning = new JTextPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.saveMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.setName("Semis");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                SemisFrame.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                SemisFrame.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jPanel1.setName("jPanel1");
        this.CloseButton.setBackground(new Color(51, 51, 51));
        this.CloseButton.setFont(new Font("Arial", 1, 12));
        this.CloseButton.setForeground(new Color(0, 1, 0));
        this.CloseButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.CloseButton.setText(bundle.getString("FERMER"));
        this.CloseButton.setToolTipText(bundle.getString("FERMER CE MENU"));
        this.CloseButton.setBorder(null);
        this.CloseButton.setBorderPainted(false);
        this.CloseButton.setContentAreaFilled(false);
        this.CloseButton.setFocusPainted(false);
        this.CloseButton.setHorizontalTextPosition(0);
        this.CloseButton.setName("CloseButton");
        this.CloseButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setVerifyInputWhenFocusTarget(false);
        this.CloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SemisFrame.this.CloseButtonMouseReleased(evt);
            }
        });
        this.jourField.setFont(new Font("Arial", 0, 12));
        this.jourField.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"}));
        this.jourField.setName("jourField");
        this.jourField.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                SemisFrame.this.jourFieldPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.moisLabel.setFont(new Font("Arial", 0, 12));
        this.moisLabel.setForeground(new Color(255, 254, 255));
        this.moisLabel.setText(bundle.getString("MOIS:"));
        this.moisLabel.setName("moisLabel");
        this.saveButton.setFont(new Font("Arial", 1, 12));
        this.saveButton.setForeground(new Color(0, 1, 0));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setBorder(null);
        this.saveButton.setContentAreaFilled(false);
        this.saveButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setName("saveButton");
        this.saveButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SemisFrame.this.saveButtonMouseEntered(evt);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemisFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setFont(new Font("Arial", 1, 12));
        this.deleteButton.setForeground(new Color(0, 1, 0));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.deleteButton.setText(bundle.getString("SUPPRIMER"));
        this.deleteButton.setBorder(null);
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SemisFrame.this.deleteButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SemisFrame.this.deleteButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SemisFrame.this.deleteButtonMouseReleased(evt);
            }
        });
        this.jComboBoxOutil.setFont(new Font("Arial", 0, 12));
        this.jComboBoxOutil.setName("jComboBoxOutil");
        this.jComboBoxOutil.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                SemisFrame.this.jComboBoxOutilPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.moisField.setFont(new Font("Arial", 0, 12));
        this.moisField.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}));
        this.moisField.setName("moisField");
        this.moisField.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                SemisFrame.this.moisFieldPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.jourLabel.setFont(new Font("Arial", 0, 12));
        this.jourLabel.setForeground(new Color(255, 254, 255));
        this.jourLabel.setText(bundle.getString("JOUR:"));
        this.jourLabel.setName("jourLabel");
        this.jourLabel.setForeground(new Color(255, 255, 255));
        this.rendementLabel1.setFont(new Font("Arial", 0, 12));
        this.rendementLabel1.setForeground(new Color(255, 254, 255));
        this.rendementLabel1.setText(bundle.getString("OUTIL:"));
        this.rendementLabel1.setName("rendementLabel1");
        this.rendementLabel1.setForeground(new Color(255, 255, 255));
        this.ObjrendementLabel.setFont(new Font("Arial", 0, 12));
        this.ObjrendementLabel.setForeground(new Color(255, 254, 255));
        this.ObjrendementLabel.setText(bundle.getString("OBJECTIF RENDEMENT (T/HA, \u00c0 LA NORME) :"));
        this.ObjrendementLabel.setName("ObjrendementLabel");
        this.ObjrendementLabel.setForeground(new Color(255, 255, 255));
        this.ObjRendementField.setFont(new Font("Arial", 0, 12));
        this.ObjRendementField.setName("ObjRendementField");
        this.ObjRendementField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SemisFrame.this.ObjRendementFieldFocusLost(evt);
            }
        });
        this.ObjRendementField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SemisFrame.this.ObjRendementFieldKeyTyped(evt);
            }
        });
        this.jComboBoxTypeSem.setFont(new Font("Arial", 0, 12));
        this.jComboBoxTypeSem.setModel(new DefaultComboBoxModel<String>(new String[]{"Certifi\u00e9es", "traitement standard", "Certifi\u00e9es", "traitement haut de gamme", "Ferme", "non trait\u00e9es", "Ferme", "traitement standard", "Ferme", "traitement haut de gamme"}));
        this.jComboBoxTypeSem.setName("jComboBoxTypeSem");
        this.jComboBoxTypeSem.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                SemisFrame.this.jComboBoxTypeSemPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.jLabelTypSem.setFont(new Font("Arial", 0, 12));
        this.jLabelTypSem.setForeground(new Color(255, 254, 255));
        this.jLabelTypSem.setText(bundle.getString("TYPE DE SEMENCES"));
        this.jLabelTypSem.setName("jLabelTypSem");
        this.jLabelTypSem.setForeground(new Color(255, 255, 255));
        this.PrixLabel.setFont(new Font("Arial", 0, 12));
        this.PrixLabel.setForeground(new Color(255, 254, 255));
        this.PrixLabel.setText(bundle.getString("PRIX(\u20ac) UNITAIRE:"));
        this.PrixLabel.setFocusable(false);
        this.PrixLabel.setName("PrixLabel");
        this.PrixLabel.setRequestFocusEnabled(false);
        this.PrixLabel.setForeground(new Color(255, 255, 255));
        this.PrixField.setFont(new Font("Arial", 0, 12));
        this.PrixField.setName("PrixField");
        this.PrixField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SemisFrame.this.PrixFieldFocusLost(evt);
            }
        });
        this.PrixField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SemisFrame.this.PrixFieldKeyTyped(evt);
            }
        });
        this.DensiteLabel.setFont(new Font("Arial", 0, 12));
        this.DensiteLabel.setForeground(new Color(255, 254, 255));
        this.DensiteLabel.setText(bundle.getString("DENSIT\u00c9 (HA):"));
        this.DensiteLabel.setFocusable(false);
        this.DensiteLabel.setName("DensiteLabel");
        this.DensiteLabel.setRequestFocusEnabled(false);
        this.DensiteLabel.setForeground(new Color(255, 255, 255));
        this.DensiteField.setFont(new Font("Arial", 0, 12));
        this.DensiteField.setName("DensiteField");
        this.DensiteField.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent evt) {
                SemisFrame.this.DensiteFieldComponentAdded(evt);
            }
        });
        this.DensiteField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SemisFrame.this.DensiteFieldFocusLost(evt);
            }
        });
        this.DensiteField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SemisFrame.this.DensiteFieldKeyTyped(evt);
            }
        });
        this.CoutSemLabel.setFont(new Font("Arial", 0, 12));
        this.CoutSemLabel.setForeground(new Color(255, 254, 255));
        this.CoutSemLabel.setText(bundle.getString("CO\u00dbT SEMENCES (\u20ac/HA):"));
        this.CoutSemLabel.setFocusable(false);
        this.CoutSemLabel.setName("CoutSemLabel");
        this.CoutSemLabel.setRequestFocusEnabled(false);
        this.CoutSemLabel.setForeground(new Color(255, 255, 255));
        this.CoutSemField.setEditable(false);
        this.CoutSemField.setFont(new Font("Arial", 0, 12));
        this.CoutSemField.setHorizontalAlignment(4);
        this.CoutSemField.setName("CoutSemField");
        this.CoutSemField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SemisFrame.this.CoutSemFieldKeyTyped(evt);
            }
        });
        this.UnitSemLabel.setFont(new Font("Arial", 0, 12));
        this.UnitSemLabel.setForeground(new Color(255, 254, 255));
        this.UnitSemLabel.setText(bundle.getString("UNIT\u00c9 DE LA SEMENCE :"));
        this.UnitSemLabel.setFocusable(false);
        this.UnitSemLabel.setName("UnitSemLabel");
        this.UnitSemLabel.setRequestFocusEnabled(false);
        this.UnitSemLabel.setForeground(new Color(255, 255, 255));
        this.UnitSemField.setEditable(false);
        this.UnitSemField.setFont(new Font("Arial", 0, 12));
        this.UnitSemField.setHorizontalAlignment(2);
        this.UnitSemField.setFocusable(false);
        this.UnitSemField.setName("UnitSemField");
        this.UnitSemField.setRequestFocusEnabled(false);
        this.UnitSemField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SemisFrame.this.UnitSemFieldKeyTyped(evt);
            }
        });
        this.jLabelCurrentCdt.setFont(new Font("Arial", 1, 12));
        this.jLabelCurrentCdt.setForeground(new Color(204, 255, 204));
        this.jLabelCurrentCdt.setText(bundle.getString("CONDUITE : "));
        this.jLabelCurrentCdt.setName("jLabelCurrentCdt");
        this.jLabelCurrentCrop.setFont(new Font("Arial", 1, 12));
        this.jLabelCurrentCrop.setForeground(new Color(204, 255, 204));
        this.jLabelCurrentCrop.setText(bundle.getString("CULTURE : "));
        this.jLabelCurrentCrop.setName("jLabelCurrentCrop");
        this.jScrollPaneInfoNode.setBackground(new Color(51, 51, 51));
        this.jScrollPaneInfoNode.setBorder(null);
        this.jScrollPaneInfoNode.setForeground(new Color(51, 51, 51));
        this.jScrollPaneInfoNode.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneInfoNode.setVerticalScrollBarPolicy(21);
        this.jScrollPaneInfoNode.setFocusable(false);
        this.jScrollPaneInfoNode.setName("jScrollPaneInfoNode");
        this.jScrollPaneInfoNode.setRequestFocusEnabled(false);
        this.JTextAreaInfoNode.setBackground(new Color(51, 51, 51));
        this.JTextAreaInfoNode.setColumns(20);
        this.JTextAreaInfoNode.setEditable(false);
        this.JTextAreaInfoNode.setFont(new Font("Arial", 0, 10));
        this.JTextAreaInfoNode.setForeground(new Color(102, 255, 51));
        this.JTextAreaInfoNode.setLineWrap(true);
        this.JTextAreaInfoNode.setRows(1);
        this.JTextAreaInfoNode.setWrapStyleWord(true);
        this.JTextAreaInfoNode.setFocusable(false);
        this.JTextAreaInfoNode.setName("JTextAreaInfoNode");
        this.JTextAreaInfoNode.setRequestFocusEnabled(false);
        this.JTextAreaInfoNode.setSelectedTextColor(new Color(51, 255, 51));
        this.JTextAreaInfoNode.setSelectionColor(new Color(153, 153, 153));
        this.jScrollPaneInfoNode.setViewportView(this.JTextAreaInfoNode);
        this.jLabelControlDate.setFont(new Font("Arial", 0, 11));
        this.jLabelControlDate.setForeground(Color.red);
        this.jLabelControlDate.setText(bundle.getString("DATE DE SEMIS POST\u00c9RIEUR \u00c0 LA DATE DE R\u00c9COLTE"));
        this.jLabelControlDate.setName("jLabelControlDate");
        this.jLabelFusariose.setFont(new Font("Arial", 0, 12));
        this.jLabelFusariose.setForeground(new Color(255, 254, 255));
        this.jLabelFusariose.setText(bundle.getString("SENSIBILIT\u00c9 DE LA VARI\u00c9T\u00c9 \u00c0 LA FUSARIOSE"));
        this.jLabelFusariose.setName("jLabelFusariose");
        this.jLabelTypSem.setForeground(new Color(255, 255, 255));
        this.jComboBoxFusariose.setFont(new Font("Arial", 0, 12));
        this.jComboBoxFusariose.setModel(new DefaultComboBoxModel<String>(new String[]{"Peu sensible", "Moyennement sensible", "Sensible"}));
        this.jComboBoxFusariose.setName("jComboBoxFusariose");
        this.jComboBoxFusariose.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                SemisFrame.this.jComboBoxFusariosePopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.jScrollPane1.setBackground(new Color(-12566464, true));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setName("jScrollPane1");
        this.jLabelWarning.setBackground(new Color(-13421773, true));
        this.jLabelWarning.setBorder(null);
        this.jLabelWarning.setFont(new Font("Dialog", 0, 10));
        this.jLabelWarning.setForeground(new Color(-256, true));
        this.jLabelWarning.setName("jLabelWarning");
        this.jScrollPane1.setViewportView(this.jLabelWarning);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.DensiteLabel).addGap(15, 15, 15).addComponent(this.DensiteField, -2, 40, -2).addGap(10, 10, 10).addComponent(this.UnitSemLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.UnitSemField, -2, 81, -2).addGap(10, 10, 10).addComponent(this.PrixLabel).addGap(15, 15, 15).addComponent(this.PrixField, -2, 81, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelFusariose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFusariose, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelTypSem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxTypeSem, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabelCurrentCdt, -1, 315, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabelCurrentCrop, -2, 269, -2).addGap(10, 10, 10)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.rendementLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxOutil, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jourLabel).addGap(45, 45, 45).addComponent(this.jourField, -2, 65, -2).addGap(37, 37, 37).addComponent(this.moisLabel).addGap(44, 44, 44).addComponent(this.moisField, -2, 65, -2))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.ObjrendementLabel).addGap(18, 18, 18).addComponent(this.ObjRendementField, -2, 40, -2)).addComponent(this.jLabelControlDate, -2, 223, -2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.CoutSemLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CoutSemField, -2, 81, -2))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.deleteButton, -2, 115, -2).addGap(130, 130, 130).addComponent(this.saveButton, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.CloseButton, -2, 116, -2)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneInfoNode, GroupLayout.Alignment.LEADING, -1, 602, Short.MAX_VALUE)).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCurrentCdt).addComponent(this.jLabelCurrentCrop)).addGap(1, 1, 1).addComponent(this.jScrollPaneInfoNode, -2, 26, -2).addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jourLabel).addComponent(this.jourField, -2, 20, -2).addComponent(this.moisLabel).addComponent(this.moisField, -2, 20, -2).addComponent(this.jLabelControlDate)).addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxOutil, -2, 20, -2).addComponent(this.rendementLabel1)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ObjrendementLabel).addComponent(this.ObjRendementField, -2, 20, -2))).addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTypSem).addComponent(this.jComboBoxTypeSem, -2, 20, -2)).addGap(15, 15, 15).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelFusariose).addComponent(this.jComboBoxFusariose, -2, 20, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.DensiteLabel).addComponent(this.DensiteField, -2, 20, -2).addComponent(this.UnitSemLabel).addComponent(this.UnitSemField, -2, 20, -2).addComponent(this.PrixLabel).addComponent(this.PrixField, -2, 20, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CoutSemLabel).addComponent(this.CoutSemField, -2, 20, -2)).addGap(2, 2, 2).addComponent(this.jScrollPane1, -2, 28, -2).addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton, -2, 49, -2).addComponent(this.saveButton, -2, 49, -2).addComponent(this.CloseButton, -2, 52, -2))));
        this.menuBar.setName("menuBar");
        this.fileMenu.setText(bundle.getString("DONN\u00c9ES SEMIS"));
        this.fileMenu.setName("fileMenu");
        this.fileMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SemisFrame.this.fileMenuMouseClicked(evt);
            }
        });
        this.saveMenuItem.setText(bundle.getString("ENREGISTRER"));
        this.saveMenuItem.setName("saveMenuItem");
        this.saveMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SemisFrame.this.saveMenuItemMouseClicked(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.exitMenuItem.setText(bundle.getString("FERMER"));
        this.exitMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SemisFrame.this.exitMenuItemMouseClicked(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void CloseButtonMouseReleased(MouseEvent evt) {
        this.Onclose();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.AddSemis) {
                this.SaveSemisData();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("ENREGISTREMENT REUSSI !"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
                this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRIMER"));
            } else {
                int choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMER_ENREGISTREMENT"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMATION DE SAUVEGARDE"), 2);
                if (choix == 0) {
                    this.SaveSemisData();
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("MISE \u00c0 JOUR EFFECTU\u00c9E !"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMATION DE LA MISE \u00c0 JOUR"), -1);
                    this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRIMER"));
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("OP\u00c9RATION ANNUL\u00c9E"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("ANNULATION"), -1);
                }
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(HarvestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.jLabelWarning.setText("");
    }

    private void deleteButtonMouseReleased(MouseEvent evt) {
        String TxtBtn = this.deleteButton.getText();
        this.jLabelWarning.setText("");
        if (this.deleteButton.isEnabled()) {
            try {
                if (TxtBtn.equals(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"))) {
                    this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRIMER"));
                    this.InitSemisData();
                } else {
                    this.DeleteSemis();
                    this.InitSemisData();
                }
                this.saveButton.setEnabled(false);
            }
            catch (ParseException ex) {
                Logger.getLogger(SemisFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jComboBoxOutilPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
        this.jLabelWarning.setText("");
        this.SetCouts();
    }

    private void saveMenuItemMouseClicked(MouseEvent evt) {
        try {
            if (this.AddSemis) {
                this.SaveSemisData();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("ENREGISTREMENT REUSSI !"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
                this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRIMER"));
            } else {
                int choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("MODIFICATIONS_NON_ENREGISTR\u00c9ES2"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMATION DE SAUVEGARDE"), 2);
                if (choix == 0) {
                    this.SaveSemisData();
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("MISE \u00c0 JOUR EFFECTU\u00c9E !"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMATION DE LA MISE \u00c0 JOUR"), -1);
                    this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRIMER"));
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("OP\u00c9RATION ANNUL\u00c9E"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("ANNULATION"), -1);
                }
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(HarvestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.deleteButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"))) {
            int choix = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("QUITTER_SANS_SAUVEGARDER"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRESSION"), 2);
            if (choix == 0) {
                try {
                    this.InitSemisData();
                }
                catch (ParseException ex) {
                    Logger.getLogger(SemisFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.entityManager.clear();
                this.entityManager.close();
                this.dispose();
            }
        } else {
            try {
                this.InitSemisData();
            }
            catch (ParseException ex) {
                Logger.getLogger(SemisFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.entityManager.clear();
            this.entityManager.close();
            this.dispose();
        }
    }

    private void fileMenuMouseClicked(MouseEvent evt) {
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(true);
        this.jourField.requestFocus();
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
        this.jLabelWarning.setText("");
    }

    private void PrixFieldFocusLost(FocusEvent evt) {
        String ValueGet;
        SowingMod SemisTools = new SowingMod();
        if (!this.PrixField.getText().isEmpty() && (ValueGet = this.Tool.RemplaceVirgule(this.PrixField.getText())).length() != ValueGet.lastIndexOf(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString(".")) + 1) {
            this.PrixField.setText(ValueGet);
        }
        try {
            this.prix = SemisTools.Getprix(this.PrixField.getText());
            this.CoutSem = SemisTools.GetCoutSemence(this.DensiteField.getText(), this.PrixField.getText());
            this.CoutSemField.setText("" + this.CoutSem);
            this.jLabelWarning.setText("");
        }
        catch (ParseException ex) {
            Logger.getLogger(InterCultureFrame.class.getName()).log(Level.SEVERE, null, ex);
            this.jLabelWarning.setText("");
        }
    }

    private void DensiteFieldFocusLost(FocusEvent evt) {
        String ValueGet;
        SowingMod SemisTools = new SowingMod();
        if (!this.DensiteField.getText().isEmpty() && (ValueGet = this.Tool.RemplaceVirgule(this.DensiteField.getText())).length() != ValueGet.lastIndexOf(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString(".")) + 1) {
            this.DensiteField.setText(ValueGet);
        }
        try {
            this.densite = SemisTools.Getdensite(this.DensiteField.getText());
            this.CoutSem = SemisTools.GetCoutSemence(this.DensiteField.getText(), this.PrixField.getText());
            this.CoutSemField.setText("" + this.CoutSem);
        }
        catch (ParseException ex) {
            Logger.getLogger(InterCultureFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void DensiteFieldComponentAdded(ContainerEvent evt) {
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
    }

    private void jourFieldPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        LasyTools Tool = new LasyTools();
        try {
            int j = Tool.SetAsA_Int(this.jourField.getSelectedItem().toString());
            int m = Tool.SetAsA_Int(this.moisField.getSelectedItem().toString());
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CHAMPS DATE INCORRECT"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("V\u00c9RIFICATION DE LA DATE"), -1);
        }
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
        this.jLabelWarning.setText("");
    }

    private void moisFieldPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        LasyTools Tool = new LasyTools();
        try {
            int j = Tool.SetAsA_Int(this.jourField.getSelectedItem().toString());
            int m = Tool.SetAsA_Int(this.moisField.getSelectedItem().toString());
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CHAMPS DATE INCORRECT"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("V\u00c9RIFICATION DE LA DATE"), -1);
        }
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
        this.jLabelWarning.setText("");
    }

    private void jComboBoxTypeSemPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
        this.jLabelWarning.setText("");
    }

    private void ObjRendementFieldFocusLost(FocusEvent evt) {
        String ValueGet = "";
        if (!this.ObjRendementField.getText().isEmpty() && (ValueGet = this.Tool.RemplaceVirgule(this.ObjRendementField.getText())).length() != ValueGet.lastIndexOf(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString(".")) + 1) {
            this.ObjRendementField.setText(ValueGet);
        }
    }

    private void PrixFieldKeyTyped(KeyEvent evt) {
        SowingMod SemisTools = new SowingMod();
        try {
            this.CoutSem = SemisTools.GetCoutSemence(this.DensiteField.getText(), this.PrixField.getText());
            this.CoutSemField.setText("" + this.CoutSem);
        }
        catch (ParseException ex) {
            Logger.getLogger(InterCultureFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
    }

    private void CoutSemFieldKeyTyped(KeyEvent evt) {
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
    }

    private void DensiteFieldKeyTyped(KeyEvent evt) {
        SowingMod SemisTools = new SowingMod();
        try {
            this.CoutSem = SemisTools.GetCoutSemence(this.DensiteField.getText(), this.PrixField.getText());
            this.CoutSemField.setText("" + this.CoutSem);
        }
        catch (ParseException ex) {
            Logger.getLogger(InterCultureFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
    }

    private void ObjRendementFieldKeyTyped(KeyEvent evt) {
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
    }

    private void UnitSemFieldKeyTyped(KeyEvent evt) {
    }

    private void deleteButtonMouseEntered(MouseEvent evt) {
        String BtnTxt = this.deleteButton.getText();
        if (BtnTxt.equals(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER")) && this.deleteButton.isEnabled()) {
            this.JTextAreaInfoNode.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CLIQUEZ SUR 'R\u00c9INITIALISER' POUR ANNULATION DE LA SAISIE"));
            this.deleteButton.setToolTipText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("ANNULATION DE LA SAISIE"));
        } else if (this.deleteButton.isEnabled()) {
            this.JTextAreaInfoNode.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CLIQUEZ SUR 'SUPPRIMER' POUR EFFACER LES DONN\u00c9ES"));
            this.deleteButton.setToolTipText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRESSION DES DONN\u00c9ES"));
        }
        this.jLabelWarning.setText("");
    }

    private void deleteButtonMouseExited(MouseEvent evt) {
        this.JTextAreaInfoNode.setText("");
        this.deleteButton.setToolTipText("" + ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMER_ENREGISTREMENT_NOUVELLES DONN\u00c9ES"));
    }

    private void exitMenuItemMouseClicked(MouseEvent evt) {
        this.Onclose();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.deleteButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"))) {
            int choix = JOptionPane.showConfirmDialog(null, "" + ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("quitter_sans_sauvegarder"), ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("SUPPRESSION"), 2);
            if (choix == 0) {
                try {
                    this.InitSemisData();
                }
                catch (ParseException ex) {
                    Logger.getLogger(SemisFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (choix == 2) {
                this.ExitMsg = true;
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        if (this.ExitMsg) {
            this.ExitMsg = false;
            this.setVisible(true);
        }
    }

    private void jComboBoxFusariosePopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.deleteButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.deleteButton.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER"));
    }

    private void saveButtonMouseEntered(MouseEvent evt) {
        String BtnTxt = this.deleteButton.getText();
        if (BtnTxt.equals(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("R\u00c9INITIALISER")) && this.deleteButton.isEnabled()) {
            this.jLabelWarning.setText(ResourceBundle.getBundle("Interfaces/resources/SemisBundle").getString("CONFIRMER_ENREGISTREMENT_NOUVELLES_DONN\u00c9ES"));
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SemisFrame().setVisible(true);
            }
        });
    }
}

