/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Conduites;
import DataBase.Equipment;
import DataBase.Fertilization;
import DataBase.Fertilizer;
import DataBase.Technicaloperations;
import Interfaces.HarvestFrame;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modules.ConduiteMod;
import modules.CultureMod;
import modules.FertilMod;
import modules.ItkMod;
import modules.LasyTools;
import modules.OutilMod;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class FertilisationFrame
extends JFrame {
    LasyTools Tool = new LasyTools();
    ConduiteMod ToolCdt = new ConduiteMod();
    OutilMod Outil = new OutilMod();
    Query MyQuery;
    int IdFertil;
    int idConduite;
    int IdOutil = 0;
    double CoutEnergie = 0.0;
    double CoutEco = 0.0;
    double DP;
    boolean AddFertil = false;
    private JButton CloseButton;
    private JButton deleteButton;
    JTextField doseField;
    EntityManager entityManager;
    JMenuItem exitMenuItem;
    JMenu fileMenu;
    JTextField frequencedinterventionField;
    JLabel frequencedinterventionLabel;
    JCheckBox jCheckBoxEnfoui;
    JComboBox jComboBoxFertil;
    JComboBox jComboBoxOutil;
    JLabel jLabelCurrentCdt;
    JLabel jLabelCurrentCrop;
    JLabel jLabelDose;
    JLabel jLabelFertil;
    JLabel jLabelOutil;
    JLabel jLabelPrixFertilisant;
    JLabel jLabelUnite;
    JPanel jPanel1;
    JScrollPane jScrollPaneEnfouis;
    JTextArea jTextAreaEnfouis;
    JTextField jTextFieldEnfoui;
    JComboBox jourField;
    JLabel jourLabel1;
    private List<Fertilization> list;
    JScrollPane masterScrollPane;
    private JTable masterTable;
    JMenuBar menuBar;
    JComboBox moisField;
    JLabel moisLabel1;
    private JButton newButton;
    private Query query;
    private JButton saveButton;
    private BindingGroup bindingGroup;

    public FertilisationFrame() {
        this.initComponents();
        this.refreshData();
        this.InitListFertilizer();
        this.InitListEquip();
        this.idConduite = 1;
        this.SetListData(this.idConduite);
        this.SetInterface();
        this.jLabelUnite.setText("");
        this.SetFreese(true);
    }

    public FertilisationFrame(int cdt) {
        this.initComponents();
        this.InitListFertilizer();
        this.InitListEquip();
        this.idConduite = cdt;
        this.SetListData(this.idConduite);
        this.SetInterface();
        this.SetFreese(false);
        this.setLocation(this.Tool.CentreFrame(this));
        this.jLabelUnite.setText("");
        this.AfficheCdtSelect();
    }

    private void AfficheCdtSelect() {
        CultureMod CropT = new CultureMod();
        this.jLabelCurrentCdt.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONDUITE : ") + ((Conduites)this.entityManager.find(Conduites.class, (Object)this.idConduite)).getNomcdt());
        this.jLabelCurrentCrop.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CULTURE : ") + CropT.GetNameCultByIdCdt(this.idConduite));
    }

    private void SetListData(int idCdte) {
        Object evt = null;
        List OpList = null;
        Object Ic = null;
        int IdFertilis = 0;
        boolean IdOP = false;
        boolean i = false;
        String Sql = "";
        String SqlNext = "";
        boolean firstRun = false;
        if (idCdte != 0) {
            ItkMod ItkTool = new ItkMod();
            OpList = ItkTool.GetListOfOP(idCdte);
            List ListOp = OpList;
            if (ListOp.isEmpty()) {
                Sql = "SELECT i FROM Fertilization i WHERE i.idfertilization =-1";
                this.query = this.entityManager.createQuery(Sql);
                this.list.clear();
            }
            if (!ListOp.isEmpty()) {
                this.list.clear();
                for (Technicaloperations T : ListOp) {
                    if (T.getFertilization() == null) continue;
                    IdFertilis = T.getFertilization().getIdfertilization();
                    if (!firstRun) {
                        Sql = "SELECT f FROM Fertilization f WHERE f.idfertilization = " + IdFertilis;
                        firstRun = true;
                        continue;
                    }
                    SqlNext = " OR (f.idfertilization = " + IdFertilis + ")";
                    Sql = Sql + SqlNext;
                }
                if (Sql.equals("")) {
                    Sql = "SELECT i FROM Fertilization i WHERE i.idfertilization =-1";
                }
                this.query = this.entityManager.createQuery(Sql);
            }
        }
        firstRun = false;
        this.refreshData();
    }

    private void SetInterface() {
        ItkMod ItkTool = new ItkMod();
        List fertOpList = ItkTool.GetListOfOP(this.idConduite);
        if (fertOpList.isEmpty()) {
            this.deleteButton.setEnabled(false);
            this.AddFertil = true;
        } else {
            for (Technicaloperations T : fertOpList) {
                if (T.getFertilization() == null) continue;
                this.deleteButton.setEnabled(true);
                this.AddFertil = false;
            }
        }
    }

    private void SetCoutNRJ() {
        boolean AddCout = false;
        int D = 0;
        int M = 0;
        String OutilN = "";
        try {
            D = this.Tool.SetAsA_Int(this.jourField.getSelectedItem().toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(HarvestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException ex1) {
            D = 1;
        }
        try {
            M = this.Tool.SetAsA_Int(this.moisField.getSelectedItem().toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(HarvestFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException ex1) {
            M = 1;
        }
        try {
            OutilN = this.jComboBoxOutil.getSelectedItem().toString();
        }
        catch (NullPointerException ex) {
            OutilN = "";
        }
        AddCout = this.Outil.CalculCout(this.idConduite, D, M, OutilN);
        if (AddCout) {
            this.IdOutil = this.Outil.GetIdOutilByName(OutilN);
            this.CoutEnergie = this.Outil.GetEquipCoutNRJ(this.IdOutil);
        } else {
            this.CoutEnergie = 0.0;
        }
    }

    private void SetFreese(boolean Statut) {
        this.jourField.setEnabled(Statut);
        this.moisField.setEnabled(Statut);
        this.doseField.setEnabled(Statut);
        this.frequencedinterventionField.setEnabled(Statut);
        this.jComboBoxFertil.setEnabled(Statut);
        this.jComboBoxOutil.setEnabled(Statut);
        this.jCheckBoxEnfoui.setEnabled(Statut);
        this.saveButton.setEnabled(Statut);
        this.deleteButton.setEnabled(Statut);
    }

    private void InitListEquip() {
        this.MyQuery = this.entityManager.createQuery("SELECT e FROM Equipment e order by e.name");
        this.jComboBoxOutil.removeAllItems();
        List Eq = this.MyQuery.getResultList();
        if (!Eq.isEmpty()) {
            for (Equipment E : Eq) {
                this.jComboBoxOutil.addItem(E.getName());
            }
        }
        this.jComboBoxOutil.setSelectedItem(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PULVE_24_M"));
    }

    private void InitListFertilizer() {
        this.MyQuery = this.entityManager.createNamedQuery("Fertilizer.findAll");
        this.jComboBoxFertil.removeAllItems();
        List FErt = this.MyQuery.getResultList();
        if (!FErt.isEmpty()) {
            for (Fertilizer F : FErt) {
                this.jComboBoxFertil.addItem(F.getNomfertil());
            }
        }
        this.jComboBoxFertil.setSelectedIndex(0);
    }

    private void AddFertilizer() {
        String FertilantN = "";
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        try {
            FertilantN = this.jComboBoxFertil.getSelectedItem().toString();
        }
        catch (NullPointerException ex) {
            FertilantN = "";
            System.out.println("combobox Fertilant =null");
        }
        this.MyQuery = this.entityManager.createNamedQuery("Fertilizer.findByNomfertil");
        List FErt = this.MyQuery.setParameter("nomfertil", (Object)FertilantN).getResultList();
        if (!FErt.isEmpty()) {
            for (Fertilizer Ft : FErt) {
                ((Fertilization)this.entityManager.find(Fertilization.class, (Object)this.IdFertil)).setFertilizer1(Ft);
            }
        }
        this.entityManager.getTransaction().commit();
    }

    private void AddCoutNRJ() {
        this.SetCoutNRJ();
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        ((Fertilization)this.entityManager.find(Fertilization.class, (Object)this.IdFertil)).setCoutenergetiqueden(this.CoutEnergie);
        this.entityManager.getTransaction().commit();
    }

    private void AddOutil() {
        String toolname = "";
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        try {
            toolname = this.jComboBoxOutil.getSelectedItem().toString();
        }
        catch (NullPointerException ex) {
            toolname = "";
            System.out.println("combobox Outil =null");
        }
        if (!toolname.isEmpty()) {
            this.MyQuery = this.entityManager.createNamedQuery("Equipment.findByName");
            List tool = this.MyQuery.setParameter("name", (Object)toolname).getResultList();
            if (!tool.isEmpty()) {
                for (Equipment O : tool) {
                    ((Fertilization)this.entityManager.find(Fertilization.class, (Object)this.IdFertil)).setEquipment(O);
                }
            }
            this.entityManager.getTransaction().commit();
        }
    }

    private void refreshData() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void UpdateData() {
        FertilMod Fertil = new FertilMod();
        String Sql = "SELECT f FROM Fertilization f WHERE f.idfertilization =-1";
        if (this.idConduite != 0) {
            Sql = Fertil.GetSqlFertilization(this.idConduite);
        }
        this.query = this.entityManager.createQuery(Sql);
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void SaveData() throws ParseException {
        try {
            boolean Val;
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            if (this.jCheckBoxEnfoui.isSelected()) {
                this.jTextFieldEnfoui.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("OUI"));
                Val = true;
                this.masterTable.setValueAt(Val, this.masterTable.getSelectedRow(), 6);
            } else {
                this.jTextFieldEnfoui.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("NON"));
                Val = false;
                this.masterTable.setValueAt(Val, this.masterTable.getSelectedRow(), 6);
            }
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            this.entityManager.flush();
            if (this.AddFertil) {
                FertilMod FertilTool = new FertilMod();
                this.IdFertil = FertilTool.getLastFertilisationId();
            }
            this.AddFertilizer();
            this.AddOutil();
            this.AddCoutNRJ();
            if (this.AddFertil) {
                ItkMod ItkTool = new ItkMod();
                ItkTool.AddNewOp(3, this.IdFertil, this.idConduite);
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("ENREGISTREMENT_REUSSI"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
                this.entityManager.refresh(this.entityManager.find(Fertilization.class, (Object)this.IdFertil));
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("MISE_\u00c0_JOUR_OK"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONFIRMATION DE LA MISE \u00c0 JOUR"), -1);
            }
            this.UpdateData();
            this.AddFertil = false;
        }
        catch (RollbackException rex) {
            rex.printStackTrace();
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
            for (Fertilization f : this.list) {
                merged.add(this.entityManager.merge((Object)f));
            }
            this.list.clear();
            this.list.addAll(merged);
        }
    }

    private boolean FormulaireStatus() {
        boolean Notset = false;
        String V = "";
        try {
            V = this.jourField.getSelectedItem().toString();
            if (V.isEmpty()) {
                Notset = true;
            }
        }
        catch (NullPointerException ex1) {
            Notset = true;
            this.jourField.requestFocus();
        }
        try {
            V = this.moisField.getSelectedItem().toString();
            if (V.isEmpty()) {
                Notset = true;
            }
        }
        catch (NullPointerException ex1) {
            Notset = true;
            this.moisField.requestFocus();
        }
        try {
            V = this.jComboBoxOutil.getSelectedItem().toString();
            if (V.isEmpty()) {
                Notset = true;
            }
        }
        catch (NullPointerException ex) {
            Notset = true;
            this.jComboBoxOutil.requestFocus();
        }
        try {
            V = this.doseField.getText().toString();
            if (V.isEmpty()) {
                Notset = true;
            }
        }
        catch (NullPointerException ex) {
            Notset = true;
            this.doseField.requestFocus();
        }
        return Notset;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/OperationsBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT f FROM Fertilization f WHERE f.idfertilization =-1");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.jPanel1 = new JPanel();
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.frequencedinterventionLabel = new JLabel();
        this.doseField = new JTextField();
        this.frequencedinterventionField = new JTextField();
        this.saveButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.jLabelFertil = new JLabel();
        this.jLabelOutil = new JLabel();
        this.jComboBoxFertil = new JComboBox();
        this.jComboBoxOutil = new JComboBox();
        this.CloseButton = new JButton();
        this.jourField = new JComboBox();
        this.jourLabel1 = new JLabel();
        this.moisLabel1 = new JLabel();
        this.moisField = new JComboBox();
        this.jScrollPaneEnfouis = new JScrollPane();
        this.jTextAreaEnfouis = new JTextArea();
        this.jCheckBoxEnfoui = new JCheckBox();
        this.jTextFieldEnfoui = new JTextField();
        this.jLabelDose = new JLabel();
        this.jLabelUnite = new JLabel();
        this.jLabelCurrentCdt = new JLabel();
        this.jLabelCurrentCrop = new JLabel();
        this.jLabelPrixFertilisant = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.setName("Fertilisation");
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jPanel1.setName("jPanel1");
        this.masterScrollPane.setName("masterScrollPane");
        this.masterTable.setCursor(new Cursor(12));
        this.masterTable.setName("masterTable");
        this.masterTable.setSelectionMode(0);
        this.masterTable.getTableHeader().setReorderingAllowed(false);
        JTableBinding<Fertilization, List<Fertilization>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${jour}"));
        columnBinding.setColumnName(bundle.getString("JOUR_COL"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${mois}"));
        columnBinding.setColumnName(bundle.getString("MOIS_COL"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${fertilizer}"));
        columnBinding.setColumnName(bundle.getString("FERTILISANT"));
        columnBinding.setColumnClass(String.class);
        columnBinding.setEditable(false);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${equipname}"));
        columnBinding.setColumnName(bundle.getString("OUTIL"));
        columnBinding.setColumnClass(String.class);
        columnBinding.setEditable(false);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${dose}"));
        columnBinding.setColumnName(bundle.getString("DOSE"));
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${frequencedintervention}"));
        columnBinding.setColumnName(bundle.getString("FR\u00c9QUENCE D'INTERVENTION"));
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${enfouisdans24h}"));
        columnBinding.setColumnName(bundle.getString("ENFOUS_24H"));
        columnBinding.setColumnClass(String.class);
        columnBinding.setEditable(false);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idfertilization}"));
        columnBinding.setColumnName("id");
        columnBinding.setColumnClass(Integer.class);
        columnBinding.setEditable(false);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FertilisationFrame.this.masterTableMouseClicked(evt);
            }
        });
        this.masterScrollPane.setViewportView(this.masterTable);
        this.masterTable.getColumnModel().getColumn(0).setMinWidth(40);
        this.masterTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.masterTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.masterTable.getColumnModel().getColumn(1).setMinWidth(40);
        this.masterTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.masterTable.getColumnModel().getColumn(1).setMaxWidth(40);
        this.masterTable.getColumnModel().getColumn(2).setMinWidth(115);
        this.masterTable.getColumnModel().getColumn(2).setPreferredWidth(115);
        this.masterTable.getColumnModel().getColumn(3).setMinWidth(115);
        this.masterTable.getColumnModel().getColumn(3).setPreferredWidth(115);
        this.masterTable.getColumnModel().getColumn(4).setMinWidth(50);
        this.masterTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.masterTable.getColumnModel().getColumn(4).setMaxWidth(50);
        this.masterTable.getColumnModel().getColumn(5).setMinWidth(140);
        this.masterTable.getColumnModel().getColumn(5).setPreferredWidth(140);
        this.masterTable.getColumnModel().getColumn(5).setMaxWidth(140);
        this.masterTable.getColumnModel().getColumn(6).setMinWidth(100);
        this.masterTable.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.masterTable.getColumnModel().getColumn(6).setMaxWidth(100);
        this.masterTable.getColumnModel().getColumn(7).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(7).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(7).setMaxWidth(1);
        this.frequencedinterventionLabel.setBackground(new Color(51, 51, 51));
        this.frequencedinterventionLabel.setFont(new Font("Arial", 0, 12));
        this.frequencedinterventionLabel.setForeground(new Color(255, 254, 255));
        this.frequencedinterventionLabel.setText(bundle.getString("FR\u00c9QUENCE D'INTERVENTION") + ":");
        this.frequencedinterventionLabel.setFocusable(false);
        this.frequencedinterventionLabel.setName("frequencedinterventionLabel");
        this.frequencedinterventionLabel.setRequestFocusEnabled(false);
        this.doseField.setFont(new Font("Arial", 0, 12));
        this.doseField.setForeground(new Color(0, 1, 0));
        this.doseField.setName("doseField");
        this.doseField.setSelectionColor(new Color(153, 153, 153));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.dose}"), this.doseField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.doseField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                FertilisationFrame.this.doseFieldCaretUpdate(evt);
            }
        });
        this.doseField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FertilisationFrame.this.doseFieldFocusLost(evt);
            }
        });
        this.frequencedinterventionField.setFont(new Font("Arial", 0, 12));
        this.frequencedinterventionField.setForeground(new Color(0, 1, 0));
        this.frequencedinterventionField.setName("frequencedinterventionField");
        this.frequencedinterventionField.setSelectionColor(new Color(153, 153, 153));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.frequencedintervention}"), this.frequencedinterventionField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.frequencedinterventionField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                FertilisationFrame.this.frequencedinterventionFieldCaretUpdate(evt);
            }
        });
        this.frequencedinterventionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FertilisationFrame.this.frequencedinterventionFieldFocusLost(evt);
            }
        });
        this.saveButton.setBackground(new Color(51, 51, 51));
        this.saveButton.setFont(new Font("Arial", 1, 12));
        this.saveButton.setForeground(new Color(0, 1, 0));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.saveButton.setText(bundle.getString("ENREGISTER"));
        this.saveButton.setBorder(null);
        this.saveButton.setBorderPainted(false);
        this.saveButton.setContentAreaFilled(false);
        this.saveButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setName("saveButton");
        this.saveButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FertilisationFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.saveButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FertilisationFrame.this.saveButtonFocusGained(evt);
            }
        });
        this.newButton.setBackground(new Color(0, 1, 0));
        this.newButton.setFont(new Font("Arial", 1, 12));
        this.newButton.setForeground(new Color(0, 1, 0));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.newButton.setText(bundle.getString("AJOUTER"));
        this.newButton.setBorder(null);
        this.newButton.setBorderPainted(false);
        this.newButton.setContentAreaFilled(false);
        this.newButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.newButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.setName("newButton");
        this.newButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FertilisationFrame.this.newButtonActionPerformed(evt);
            }
        });
        this.newButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FertilisationFrame.this.newButtonFocusGained(evt);
            }
        });
        this.deleteButton.setBackground(new Color(0, 1, 0));
        this.deleteButton.setFont(new Font("Arial", 1, 12));
        this.deleteButton.setForeground(new Color(0, 1, 0));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.deleteButton.setText(bundle.getString("SUPPRIMER"));
        this.deleteButton.setBorder(null);
        this.deleteButton.setBorderPainted(false);
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FertilisationFrame.this.deleteButtonActionPerformed(evt);
            }
        });
        this.deleteButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FertilisationFrame.this.deleteButtonFocusGained(evt);
            }
        });
        this.jLabelFertil.setFont(new Font("Arial", 0, 12));
        this.jLabelFertil.setForeground(new Color(255, 254, 255));
        this.jLabelFertil.setText(bundle.getString("FERTILISANT") + ":");
        this.jLabelFertil.setName("jLabelFertil");
        this.jLabelOutil.setFont(new Font("Arial", 0, 12));
        this.jLabelOutil.setForeground(new Color(255, 254, 255));
        this.jLabelOutil.setText(bundle.getString("OUTIL") + ":");
        this.jLabelOutil.setName("jLabelOutil");
        this.jComboBoxFertil.setFont(new Font("Arial", 0, 12));
        this.jComboBoxFertil.setForeground(new Color(0, 1, 0));
        this.jComboBoxFertil.setName("jComboBoxFertil");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.fertilizer}"), this.jComboBoxFertil, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxFertil.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                FertilisationFrame.this.jComboBoxFertilPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jComboBoxOutil.setFont(new Font("Arial", 0, 12));
        this.jComboBoxOutil.setForeground(new Color(0, 1, 0));
        this.jComboBoxOutil.setName("jComboBoxOutil");
        this.jComboBoxOutil.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                FertilisationFrame.this.jComboBoxOutilPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.CloseButton.setFont(new Font("Tahoma", 1, 12));
        this.CloseButton.setForeground(new Color(0, 1, 0));
        this.CloseButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.CloseButton.setText(bundle.getString("FERMER"));
        this.CloseButton.setBorder(null);
        this.CloseButton.setBorderPainted(false);
        this.CloseButton.setContentAreaFilled(false);
        this.CloseButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.CloseButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.CloseButton.setHorizontalTextPosition(0);
        this.CloseButton.setName("CloseButton");
        this.CloseButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FertilisationFrame.this.CloseButtonMouseReleased(evt);
            }
        });
        this.jourField.setFont(new Font("Arial", 0, 12));
        this.jourField.setForeground(new Color(0, 1, 0));
        this.jourField.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"}));
        this.jourField.setName("jourField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.jour}"), this.jourField, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jourField.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                FertilisationFrame.this.jourFieldPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jourLabel1.setBackground(new Color(51, 51, 51));
        this.jourLabel1.setFont(new Font("Arial", 0, 12));
        this.jourLabel1.setForeground(new Color(255, 254, 255));
        this.jourLabel1.setText(bundle.getString("JOUR") + ":");
        this.jourLabel1.setFocusable(false);
        this.jourLabel1.setName("jourLabel1");
        this.jourLabel1.setRequestFocusEnabled(false);
        this.moisLabel1.setBackground(new Color(51, 51, 51));
        this.moisLabel1.setFont(new Font("Arial", 0, 12));
        this.moisLabel1.setForeground(new Color(255, 254, 255));
        this.moisLabel1.setText(bundle.getString("MOIS") + ":");
        this.moisLabel1.setFocusable(false);
        this.moisLabel1.setName("moisLabel1");
        this.moisLabel1.setRequestFocusEnabled(false);
        this.moisField.setFont(new Font("Arial", 0, 12));
        this.moisField.setForeground(new Color(0, 1, 0));
        this.moisField.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}));
        this.moisField.setName("moisField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.mois}"), this.moisField, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.moisField.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                FertilisationFrame.this.moisFieldPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jScrollPaneEnfouis.setBackground(new Color(51, 51, 51));
        this.jScrollPaneEnfouis.setBorder(null);
        this.jScrollPaneEnfouis.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneEnfouis.setVerticalScrollBarPolicy(21);
        this.jScrollPaneEnfouis.setFocusable(false);
        this.jScrollPaneEnfouis.setHorizontalScrollBar(null);
        this.jScrollPaneEnfouis.setName("jScrollPaneEnfouis");
        this.jTextAreaEnfouis.setBackground(new Color(51, 51, 51));
        this.jTextAreaEnfouis.setColumns(20);
        this.jTextAreaEnfouis.setEditable(false);
        this.jTextAreaEnfouis.setFont(new Font("Arial", 0, 12));
        this.jTextAreaEnfouis.setForeground(new Color(255, 254, 255));
        this.jTextAreaEnfouis.setLineWrap(true);
        this.jTextAreaEnfouis.setRows(3);
        this.jTextAreaEnfouis.setText(bundle.getString("ENFOUS_24H") + ":");
        this.jTextAreaEnfouis.setToolTipText(bundle.getString("ENFOUS_24H"));
        this.jTextAreaEnfouis.setWrapStyleWord(true);
        this.jTextAreaEnfouis.setFocusable(false);
        this.jTextAreaEnfouis.setName("jTextAreaEnfouis");
        this.jTextAreaEnfouis.setRequestFocusEnabled(false);
        this.jTextAreaEnfouis.setSelectionColor(new Color(51, 51, 51));
        this.jScrollPaneEnfouis.setViewportView(this.jTextAreaEnfouis);
        this.jCheckBoxEnfoui.setBackground(new Color(0, 1, 0));
        this.jCheckBoxEnfoui.setToolTipText(bundle.getString("ENFOUS_24H"));
        this.jCheckBoxEnfoui.setBorder(null);
        this.jCheckBoxEnfoui.setContentAreaFilled(false);
        this.jCheckBoxEnfoui.setName("jCheckBoxEnfoui");
        this.jCheckBoxEnfoui.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FertilisationFrame.this.jCheckBoxEnfouiMouseClicked(evt);
            }
        });
        this.jTextFieldEnfoui.setBackground(new Color(51, 51, 51));
        this.jTextFieldEnfoui.setFont(new Font("Arial", 0, 12));
        this.jTextFieldEnfoui.setForeground(new Color(51, 51, 51));
        this.jTextFieldEnfoui.setBorder(null);
        this.jTextFieldEnfoui.setName("jTextFieldEnfoui");
        this.jLabelDose.setFont(new Font("Arial", 0, 12));
        this.jLabelDose.setForeground(new Color(255, 254, 255));
        this.jLabelDose.setText(bundle.getString("DOSE") + ":");
        this.jLabelDose.setToolTipText(bundle.getString("DOSE"));
        this.jLabelDose.setName("jLabelDose");
        this.jLabelUnite.setFont(new Font("Script MT Bold", 0, 14));
        this.jLabelUnite.setForeground(new Color(255, 254, 255));
        this.jLabelUnite.setText(bundle.getString("UNITE"));
        this.jLabelUnite.setName("jLabelUnite");
        this.jLabelCurrentCdt.setFont(new Font("Arial", 1, 12));
        this.jLabelCurrentCdt.setForeground(new Color(204, 255, 204));
        this.jLabelCurrentCdt.setText(bundle.getString("CONDUITE") + " : ");
        this.jLabelCurrentCdt.setName("jLabelCurrentCdt");
        this.jLabelCurrentCrop.setFont(new Font("Arial", 1, 12));
        this.jLabelCurrentCrop.setForeground(new Color(204, 255, 204));
        this.jLabelCurrentCrop.setText(bundle.getString("CULTURE"));
        this.jLabelCurrentCrop.setName("jLabelCurrentCrop");
        this.jLabelPrixFertilisant.setForeground(new Color(-1, true));
        this.jLabelPrixFertilisant.setText(bundle.getString("PRIX"));
        this.jLabelPrixFertilisant.setName("jLabelPrixFertilisant");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.masterScrollPane, -1, 790, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelCurrentCdt, -2, 183, -2).addGap(38, 38, 38).addComponent(this.jLabelCurrentCrop, -2, 224, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moisLabel1).addComponent(this.jourLabel1)).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jourField, -2, 66, -2).addComponent(this.moisField, -2, 66, -2))).addComponent(this.jScrollPaneEnfouis, -2, 127, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelOutil).addComponent(this.jLabelFertil).addComponent(this.jCheckBoxEnfoui))).addComponent(this.newButton, -2, 116, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxOutil, -2, 301, -2).addGap(18, 18, 18).addComponent(this.jLabelPrixFertilisant)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxFertil, -2, 301, -2).addGap(18, 18, 18).addComponent(this.jLabelDose).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.doseField, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelUnite, -2, 98, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.deleteButton, -2, 116, -2).addComponent(this.frequencedinterventionLabel)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.frequencedinterventionField, -2, 39, -2).addGap(18, 18, 18).addComponent(this.jTextFieldEnfoui, -2, 32, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(108, 108, 108).addComponent(this.saveButton, -2, 116, -2))))).addGap(40, 40, 40)).addComponent(this.CloseButton, -2, 120, -2)))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jComboBoxFertil, this.jComboBoxOutil);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCurrentCdt).addComponent(this.jLabelCurrentCrop)).addGap(33, 33, 33).addComponent(this.masterScrollPane, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jourLabel1).addComponent(this.jourField, -2, 20, -2).addComponent(this.jLabelFertil).addComponent(this.jComboBoxFertil, -2, 20, -2).addComponent(this.jLabelDose).addComponent(this.doseField, -2, 20, -2).addComponent(this.jLabelUnite)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moisLabel1).addComponent(this.moisField, -2, 20, -2).addComponent(this.jComboBoxOutil, -2, 20, -2).addComponent(this.jLabelOutil).addComponent(this.jLabelPrixFertilisant)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.frequencedinterventionField, -2, 20, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldEnfoui, -2, -1, -2))).addComponent(this.frequencedinterventionLabel).addComponent(this.jCheckBoxEnfoui)).addComponent(this.jScrollPaneEnfouis, -2, 22, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.newButton, -2, 40, -2).addComponent(this.deleteButton, -2, 40, -2).addComponent(this.saveButton, -2, 40, -2).addComponent(this.CloseButton, -2, 45, -2)).addContainerGap()));
        this.menuBar.setName("menuBar");
        this.fileMenu.setText(bundle.getString("FERTILISATION_DATA"));
        this.fileMenu.setName("fileMenu");
        this.fileMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FertilisationFrame.this.fileMenuMouseClicked(evt);
            }
        });
        this.exitMenuItem.setText(bundle.getString("FERMER"));
        this.exitMenuItem.setName("exitMenuItem");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FertilisationFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 376, -2));
        this.bindingGroup.bind();
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        FertilMod ferti = new FertilMod();
        ferti.verifFertilCorrespondance(this.idConduite);
        this.dispose();
    }

    private void fileMenuMouseClicked(MouseEvent evt) {
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(true);
        this.jourField.requestFocus();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (!this.FormulaireStatus()) {
            if (!this.Outil.VerifFrequence(this.frequencedinterventionField)) {
                this.frequencedinterventionField.setForeground(Color.red);
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("Test_frequence"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VALEUR_INCORRECTE"), -1);
            } else {
                this.frequencedinterventionField.setForeground(Color.getColor("#000100"));
                try {
                    this.SaveData();
                    this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("AJOUTER"));
                    this.SetFreese(false);
                }
                catch (ParseException ex) {
                    Logger.getLogger(FertilisationFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VEUILLEZ RENSEIGNER L'ENSEMBLE DES VALEURS"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("DONNEES_MANQUANTES"), -1);
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("AJOUTER"))) {
            this.IdFertil = 0;
            Fertilization f = new Fertilization();
            this.SetFreese(true);
            this.AddFertil = true;
            this.entityManager.persist((Object)f);
            this.list.add(f);
            int row = this.list.size() - 1;
            this.masterTable.setRowSelectionInterval(row, row);
            this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
            this.frequencedinterventionField.setText("1");
            this.jComboBoxOutil.setSelectedIndex(this.Outil.GetOutilDefaultIndex());
            this.jCheckBoxEnfoui.setSelected(false);
            this.masterTable.setValueAt(this.jComboBoxOutil.getItemAt(this.Outil.GetOutilDefaultIndex(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PULVE_24_M"))).toString(), row, 3);
            this.AddFertil = true;
            this.jourField.requestFocus();
            this.jourField.setSelectedItem("");
            this.moisField.setSelectedItem("");
            this.jComboBoxFertil.setSelectedItem("");
            this.jComboBoxOutil.setSelectedItem("");
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("ANNULER"));
            this.deleteButton.setEnabled(false);
        } else {
            this.UpdateData();
            this.SetFreese(false);
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("AJOUTER"));
            this.jCheckBoxEnfoui.setSelected(false);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int choix = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONFIRMER_SUPPRESSION"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("SUPPRESSION"), 2);
        if (choix == 0) {
            int[] selected = this.masterTable.getSelectedRows();
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            ArrayList<Fertilization> toRemove = new ArrayList<Fertilization>(selected.length);
            for (int idx = 0; idx < selected.length; ++idx) {
                Fertilization f = this.list.get(this.masterTable.convertRowIndexToModel(selected[idx]));
                toRemove.add(f);
                this.entityManager.remove((Object)f);
            }
            this.list.removeAll(toRemove);
            this.entityManager.getTransaction().commit();
            this.SetFreese(false);
        }
    }

    private void CloseButtonMouseReleased(MouseEvent evt) {
        FertilMod ferti = new FertilMod();
        ferti.verifFertilCorrespondance(this.idConduite);
        this.dispose();
    }

    private void masterTableMouseClicked(MouseEvent evt) {
        int RowSelect = 0;
        String EnfouiVal = "";
        RowSelect = this.masterTable.getSelectedRow();
        this.SetFreese(true);
        try {
            this.jourField.setSelectedItem(this.masterTable.getValueAt(RowSelect, 0).toString());
        }
        catch (NullPointerException ext) {
            System.out.println(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PAS_DE_VALEUR_JOUR") + ext);
            this.jourField.setSelectedItem("");
        }
        try {
            this.moisField.setSelectedItem(this.masterTable.getValueAt(RowSelect, 1).toString());
        }
        catch (NullPointerException ext) {
            System.out.println(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PAS_DE_VALEUR_MOIS") + ext);
            this.moisField.setSelectedItem("");
        }
        try {
            this.doseField.setText(this.masterTable.getValueAt(RowSelect, 4).toString());
        }
        catch (NullPointerException ext) {
            System.out.println(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PAS_DE_VALEUR_DOSE") + ext);
            this.doseField.setText("");
        }
        try {
            this.jComboBoxFertil.setSelectedItem(this.masterTable.getValueAt(RowSelect, 2).toString());
        }
        catch (NullPointerException ext) {
            System.out.println(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PAS_DE_VALEUR_DOSE ") + ext);
            this.jComboBoxFertil.setSelectedItem("");
        }
        try {
            this.jComboBoxOutil.setSelectedItem(this.masterTable.getValueAt(RowSelect, 3).toString());
        }
        catch (NullPointerException ext) {
            System.out.println(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PAS_DE_VALEUR_DOSE") + ext);
            this.jComboBoxOutil.setSelectedItem("");
        }
        try {
            this.frequencedinterventionField.setText(this.masterTable.getValueAt(RowSelect, 5).toString());
        }
        catch (NullPointerException ext) {
            System.out.println(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PAS_DE_VALEUR_DOSE") + ext);
            this.frequencedinterventionField.setText("");
        }
        try {
            EnfouiVal = this.masterTable.getValueAt(RowSelect, 6).toString();
        }
        catch (NullPointerException ext) {
            System.out.println(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("ERREUR") + ext);
            EnfouiVal = "false";
        }
        if (EnfouiVal.equals("true")) {
            this.jCheckBoxEnfoui.setSelected(true);
            this.jCheckBoxEnfoui.getPressedIcon();
        } else {
            this.jCheckBoxEnfoui.setSelected(false);
        }
        try {
            this.IdFertil = this.Tool.SetAsA_Int(this.masterTable.getValueAt(RowSelect, 7).toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(FertilisationFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.SetPriceAndUnit();
    }

    private void SetPriceAndUnit() {
        String Fertilisant = "";
        try {
            Fertilisant = this.jComboBoxFertil.getSelectedItem().toString();
        }
        catch (NullPointerException ex) {
            Fertilisant = "";
        }
        if (!Fertilisant.equals("")) {
            try {
                FertilMod FertilT = new FertilMod();
                this.jLabelUnite.setText(FertilT.GetFertilUnite(Fertilisant));
                double prixProd = FertilT.GetFertilPrix(Fertilisant);
                prixProd = this.Tool.FormatMyDouble(prixProd, 2);
                this.jLabelPrixFertilisant.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PRIX_\u20ac/UNITE") + prixProd);
            }
            catch (ParseException parseException) {}
        } else {
            this.jLabelPrixFertilisant.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PRIX_NON_RENSEIGNE"));
        }
    }

    private void doseFieldCaretUpdate(CaretEvent evt) {
        int row = 0;
        if (this.masterTable.getSelectedRow() != -1) {
            row = this.masterTable.getSelectedRow();
            this.masterTable.setValueAt(this.doseField.getText().toString(), row, 4);
        }
    }

    private void frequencedinterventionFieldCaretUpdate(CaretEvent evt) {
        int row = 0;
        if (this.masterTable.getSelectedRow() != -1) {
            row = this.masterTable.getSelectedRow();
            this.masterTable.setValueAt(this.frequencedinterventionField.getText().toString(), row, 5);
        }
    }

    private void jourFieldPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        if (this.masterTable.getSelectedRow() != -1) {
            row = this.masterTable.getSelectedRow();
            if (this.jourField.getSelectedItem() == null) {
                this.masterTable.setValueAt(this.jourField.getItemAt(0).toString(), row, 0);
            } else {
                this.masterTable.setValueAt(this.jourField.getSelectedItem().toString(), row, 0);
            }
        }
    }

    private void moisFieldPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        if (this.masterTable.getSelectedRow() != -1) {
            row = this.masterTable.getSelectedRow();
            if (this.moisField.getSelectedItem() == null) {
                this.masterTable.setValueAt(this.moisField.getItemAt(0).toString(), row, 1);
            } else {
                this.masterTable.setValueAt(this.moisField.getSelectedItem().toString(), row, 1);
            }
        }
    }

    private void jComboBoxFertilPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        if (this.masterTable.getSelectedRow() != -1) {
            row = this.masterTable.getSelectedRow();
            if (this.jComboBoxFertil.getSelectedItem() != null) {
                this.masterTable.setValueAt(this.jComboBoxFertil.getSelectedItem().toString(), row, 2);
                String Fertilisant = this.jComboBoxFertil.getSelectedItem().toString();
                if (!Fertilisant.equals("")) {
                    try {
                        FertilMod FertilT = new FertilMod();
                        this.jLabelUnite.setText(FertilT.GetFertilUnite(Fertilisant));
                        double prixProd = FertilT.GetFertilPrix(Fertilisant);
                        prixProd = this.Tool.FormatMyDouble(prixProd, 2);
                        this.jLabelPrixFertilisant.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PRIX_\u20ac/UNITE") + prixProd);
                    }
                    catch (ParseException ex) {}
                } else {
                    this.jLabelPrixFertilisant.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PRIX_NON_RENSEIGNE"));
                }
                String UniteF = this.jLabelUnite.getText().toLowerCase();
                if (this.AddFertil) {
                    if (UniteF.equals("l")) {
                        this.jComboBoxOutil.setSelectedItem(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("PULVE_24_M"));
                        this.masterTable.setValueAt(this.jComboBoxOutil.getItemAt(this.Outil.GetOutilDefaultIndex()).toString(), row, 3);
                    } else {
                        this.jComboBoxOutil.setSelectedItem(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("EPANDEUR_CENTRIFUGE_ENGRAIS"));
                        this.masterTable.setValueAt(this.jComboBoxOutil.getItemAt(this.Outil.GetOutilDefaultIndex(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("EPANDEUR_CENTRIFUGE_ENGRAIS"))).toString(), row, 3);
                    }
                } else {
                    this.masterTable.setValueAt(this.jComboBoxOutil.getSelectedItem().toString(), row, 3);
                }
            }
        }
    }

    private void jComboBoxOutilPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        if (this.masterTable.getSelectedRow() != -1) {
            row = this.masterTable.getSelectedRow();
            if (this.jComboBoxOutil.getSelectedItem() == null) {
                this.masterTable.setValueAt(this.jComboBoxOutil.getItemAt(this.Outil.GetOutilDefaultIndex()).toString(), row, 3);
            } else {
                this.masterTable.setValueAt(this.jComboBoxOutil.getSelectedItem().toString(), row, 3);
            }
        }
    }

    private void jCheckBoxEnfouiMouseClicked(MouseEvent evt) {
        if (this.jCheckBoxEnfoui.isSelected()) {
            this.masterTable.setValueAt("true", this.masterTable.getSelectedRow(), 6);
        } else {
            this.masterTable.setValueAt("false", this.masterTable.getSelectedRow(), 6);
        }
    }

    private void newButtonFocusGained(FocusEvent evt) {
    }

    private void deleteButtonFocusGained(FocusEvent evt) {
    }

    private void saveButtonFocusGained(FocusEvent evt) {
    }

    private void doseFieldFocusLost(FocusEvent evt) {
        String ValueGet = "";
        if (!this.doseField.getText().isEmpty() && (ValueGet = this.Tool.RemplaceVirgule(this.doseField.getText())).length() != ValueGet.lastIndexOf(".") + 1) {
            this.doseField.setText(ValueGet);
        }
    }

    private void frequencedinterventionFieldFocusLost(FocusEvent evt) {
        String ValueGet = "";
        if (!this.frequencedinterventionField.getText().isEmpty() && (ValueGet = this.Tool.RemplaceVirgule(this.frequencedinterventionField.getText())).length() != ValueGet.lastIndexOf(".") + 1) {
            this.frequencedinterventionField.setText(ValueGet);
        }
        if (!this.Outil.VerifFrequence(this.frequencedinterventionField)) {
            this.frequencedinterventionField.setForeground(Color.red);
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("Test_frequence"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VALEUR_INCORRECTE"), -1);
        } else {
            this.frequencedinterventionField.setForeground(Color.getColor("#000100"));
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FertilisationFrame().setVisible(true);
            }
        });
    }
}

