/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Dpu;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class DPUPanel
extends JPanel {
    boolean AddParametre = false;
    private JButton deleteButton;
    private JTextField departmentField;
    private JLabel departmentLabel;
    private JTextField dpuField;
    private JLabel dpuLabel;
    private JLabel dpuLabel1;
    private EntityManager entityManager;
    private JLabel jLabelStationMenuTitle;
    private List<Dpu> list;
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private JButton newButton;
    private Query query;
    private JButton saveButton;
    private BindingGroup bindingGroup;

    public DPUPanel() {
        this.initComponents();
        this.SetFreeseElements(false);
        if (!Beans.isDesignTime()) {
            this.entityManager.getTransaction().begin();
        }
    }

    private void SetFreeseElements(boolean Statut) {
        if (!Statut) {
            this.departmentField.setText("");
            this.dpuField.setText("");
            this.newButton.setEnabled(true);
        } else {
            this.newButton.setEnabled(false);
        }
        this.departmentField.setEnabled(Statut);
        this.dpuField.setEnabled(Statut);
        this.saveButton.setEnabled(Statut);
        this.deleteButton.setEnabled(Statut);
    }

    private void Refresh() {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT d FROM Dpu d");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.departmentLabel = new JLabel();
        this.dpuLabel = new JLabel();
        this.departmentField = new JTextField();
        this.dpuField = new JTextField();
        this.saveButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.jLabelStationMenuTitle = new JLabel();
        this.dpuLabel1 = new JLabel();
        FormListener formListener = new FormListener();
        this.setBackground(new Color(51, 51, 51));
        this.setBorder(new SoftBevelBorder(0));
        this.masterTable.setCursor(new Cursor(12));
        this.masterTable.setSelectionMode(0);
        JTableBinding<Dpu, List<Dpu>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${department}"));
        columnBinding.setColumnName(bundle.getString("DEPARTEMENT"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${dpu}"));
        columnBinding.setColumnName("DPU");
        columnBinding.setColumnClass(Double.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTable.addMouseListener(formListener);
        this.masterScrollPane.setViewportView(this.masterTable);
        this.departmentLabel.setFont(new Font("Arial", 0, 12));
        this.departmentLabel.setForeground(new Color(255, 254, 255));
        this.departmentLabel.setText(bundle.getString("DEPARTEMENT"));
        this.dpuLabel.setFont(new Font("Arial", 0, 12));
        this.dpuLabel.setForeground(new Color(255, 254, 255));
        this.dpuLabel.setText("DPU:");
        this.departmentField.setFont(new Font("Arial", 0, 12));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.department}"), this.departmentField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.masterTable, ELProperty.create("${selectedElement != null}"), this.departmentField, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.dpuField.setFont(new Font("Arial", 0, 12));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.dpu}"), this.dpuField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.masterTable, ELProperty.create("${selectedElement != null}"), this.dpuField, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.saveButton.setFont(new Font("Arial", 1, 12));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.saveButton.setText("Enregistrer");
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.addActionListener(formListener);
        this.newButton.setFont(new Font("Arial", 1, 12));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.newButton.setText("Ajouter");
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.addMouseListener(formListener);
        this.deleteButton.setFont(new Font("Arial", 1, 12));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.deleteButton.setText("Supprimer");
        this.deleteButton.setHorizontalTextPosition(0);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.masterTable, ELProperty.create("${selectedElement != null}"), this.deleteButton, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.deleteButton.addMouseListener(formListener);
        this.jLabelStationMenuTitle.setFont(new Font("Arial", 0, 13));
        this.jLabelStationMenuTitle.setForeground(new Color(255, 254, 255));
        this.jLabelStationMenuTitle.setHorizontalAlignment(0);
        this.jLabelStationMenuTitle.setText("DPU");
        this.jLabelStationMenuTitle.setName("jLabelStationMenuTitle");
        this.dpuLabel1.setFont(new Font("Arial", 0, 12));
        this.dpuLabel1.setForeground(new Color(255, 254, 255));
        this.dpuLabel1.setText(bundle.getString("\u20ac/HA/AN"));
        this.dpuLabel1.setName("dpuLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelStationMenuTitle, -1, 424, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.departmentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.departmentField, -2, 52, -2).addGap(18, 18, 18).addComponent(this.dpuLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dpuField, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dpuLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.masterScrollPane, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.newButton, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deleteButton, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveButton, -2, 135, -2)))).addContainerGap()));
        layout.linkSize(0, this.newButton, this.saveButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelStationMenuTitle, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addComponent(this.masterScrollPane, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.departmentLabel).addComponent(this.departmentField, -2, 20, -2).addComponent(this.dpuLabel).addComponent(this.dpuField, -2, 20, -2).addComponent(this.dpuLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton, -2, 20, -2).addComponent(this.deleteButton, -2, 20, -2).addComponent(this.saveButton, -2, 20, -2)).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        try {
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            if (this.AddParametre) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ENREGISTREMENT REUSSI !"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("MISE \u00c0 JOUR EFFECTU\u00c9E !"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
            }
            this.AddParametre = false;
        }
        catch (RollbackException rex) {
            rex.printStackTrace();
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
            for (Dpu d : this.list) {
                merged.add(this.entityManager.merge((Object)d));
            }
            this.list.clear();
            this.list.addAll(merged);
        }
    }

    private void newButtonMouseReleased(MouseEvent evt) {
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("AJOUTER"))) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            Dpu d = new Dpu();
            this.entityManager.persist((Object)d);
            this.list.add(d);
            int row = this.list.size() - 1;
            this.masterTable.setRowSelectionInterval(row, row);
            this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
            this.departmentField.setEnabled(true);
            this.dpuField.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ANNULER"));
            this.AddParametre = true;
        } else {
            this.departmentField.setEnabled(true);
            this.dpuField.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.AddParametre = false;
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("AJOUTER"));
            this.Refresh();
        }
    }

    private void deleteButtonMouseReleased(MouseEvent evt) {
        int choix;
        if (this.deleteButton.isEnabled() && (choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VEUILLEZ CONFIRMER LA SUPPRESSION DE CET \u00c9L\u00c9MENT"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("SUPPRESSION"), 2)) == 0) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            int[] selected = this.masterTable.getSelectedRows();
            ArrayList<Dpu> toRemove = new ArrayList<Dpu>(selected.length);
            for (int idx = 0; idx < selected.length; ++idx) {
                Dpu d = this.list.get(this.masterTable.convertRowIndexToModel(selected[idx]));
                toRemove.add(d);
                this.entityManager.remove((Object)d);
            }
            this.list.removeAll(toRemove);
            this.SetFreeseElements(false);
            this.entityManager.getTransaction().commit();
        }
    }

    private void masterTableMouseClicked(MouseEvent evt) {
        this.saveButton.setEnabled(true);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DPUPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DPUPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DPUPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DPUPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setContentPane(new DPUPanel());
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private class FormListener
    implements ActionListener,
    MouseListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DPUPanel.this.saveButton) {
                DPUPanel.this.saveButtonActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == DPUPanel.this.masterTable) {
                DPUPanel.this.masterTableMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.getSource() == DPUPanel.this.newButton) {
                DPUPanel.this.newButtonMouseReleased(evt);
            } else if (evt.getSource() == DPUPanel.this.deleteButton) {
                DPUPanel.this.deleteButtonMouseReleased(evt);
            }
        }
    }
}

