/*
 * Decompiled with CFR 0.152.
 */
package com.imagine.component.calendar.selection;

import com.imagine.component.calendar.CalendarComponent;
import com.imagine.component.calendar.data.CalendarDate;
import com.imagine.component.calendar.data.CalendarHeaderCellInfo;
import com.imagine.component.calendar.data.CalendarPartInfo;
import com.imagine.component.calendar.data.CalendarTableCellInfo;
import com.imagine.component.calendar.data.CalendarWeekCellInfo;
import com.imagine.component.calendar.events.CalendarEventDateSelectedByKey;
import com.imagine.component.calendar.events.CalendarEventDateSelectedByMouse;
import com.imagine.component.calendar.events.CalendarEventHeaderCellSelectedByMouse;
import com.imagine.component.calendar.events.CalendarEventKeyAction;
import com.imagine.component.calendar.events.CalendarEventMouseAction;
import com.imagine.component.calendar.events.CalendarEventMouseMotionAction;
import com.imagine.component.calendar.events.CalendarEventWeekCellSelectedByMouse;
import com.imagine.component.calendar.selection.CalendarSelectionListener;
import com.imagine.component.calendar.selection.CalendarSelectionModel;
import com.imagine.component.calendar.selection.CalendarSelectionModelAdapter;
import com.imagine.util.events.KeyEventType;
import com.imagine.util.events.MouseEventType;
import com.imagine.util.events.MouseMotionEventType;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class CalendarSelectionModelSingleIntervalSelection
extends CalendarSelectionModel {
    private CalendarDate eb;
    private CalendarDate fb;
    private CalendarSelectionModelAdapter db;
    private boolean ib;
    private CalendarDate lb;
    private static final int mb = 0;
    private static final int jb = 1;
    private static final int hb = 2;
    private static final int bb = 3;
    private static final int cb = 4;
    private static final int kb = 5;
    private int gb;

    public CalendarSelectionModelSingleIntervalSelection() {
        this.fb = this.eb = new CalendarDate();
        this.db = new CalendarSelectionModelAdapter();
        this.ib = false;
        this.lb = null;
        this.gb = 0;
    }

    public boolean processKeyEvent(CalendarEventKeyAction calendarEventKeyAction) {
        boolean bl = false;
        this.gb = 0;
        CalendarComponent calendarComponent = this.getCalendarComponent();
        CalendarPartInfo calendarPartInfo = calendarComponent.getCalendarView().getMonthView().getCurrentCalendarPartInfo();
        if (calendarPartInfo instanceof CalendarTableCellInfo) {
            CalendarTableCellInfo calendarTableCellInfo = (CalendarTableCellInfo)calendarPartInfo;
            this.gb = (calendarTableCellInfo.getModifiers() & 1) != 0 || (calendarTableCellInfo.getModifiers() & 2) != 0 ? 1 : 2;
            int n = calendarComponent.getIntegerCalendarProperty(CalendarComponent.MAX_ADVANCE_OVER_NON_SELECTABLE_DATES);
            KeyEvent keyEvent = calendarEventKeyAction.getKeyEvent();
            int n2 = keyEvent.getKeyCode();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(calendarTableCellInfo.getDate());
            KeyEventType keyEventType = calendarEventKeyAction.getKeyEventType();
            if (keyEventType == KeyEventType.KEY_PRESSED) {
                int n3 = 0;
                if (n2 == 8 && calendarComponent.getCalendarSelectionModel().isEmptySelectionAllowed()) {
                    calendarComponent.getCalendarSelectionModel().setSelectedDates(new Date[0]);
                } else if (n2 == 224 || n2 == 38) {
                    n3 = -7;
                } else if (n2 == 225 || n2 == 40) {
                    n3 = 7;
                } else if (n2 == 226 || n2 == 37) {
                    n3 = -1;
                } else if (n2 == 227 || n2 == 39) {
                    n3 = 1;
                }
                if (n3 != 0) {
                    int n4;
                    gregorianCalendar.add(5, n3);
                    for (n4 = 0; n4 <= n && !this.isDateSelectable(gregorianCalendar.getTime()); ++n4) {
                        gregorianCalendar.add(5, n3);
                    }
                    if (n4 == n) {
                        return false;
                    }
                    calendarComponent.getCalendarView().getMonthView().setMonthViewCurrentDate(gregorianCalendar.getTime());
                    CalendarPartInfo calendarPartInfo2 = calendarComponent.getCalendarView().getMonthView().getCurrentCalendarPartInfo();
                    if (calendarPartInfo2 instanceof CalendarTableCellInfo) {
                        CalendarTableCellInfo calendarTableCellInfo2 = (CalendarTableCellInfo)calendarPartInfo2;
                        bl = this.d(calendarTableCellInfo2.getDate(), calendarTableCellInfo2.getModifiers());
                        if (bl) {
                            this.getCalendarComponent().processCalendarEvent(new CalendarEventDateSelectedByKey(this.getCalendarComponent(), calendarTableCellInfo2.getMonthType(), this.getLeadSelectionDate()));
                        }
                    } else if (calendarPartInfo2 instanceof CalendarHeaderCellInfo || calendarPartInfo2 instanceof CalendarWeekCellInfo) {
                        // empty if block
                    }
                }
            }
        }
        return bl;
    }

    public boolean processMouseEvent(CalendarEventMouseAction calendarEventMouseAction) {
        CalendarPartInfo calendarPartInfo;
        boolean bl = false;
        this.gb = 0;
        CalendarPartInfo calendarPartInfo2 = calendarEventMouseAction.getRelatedCalendarPartInfo();
        if (calendarPartInfo2 instanceof CalendarTableCellInfo) {
            calendarPartInfo = (CalendarTableCellInfo)calendarPartInfo2;
            if (calendarEventMouseAction.getMouseEventType() == MouseEventType.MOUSE_RELEASED) {
                this.gb = (calendarPartInfo.getModifiers() & 1) != 0 ? 0 : ((calendarPartInfo.getModifiers() & 2) != 0 ? 0 : 5);
            } else if (calendarEventMouseAction.getMouseEventType() == MouseEventType.MOUSE_CLICKED) {
                CalendarDate calendarDate = new CalendarDate(calendarPartInfo.getDate());
                if (calendarDate.compareTo(this.lb) == 0) {
                    if ((calendarPartInfo.getModifiers() & 1) != 0) {
                        this.gb = 0;
                    } else if ((calendarPartInfo.getModifiers() & 2) != 0) {
                        if (this.ib) {
                            this.gb = 4;
                        }
                    } else {
                        this.gb = 2;
                    }
                }
            } else if (calendarEventMouseAction.getMouseEventType() == MouseEventType.MOUSE_PRESSED) {
                this.ib = this.isDateSelected(calendarPartInfo.getDate());
                this.lb = new CalendarDate(calendarPartInfo.getDate());
                this.gb = (calendarPartInfo.getModifiers() & 1) != 0 ? 1 : ((calendarPartInfo.getModifiers() & 2) != 0 ? 3 : 2);
            }
            if (this.gb != 0) {
                bl = this.d(calendarPartInfo.getDate(), calendarPartInfo.getModifiers());
            }
        }
        if (calendarEventMouseAction.getMouseEventType() == MouseEventType.MOUSE_PRESSED || calendarEventMouseAction.getMouseEventType() == MouseEventType.MOUSE_RELEASED) {
            if (calendarPartInfo2 instanceof CalendarTableCellInfo) {
                calendarPartInfo = (CalendarTableCellInfo)calendarPartInfo2;
                this.getCalendarComponent().processCalendarEvent(new CalendarEventDateSelectedByMouse(this.getCalendarComponent(), calendarPartInfo.getMonthType(), this.getLeadSelectionDate()));
            } else if (calendarPartInfo2 instanceof CalendarHeaderCellInfo) {
                calendarPartInfo = (CalendarHeaderCellInfo)calendarPartInfo2;
                this.getCalendarComponent().processCalendarEvent(new CalendarEventHeaderCellSelectedByMouse(this.getCalendarComponent(), calendarPartInfo.getDayOfWeek()));
            } else if (calendarPartInfo2 instanceof CalendarWeekCellInfo) {
                calendarPartInfo = (CalendarWeekCellInfo)calendarPartInfo2;
                this.getCalendarComponent().processCalendarEvent(new CalendarEventWeekCellSelectedByMouse(this.getCalendarComponent(), calendarPartInfo.getWeekOfYear()));
            }
        }
        return bl;
    }

    public boolean processMouseMotionEvent(CalendarEventMouseMotionAction calendarEventMouseMotionAction) {
        boolean bl = false;
        this.gb = 0;
        if (calendarEventMouseMotionAction.getMouseMotionEventType() == MouseMotionEventType.MOUSE_DRAGGED) {
            CalendarPartInfo calendarPartInfo;
            CalendarPartInfo calendarPartInfo2 = calendarEventMouseMotionAction.getRelatedCalendarPartInfo();
            if (calendarPartInfo2 instanceof CalendarTableCellInfo) {
                calendarPartInfo = (CalendarTableCellInfo)calendarPartInfo2;
                this.gb = 1;
                if (this.gb != 0) {
                    bl = this.d(calendarPartInfo.getDate(), calendarPartInfo.getModifiers());
                }
            }
            if (calendarPartInfo2 instanceof CalendarTableCellInfo) {
                calendarPartInfo = (CalendarTableCellInfo)calendarPartInfo2;
                this.getCalendarComponent().processCalendarEvent(new CalendarEventDateSelectedByMouse(this.getCalendarComponent(), calendarPartInfo.getMonthType(), this.getLeadSelectionDate()));
            } else if (calendarPartInfo2 instanceof CalendarHeaderCellInfo) {
                calendarPartInfo = (CalendarHeaderCellInfo)calendarPartInfo2;
                this.getCalendarComponent().processCalendarEvent(new CalendarEventHeaderCellSelectedByMouse(this.getCalendarComponent(), calendarPartInfo.getDayOfWeek()));
            } else if (calendarPartInfo2 instanceof CalendarWeekCellInfo) {
                calendarPartInfo = (CalendarWeekCellInfo)calendarPartInfo2;
                this.getCalendarComponent().processCalendarEvent(new CalendarEventWeekCellSelectedByMouse(this.getCalendarComponent(), calendarPartInfo.getWeekOfYear()));
            }
        }
        return bl;
    }

    private boolean d(Date date, int n) {
        if (!this.isDateSelectable(date)) {
            return false;
        }
        CalendarDate calendarDate = new CalendarDate(date);
        if (this.gb == 1) {
            this.fb = calendarDate;
            this.getCalendarComponent().getCalendarView().getMonthView().setMonthViewCurrentDate(this.getLeadSelectionDate());
        } else if (this.gb == 3) {
            if (this.eb.wrapsNullDate() || this.fb.wrapsNullDate()) {
                this.eb = this.fb = calendarDate;
            } else if (!(this.isEmptySelectionAllowed() && this.eb.equals(this.fb) && this.eb.equals(calendarDate) || this.eb.compareTo(calendarDate) * calendarDate.compareTo(this.fb) >= 0)) {
                if (this.eb.compareTo(this.fb) <= 0) {
                    if (calendarDate.add(1).equals(this.eb)) {
                        this.eb = calendarDate;
                    } else if (calendarDate.add(-1).equals(this.fb)) {
                        this.fb = calendarDate;
                    } else {
                        this.eb = this.fb = calendarDate;
                    }
                } else if (this.fb.compareTo(this.eb) < 0) {
                    if (calendarDate.add(1).equals(this.fb)) {
                        this.fb = calendarDate;
                    } else if (calendarDate.add(-1).equals(this.eb)) {
                        this.eb = calendarDate;
                    } else {
                        this.fb = this.eb = calendarDate;
                    }
                }
            }
            this.getCalendarComponent().getCalendarView().getMonthView().setMonthViewCurrentDate(this.getLeadSelectionDate());
        } else if (this.gb == 4) {
            if (this.eb.wrapsNullDate() || this.fb.wrapsNullDate()) {
                this.eb = this.fb = calendarDate;
            } else if (this.isEmptySelectionAllowed() && this.eb.equals(this.fb) && this.eb.equals(calendarDate)) {
                this.eb = this.fb = new CalendarDate((Date)null);
            } else if (this.eb.compareTo(calendarDate) * calendarDate.compareTo(this.fb) >= 0) {
                if (this.eb.equals(calendarDate)) {
                    if (this.eb.compareTo(this.fb) < 0) {
                        this.eb = this.eb.add(1);
                    } else if (this.eb.compareTo(this.fb) > 0) {
                        this.eb = this.eb.add(-1);
                    }
                } else if (this.fb.equals(calendarDate)) {
                    if (this.fb.compareTo(this.eb) < 0) {
                        this.fb = this.fb.add(1);
                    } else if (this.fb.compareTo(this.eb) > 0) {
                        this.fb = this.fb.add(-1);
                    }
                } else {
                    this.eb = this.fb = calendarDate;
                }
            }
            this.getCalendarComponent().getCalendarView().getMonthView().setMonthViewCurrentDate(this.getLeadSelectionDate());
        } else if (this.gb == 5) {
            this.getCalendarComponent().getCalendarView().getMonthView().setMonthViewCurrentDate(this.getLeadSelectionDate());
        } else if (this.gb == 2) {
            this.eb = this.fb = calendarDate;
            this.getCalendarComponent().getCalendarView().getMonthView().setMonthViewCurrentDate(this.getLeadSelectionDate());
        }
        this.db.selectionChanged(this);
        return true;
    }

    private void c(Vector vector, CalendarDate calendarDate, CalendarDate calendarDate2) {
        block7: {
            int n;
            block10: {
                block9: {
                    block8: {
                        if (calendarDate.wrapsNullDate() && calendarDate2.wrapsNullDate()) break block7;
                        if (!calendarDate.wrapsNullDate()) break block8;
                        if (vector.contains(calendarDate2) || !this.isDateSelectable(calendarDate2.createDate())) break block7;
                        vector.add(calendarDate2);
                        break block7;
                    }
                    if (!calendarDate2.wrapsNullDate()) break block9;
                    if (vector.contains(calendarDate) || !this.isDateSelectable(calendarDate.createDate())) break block7;
                    vector.add(calendarDate);
                    break block7;
                }
                n = calendarDate2.compareTo(calendarDate);
                if (n != 0) break block10;
                if (vector.contains(calendarDate) || !this.isDateSelectable(calendarDate.createDate())) break block7;
                vector.add(calendarDate);
                break block7;
            }
            if (n < 0) {
                while (n <= 0) {
                    if (!vector.contains(calendarDate) && this.isDateSelectable(calendarDate.createDate())) {
                        vector.add(calendarDate);
                    }
                    calendarDate = calendarDate.add(-1);
                    n = calendarDate2.compareTo(calendarDate);
                }
            } else if (n > 0) {
                while (n >= 0) {
                    if (!vector.contains(calendarDate) && this.isDateSelectable(calendarDate.createDate())) {
                        vector.add(calendarDate);
                    }
                    calendarDate = calendarDate.add(1);
                    n = calendarDate2.compareTo(calendarDate);
                }
            }
        }
    }

    public boolean isDateSelected(Date date) {
        CalendarDate calendarDate = new CalendarDate(date);
        return this.isDateSelectable(date) && this.eb.compareTo(calendarDate) * calendarDate.compareTo(this.fb) >= 0;
    }

    public void setSelectedDates(Date[] dateArray) {
        if (dateArray.length == 0) {
            if (this.isEmptySelectionAllowed()) {
                this.eb = this.fb = new CalendarDate((Date)null);
            }
        } else {
            Date date = dateArray[0];
            Date date2 = dateArray[0];
            for (int i = 1; i < dateArray.length; ++i) {
                if (!this.isDateSelectable(dateArray[i])) continue;
                if (dateArray[i].getTime() < date.getTime()) {
                    date = dateArray[i];
                }
                if (dateArray[i].getTime() <= date2.getTime()) continue;
                date2 = dateArray[i];
            }
            this.eb = new CalendarDate(date);
            this.fb = new CalendarDate(date2);
        }
        this.db.selectionChanged(this);
    }

    public Date[] getSelectedDates() {
        Vector vector = new Vector();
        this.c(vector, this.eb, this.fb);
        if (vector.size() == 0) {
            return new Date[0];
        }
        Date[] dateArray = new Date[vector.size()];
        for (int i = 0; i < dateArray.length; ++i) {
            dateArray[i] = ((CalendarDate)vector.elementAt(i)).createDate();
        }
        return dateArray;
    }

    public Date getAnchorSelectionDate() {
        return this.eb.createDate();
    }

    public void setAnchorSelectionDate(Date date) {
        if (!this.isDateSelectable(date)) {
            return;
        }
        this.eb = new CalendarDate(date);
        this.db.selectionChanged(this);
    }

    public Date getLeadSelectionDate() {
        return this.fb.createDate();
    }

    public void setLeadSelectionDate(Date date) {
        if (!this.isDateSelectable(date)) {
            return;
        }
        this.fb = new CalendarDate(date);
        this.db.selectionChanged(this);
    }

    public void addCalendarSelectionListener(CalendarSelectionListener calendarSelectionListener) {
        this.db.addCalendarSelectionListener(calendarSelectionListener);
    }

    public boolean removeCalendarSelectionListener(CalendarSelectionListener calendarSelectionListener) {
        return this.db.removeCalendarSelectionListener(calendarSelectionListener);
    }

    public String getName() {
        return "Single Interval Selection";
    }
}

