/*
 * Decompiled with CFR 0.152.
 */
package com.imagine.component.calendar.renderers.tablecellrenderers;

import com.imagine.component.calendar.CalendarComponent;
import com.imagine.component.calendar.data.CalendarMonthType;
import com.imagine.component.calendar.data.CalendarTableCellInfo;
import com.imagine.component.calendar.renderers.tablecellrenderers.CalendarTableCellRenderer;
import com.imagine.component.calendar.skins.CalendarSkin;
import com.imagine.component.calendar.util.GUIUtilities;
import java.awt.Font;
import java.awt.Graphics;

public class CalendarTableCellRendererHoveredRoundRect
implements CalendarTableCellRenderer {
    public void paint(Graphics graphics, CalendarComponent calendarComponent, CalendarTableCellInfo calendarTableCellInfo) {
        if (!calendarComponent.getCalendarRendererProvider().hasBackgroundRenderer()) {
            graphics.setColor(calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.CELL_FILL_COLOR));
            graphics.fillRect(0, 0, calendarTableCellInfo.getWidth(), calendarTableCellInfo.getHeight());
        }
        graphics.setColor(calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.HOVERED_CELL_FILL_COLOR));
        graphics.fillRoundRect(0, 0, calendarTableCellInfo.getWidth(), calendarTableCellInfo.getHeight(), 10, 10);
        graphics.setColor(calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.HOVERED_CELL_TEXT_COLOR));
        Font font = null;
        font = calendarTableCellInfo.getMonthType() != CalendarMonthType.CURRENT_MONTH ? calendarComponent.getCalendarSkin().getFontSkinProperty(CalendarSkin.EXTRA_MONTH_CELL_FONT) : (calendarTableCellInfo.isFromWeekend() ? calendarComponent.getCalendarSkin().getFontSkinProperty(CalendarSkin.WEEKEND_CELL_FONT) : calendarComponent.getCalendarSkin().getFontSkinProperty(CalendarSkin.CELL_FONT));
        graphics.setFont(font);
        GUIUtilities.drawCenteredString(graphics, 0, 0, calendarTableCellInfo.getWidth(), calendarTableCellInfo.getHeight(), calendarTableCellInfo.getValue().toString());
        if (calendarTableCellInfo.isDisabled()) {
            graphics.setColor(calendarComponent.getCalendarSkin().getColorSkinProperty(CalendarSkin.DISABLED_COLOR));
            int n = 3;
            graphics.drawLine(n, n, calendarTableCellInfo.getWidth() - n, calendarTableCellInfo.getHeight() - n);
            graphics.drawLine(n, calendarTableCellInfo.getHeight() - n, calendarTableCellInfo.getWidth() - n, n);
        }
    }
}

