/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Crop;
import DataBase.Famille;
import DataBase.PluriCrop;
import Interfaces.FamilyFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modules.CultureMod;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class MultiCropJFrame
extends JFrame {
    String CurrentCrop = "";
    boolean AddFamily = false;
    private JButton CloseButton;
    private JLabel cropLabel;
    private JButton deleteButton;
    private EntityManager entityManager;
    private JLabel familyLabel;
    private JButton jButtonCreatNewFamily;
    private JComboBox jComboBoxCrop;
    private JComboBox jComboBoxFamille;
    private JLabel jLabelCultureTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private List<PluriCrop> list;
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private JButton newButton;
    private Query query;
    private JButton saveButton;
    private BindingGroup bindingGroup;

    public MultiCropJFrame() {
        this.initComponents();
        this.InitCropList();
        this.InitFamilylist();
        this.InitListByCrop();
        this.SetFreeseElements(false);
        this.CentreFrame();
    }

    public MultiCropJFrame(String CropName) {
        this.CurrentCrop = CropName;
        this.initComponents();
        this.InitCropList();
        this.InitFamilylist();
        this.InitListByCrop();
        this.refreshForSingleCrop();
        this.SetFreeseElements(false);
        this.CentreFrame();
    }

    private void CentreFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void InitCropList() {
        CultureMod CropT = new CultureMod();
        List CropList = new ArrayList();
        CropList = CropT.GetCultureList();
        for (Object CropName : CropList) {
            this.jComboBoxCrop.addItem(CropName);
        }
        if (!this.CurrentCrop.equals("")) {
            this.jComboBoxCrop.setSelectedItem(this.CurrentCrop);
        }
    }

    private void InitFamilylist() {
        Query MyQuery = this.entityManager.createQuery("SELECT DISTINCT f FROM Famille f ORDER BY f.namef");
        List FaDataView = MyQuery.getResultList();
        this.jComboBoxFamille.removeAllItems();
        for (Famille Fa : FaDataView) {
            this.jComboBoxFamille.addItem(Fa.getNamef());
        }
    }

    private void SetFreeseElements(boolean Statut) {
        this.jComboBoxFamille.setEnabled(Statut);
        this.saveButton.setEnabled(Statut);
        if (!Statut) {
            if (this.jComboBoxFamille.getSelectedIndex() != -1 && this.jComboBoxFamille.getSelectedIndex() != 0 && !this.jComboBoxFamille.getSelectedItem().equals("")) {
                this.deleteButton.setEnabled(true);
            }
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    private void RefreshFamilyList() {
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT p FROM PluriCrop p");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.jPanel1 = new JPanel();
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.familyLabel = new JLabel();
        this.saveButton = new JButton();
        this.CloseButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.jComboBoxFamille = new JComboBox();
        this.jButtonCreatNewFamily = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabelCultureTitle = new JLabel();
        this.cropLabel = new JLabel();
        this.jComboBoxCrop = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(51, 51, 51));
        this.jPanel1.setBackground(new Color(1, 1, 1));
        this.jPanel1.setName("jPanel1");
        this.masterScrollPane.setName("masterScrollPane");
        this.masterTable.setName("masterTable");
        JTableBinding<PluriCrop, List<PluriCrop>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${family}"));
        columnBinding.setColumnName(bundle.getString("LISTE_FAMILLE_SELECT"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${crop}"));
        columnBinding.setColumnName("c");
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idCrop}"));
        columnBinding.setColumnName("idc");
        columnBinding.setColumnClass(Crop.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idFamily}"));
        columnBinding.setColumnName("idf");
        columnBinding.setColumnClass(Famille.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MultiCropJFrame.this.masterTableMouseClicked(evt);
            }
        });
        this.masterScrollPane.setViewportView(this.masterTable);
        this.masterTable.getColumnModel().getColumn(0).setMinWidth(210);
        this.masterTable.getColumnModel().getColumn(0).setPreferredWidth(210);
        this.masterTable.getColumnModel().getColumn(1).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(1).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(1).setMaxWidth(1);
        this.masterTable.getColumnModel().getColumn(2).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(2).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(2).setMaxWidth(1);
        this.masterTable.getColumnModel().getColumn(3).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(3).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.familyLabel.setFont(new Font("Arial", 1, 14));
        this.familyLabel.setForeground(new Color(255, 254, 255));
        this.familyLabel.setText(bundle.getString("FAMILLE:"));
        this.familyLabel.setName("familyLabel");
        this.saveButton.setFont(new Font("Arial", 1, 12));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiCropJFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.CloseButton.setFont(new Font("Arial", 1, 12));
        this.CloseButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.CloseButton.setText(bundle.getString("FERMER"));
        this.CloseButton.setHorizontalTextPosition(0);
        this.CloseButton.setName("CloseButton");
        this.CloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MultiCropJFrame.this.CloseButtonMouseReleased(evt);
            }
        });
        this.newButton.setFont(new Font("Arial", 1, 12));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.newButton.setText(bundle.getString("AJOUTER"));
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.setName("newButton");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiCropJFrame.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setFont(new Font("Arial", 1, 12));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.deleteButton.setText(bundle.getString("RETIRER"));
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiCropJFrame.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jComboBoxFamille.setFont(new Font("Arial", 0, 14));
        this.jComboBoxFamille.setName("jComboBoxFamille");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.family}"), this.jComboBoxFamille, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxFamille.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                MultiCropJFrame.this.jComboBoxFamillePopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jButtonCreatNewFamily.setFont(new Font("Arial", 1, 12));
        this.jButtonCreatNewFamily.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn long rect chrome.png")));
        this.jButtonCreatNewFamily.setText(bundle.getString("CR\u00c9ER UNE NOUVELLE FAMILLE"));
        this.jButtonCreatNewFamily.setHorizontalTextPosition(0);
        this.jButtonCreatNewFamily.setName("jButtonCreatNewFamily");
        this.jButtonCreatNewFamily.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MultiCropJFrame.this.jButtonCreatNewFamilyMouseReleased(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.masterScrollPane, -1, 632, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.familyLabel).addGap(4, 4, 4).addComponent(this.jComboBoxFamille, -2, 286, -2).addGap(60, 60, 60).addComponent(this.jButtonCreatNewFamily, -2, 205, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.newButton, -2, 133, -2).addGap(32, 32, 32).addComponent(this.deleteButton, -2, 133, -2).addGap(35, 35, 35).addComponent(this.saveButton, -2, 130, -2).addGap(32, 32, 32).addComponent(this.CloseButton, -2, 133, -2)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.masterScrollPane, -1, 228, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.familyLabel).addComponent(this.jComboBoxFamille, -2, 20, -2).addComponent(this.jButtonCreatNewFamily, -2, 20, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton, -2, 19, -2).addComponent(this.newButton, -2, 19, -2).addComponent(this.saveButton, -2, 19, -2).addComponent(this.CloseButton, -2, 19, -2)).addContainerGap()));
        this.jPanel2.setBackground(new Color(51, 51, 51));
        this.jPanel2.setName("jPanel2");
        this.jLabelCultureTitle.setFont(new Font("Arial", 1, 13));
        this.jLabelCultureTitle.setForeground(new Color(255, 255, 255));
        this.jLabelCultureTitle.setHorizontalAlignment(0);
        this.jLabelCultureTitle.setText(bundle.getString("CULTURES PLURISP\u00c9CIFIQUES"));
        this.jLabelCultureTitle.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelCultureTitle.setName("jLabelCultureTitle");
        this.cropLabel.setFont(new Font("Arial", 1, 14));
        this.cropLabel.setForeground(new Color(255, 254, 255));
        this.cropLabel.setText(bundle.getString("CULTURE:"));
        this.cropLabel.setName("cropLabel");
        this.jComboBoxCrop.setFont(new Font("Arial", 0, 14));
        this.jComboBoxCrop.setModel(new DefaultComboBoxModel<String>(new String[]{bundle.getString("LISTE_FAMILLE_SELECT")}));
        this.jComboBoxCrop.setName("jComboBoxCrop");
        this.jComboBoxCrop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                MultiCropJFrame.this.jComboBoxCropPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jSeparator1.setName("jSeparator1");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 656, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.cropLabel).addGap(18, 18, 18).addComponent(this.jComboBoxCrop, -2, 310, -2).addContainerGap(260, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(178, 178, 178).addComponent(this.jLabelCultureTitle, -2, 284, -2).addContainerGap(194, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabelCultureTitle, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cropLabel).addComponent(this.jComboBoxCrop, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0)));
        this.bindingGroup.bind();
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        try {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ENREGISTREMENT REUSSI !"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
            this.AddFamily = false;
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("AJOUTER"));
            this.SetFreeseElements(false);
        }
        catch (RollbackException rex) {
            rex.printStackTrace();
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
            for (PluriCrop p : this.list) {
                merged.add(this.entityManager.merge((Object)p));
            }
            this.list.clear();
            this.list.addAll(merged);
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.InitFamilylist();
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("AJOUTER"))) {
            PluriCrop p = new PluriCrop();
            this.entityManager.persist((Object)p);
            this.list.add(p);
            int row = this.list.size() - 1;
            this.masterTable.setRowSelectionInterval(row, row);
            this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
            this.jComboBoxFamille.setSelectedItem("");
            this.SetFreeseElements(true);
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ANNULER"));
            this.AddFamily = true;
        } else {
            this.SetFreeseElements(false);
            this.AddFamily = false;
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("AJOUTER"));
            this.RefreshFamilyList();
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int choix;
        if (this.deleteButton.isEnabled() && (choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("VEUILLEZ CONFIRMER LE RETRAIT DE CETTE FAMILLE"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("SUPPRESSION"), 2)) == 0) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            int[] selected = this.masterTable.getSelectedRows();
            ArrayList<PluriCrop> toRemove = new ArrayList<PluriCrop>(selected.length);
            for (int idx = 0; idx < selected.length; ++idx) {
                PluriCrop p = this.list.get(this.masterTable.convertRowIndexToModel(selected[idx]));
                toRemove.add(p);
                this.entityManager.remove((Object)p);
            }
            this.entityManager.getTransaction().commit();
            this.list.removeAll(toRemove);
            this.SetFreeseElements(false);
        }
    }

    private void jComboBoxCropPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.SetFreeseElements(false);
        if (!this.jComboBoxCrop.getSelectedItem().equals("")) {
            this.newButton.setEnabled(true);
            this.CurrentCrop = this.jComboBoxCrop.getSelectedItem().toString();
            this.jComboBoxFamille.setSelectedItem("");
            this.InitListByCrop();
        } else {
            this.newButton.setEnabled(false);
            this.query = this.entityManager.createQuery("SELECT m FROM Meteo m WHERE m.id = -1");
        }
        this.refreshForSingleCrop();
    }

    private void jComboBoxFamillePopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        CultureMod CropMod = new CultureMod();
        String famille = "";
        try {
            famille = this.jComboBoxFamille.getSelectedItem().toString();
        }
        catch (NullPointerException ex) {
            famille = "";
        }
        if (!this.jComboBoxCrop.getSelectedItem().equals("")) {
            this.CurrentCrop = this.jComboBoxCrop.getSelectedItem().toString();
        }
        int idFa = 0;
        int idCrp = 0;
        if (!famille.equals("") && !this.CurrentCrop.equals("")) {
            idFa = CropMod.ReturnFamilyId(famille);
            this.masterTable.setValueAt(this.entityManager.find(Famille.class, (Object)idFa), this.masterTable.getSelectedRow(), 3);
            this.masterTable.setValueAt(famille, this.masterTable.getSelectedRow(), 0);
            this.masterTable.setValueAt(this.CurrentCrop, this.masterTable.getSelectedRow(), 1);
            idCrp = CropMod.GetIdCultByNameCult(this.CurrentCrop);
            this.masterTable.setValueAt(this.entityManager.find(Crop.class, (Object)idCrp), this.masterTable.getSelectedRow(), 2);
        }
    }

    private void CloseButtonMouseReleased(MouseEvent evt) {
        this.dispose();
    }

    private void masterTableMouseClicked(MouseEvent evt) {
        this.SetFreeseElements(false);
    }

    private void jButtonCreatNewFamilyMouseReleased(MouseEvent evt) {
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("ANNULER"))) {
            this.SetFreeseElements(false);
            this.AddFamily = false;
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("AJOUTER"));
            this.RefreshFamilyList();
        }
        JFrame frame = new JFrame();
        frame = new FamilyFrame();
        frame.setVisible(true);
    }

    private void InitListByCrop() {
        String Culture = this.jComboBoxCrop.getSelectedItem().toString();
        String Sql = "";
        List PcropList = this.entityManager.createQuery("SELECT p FROM PluriCrop p WHERE p.crop = '" + Culture + "'").getResultList();
        Sql = PcropList.isEmpty() ? "SELECT p FROM PluriCrop p WHERE p.idPluriCrop = -1" : "SELECT p FROM PluriCrop p WHERE p.crop = '" + Culture + "'";
        this.query = this.entityManager.createQuery(Sql);
    }

    private void refreshForSingleCrop() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MultiCropJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MultiCropJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MultiCropJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MultiCropJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MultiCropJFrame().setVisible(true);
            }
        });
    }
}

