/*
 * Decompiled with CFR 0.152.
 */
package com.imagine.component.calendar.selection;

import com.imagine.component.calendar.CalendarComponent;
import com.imagine.component.calendar.events.CalendarEventEmptySelectionAllowedChanged;
import com.imagine.component.calendar.events.CalendarEventKeyAction;
import com.imagine.component.calendar.events.CalendarEventMouseAction;
import com.imagine.component.calendar.events.CalendarEventMouseMotionAction;
import com.imagine.component.calendar.selection.CalendarSelectionListener;
import com.imagine.component.calendar.selection.EmptySelectionNotAllowedException;
import java.util.Date;

public abstract class CalendarSelectionModel {
    private CalendarComponent b = null;
    private boolean c = false;

    public final void setCalendarComponent(CalendarComponent calendarComponent) {
        this.b = calendarComponent;
    }

    public final CalendarComponent getCalendarComponent() {
        return this.b;
    }

    public abstract boolean processKeyEvent(CalendarEventKeyAction var1);

    public abstract boolean processMouseEvent(CalendarEventMouseAction var1);

    public abstract boolean processMouseMotionEvent(CalendarEventMouseMotionAction var1);

    public abstract boolean isDateSelected(Date var1);

    public boolean isDateSelectable(Date date) {
        if (date == null) {
            return this.isEmptySelectionAllowed();
        }
        return !this.isDateDisabled(date);
    }

    public boolean isDateDisabled(Date date) {
        return false;
    }

    public boolean isEmptySelectionAllowed() {
        return this.c;
    }

    public void setEmptySelectionAllowed(boolean bl) throws EmptySelectionNotAllowedException {
        if (this.b != null && !bl && this.getSelectedDates().length == 0) {
            throw new EmptySelectionNotAllowedException("Empty selection cannot be set as not allowed when no date is selected.");
        }
        this.c = bl;
        if (this.b != null) {
            CalendarEventEmptySelectionAllowedChanged calendarEventEmptySelectionAllowedChanged = new CalendarEventEmptySelectionAllowedChanged(this.b, bl);
            this.b.processCalendarEvent(calendarEventEmptySelectionAllowedChanged);
        }
    }

    public abstract void setSelectedDates(Date[] var1);

    public abstract Date[] getSelectedDates();

    public abstract String getName();

    public abstract Date getAnchorSelectionDate();

    public abstract void setAnchorSelectionDate(Date var1);

    public abstract Date getLeadSelectionDate();

    public abstract void setLeadSelectionDate(Date var1);

    public abstract void addCalendarSelectionListener(CalendarSelectionListener var1);

    public abstract boolean removeCalendarSelectionListener(CalendarSelectionListener var1);

    public String toString() {
        return this.getName();
    }
}

