/*
 * Decompiled with CFR 0.152.
 */
package modules;

import DataBase.Attendrules;
import DataBase.Conduites;
import DataBase.Depthrules;
import DataBase.Detailpesticides;
import DataBase.Harvesting;
import DataBase.Herbicideintercropapp;
import DataBase.Pesticideapp;
import DataBase.Pesticides;
import DataBase.Riskpairrules;
import DataBase.Riskpeprules;
import DataBase.Riskpesrules;
import DataBase.Sousensflous;
import DataBase.Sowing;
import DataBase.Surfacerules;
import DataBase.Technicaloperations;
import DataBase.Volatrules;
import java.beans.Beans;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import modules.IntermediateCalc;
import modules.IphyMod;
import modules.ItkMod;
import modules.LasyTools;
import modules.MactActiveMod;
import modules.SolMod;

public class RisqueIphyMod {
    Query MyQuery;
    EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("CRITERBASE.DB3PU"));
    public double RisquePES = 0.0;
    public double RisquePEP = 0.0;
    public double RisquePAir = 0.0;
    public int MsgOption = 0;
    public List ListDetails = new ArrayList();

    public RisqueIphyMod() {
    }

    public RisqueIphyMod(int IdCdt) {
        this.CalculRisk(IdCdt);
    }

    private void CalculRisk(int IdCdt) {
        SolMod SolTools;
        String MatiereActive = ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("");
        int IdProduit = 0;
        int indexPosition = 0;
        int indexLogDJA = 0;
        int IndexRisquePEP = 0;
        int IndexRisquePES = 0;
        int countOperation = 0;
        boolean SecondPassage = false;
        ArrayList<String> ListFromTable = new ArrayList<String>();
        Double Gus = 0.0;
        Double DT50 = 0.0;
        Double LogDJA = 0.0;
        Double LogAquatox = 0.0;
        Double LogDose = 0.0;
        Double LogKH = 0.0;
        Double RisquePEPtemp = 0.0;
        Double RisquePEStemp = 0.0;
        Double RisquePairtemp = 0.0;
        double CoefSurf = 0.0;
        double tempValue = 0.0;
        double PEPTemp = 0.0;
        double PESTemp = 0.0;
        double Ipest_eso = 0.0;
        double k_eso = 0.0;
        double kmin_eso = 0.0;
        double Ipestk_eso = 0.0;
        double Ipestmin_eso = 0.0;
        double Ipest_esu = 0.0;
        double k_esu = 0.0;
        double kmin_esu = 0.0;
        double Ipestk_esu = 0.0;
        double Ipestmin_esu = 0.0;
        double Ipest_air = 0.0;
        double k_air = 0.0;
        double kmin_air = 0.0;
        double Ipestk_air = 0.0;
        double Ipestmin_air = 0.0;
        double Aquatox = 0.0;
        double LessivagePot = 0.0;
        double CouvertureSol = 0.0;
        double Potruissellement = 0.0;
        double PotDerive = 0.0;
        LasyTools Tools = new LasyTools();
        MactActiveMod MatAct = new MactActiveMod();
        EntityManager entityManager = this.emf.createEntityManager();
        if (!Beans.isDesignTime() && !entityManager.getTransaction().isActive()) {
            entityManager.getTransaction().begin();
        }
        this.RisquePEP = 0.0;
        this.RisquePES = 0.0;
        this.RisquePAir = 0.0;
        List IphyAppView = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT P FROM PESTICIDEAPP P WHERE P.IDPESTAPP = -1")).getResultList();
        List IphyInterCropAppView = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT H FROM HERBICIDEINTERCROPAPP H WHERE H.IDHERBICIDEAPP = -1")).getResultList();
        List DetailIphyView = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT D FROM DETAILPESTICIDES D WHERE D.IDDETAILPEST =-1")).getResultList();
        List OpTechnique = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT T FROM TECHNICALOPERATIONS T WHERE T.IDTECHOP =-1")).getResultList();
        OpTechnique.clear();
        OpTechnique.addAll(((Conduites)entityManager.find(Conduites.class, (Object)IdCdt)).getTechnicaloperationsCollection());
        try {
            SolTools = new SolMod();
            Potruissellement = SolTools.GetPotRuissellement(IdCdt);
            SolTools = null;
        }
        catch (NullPointerException ex) {
            Potruissellement = 0.0;
        }
        try {
            SolTools = new SolMod();
            PotDerive = SolTools.GetPotDerive(IdCdt);
            SolTools = null;
        }
        catch (NullPointerException ex) {
            PotDerive = 0.0;
        }
        boolean Intercrop = false;
        ItkMod itk = new ItkMod();
        int idSemi = 0;
        int jourSemi = 0;
        int moiSemi = 0;
        String StrDateSemi = ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("");
        String StrDateApp = ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("");
        idSemi = itk.getId_TillageSowingHarv(IdCdt, 5);
        if (idSemi > 0) {
            jourSemi = ((Sowing)entityManager.find(Sowing.class, (Object)idSemi)).getJour();
            moiSemi = ((Sowing)entityManager.find(Sowing.class, (Object)idSemi)).getMois();
            StrDateSemi = jourSemi + ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("-") + moiSemi;
        } else {
            this.MsgOption = 200;
        }
        int idRecolte = 0;
        int jourRec = 0;
        int moisRec = 0;
        idRecolte = itk.getId_TillageSowingHarv(IdCdt, 6);
        if (idRecolte > 0) {
            jourRec = ((Harvesting)entityManager.find(Harvesting.class, (Object)idRecolte)).getJour();
            moisRec = ((Harvesting)entityManager.find(Harvesting.class, (Object)idRecolte)).getMois();
        } else {
            jourRec = 31;
            moisRec = 12;
            this.MsgOption = 201;
        }
        for (Technicaloperations T : OpTechnique) {
            SolMod SolTools2;
            LasyTools tool;
            IntermediateCalc CalcModule;
            IphyMod IphyM;
            IphyAppView.clear();
            DetailIphyView.clear();
            if (T.getPesticideapp() != null) {
                IphyAppView = entityManager.createQuery(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("SELECT P FROM PESTICIDEAPP P WHERE P.IDPESTAPP = ") + T.getPesticideapp().getIdpestapp()).getResultList();
                ++countOperation;
                for (Serializable Iphy : IphyAppView) {
                    try {
                        IdProduit = ((Pesticideapp)Iphy).getPesticide().getIdpest();
                    }
                    catch (NullPointerException ex) {
                        IphyM = new IphyMod();
                        IdProduit = IphyM.GetIdPestByName(((Pesticideapp)Iphy).getNompesticide());
                    }
                    StrDateApp = ((Pesticideapp)Iphy).getJour() + ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("-") + ((Pesticideapp)Iphy).getMois();
                    Intercrop = moiSemi > 0 && Tools.FirstDateIsEarly(jourSemi, moiSemi, ((Pesticideapp)Iphy).getJour(), ((Pesticideapp)Iphy).getMois()) && Tools.FirstDateIsEarly(((Pesticideapp)Iphy).getJour(), ((Pesticideapp)Iphy).getMois(), jourRec, moisRec) ? false : (moiSemi > 0 && StrDateApp.equals(StrDateSemi) ? false : (moisRec > moiSemi ? true : (Tools.FirstDateIsEarly(((Pesticideapp)Iphy).getJour(), ((Pesticideapp)Iphy).getMois(), jourRec, moisRec) ? false : !Tools.FirstDateIsEarly(jourSemi, moiSemi, ((Pesticideapp)Iphy).getJour(), ((Pesticideapp)Iphy).getMois()))));
                    try {
                        CalcModule = new IntermediateCalc();
                        CouvertureSol = CalcModule.GetCouvertureSol(IdCdt, ((Pesticideapp)Iphy).getJour(), ((Pesticideapp)Iphy).getMois(), Intercrop);
                        CalcModule = null;
                    }
                    catch (NullPointerException ex) {
                        CouvertureSol = 0.0;
                    }
                    entityManager.refresh(entityManager.find(Pesticides.class, (Object)IdProduit));
                    DetailIphyView.addAll(((Pesticides)entityManager.find(Pesticides.class, (Object)IdProduit)).getDetailpesticidesCollection());
                    if (DetailIphyView == null) continue;
                    for (Detailpesticides D : DetailIphyView) {
                        try {
                            MatiereActive = D.getNamematact().isEmpty() ? D.getNamematact() : D.getActivematter().getName();
                        }
                        catch (NullPointerException ex) {
                            tool = new LasyTools();
                            tool.SetReport(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("NOM DE LA MATI\u00c8RE ACTIVE INTROUVABLE POUR LA CONDUITE ") + ((Conduites)entityManager.find(Conduites.class, (Object)IdCdt)).getNomcdt(), 3);
                            System.out.println(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("NOM DE LA MATI\u00c8RE ACTIVE INTROUVABLE POUR LA CONDUITE ") + ((Conduites)entityManager.find(Conduites.class, (Object)IdCdt)).getNomcdt());
                            MatiereActive = ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("");
                        }
                        ListFromTable.add(MatiereActive);
                        this.ListDetails.add(MatiereActive);
                        try {
                            DT50 = D.getActivematter().getDt50();
                            if (DT50.isInfinite()) {
                                DT50 = 0.0;
                            }
                        }
                        catch (NullPointerException ex) {
                            DT50 = 0.0;
                        }
                        ListFromTable.add(ResourceBundle.getBundle("Interfaces/resources/ModulesBundle").getString("DT50=") + DT50);
                        try {
                            double Koc = 0.0;
                            try {
                                Koc = D.getActivematter().getKoc();
                            }
                            catch (NullPointerException ex) {
                                Koc = 0.0;
                            }
                            Gus = Math.log(DT50) / Math.log(10.0) * (4.0 - Math.log(Koc) / Math.log(10.0));
                            if (Gus.isInfinite()) {
                                Gus = 0.0;
                            }
                        }
                        catch (NullPointerException ex) {
                            Gus = 0.0;
                        }
                        ListFromTable.add("Gus=" + Gus);
                        try {
                            LogDJA = Math.log(D.getActivematter().getDja()) / Math.log(10.0);
                            if (LogDJA.isInfinite()) {
                                LogDJA = 0.0;
                            }
                        }
                        catch (NullPointerException ex) {
                            LogDJA = 0.0;
                        }
                        ListFromTable.add("Log DJA=" + LogDJA);
                        indexLogDJA = ListFromTable.indexOf("Log DJA=" + LogDJA);
                        try {
                            LogDose = Math.log(((Pesticideapp)Iphy).getDose() * D.getDosage()) / Math.log(10.0);
                            if (LogDose.isInfinite()) {
                                LogDose = 0.0;
                            }
                        }
                        catch (NullPointerException ex) {
                            LogDose = 0.0;
                        }
                        ListFromTable.add("Log Dose=" + LogDose);
                        try {
                            LogKH = Math.log(D.getActivematter().getKh()) / Math.log(10.0);
                            if (LogKH.isInfinite()) {
                                LogKH = 0.0;
                            }
                        }
                        catch (NullPointerException ex) {
                            LogKH = 0.0;
                        }
                        ListFromTable.add("Log KH=" + LogKH);
                        try {
                            Aquatox = D.getActivematter().getAquatox();
                        }
                        catch (NullPointerException ex) {
                            Aquatox = 0.0;
                        }
                        if (Math.log(Aquatox) / Math.log(10.0) < 2.0 + LogDJA) {
                            LogAquatox = Math.log(Aquatox) / Math.log(10.0);
                            if (LogAquatox.isInfinite()) {
                                LogAquatox = 0.0;
                            }
                        } else {
                            LogAquatox = LogDJA + 2.0;
                        }
                        ListFromTable.add("Log Aquatox=" + LogAquatox);
                        tempValue = this.Infere(ListFromTable, "R\u00e8gles Pr\u00e9sence");
                        ListFromTable.add("Pr\u00e9sence=" + tempValue);
                        try {
                            if (((Pesticideapp)Iphy).getTraitement().equals("en surface")) {
                                ListFromTable.add("Note Position=0");
                                indexPosition = ListFromTable.indexOf("Note Position=0");
                            } else {
                                ListFromTable.add("Note Position=1");
                                indexPosition = ListFromTable.indexOf("Note Position=1");
                            }
                        }
                        catch (NullPointerException ex) {
                            ListFromTable.add("Note Position=1");
                            indexPosition = ListFromTable.indexOf("Note Position=1");
                            System.out.println("Pas de traitement de surface d\u00e9fini pour la conduite " + ((Conduites)entityManager.find(Conduites.class, (Object)IdCdt)).getNomcdt());
                            this.MsgOption = 2;
                        }
                        tempValue = this.Infere(ListFromTable, "R\u00e8gles Volatilisation");
                        ListFromTable.add("Risque Air=" + tempValue);
                        ListFromTable.remove(indexPosition);
                        if (((Pesticideapp)Iphy).getTraitement().equals("incorpor\u00e9")) {
                            ListFromTable.add(indexPosition, "Note Position=1");
                        } else if (((Pesticideapp)Iphy).getTraitement().equals("en surface")) {
                            ListFromTable.add(indexPosition, "Note Position=" + 1.0 * CouvertureSol);
                        }
                        try {
                            SolTools2 = new SolMod();
                            LessivagePot = SolTools2.GetPotLessivage(IdCdt);
                            SolTools2 = null;
                        }
                        catch (NullPointerException ex) {
                            LessivagePot = 0.0;
                        }
                        ListFromTable.add("Pot Lessivage=" + LessivagePot);
                        this.ListDetails.add(LessivagePot);
                        if (LessivagePot == 0.99999 && Math.log(Aquatox) / Math.log(10.0) < 2.0 + LogDJA) {
                            LogDJA = Math.log(Aquatox) / Math.log(10.0) - 2.0;
                            ListFromTable.remove(indexLogDJA);
                            ListFromTable.add("Log DJA=" + LogDJA);
                        }
                        ListFromTable.remove(indexPosition);
                        if (((Pesticideapp)Iphy).getTraitement().equals("incorpor\u00e9")) {
                            ListFromTable.add(indexPosition, "Note Position=0");
                        } else {
                            ListFromTable.add(indexPosition, "Note Position=" + 1.0 * CouvertureSol);
                        }
                        PEPTemp = this.Infere(ListFromTable, "R\u00e8gles Profondeur");
                        ListFromTable.add("Risque Eaux Profondeur=" + PEPTemp);
                        IndexRisquePEP = ListFromTable.indexOf("Risque Eaux Profondeur=" + PEPTemp);
                        if (((Pesticideapp)Iphy).getTraitement().equals("incorpor\u00e9")) {
                            ListFromTable.remove(indexPosition);
                            ListFromTable.add(indexPosition, "Note Position=1");
                        }
                        ListFromTable.add("Pot Ruissellement=" + Potruissellement);
                        this.ListDetails.add(Potruissellement);
                        ListFromTable.add("Pot D\u00e9rive=" + PotDerive);
                        this.ListDetails.add(PotDerive);
                        PESTemp = this.Infere(ListFromTable, "R\u00e8gles Surface");
                        ListFromTable.add("Risque Eaux Surface=" + PESTemp);
                        IndexRisquePES = ListFromTable.indexOf("Risque Eaux Surface=" + PESTemp);
                        if (LessivagePot == 0.99999) {
                            ListFromTable.remove(IndexRisquePEP);
                            ListFromTable.add(IndexRisquePEP, "Risque Eaux Profondeur=" + (PEPTemp /= 2.0));
                        }
                        if (LessivagePot == 0.99999 && PEPTemp > PESTemp) {
                            PESTemp = PEPTemp;
                            ListFromTable.remove(IndexRisquePES);
                            ListFromTable.add(IndexRisquePES, "Risque Eaux Surface=" + PESTemp);
                        }
                        CoefSurf = ((Pesticideapp)Iphy).getTotalepartielle() / 100;
                        RisquePEPtemp = this.Infere(ListFromTable, "r\u00e8gles Risque P+EP");
                        if ((RisquePEPtemp = Double.valueOf(10.0 * (1.0 - RisquePEPtemp * (CoefSurf *= ((Pesticideapp)Iphy).getFrequencedintervention().doubleValue())))) < Ipestmin_eso || !SecondPassage) {
                            Ipestmin_eso = RisquePEPtemp;
                        }
                        RisquePEStemp = this.Infere(ListFromTable, "r\u00e8gles Risque P+ES");
                        if ((RisquePEStemp = Double.valueOf(10.0 * (1.0 - RisquePEStemp * CoefSurf))) < Ipestmin_esu || !SecondPassage) {
                            Ipestmin_esu = RisquePEStemp;
                        }
                        RisquePairtemp = this.Infere(ListFromTable, "r\u00e8gles Risque P+Air");
                        if ((RisquePairtemp = Double.valueOf(10.0 * (1.0 - RisquePairtemp * CoefSurf))) < Ipestmin_air || !SecondPassage) {
                            Ipestmin_air = RisquePairtemp;
                        }
                        SecondPassage = true;
                        Ipest_eso = (10.0 - RisquePEPtemp) / 10.0;
                        k_eso = 1.7175 * Math.pow(2.718, -0.2913 * RisquePEPtemp);
                        kmin_eso = 1.7175 * Math.pow(2.718, -0.2913 * Ipestmin_eso);
                        Ipestk_eso += k_eso * Ipest_eso;
                        Ipest_esu = (10.0 - RisquePEStemp) / 10.0;
                        k_esu = 1.7175 * Math.pow(2.718, -0.2913 * RisquePEStemp);
                        kmin_esu = 1.7175 * Math.pow(2.718, -0.2913 * Ipestmin_esu);
                        Ipestk_esu += k_esu * Ipest_esu;
                        Ipest_air = (10.0 - RisquePairtemp) / 10.0;
                        k_air = 1.7175 * Math.pow(2.718, -0.2913 * RisquePairtemp);
                        kmin_air = 1.7175 * Math.pow(2.718, -0.2913 * Ipestmin_air);
                        Ipestk_air += k_air * Ipest_air;
                        this.ListDetails.add(RisquePEPtemp);
                        this.ListDetails.add(RisquePEStemp);
                        this.ListDetails.add(RisquePairtemp);
                        this.RisquePEP = Ipestmin_eso - Ipestk_eso + kmin_eso * (10.0 - Ipestmin_eso) / 10.0;
                        try {
                            this.RisquePEP = Tools.FormatMyDouble(this.RisquePEP);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(RisqueIphyMod.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.RisquePES = Ipestmin_esu - Ipestk_esu + kmin_esu * (10.0 - Ipestmin_esu) / 10.0;
                        try {
                            this.RisquePES = Tools.FormatMyDouble(this.RisquePES);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(RisqueIphyMod.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.RisquePAir = Ipestmin_air - Ipestk_air + kmin_air * (10.0 - Ipestmin_air) / 10.0;
                        try {
                            this.RisquePAir = Tools.FormatMyDouble(this.RisquePAir);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(RisqueIphyMod.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.ListDetails.add(CouvertureSol);
                        this.ListDetails.add(IdProduit);
                        ListFromTable.clear();
                    }
                }
            }
            if (T.getIntermediatecrop() == null || T.getIntermediatecrop().getHerbicideintercropappCollection() == null) continue;
            IphyInterCropAppView.clear();
            IphyInterCropAppView.addAll(T.getIntermediatecrop().getHerbicideintercropappCollection());
            for (Serializable Iphy : IphyInterCropAppView) {
                ++countOperation;
                try {
                    IdProduit = ((Herbicideintercropapp)Iphy).getIdpest().getIdpest();
                }
                catch (NullPointerException ex) {
                    IphyM = new IphyMod();
                    IdProduit = IphyM.GetIdPestByName(((Herbicideintercropapp)Iphy).getNompesticide());
                }
                try {
                    CalcModule = new IntermediateCalc();
                    CouvertureSol = CalcModule.GetCouvertureSol(IdCdt, ((Herbicideintercropapp)Iphy).getJour(), ((Herbicideintercropapp)Iphy).getMois(), true);
                    this.MsgOption = CalcModule.MsgOption;
                    CalcModule = null;
                }
                catch (NullPointerException ex) {
                    CouvertureSol = 0.0;
                }
                entityManager.refresh(entityManager.find(Pesticides.class, (Object)IdProduit));
                DetailIphyView.clear();
                DetailIphyView.addAll(((Pesticides)entityManager.find(Pesticides.class, (Object)IdProduit)).getDetailpesticidesCollection());
                if (DetailIphyView == null) continue;
                for (Detailpesticides D : DetailIphyView) {
                    try {
                        MatiereActive = D.getNamematact().isEmpty() ? D.getNamematact() : D.getActivematter().getName();
                    }
                    catch (NullPointerException ex) {
                        tool = new LasyTools();
                        tool.SetReport("Nom de la mati\u00e8re active introuvable pour la conduite " + ((Conduites)entityManager.find(Conduites.class, (Object)IdCdt)).getNomcdt(), 3);
                        System.out.println("Nom de la mati\u00e8re active introuvable pour la conduite " + ((Conduites)entityManager.find(Conduites.class, (Object)IdCdt)).getNomcdt());
                        MatiereActive = "";
                    }
                    ListFromTable.add(MatiereActive);
                    this.ListDetails.add(MatiereActive);
                    try {
                        DT50 = D.getActivematter().getDt50();
                        if (DT50.isInfinite()) {
                            DT50 = 0.0;
                        }
                    }
                    catch (NullPointerException ex) {
                        DT50 = 0.0;
                    }
                    ListFromTable.add("DT50=" + DT50);
                    try {
                        double Koc = 0.0;
                        try {
                            Koc = D.getActivematter().getKoc();
                        }
                        catch (NullPointerException ex) {
                            Koc = 0.0;
                        }
                        Gus = Math.log(DT50) / Math.log(10.0) * (4.0 - Math.log(Koc) / Math.log(10.0));
                        if (Gus.isInfinite()) {
                            Gus = 0.0;
                        }
                    }
                    catch (NullPointerException ex) {
                        Gus = 0.0;
                    }
                    ListFromTable.add("Gus=" + Gus);
                    try {
                        LogDJA = Math.log(D.getActivematter().getDja()) / Math.log(10.0);
                        if (LogDJA.isInfinite()) {
                            LogDJA = 0.0;
                        }
                    }
                    catch (NullPointerException ex) {
                        LogDJA = 0.0;
                    }
                    ListFromTable.add("Log DJA=" + LogDJA);
                    indexLogDJA = ListFromTable.indexOf("Log DJA=" + LogDJA);
                    try {
                        LogDose = Math.log(((Herbicideintercropapp)Iphy).getDose() * D.getDosage()) / Math.log(10.0);
                        if (LogDose.isInfinite()) {
                            LogDose = 0.0;
                        }
                    }
                    catch (NullPointerException ex) {
                        LogDose = 0.0;
                    }
                    ListFromTable.add("Log Dose=" + LogDose);
                    try {
                        LogKH = Math.log(D.getActivematter().getKh()) / Math.log(10.0);
                        if (LogKH.isInfinite()) {
                            LogKH = 0.0;
                        }
                    }
                    catch (NullPointerException ex) {
                        LogKH = 0.0;
                    }
                    ListFromTable.add("Log KH=" + LogKH);
                    try {
                        Aquatox = D.getActivematter().getAquatox();
                    }
                    catch (NullPointerException ex) {
                        Aquatox = 0.0;
                    }
                    if (Math.log(Aquatox) / Math.log(10.0) < 2.0 + LogDJA) {
                        LogAquatox = Math.log(Aquatox) / Math.log(10.0);
                        if (LogAquatox.isInfinite()) {
                            LogAquatox = 0.0;
                        }
                    } else {
                        LogAquatox = LogDJA + 2.0;
                    }
                    ListFromTable.add("Log Aquatox=" + LogAquatox);
                    tempValue = this.Infere(ListFromTable, "R\u00e8gles Pr\u00e9sence");
                    ListFromTable.add("Pr\u00e9sence=" + tempValue);
                    try {
                        if (((Herbicideintercropapp)Iphy).getTraitement().equals("en surface")) {
                            ListFromTable.add("Note Position=0");
                            indexPosition = ListFromTable.indexOf("Note Position=0");
                        } else {
                            ListFromTable.add("Note Position=1");
                            indexPosition = ListFromTable.indexOf("Note Position=1");
                        }
                    }
                    catch (NullPointerException ex) {
                        ListFromTable.add("Note Position=1");
                        indexPosition = ListFromTable.indexOf("Note Position=1");
                        System.out.println("Pas de traitement de surface d\u00e9fini pour la conduite " + ((Conduites)entityManager.find(Conduites.class, (Object)IdCdt)).getNomcdt());
                        this.MsgOption = 2;
                    }
                    tempValue = this.Infere(ListFromTable, "R\u00e8gles Volatilisation");
                    ListFromTable.add("Risque Air=" + tempValue);
                    ListFromTable.remove(indexPosition);
                    if (((Herbicideintercropapp)Iphy).getTraitement().equals("incorpor\u00e9")) {
                        ListFromTable.add(indexPosition, "Note Position=1");
                    } else if (((Herbicideintercropapp)Iphy).getTraitement().equals("en surface")) {
                        ListFromTable.add(indexPosition, "Note Position=" + 1.0 * CouvertureSol);
                    }
                    try {
                        SolTools2 = new SolMod();
                        LessivagePot = SolTools2.GetPotLessivage(IdCdt);
                        SolTools2 = null;
                    }
                    catch (NullPointerException ex) {
                        LessivagePot = 0.0;
                    }
                    ListFromTable.add("Pot Lessivage=" + LessivagePot);
                    this.ListDetails.add(LessivagePot);
                    if (LessivagePot == 0.99999 && Math.log(Aquatox) / Math.log(10.0) < 2.0 + LogDJA) {
                        LogDJA = Math.log(Aquatox) / Math.log(10.0) - 2.0;
                        ListFromTable.remove(indexLogDJA);
                        ListFromTable.add("Log DJA=" + LogDJA);
                    }
                    ListFromTable.remove(indexPosition);
                    if (((Herbicideintercropapp)Iphy).getTraitement().equals("incorpor\u00e9")) {
                        ListFromTable.add(indexPosition, "Note Position=0");
                    } else {
                        ListFromTable.add(indexPosition, "Note Position=" + 1.0 * CouvertureSol);
                    }
                    PEPTemp = this.Infere(ListFromTable, "R\u00e8gles Profondeur");
                    ListFromTable.add("Risque Eaux Profondeur=" + PEPTemp);
                    IndexRisquePEP = ListFromTable.indexOf("Risque Eaux Profondeur=" + PEPTemp);
                    if (((Herbicideintercropapp)Iphy).getTraitement().equals("incorpor\u00e9")) {
                        ListFromTable.remove(indexPosition);
                        ListFromTable.add(indexPosition, "Note Position=1");
                    }
                    ListFromTable.add("Pot Ruissellement=" + Potruissellement);
                    this.ListDetails.add(Potruissellement);
                    ListFromTable.add("Pot D\u00e9rive=" + PotDerive);
                    this.ListDetails.add(PotDerive);
                    PESTemp = this.Infere(ListFromTable, "R\u00e8gles Surface");
                    ListFromTable.add("Risque Eaux Surface=" + PESTemp);
                    IndexRisquePES = ListFromTable.indexOf("Risque Eaux Surface=" + PESTemp);
                    if (LessivagePot == 0.99999) {
                        ListFromTable.remove(IndexRisquePEP);
                        ListFromTable.add(IndexRisquePEP, "Risque Eaux Profondeur=" + (PEPTemp /= 2.0));
                    }
                    if (LessivagePot == 0.99999 && PEPTemp > PESTemp) {
                        PESTemp = PEPTemp;
                        ListFromTable.remove(IndexRisquePES);
                        ListFromTable.add(IndexRisquePES, "Risque Eaux Surface=" + PESTemp);
                    }
                    CoefSurf = ((Herbicideintercropapp)Iphy).getTotalepartielle() / 100;
                    RisquePEPtemp = this.Infere(ListFromTable, "r\u00e8gles Risque P+EP");
                    if ((RisquePEPtemp = Double.valueOf(10.0 * (1.0 - RisquePEPtemp * (CoefSurf *= ((Herbicideintercropapp)Iphy).getFrequencedintervention().doubleValue())))) < Ipestmin_eso || !SecondPassage) {
                        Ipestmin_eso = RisquePEPtemp;
                    }
                    RisquePEStemp = this.Infere(ListFromTable, "r\u00e8gles Risque P+ES");
                    if ((RisquePEStemp = Double.valueOf(10.0 * (1.0 - RisquePEStemp * CoefSurf))) < Ipestmin_esu || !SecondPassage) {
                        Ipestmin_esu = RisquePEStemp;
                    }
                    RisquePairtemp = this.Infere(ListFromTable, "r\u00e8gles Risque P+Air");
                    if ((RisquePairtemp = Double.valueOf(10.0 * (1.0 - RisquePairtemp * CoefSurf))) < Ipestmin_air || !SecondPassage) {
                        Ipestmin_air = RisquePairtemp;
                    }
                    SecondPassage = true;
                    Ipest_eso = (10.0 - RisquePEPtemp) / 10.0;
                    k_eso = 1.7175 * Math.pow(2.718, -0.2913 * RisquePEPtemp);
                    kmin_eso = 1.7175 * Math.pow(2.718, -0.2913 * Ipestmin_eso);
                    Ipestk_eso += k_eso * Ipest_eso;
                    Ipest_esu = (10.0 - RisquePEStemp) / 10.0;
                    k_esu = 1.7175 * Math.pow(2.718, -0.2913 * RisquePEStemp);
                    kmin_esu = 1.7175 * Math.pow(2.718, -0.2913 * Ipestmin_esu);
                    Ipestk_esu += k_esu * Ipest_esu;
                    Ipest_air = (10.0 - RisquePairtemp) / 10.0;
                    k_air = 1.7175 * Math.pow(2.718, -0.2913 * RisquePairtemp);
                    kmin_air = 1.7175 * Math.pow(2.718, -0.2913 * Ipestmin_air);
                    Ipestk_air += k_air * Ipest_air;
                    this.ListDetails.add(RisquePEPtemp);
                    this.ListDetails.add(RisquePEStemp);
                    this.ListDetails.add(RisquePairtemp);
                    this.RisquePEP = Ipestmin_eso - Ipestk_eso + kmin_eso * (10.0 - Ipestmin_eso) / 10.0;
                    try {
                        this.RisquePEP = Tools.FormatMyDouble(this.RisquePEP);
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(RisqueIphyMod.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.RisquePES = Ipestmin_esu - Ipestk_esu + kmin_esu * (10.0 - Ipestmin_esu) / 10.0;
                    try {
                        this.RisquePES = Tools.FormatMyDouble(this.RisquePES);
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(RisqueIphyMod.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.RisquePAir = Ipestmin_air - Ipestk_air + kmin_air * (10.0 - Ipestmin_air) / 10.0;
                    try {
                        this.RisquePAir = Tools.FormatMyDouble(this.RisquePAir);
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(RisqueIphyMod.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.ListDetails.add(CouvertureSol);
                    this.ListDetails.add(IdProduit);
                    ListFromTable.clear();
                }
            }
        }
        MatAct.AddNewResultatIphy(IdCdt, this.ListDetails);
        if (this.RisquePEP < 0.0) {
            this.RisquePEP = 0.0;
        }
        if (this.RisquePEP > 10.0) {
            this.RisquePEP = 10.0;
        }
        if (this.RisquePES < 0.0) {
            this.RisquePES = 0.0;
        }
        if (this.RisquePES > 10.0) {
            this.RisquePES = 10.0;
        }
        if (this.RisquePAir < 0.0) {
            this.RisquePAir = 0.0;
        }
        if (this.RisquePAir > 10.0) {
            this.RisquePAir = 10.0;
        }
        if (countOperation == 0 && this.MsgOption != 200 && this.MsgOption != 201) {
            this.MsgOption = 1;
        }
        Tools = null;
        entityManager.clear();
        entityManager.close();
    }

    private double Infere(List ValuesFromTable, String Rules) {
        EntityManager entityManager = this.emf.createEntityManager();
        LasyTools Tool = new LasyTools();
        ArrayList ListVariables = new ArrayList();
        double Tmin = 0.0;
        String Pr\u00e9misses = "";
        double result = 0.0;
        double S = 0.0;
        boolean Id2 = false;
        if (ValuesFromTable != null) {
            if (Rules.contains("R\u00e8gles Pr\u00e9sence")) {
                List RulesView = entityManager.createQuery("SELECT a FROM Attendrules a").getResultList();
                for (Attendrules R : RulesView) {
                    Tmin = this.SetCondition(ValuesFromTable, R.getConditions());
                    S += (double)R.getWeight().intValue() * Tmin;
                    result += R.getValeurcl() * (double)R.getWeight().intValue() * Tmin;
                }
            } else if (Rules.contains("R\u00e8gles Volatilisation")) {
                List RulesView = entityManager.createQuery("SELECT v FROM Volatrules v").getResultList();
                for (Volatrules R : RulesView) {
                    Tmin = this.SetCondition(ValuesFromTable, R.getConditions());
                    S += (double)R.getWeight().intValue() * Tmin;
                    result += R.getValeurcl() * (double)R.getWeight().intValue() * Tmin;
                }
            } else if (Rules.contains("R\u00e8gles Profondeur")) {
                List RulesView = entityManager.createQuery("SELECT d FROM Depthrules d").getResultList();
                for (Depthrules R : RulesView) {
                    Tmin = this.SetCondition(ValuesFromTable, R.getConditions());
                    S += (double)R.getWeight().intValue() * Tmin;
                    result += R.getValeurcl() * (double)R.getWeight().intValue() * Tmin;
                }
            } else if (Rules.contains("R\u00e8gles Surface")) {
                List RulesView = entityManager.createQuery("SELECT s FROM Surfacerules s").getResultList();
                for (Surfacerules R : RulesView) {
                    Tmin = this.SetCondition(ValuesFromTable, R.getConditions());
                    S += (double)R.getWeight().intValue() * Tmin;
                    result += R.getValeurcl() * (double)R.getWeight().intValue() * Tmin;
                }
            } else if (Rules.contains("r\u00e8gles Risque P+Air")) {
                List RulesView = entityManager.createQuery("SELECT r FROM Riskpairrules r").getResultList();
                for (Riskpairrules R : RulesView) {
                    Tmin = this.SetCondition(ValuesFromTable, R.getConditions());
                    S += (double)R.getWeight().intValue() * Tmin;
                    result += R.getValeurcl() * (double)R.getWeight().intValue() * Tmin;
                }
            } else if (Rules.contains("r\u00e8gles Risque P+EP")) {
                List RulesView = entityManager.createQuery("SELECT r FROM Riskpeprules r").getResultList();
                for (Riskpeprules R : RulesView) {
                    Tmin = this.SetCondition(ValuesFromTable, R.getConditions());
                    S += (double)R.getWeight().intValue() * Tmin;
                    result += R.getValeurcl() * (double)R.getWeight().intValue() * Tmin;
                }
            } else if (Rules.contains("r\u00e8gles Risque P+ES")) {
                List RulesView = entityManager.createQuery("SELECT r FROM Riskpesrules r").getResultList();
                for (Riskpesrules R : RulesView) {
                    Tmin = this.SetCondition(ValuesFromTable, R.getConditions());
                    S += (double)R.getWeight().intValue() * Tmin;
                    result += R.getValeurcl() * (double)R.getWeight().intValue() * Tmin;
                }
            }
        }
        result = S > 0.0 ? (result /= S) : 0.0;
        entityManager.clear();
        entityManager.close();
        return result;
    }

    private double SetCondition(List Data, String Rules) {
        double Tmin = 1.0;
        double aux = 0.0;
        double pt01 = 0.0;
        double pt11 = 0.0;
        double pt12 = 0.0;
        double pt02 = 0.0;
        double X = 0.0;
        int flag = 0;
        int CutPosition = 0;
        String MyStr = "";
        String NomVar = "";
        String SousEnsFlou = "";
        String XStr = "";
        EntityManager entityManager = this.emf.createEntityManager();
        LasyTools Tool = new LasyTools();
        MyStr = Rules;
        while (MyStr.contains("]")) {
            flag = MyStr.indexOf("[") + 1;
            NomVar = MyStr.substring(flag);
            flag = NomVar.indexOf("]");
            SousEnsFlou = NomVar.substring(flag + 2, flag + 3);
            SousEnsFlou = SousEnsFlou.trim();
            NomVar = NomVar.substring(0, flag);
            NomVar = NomVar.trim();
            CutPosition = MyStr.indexOf("]") + 3;
            MyStr = MyStr.substring(CutPosition);
            List SousEnsFlouView = entityManager.createQuery("SELECT s FROM Sousensflous s WHERE s.nomvariable = '" + NomVar + "' AND  s.sousens = '" + SousEnsFlou + "'").getResultList();
            for (Sousensflous Flou : SousEnsFlouView) {
                pt01 = Flou.getPt01();
                pt11 = Flou.getPt11();
                pt12 = Flou.getPt12();
                pt02 = Flou.getPt02();
                for (Object O : Data) {
                    String Str = O.toString();
                    try {
                        Str = Str.substring(0, Str.indexOf("="));
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (!Str.contains(NomVar) || Str.contains("Infinity")) continue;
                    XStr = O.toString();
                    if (!XStr.contains("Infinity")) {
                        XStr = XStr.substring(XStr.indexOf("=") + 1);
                        continue;
                    }
                    XStr = "0";
                }
                try {
                    X = Tool.SetAsABigdouble(XStr);
                }
                catch (ParseException ex) {
                    Logger.getLogger(RisqueIphyMod.class.getName()).log(Level.SEVERE, null, ex);
                    X = 0.0;
                }
                if (Flou.getTypepente().equals("droite")) {
                    aux = this.MuTrap(pt01, pt11, pt12, pt02, X);
                }
                if (Flou.getTypepente().equals("sinus")) {
                    aux = this.MuSin(pt01, pt11, pt12, pt02, X);
                }
                if (Tmin > aux) {
                    Tmin = aux;
                }
                XStr = "";
            }
        }
        entityManager.clear();
        entityManager.close();
        return Tmin;
    }

    private double MuSin(double pt01, double pt11, double pt12, double pt02, double X) {
        double m = 0.0;
        m = X < pt01 ? 0.0 : (X < pt11 && pt11 != pt01 ? 0.5 + 0.5 * Math.sin(Math.PI * ((X - pt01) / (pt11 - pt01) - 0.5)) : (X <= pt12 ? 1.0 : (X < pt02 && pt12 != pt02 ? 0.5 + 0.5 * Math.cos(Math.PI * (X - pt12) / (pt02 - pt12)) : 0.0)));
        return m;
    }

    private double MuTrap(double pt01, double pt11, double pt12, double pt02, double X) {
        double m = 0.0;
        m = X < pt01 ? 0.0 : (X < pt11 && pt11 != pt01 ? (X - pt01) / (pt11 - pt01) : (X <= pt12 ? 1.0 : (X < pt02 && pt12 != pt02 ? (X - pt02) / (pt12 - pt02) : 0.0)));
        return m;
    }
}

