/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Sens;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class SensPanel
extends JPanel {
    private EntityManager entityManager;
    private JComboBox jComboBoxSens;
    private JLabel jLabel1;
    private JLabel jLabelStationMenuTitle;
    private JSeparator jSeparator1;
    private List<Sens> list;
    private JScrollPane masterScrollPane;
    private JTable masterTable;
    private Query query;
    private JButton saveButton;
    private JLabel sensLabel;
    private BindingGroup bindingGroup;

    public SensPanel() {
        this.initComponents();
        if (!Beans.isDesignTime()) {
            this.entityManager.getTransaction().begin();
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT s FROM Sens s");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.sensLabel = new JLabel();
        this.saveButton = new JButton();
        this.jComboBoxSens = new JComboBox();
        this.jLabelStationMenuTitle = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        FormListener formListener = new FormListener();
        this.setBackground(new Color(51, 51, 51));
        this.setMaximumSize(new Dimension(748, 420));
        this.masterTable.setFont(new Font("Arial", 0, 12));
        this.masterTable.setCursor(new Cursor(12));
        this.masterTable.setSelectionMode(0);
        this.masterTable.getTableHeader().setResizingAllowed(false);
        JTableBinding<Sens, List<Sens>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idsens}"));
        columnBinding.setColumnName("Idsens");
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${battance}"));
        columnBinding.setColumnName(bundle.getString("BATTANCE"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${pente}"));
        columnBinding.setColumnName(bundle.getString("PENTE"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${erodabilitymin}"));
        columnBinding.setColumnName("minimum");
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${erodabilitymax}"));
        columnBinding.setColumnName("maximum");
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${precipitation}"));
        columnBinding.setColumnName(bundle.getString("PRECIPITATION"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${sens}"));
        columnBinding.setColumnName(bundle.getString("SENS"));
        columnBinding.setColumnClass(Integer.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTable.addMouseListener(formListener);
        this.masterScrollPane.setViewportView(this.masterTable);
        this.masterTable.getColumnModel().getColumn(0).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(0).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(0).setMaxWidth(1);
        this.masterTable.getColumnModel().getColumn(1).setMinWidth(82);
        this.masterTable.getColumnModel().getColumn(1).setPreferredWidth(82);
        this.masterTable.getColumnModel().getColumn(1).setMaxWidth(82);
        this.masterTable.getColumnModel().getColumn(2).setMinWidth(100);
        this.masterTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.masterTable.getColumnModel().getColumn(2).setMaxWidth(100);
        this.masterTable.getColumnModel().getColumn(3).setMinWidth(84);
        this.masterTable.getColumnModel().getColumn(3).setPreferredWidth(84);
        this.masterTable.getColumnModel().getColumn(3).setMaxWidth(84);
        this.masterTable.getColumnModel().getColumn(4).setMinWidth(87);
        this.masterTable.getColumnModel().getColumn(4).setPreferredWidth(87);
        this.masterTable.getColumnModel().getColumn(4).setMaxWidth(87);
        this.masterTable.getColumnModel().getColumn(5).setMinWidth(112);
        this.masterTable.getColumnModel().getColumn(5).setPreferredWidth(112);
        this.masterTable.getColumnModel().getColumn(5).setMaxWidth(112);
        this.masterTable.getColumnModel().getColumn(6).setMinWidth(60);
        this.masterTable.getColumnModel().getColumn(6).setPreferredWidth(60);
        this.masterTable.getColumnModel().getColumn(6).setMaxWidth(60);
        this.sensLabel.setFont(new Font("Arial", 0, 12));
        this.sensLabel.setForeground(new Color(255, 254, 255));
        this.sensLabel.setText(bundle.getString("SENS:"));
        this.saveButton.setFont(new Font("Arial", 1, 12));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/btn rect chrome.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.addMouseListener(formListener);
        this.jComboBoxSens.setFont(new Font("Arial", 0, 12));
        this.jComboBoxSens.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jComboBoxSens.setName("jComboBoxSens");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.sens}"), this.jComboBoxSens, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement != null}"), this.jComboBoxSens, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.jLabelStationMenuTitle.setFont(new Font("Arial", 0, 13));
        this.jLabelStationMenuTitle.setForeground(new Color(255, 254, 255));
        this.jLabelStationMenuTitle.setHorizontalAlignment(0);
        this.jLabelStationMenuTitle.setText(bundle.getString("SENS"));
        this.jLabelStationMenuTitle.setName("jLabelStationMenuTitle");
        this.jLabel1.setFont(new Font("Arial", 0, 10));
        this.jLabel1.setForeground(new Color(255, 254, 255));
        this.jLabel1.setText(bundle.getString("ERODIBILIT\u00c9 "));
        this.jLabel1.setName("jLabel1");
        this.jSeparator1.setName("jSeparator1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.masterScrollPane, -1, 546, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.sensLabel).addGap(28, 28, 28).addComponent(this.jComboBoxSens, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 333, Short.MAX_VALUE).addComponent(this.saveButton, -2, 120, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSeparator1, -2, 147, -2).addGap(197, 197, 197)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(240, 240, 240))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelStationMenuTitle, -2, 328, -2).addGap(118, 118, 118)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(25, Short.MAX_VALUE).addComponent(this.jLabelStationMenuTitle, -2, 33, -2).addGap(18, 18, 18).addComponent(this.jLabel1).addGap(1, 1, 1).addComponent(this.jSeparator1, -2, -1, -2).addGap(1, 1, 1).addComponent(this.masterScrollPane, -2, 280, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sensLabel).addComponent(this.jComboBoxSens, -2, 25, -2).addComponent(this.saveButton, -2, 20, -2)).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void saveButtonMouseReleased(MouseEvent evt) {
        try {
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("MISE \u00c0 JOUR EFFECTU\u00c9E !"), ResourceBundle.getBundle("Interfaces/resources/ParametresExtBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
        }
        catch (RollbackException rex) {
            rex.printStackTrace();
            this.entityManager.getTransaction().begin();
            ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
            for (Sens s : this.list) {
                merged.add(this.entityManager.merge((Object)s));
            }
            this.list.clear();
            this.list.addAll(merged);
        }
    }

    private void masterTableMouseClicked(MouseEvent evt) {
        try {
            String Item = this.masterTable.getValueAt(this.masterTable.getSelectedRow(), 6).toString();
            this.jComboBoxSens.setSelectedItem(Item);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SensPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SensPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SensPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SensPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setContentPane(new SensPanel());
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private class FormListener
    implements MouseListener {
        FormListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == SensPanel.this.masterTable) {
                SensPanel.this.masterTableMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.getSource() == SensPanel.this.saveButton) {
                SensPanel.this.saveButtonMouseReleased(evt);
            }
        }
    }
}

