/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Ilot;
import DataBase.Parcelle;
import DataBase.Soil;
import Interfaces.IlotGestionForm;
import Interfaces.InterfacePrincipal;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modules.LasyTools;
import modules.MeteoMod;
import modules.ParcelleMod;
import modules.SolMod;
import org.apache.commons.lang.math.NumberUtils;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class ParcelleForm
extends JFrame {
    int SetIlot = 0;
    int IdSol = 0;
    int IdP = 0;
    int InterfaceNb = 0;
    boolean AddPlot = false;
    LasyTools Tool = new LasyTools();
    String NameInStock = "";
    Parcelle p = new Parcelle();
    private JButton CloseButton;
    JLabel ErodabilityLabel;
    JTextArea JTextAreaInfo;
    JTextField NbRotAnneeField;
    JLabel NbRotAnneeLabel;
    private JButton deleteButton;
    JLabel distancetoriverLabel;
    private EntityManager entityManager;
    JMenuItem exitMenuItem;
    JMenu fileMenu;
    JLabel gradientLabel;
    JComboBox jComboBoxErodability;
    JComboBox jComboBoxLargBHerbee;
    JComboBox jComboBoxListSol;
    JComboBox jComboBoxPente;
    JComboBox jComboDistToRiver;
    JDialog jDialogInfoShow;
    JLabel jLabelAnneeClim;
    JLabel jLabelParcelleTitle;
    JLabel jLabelSol;
    JPanel jPanelDialog;
    JPanel jPanelParcelle;
    JScrollPane jScrollPaneInfo;
    JLabel largeurbandeenherbeeLabel;
    private List<Parcelle> list;
    JScrollPane masterScrollPane;
    private JTable masterTable;
    JMenuBar menuBar;
    private JButton newButton;
    JTextField nomparcelleField;
    JLabel nomparcelleLabel;
    JMenuItem openMenuItem;
    private Query query;
    Query querySoil;
    private JButton saveButton;
    JMenuItem saveMenuItem;
    JTextField surfaceField;
    JLabel surfaceLabel;
    private BindingGroup bindingGroup;

    public ParcelleForm() {
        this.InitForm();
    }

    public ParcelleForm(int id, int interfaceNumb) {
        this.SetIlot = id;
        this.InterfaceNb = interfaceNumb;
        this.InitForm();
        this.SetFreese(false);
        this.SetIlotMenuStatut(false);
    }

    private void InitForm() {
        this.initComponents();
        if (!this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.InitListSoil();
        this.ShowWithIlotId();
        this.refresh();
        this.setLocation(this.Tool.CentreFrame(this));
        this.deleteButton.setEnabled(false);
        this.jLabelAnneeClim.setText("");
    }

    private void SetFreese(boolean Statut) {
        this.nomparcelleField.setEnabled(Statut);
        this.surfaceField.setEnabled(Statut);
        this.jComboBoxPente.setEnabled(Statut);
        this.jComboBoxListSol.setEnabled(Statut);
        this.jComboDistToRiver.setEnabled(Statut);
        this.jComboBoxLargBHerbee.setEnabled(Statut);
        this.NbRotAnneeField.setEnabled(Statut);
        this.jComboBoxErodability.setEnabled(Statut);
        this.saveButton.setEnabled(Statut);
        this.deleteButton.setEnabled(Statut);
    }

    private void SetIlotMenuStatut(boolean Statut) {
        boolean FrameSet = false;
        if (this.InterfaceNb == 1) {
            boolean MainFormDetected = false;
            for (Window Fr : InterfacePrincipal.getWindows()) {
                if (!Fr.getName().equals("MAINFORM")) continue;
                Fr.repaint();
                Fr.setVisible(true);
                MainFormDetected = true;
            }
            if (!MainFormDetected && Statut) {
                InterfacePrincipal Main = new InterfacePrincipal();
                Main.setVisible(true);
            }
        } else {
            boolean FormDetected = false;
            for (Window Fr : IlotGestionForm.getWindows()) {
                if (!Fr.getName().equals("ILOTFRAME") || FrameSet) continue;
                Fr.repaint();
                FrameSet = true;
                Fr.setVisible(Statut);
                FormDetected = true;
            }
            if (!FormDetected && Statut) {
                IlotGestionForm IlotGestion = new IlotGestionForm();
                IlotGestion.setVisible(true);
            }
        }
        this.setDefaultCloseOperation(2);
    }

    private void ShowWithIlotId() {
        boolean firstRun = false;
        String Sql = "";
        String SqlNext = "";
        if (this.SetIlot != 0) {
            Ilot i = (Ilot)this.entityManager.find(Ilot.class, (Object)this.SetIlot);
            this.entityManager.refresh((Object)i);
            List PList = this.query.getResultList();
            Collection<Parcelle> Ic = i.getParcelleCollection();
            PList.clear();
            PList.addAll(Ic);
            if (Ic.isEmpty()) {
                Sql = "SELECT p FROM Parcelle p WHERE p.idparcelle = 0";
                this.query = this.entityManager.createQuery(Sql);
            } else {
                for (Parcelle p : PList) {
                    if (!firstRun) {
                        Sql = "SELECT p FROM Parcelle p WHERE p.idparcelle = " + p.getIdparcelle();
                        firstRun = true;
                        continue;
                    }
                    SqlNext = " OR p.idparcelle = " + p.getIdparcelle();
                    Sql = Sql + SqlNext;
                }
                this.query = this.entityManager.createQuery(Sql);
            }
        }
    }

    private void InitListSoil() {
        List SoilDataView;
        if (!this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        if ((SoilDataView = this.querySoil.getResultList()) != null) {
            for (Soil SoilInfo : SoilDataView) {
                this.jComboBoxListSol.addItem(SoilInfo.getName());
            }
        }
    }

    public void DetectModeAnneeClimat(int IdStation) {
        MeteoMod MeteoFunction = new MeteoMod();
        List<Object> AnneeClimStList = new ArrayList();
        AnneeClimStList = MeteoFunction.GetAnneeClimatByIdStation(IdStation);
        String ModClimat = "";
        int AnneeRotation = 1;
        try {
            AnneeRotation = this.Tool.SetAsA_Int(this.NbRotAnneeField.getText().toString());
            if (AnneeRotation == 0) {
                AnneeRotation = 1;
            }
        }
        catch (NullPointerException rex) {
            AnneeRotation = 1;
        }
        catch (ParseException rex) {
            AnneeRotation = 1;
        }
        if (!AnneeClimStList.isEmpty()) {
            ModClimat = MeteoFunction.getLastAnneeClimatByIdStation(IdStation) + ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString(" SERA L'ANN\u00c9E CLIMATIQUE DE R\u00c9F\u00c9RENCE POUR TOUTE LA ROTATION");
        } else {
            LasyTools tool = new LasyTools();
            tool.SetReport(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("LA STATION S\u00c9LECTIONN\u00c9E NE COMPORTE PAS D'ANN\u00c9E CLIMATIQUE"), 3);
        }
        ModClimat = AnneeClimStList.size() == 1 ? AnneeClimStList.get(0).toString() : (AnneeClimStList.size() == AnneeRotation ? ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("SOIT UNE ANN\u00c9E CLIMATIQUE PAR CONDUITE") : (AnneeClimStList.size() / AnneeRotation == 2 ? ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("SOIT DEUX ANN\u00c9ES CLIMATIQUES PAR CONDUITE") : MeteoFunction.getLastAnneeClimatByIdStation(IdStation) + ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString(" SERA L'ANN\u00c9E CLIMATIQUE DE R\u00c9F\u00c9RENCE POUR TOUTE LA ROTATION")));
        if (!AnneeClimStList.isEmpty()) {
            this.jLabelAnneeClim.setText(ModClimat);
            this.jLabelAnneeClim.setForeground(Color.yellow);
        } else {
            this.jLabelAnneeClim.setText(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("LA STATION S\u00c9LECTIONN\u00c9E NE COMPORTE PAS D'ANN\u00c9E CLIMATIQUE"));
            this.jLabelAnneeClim.setForeground(Color.RED);
        }
    }

    private void refresh() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.entityManager.getTransaction().rollback();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void Update() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void afficheDialogInfoRight() {
        PointerInfo P = MouseInfo.getPointerInfo();
        Point Location2 = P.getLocation();
        this.jDialogInfoShow.setLocation(Location2.x + 50, Location2.y);
        this.jDialogInfoShow.pack();
        this.jDialogInfoShow.toFront();
        this.jDialogInfoShow.setVisible(true);
    }

    private void GetValues() {
        int row = this.masterTable.getSelectedRow();
        String a = "";
        String b = "";
        String c = "";
        String d = "";
        String e = "";
        String f = "";
        try {
            a = this.masterTable.getValueAt(row, 0).toString();
            this.p.setNomparcelle(a);
        }
        catch (NullPointerException rex) {
            a = "";
        }
        try {
            b = this.masterTable.getValueAt(row, 1).toString();
            this.p.setSurface(this.Tool.SetAsAdouble(b));
        }
        catch (ParseException ex) {
            Logger.getLogger(ParcelleForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException rex) {
            b = "";
        }
        try {
            c = this.masterTable.getValueAt(row, 2).toString();
            this.p.setGradient(c);
        }
        catch (NullPointerException rex) {
            c = "";
        }
        try {
            d = this.masterTable.getValueAt(row, 3).toString();
            this.masterTable.setValueAt(d, row, 3);
            this.p.setDistancetoriver(d);
        }
        catch (NullPointerException rex) {
            d = "";
        }
        try {
            e = this.masterTable.getValueAt(row, 4).toString();
            this.p.setLargeurbandeenherbee(e);
        }
        catch (NullPointerException rex) {
            e = "";
        }
        try {
            f = this.masterTable.getValueAt(row, 5).toString();
            this.p.setNbanneesrotation(this.Tool.SetAsA_Int(f));
        }
        catch (ParseException ex) {
            Logger.getLogger(ParcelleForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException rex) {
            f = "1";
            this.p.setNbanneesrotation(1);
        }
        try {
            f = this.masterTable.getValueAt(row, 9).toString();
            this.p.setErodabilite(this.Tool.SetAsA_Int(f));
        }
        catch (ParseException ex) {
            Logger.getLogger(ParcelleForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT p FROM Parcelle p");
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ParcelleForm.class);
        this.querySoil = Beans.isDesignTime() ? null : this.entityManager.createQuery(resourceMap.getString("querySoil.query", new Object[0]));
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.jDialogInfoShow = new JDialog();
        this.jPanelDialog = new JPanel();
        this.jScrollPaneInfo = new JScrollPane();
        this.JTextAreaInfo = new JTextArea();
        this.jPanelParcelle = new JPanel();
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.saveButton = new JButton();
        this.CloseButton = new JButton();
        this.jLabelParcelleTitle = new JLabel();
        this.largeurbandeenherbeeLabel = new JLabel();
        this.gradientLabel = new JLabel();
        this.distancetoriverLabel = new JLabel();
        this.nomparcelleLabel = new JLabel();
        this.surfaceLabel = new JLabel();
        this.surfaceField = new JTextField();
        this.nomparcelleField = new JTextField();
        this.jComboDistToRiver = new JComboBox();
        this.jComboBoxPente = new JComboBox();
        this.jLabelSol = new JLabel();
        this.jComboBoxLargBHerbee = new JComboBox();
        this.jComboBoxListSol = new JComboBox();
        this.NbRotAnneeLabel = new JLabel();
        this.NbRotAnneeField = new JTextField();
        this.ErodabilityLabel = new JLabel();
        this.jComboBoxErodability = new JComboBox();
        this.jLabelAnneeClim = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.jDialogInfoShow.setName("jDialogInfoShow");
        this.jDialogInfoShow.setResizable(false);
        this.jDialogInfoShow.setUndecorated(true);
        this.jPanelDialog.setName("jPanelDialog");
        this.jPanelDialog.setPreferredSize(new Dimension(226, 100));
        this.jScrollPaneInfo.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneInfo.setVerticalScrollBarPolicy(21);
        this.jScrollPaneInfo.setName("jScrollPaneInfo");
        this.JTextAreaInfo.setBackground(new Color(51, 51, 51));
        this.JTextAreaInfo.setColumns(20);
        this.JTextAreaInfo.setEditable(false);
        this.JTextAreaInfo.setForeground(new Color(102, 255, 51));
        this.JTextAreaInfo.setLineWrap(true);
        this.JTextAreaInfo.setRows(5);
        this.JTextAreaInfo.setWrapStyleWord(true);
        this.JTextAreaInfo.setBorder(null);
        this.JTextAreaInfo.setName("JTextAreaInfo");
        this.jScrollPaneInfo.setViewportView(this.JTextAreaInfo);
        GroupLayout jPanelDialogLayout = new GroupLayout(this.jPanelDialog);
        this.jPanelDialog.setLayout(jPanelDialogLayout);
        jPanelDialogLayout.setHorizontalGroup(jPanelDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelDialogLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jScrollPaneInfo, -1, 216, Short.MAX_VALUE).addGap(10, 10, 10)));
        jPanelDialogLayout.setVerticalGroup(jPanelDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDialogLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jScrollPaneInfo, -2, 81, -2).addGap(5, 5, 5)));
        GroupLayout jDialogInfoShowLayout = new GroupLayout(this.jDialogInfoShow.getContentPane());
        this.jDialogInfoShow.getContentPane().setLayout(jDialogInfoShowLayout);
        jDialogInfoShowLayout.setHorizontalGroup(jDialogInfoShowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDialog, -2, 226, -2));
        jDialogInfoShowLayout.setVerticalGroup(jDialogInfoShowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDialog, -2, 89, -2));
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ParcelleForm.this.formWindowClosing(evt);
            }
        });
        this.jPanelParcelle.setBackground(new Color(51, 51, 51));
        this.jPanelParcelle.setName("jPanelParcelle");
        this.masterScrollPane.setName("masterScrollPane");
        this.masterTable.setBackground(new Color(255, 254, 255));
        this.masterTable.setFont(new Font("Arial", 0, 12));
        this.masterTable.setForeground(new Color(0, 1, 0));
        this.masterTable.setCursor(new Cursor(12));
        this.masterTable.setName("masterTable");
        this.masterTable.setSelectionBackground(new Color(204, 204, 204));
        this.masterTable.setSelectionForeground(new Color(0, 0, 0));
        this.masterTable.setSelectionMode(0);
        JTableBinding<Parcelle, List<Parcelle>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${nomparcelle}"));
        columnBinding.setColumnName(bundle.getString("PARCELLE"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${surface}"));
        columnBinding.setColumnName(bundle.getString("SURFACE (HA)"));
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${gradient}"));
        columnBinding.setColumnName(bundle.getString("PENTE_TXT"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${distancetoriver}"));
        columnBinding.setColumnName(bundle.getString("DISTANCE D'UN COURS D'EAU"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${largeurbandeenherbee}"));
        columnBinding.setColumnName(bundle.getString("LARGEUR DE LA BANDE ENHERB\u00c9E"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${nbanneesrotation}"));
        columnBinding.setColumnName(bundle.getString("ROTATION"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${soil.name}"));
        columnBinding.setColumnName(bundle.getString("SOL"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idsoil}"));
        columnBinding.setColumnName("idsol");
        columnBinding.setColumnClass(Soil.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idparcelle}"));
        columnBinding.setColumnName("idplot");
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${erodabilite}"));
        columnBinding.setColumnName(bundle.getString("ERODIBILIT\u00c9"));
        columnBinding.setColumnClass(Integer.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ParcelleForm.this.masterTableMouseClicked(evt);
            }
        });
        this.masterScrollPane.setViewportView(this.masterTable);
        this.masterTable.getColumnModel().getColumn(1).setMinWidth(77);
        this.masterTable.getColumnModel().getColumn(1).setPreferredWidth(77);
        this.masterTable.getColumnModel().getColumn(1).setMaxWidth(77);
        this.masterTable.getColumnModel().getColumn(2).setMinWidth(70);
        this.masterTable.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.masterTable.getColumnModel().getColumn(2).setMaxWidth(70);
        this.masterTable.getColumnModel().getColumn(3).setMinWidth(150);
        this.masterTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.masterTable.getColumnModel().getColumn(3).setMaxWidth(150);
        this.masterTable.getColumnModel().getColumn(4).setMinWidth(160);
        this.masterTable.getColumnModel().getColumn(4).setPreferredWidth(160);
        this.masterTable.getColumnModel().getColumn(4).setMaxWidth(160);
        this.masterTable.getColumnModel().getColumn(5).setMinWidth(60);
        this.masterTable.getColumnModel().getColumn(5).setPreferredWidth(60);
        this.masterTable.getColumnModel().getColumn(5).setMaxWidth(60);
        this.masterTable.getColumnModel().getColumn(7).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(7).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(7).setMaxWidth(1);
        this.masterTable.getColumnModel().getColumn(8).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(8).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(8).setMaxWidth(1);
        this.masterTable.getColumnModel().getColumn(9).setMinWidth(65);
        this.masterTable.getColumnModel().getColumn(9).setPreferredWidth(65);
        this.masterTable.getColumnModel().getColumn(9).setMaxWidth(65);
        this.newButton.setBackground(new Color(51, 51, 51));
        this.newButton.setFont(new Font("Arial", 1, 12));
        this.newButton.setForeground(new Color(0, 1, 0));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.newButton.setText(bundle.getString("AJOUTER"));
        this.newButton.setBorder(null);
        this.newButton.setBorderPainted(false);
        this.newButton.setContentAreaFilled(false);
        this.newButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.newButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.newButton.setFocusPainted(false);
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.setName("newButton");
        this.newButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParcelleForm.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setBackground(new Color(51, 51, 51));
        this.deleteButton.setFont(new Font("Arial", 1, 12));
        this.deleteButton.setForeground(new Color(0, 1, 0));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.deleteButton.setText(bundle.getString("SUPPRIMER"));
        this.deleteButton.setBorder(null);
        this.deleteButton.setBorderPainted(false);
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setFocusPainted(false);
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParcelleForm.this.deleteButtonActionPerformed(evt);
            }
        });
        this.saveButton.setBackground(new Color(51, 51, 51));
        this.saveButton.setFont(new Font("Arial", 1, 12));
        this.saveButton.setForeground(new Color(0, 1, 0));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setBorder(null);
        this.saveButton.setBorderPainted(false);
        this.saveButton.setContentAreaFilled(false);
        this.saveButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setFocusPainted(false);
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setName("saveButton");
        this.saveButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParcelleForm.this.saveButtonActionPerformed(evt);
            }
        });
        this.CloseButton.setBackground(new Color(51, 51, 51));
        this.CloseButton.setFont(new Font("Arial", 1, 12));
        this.CloseButton.setForeground(new Color(0, 1, 0));
        this.CloseButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.CloseButton.setText(bundle.getString("FERMER"));
        this.CloseButton.setBorder(null);
        this.CloseButton.setBorderPainted(false);
        this.CloseButton.setContentAreaFilled(false);
        this.CloseButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.CloseButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.CloseButton.setFocusPainted(false);
        this.CloseButton.setHorizontalTextPosition(0);
        this.CloseButton.setName("CloseButton");
        this.CloseButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ParcelleForm.this.CloseButtonMouseReleased(evt);
            }
        });
        this.jLabelParcelleTitle.setFont(new Font("Arial", 1, 14));
        this.jLabelParcelleTitle.setForeground(new Color(255, 254, 255));
        this.jLabelParcelleTitle.setHorizontalAlignment(0);
        this.jLabelParcelleTitle.setText(bundle.getString("GESTION DES PARCELLES"));
        this.jLabelParcelleTitle.setName("jLabelParcelleTitle");
        this.largeurbandeenherbeeLabel.setFont(new Font("Arial", 0, 12));
        this.largeurbandeenherbeeLabel.setForeground(new Color(255, 254, 255));
        this.largeurbandeenherbeeLabel.setText(bundle.getString("LARGEUR DE LA BANDE ENHERB\u00c9E:"));
        this.largeurbandeenherbeeLabel.setName("largeurbandeenherbeeLabel");
        this.gradientLabel.setFont(new Font("Arial", 0, 12));
        this.gradientLabel.setForeground(new Color(255, 254, 255));
        this.gradientLabel.setText(bundle.getString("PENTE:"));
        this.gradientLabel.setName("gradientLabel");
        this.distancetoriverLabel.setFont(new Font("Arial", 0, 12));
        this.distancetoriverLabel.setForeground(new Color(255, 254, 255));
        this.distancetoriverLabel.setText(bundle.getString("DISTANCE D'UN COURS D'EAU:"));
        this.distancetoriverLabel.setName("distancetoriverLabel");
        this.nomparcelleLabel.setFont(new Font("Arial", 0, 12));
        this.nomparcelleLabel.setForeground(new Color(255, 254, 255));
        this.nomparcelleLabel.setText(bundle.getString("NOM DE LA PARCELLE :"));
        this.nomparcelleLabel.setName("nomparcelleLabel");
        this.surfaceLabel.setFont(new Font("Arial", 0, 12));
        this.surfaceLabel.setForeground(new Color(255, 254, 255));
        this.surfaceLabel.setText(bundle.getString("SURFACE (HA):"));
        this.surfaceLabel.setName("surfaceLabel");
        this.surfaceField.setFont(new Font("Arial", 0, 12));
        this.surfaceField.setForeground(new Color(0, 1, 0));
        this.surfaceField.setName("surfaceField");
        this.surfaceField.setSelectionColor(new Color(102, 102, 102));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.surface}"), this.surfaceField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.surfaceField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ParcelleForm.this.surfaceFieldCaretUpdate(evt);
            }
        });
        this.surfaceField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ParcelleForm.this.surfaceFieldFocusLost(evt);
            }
        });
        this.nomparcelleField.setFont(new Font("Arial", 0, 12));
        this.nomparcelleField.setForeground(new Color(0, 1, 0));
        this.nomparcelleField.setName("nomparcelleField");
        this.nomparcelleField.setSelectionColor(new Color(102, 102, 102));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.nomparcelle}"), this.nomparcelleField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.nomparcelleField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ParcelleForm.this.nomparcelleFieldCaretUpdate(evt);
            }
        });
        this.jComboDistToRiver.setFont(new Font("Arial", 0, 12));
        this.jComboDistToRiver.setForeground(new Color(0, 1, 0));
        this.jComboDistToRiver.setModel(new DefaultComboBoxModel<String>(new String[]{"<3 m", "3-6 m", "6-12 m", ">12 m"}));
        this.jComboDistToRiver.setSelectedIndex(3);
        this.jComboDistToRiver.setName("jComboDistToRiver");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.distancetoriver}"), this.jComboDistToRiver, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboDistToRiver.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ParcelleForm.this.jComboDistToRiverPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jComboDistToRiver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParcelleForm.this.jComboDistToRiverActionPerformed(evt);
            }
        });
        this.jComboBoxPente.setFont(new Font("Arial", 0, 12));
        this.jComboBoxPente.setForeground(new Color(0, 1, 0));
        this.jComboBoxPente.setModel(new DefaultComboBoxModel<String>(new String[]{bundle.getString("PENTE1"), bundle.getString("PENTE2"), bundle.getString("PENTE3"), bundle.getString("PENTE4")}));
        this.jComboBoxPente.setName("jComboBoxPente");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.gradient}"), this.jComboBoxPente, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxPente.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ParcelleForm.this.jComboBoxPentePopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jComboBoxPente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParcelleForm.this.jComboBoxPenteActionPerformed(evt);
            }
        });
        this.jLabelSol.setFont(new Font("Arial", 0, 12));
        this.jLabelSol.setForeground(new Color(255, 254, 255));
        this.jLabelSol.setText(bundle.getString("SOL:") + "                         ");
        this.jLabelSol.setName("jLabelSol");
        this.jComboBoxLargBHerbee.setFont(new Font("Arial", 0, 12));
        this.jComboBoxLargBHerbee.setForeground(new Color(0, 1, 0));
        this.jComboBoxLargBHerbee.setModel(new DefaultComboBoxModel<String>(new String[]{bundle.getString("AUCUNE"), "0-6 m", "6-12 m", ">12 m"}));
        this.jComboBoxLargBHerbee.setName("jComboBoxLargBHerbee");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.largeurbandeenherbee}"), this.jComboBoxLargBHerbee, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxLargBHerbee.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ParcelleForm.this.jComboBoxLargBHerbeePopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jComboBoxListSol.setFont(new Font("Arial", 0, 12));
        this.jComboBoxListSol.setForeground(new Color(0, 1, 0));
        this.jComboBoxListSol.setModel(new DefaultComboBoxModel<String>(new String[]{bundle.getString("AUCUN SOL")}));
        this.jComboBoxListSol.setName("jComboBoxListSol");
        this.jComboBoxListSol.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ParcelleForm.this.jComboBoxListSolMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ParcelleForm.this.jComboBoxListSolMouseExited(evt);
            }
        });
        this.jComboBoxListSol.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ParcelleForm.this.jComboBoxListSolPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.NbRotAnneeLabel.setFont(new Font("Arial", 0, 12));
        this.NbRotAnneeLabel.setForeground(new Color(255, 254, 255));
        this.NbRotAnneeLabel.setText(bundle.getString("DUR\u00c9E DE LA ROTATION(ANN\u00c9E):"));
        this.NbRotAnneeLabel.setName("NbRotAnneeLabel");
        this.NbRotAnneeField.setFont(new Font("Arial", 0, 12));
        this.NbRotAnneeField.setForeground(new Color(0, 1, 0));
        this.NbRotAnneeField.setName("NbRotAnneeField");
        this.NbRotAnneeField.setSelectionColor(new Color(102, 102, 102));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.nbanneesrotation}"), this.NbRotAnneeField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.NbRotAnneeField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ParcelleForm.this.NbRotAnneeFieldCaretUpdate(evt);
            }
        });
        this.NbRotAnneeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ParcelleForm.this.NbRotAnneeFieldFocusLost(evt);
            }
        });
        this.NbRotAnneeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ParcelleForm.this.NbRotAnneeFieldKeyTyped(evt);
            }
        });
        this.ErodabilityLabel.setFont(new Font("Arial", 0, 12));
        this.ErodabilityLabel.setForeground(new Color(255, 254, 255));
        this.ErodabilityLabel.setText(bundle.getString("ERODIBILIT\u00c9\u00a0:"));
        this.ErodabilityLabel.setName("ErodabilityLabel");
        this.jComboBoxErodability.setFont(new Font("Arial", 0, 12));
        this.jComboBoxErodability.setForeground(new Color(0, 1, 0));
        this.jComboBoxErodability.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.jComboBoxErodability.setSelectedIndex(1);
        this.jComboBoxErodability.setName("jComboBoxErodability");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.erodabilite}"), this.jComboBoxErodability, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jComboBoxErodability.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ParcelleForm.this.jComboBoxErodabilityPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jLabelAnneeClim.setFont(new Font("Arial", 0, 11));
        this.jLabelAnneeClim.setForeground(new Color(255, 254, 255));
        this.jLabelAnneeClim.setText(bundle.getString("DUR\u00c9E DE LA ROTATION(ANN\u00c9E):"));
        this.jLabelAnneeClim.setName("jLabelAnneeClim");
        GroupLayout jPanelParcelleLayout = new GroupLayout(this.jPanelParcelle);
        this.jPanelParcelle.setLayout(jPanelParcelleLayout);
        jPanelParcelleLayout.setHorizontalGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelParcelleLayout.createSequentialGroup().addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelParcelleLayout.createSequentialGroup().addContainerGap().addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.masterScrollPane, GroupLayout.Alignment.LEADING, -1, 881, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanelParcelleLayout.createSequentialGroup().addComponent(this.newButton, -2, 116, -2).addGap(130, 130, 130).addComponent(this.deleteButton, -2, 116, -2).addGap(130, 130, 130).addComponent(this.saveButton, -2, 116, -2).addGap(130, 130, 130).addComponent(this.CloseButton, -2, 116, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanelParcelleLayout.createSequentialGroup().addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.NbRotAnneeLabel).addComponent(this.nomparcelleLabel).addComponent(this.surfaceLabel).addComponent(this.gradientLabel)).addGap(29, 29, 29).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxPente, -2, -1, -2).addGroup(jPanelParcelleLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nomparcelleField, -2, 177, -2).addComponent(this.surfaceField, -2, 74, -2))).addGroup(jPanelParcelleLayout.createSequentialGroup().addComponent(this.NbRotAnneeField, -2, 51, -2).addGap(4, 4, 4).addComponent(this.jLabelAnneeClim, -1, 338, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelParcelleLayout.createSequentialGroup().addComponent(this.ErodabilityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 143, Short.MAX_VALUE).addComponent(this.jComboBoxErodability, -2, 50, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanelParcelleLayout.createSequentialGroup().addComponent(this.jLabelSol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxListSol, 0, 153, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelParcelleLayout.createSequentialGroup().addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.largeurbandeenherbeeLabel).addComponent(this.distancetoriverLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboDistToRiver, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxLargBHerbee, 0, -1, Short.MAX_VALUE)))).addGap(44, 44, 44)))).addGroup(jPanelParcelleLayout.createSequentialGroup().addGap(285, 285, 285).addComponent(this.jLabelParcelleTitle, -2, 284, -2))).addContainerGap()));
        jPanelParcelleLayout.setVerticalGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelParcelleLayout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.jLabelParcelleTitle, -2, 33, -2).addGap(36, 36, 36).addComponent(this.masterScrollPane, -1, 179, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelParcelleLayout.createSequentialGroup().addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nomparcelleLabel).addComponent(this.nomparcelleField, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.surfaceLabel).addComponent(this.surfaceField, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gradientLabel).addComponent(this.jComboBoxPente, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.NbRotAnneeField, -2, 20, -2).addComponent(this.NbRotAnneeLabel).addComponent(this.jLabelAnneeClim))).addGroup(jPanelParcelleLayout.createSequentialGroup().addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxListSol, -2, 20, -2).addComponent(this.jLabelSol)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxErodability, -2, 20, -2).addComponent(this.ErodabilityLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboDistToRiver, -2, 20, -2).addComponent(this.distancetoriverLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.largeurbandeenherbeeLabel).addComponent(this.jComboBoxLargBHerbee, -2, 20, -2)))).addGap(18, 18, 18).addGroup(jPanelParcelleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton, -2, 42, -2).addComponent(this.CloseButton, -2, 42, -2).addComponent(this.saveButton, -2, 42, -2).addComponent(this.deleteButton, -2, 42, -2)).addContainerGap()));
        this.menuBar.setName("menuBar");
        this.fileMenu.setText(bundle.getString("DONN\u00c9ES"));
        this.fileMenu.setName("fileMenu");
        this.openMenuItem.setText(bundle.getString("AJOUTER"));
        this.openMenuItem.setName("openMenuItem");
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText(bundle.getString("ENREGISTRER"));
        this.saveMenuItem.setName("saveMenuItem");
        this.fileMenu.add(this.saveMenuItem);
        this.exitMenuItem.setText(bundle.getString("FERMER"));
        this.exitMenuItem.setName("exitMenuItem");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParcelleForm.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 905, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelParcelle, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 468, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelParcelle, -1, 468, Short.MAX_VALUE)));
        this.bindingGroup.bind();
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.SetIlotMenuStatut(true);
        this.dispose();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AJOUTER"))) {
            this.refresh();
            this.SetFreese(true);
            ParcelleMod PMod = new ParcelleMod();
            this.p = new Parcelle();
            try {
                this.IdP = PMod.getPlotIdDispo();
                this.p.setIdparcelle(this.IdP);
            }
            catch (ParseException ex) {
                Logger.getLogger(ParcelleForm.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.p.setIlot((Ilot)this.entityManager.find(Ilot.class, (Object)this.SetIlot));
            this.entityManager.merge((Object)this.p);
            this.list.add(this.p);
            int row = this.list.size() - 1;
            this.masterTable.setRowSelectionInterval(row, row);
            this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
            this.nomparcelleField.requestFocus();
            this.nomparcelleField.setText("");
            this.surfaceField.setText("");
            this.NbRotAnneeField.setText("1");
            this.jComboBoxErodability.setSelectedIndex(0);
            this.jComboDistToRiver.setSelectedIndex(3);
            this.jComboBoxLargBHerbee.setSelectedIndex(0);
            this.jComboBoxPente.setSelectedIndex(0);
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("ANNULER"));
            this.deleteButton.setEnabled(false);
            this.AddPlot = true;
        } else {
            this.refresh();
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AJOUTER"));
            this.refresh();
            this.SetFreese(false);
            this.AddPlot = false;
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.masterTable.getSelectedRow() != -1) {
            int choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("CONFIRMER_SUPPRESSION_PARCELLE"), ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("SUPPRESSION"), 2);
            if (choix == 0) {
                int[] selected = this.masterTable.getSelectedRows();
                ArrayList<Parcelle> toRemove = new ArrayList<Parcelle>(selected.length);
                for (int idx = 0; idx < selected.length; ++idx) {
                    Parcelle p = this.list.get(this.masterTable.convertRowIndexToModel(selected[idx]));
                    toRemove.add(p);
                    this.entityManager.remove((Object)p);
                }
                this.list.removeAll(toRemove);
                if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                    this.entityManager.getTransaction().begin();
                }
                this.Tool.SaveInCriterDB(this.entityManager);
                this.SetFreese(false);
                this.IdP = 0;
                this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AJOUTER"));
            }
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("VEUILLEZ S\u00c9LECTIONNER DANS LA LISTE LA PARCELLE \u00c0 SUPPRIM\u00c9"), ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("S\u00c9LECTION NON EFFECTU\u00c9E"), -1);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        block19: {
            try {
                String NomPlot = this.nomparcelleField.getText();
                if (!NomPlot.equals("")) {
                    ParcelleMod PlotTools = new ParcelleMod();
                    SolMod MySoil = new SolMod();
                    boolean Exist = false;
                    if (this.AddPlot) {
                        Exist = PlotTools.PlotNameExist(NomPlot, this.SetIlot);
                        this.NameInStock = this.nomparcelleField.getText();
                    } else if (!NomPlot.equals(this.NameInStock)) {
                        Exist = PlotTools.PlotNameExist(NomPlot, this.SetIlot);
                    }
                    if (this.IdP == 0) {
                        this.IdP = this.p.getIdparcelle();
                    } else {
                        this.p = (Parcelle)this.entityManager.find(Parcelle.class, (Object)this.IdP);
                    }
                    if (this.NameInStock.equals("")) {
                        this.NameInStock = this.nomparcelleField.getText();
                    }
                    if (!Exist) {
                        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                            this.entityManager.getTransaction().begin();
                        }
                        this.SetValuesFromFields();
                        this.GetValues();
                        this.entityManager.merge((Object)this.p);
                        if (this.Tool.SaveInCriterBaseOk(this.entityManager)) {
                            ParcelleMod pMod = new ParcelleMod();
                            String SoilVal = this.jComboBoxListSol.getSelectedItem().toString();
                            if (this.IdSol == 0) {
                                try {
                                    String NomSol = this.jComboBoxListSol.getSelectedItem().toString();
                                    if (!NomSol.equals("") || !NomSol.equals(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AUCUN"))) {
                                        this.IdSol = MySoil.GetSolByName(NomSol);
                                    }
                                }
                                catch (NullPointerException rex) {
                                    // empty catch block
                                }
                            }
                            if (!SoilVal.equals(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AUCUN SOL")) && this.jComboBoxListSol.getSelectedIndex() != -1) {
                                pMod.AddSoilToPlot(this.IdSol, this.p);
                            }
                            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("ENREGISTREMENT REUSSI !"), ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("CONFIRMATION DE SAUVEGARDE"), -1);
                        }
                        this.ShowWithIlotId();
                        this.refresh();
                        this.setAlwaysOnTop(true);
                        this.setAlwaysOnTop(false);
                        this.SetFreese(false);
                        this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AJOUTER"));
                        this.AddPlot = false;
                        this.IdP = 0;
                    } else {
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("LA PARCELLE") + " " + NomPlot + ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("NOM_PARCELLE_EXISTE_DEJA"), ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("PARCELLE EXISTANTE"), -1);
                        this.nomparcelleField.setText(this.NameInStock);
                        this.nomparcelleField.requestFocus();
                    }
                    this.NameInStock = "";
                    break block19;
                }
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("VEUILLEZ ENTRER UN NOM POUR VOTRE PARCELLE !"), ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AUCUN NOM DE PARCELLE"), -1);
            }
            catch (RollbackException rex) {
                rex.printStackTrace();
                this.entityManager.getTransaction().begin();
                ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
                for (Parcelle p : this.list) {
                    merged.add(this.entityManager.merge((Object)p));
                }
                this.list.clear();
                this.list.addAll(merged);
            }
        }
    }

    private void CloseButtonMouseReleased(MouseEvent evt) {
        this.SetIlotMenuStatut(true);
        this.dispose();
    }

    private void masterTableMouseClicked(MouseEvent evt) {
        int RowSelect = 0;
        boolean IdNotSet = false;
        this.SetFreese(true);
        RowSelect = this.masterTable.getSelectedRow();
        try {
            this.IdP = this.Tool.SetAsA_Int(this.masterTable.getValueAt(RowSelect, 8).toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(ParcelleForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException ext) {
            IdNotSet = true;
        }
        if (!IdNotSet) {
            try {
                this.nomparcelleField.setText(this.masterTable.getValueAt(RowSelect, 0).toString());
            }
            catch (NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("INTITUL\u00c9 DE LA PARCELLE NULL - ERREUR TYPE : ") + ext);
                this.nomparcelleField.setText("");
            }
            this.NameInStock = this.nomparcelleField.getText();
            try {
                this.surfaceField.setText(this.masterTable.getValueAt(RowSelect, 1).toString());
            }
            catch (NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("SURFACE \u00c0 NULL - ERREUR TYPE : ") + ext);
                this.surfaceField.setText("");
            }
            try {
                this.jComboBoxPente.setSelectedItem(this.masterTable.getValueAt(RowSelect, 2).toString());
            }
            catch (NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("PENTE \u00c0 NULL - ERREUR TYPE : ") + ext);
                this.jComboBoxPente.setSelectedItem("");
            }
            try {
                String sol = this.masterTable.getValueAt(RowSelect, 6).toString();
                this.jComboBoxListSol.setSelectedItem(sol);
            }
            catch (NullPointerException ext) {
                this.jComboBoxListSol.setSelectedItem(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AUCUN SOL"));
            }
            try {
                this.jComboDistToRiver.setSelectedItem(this.masterTable.getValueAt(RowSelect, 3).toString());
            }
            catch (NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AUCUNE DISTANCE NULL - ERREUR TYPE : ") + ext);
                this.jComboDistToRiver.setSelectedItem("");
            }
            try {
                this.jComboBoxLargBHerbee.setSelectedItem(this.masterTable.getValueAt(RowSelect, 4).toString());
            }
            catch (NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AUCUNE LARGEUR BANDE NULL - ERREUR TYPE : ") + ext);
                this.jComboBoxLargBHerbee.setSelectedItem("");
            }
            try {
                this.NbRotAnneeField.setText(this.masterTable.getValueAt(RowSelect, 5).toString());
            }
            catch (NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("ROTATION NULL - ERREUR TYPE : ") + ext);
                this.NbRotAnneeField.setText("");
            }
            try {
                this.jComboBoxErodability.setSelectedItem(this.masterTable.getValueAt(RowSelect, 9).toString());
            }
            catch (NullPointerException ext) {
                System.out.println(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("ERODABILIT\u00c9 NULL - ERREUR TYPE : ") + ext);
                this.jComboBoxErodability.setSelectedItem("");
            }
        }
        this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AJOUTER"));
    }

    private void jComboDistToRiverActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxPenteActionPerformed(ActionEvent evt) {
    }

    private void jComboDistToRiverPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboDistToRiver.getSelectedItem().toString(), row, 3);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void nomparcelleFieldCaretUpdate(CaretEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.nomparcelleField.getText(), row, 0);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void surfaceFieldCaretUpdate(CaretEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.surfaceField.getText(), row, 1);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void jComboBoxPentePopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboBoxPente.getSelectedItem().toString(), row, 2);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void SetValuesFromFields() {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboBoxLargBHerbee.getSelectedItem().toString(), row, 4);
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboBoxPente.getSelectedItem().toString(), row, 2);
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            if (!this.NbRotAnneeField.getText().isEmpty()) {
                if (this.masterTable.getSelectedRow() != -1) {
                    row = this.masterTable.getSelectedRow();
                    this.masterTable.setValueAt(this.NbRotAnneeField.getText().toString(), row, 5);
                }
                if (this.SetIlot != 0) {
                    int IdStation = ((Ilot)this.entityManager.find(Ilot.class, (Object)this.SetIlot)).getStationmeteo().getIdstationmeteo();
                    this.DetectModeAnneeClimat(IdStation);
                }
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.nomparcelleField.getText(), row, 0);
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.surfaceField.getText(), row, 1);
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboDistToRiver.getSelectedItem().toString(), row, 3);
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboBoxListSol.getSelectedItem().toString(), row, 6);
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboBoxErodability.getSelectedItem().toString(), row, 9);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void jComboBoxLargBHerbeePopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboBoxLargBHerbee.getSelectedItem().toString(), row, 4);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void NbRotAnneeFieldCaretUpdate(CaretEvent evt) {
        int row = 0;
        try {
            if (!this.NbRotAnneeField.getText().isEmpty()) {
                if (this.masterTable.getSelectedRow() != -1) {
                    row = this.masterTable.getSelectedRow();
                    this.masterTable.setValueAt(this.NbRotAnneeField.getText().toString(), row, 5);
                }
                if (this.SetIlot != 0) {
                    int IdStation = ((Ilot)this.entityManager.find(Ilot.class, (Object)this.SetIlot)).getStationmeteo().getIdstationmeteo();
                    this.DetectModeAnneeClimat(IdStation);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void surfaceFieldFocusLost(FocusEvent evt) {
        int row = 0;
        String ValueGet = "";
        if (!this.surfaceField.getText().isEmpty() && (ValueGet = this.Tool.RemplaceVirgule(this.surfaceField.getText())).length() != ValueGet.lastIndexOf(".") + 1) {
            this.surfaceField.setText(ValueGet);
        }
        try {
            if (NumberUtils.isNumber(ValueGet) || ValueGet.equals("")) {
                if (this.masterTable.getSelectedRow() != -1) {
                    row = this.masterTable.getSelectedRow();
                    this.masterTable.setValueAt(this.surfaceField.getText(), row, 1);
                }
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("LA SUPERFICIE DOIT \u00caTRE INDIQU\u00c9 AU FORMAT NUM\u00c9RIQUE"), ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("SUPERFICIE INCORRECT"), -1);
                this.surfaceField.requestFocus();
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("LA SUPERFICIE DOIT \u00caTRE INDIQU\u00c9 AU FORMAT NUM\u00c9RIQUE"), ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("SUPERFICIE INCORRECT"), -1);
            this.surfaceField.requestFocus();
        }
    }

    private void jComboBoxListSolPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        SolMod MySoil = new SolMod();
        boolean row = false;
        String NomSol = "";
        try {
            NomSol = this.jComboBoxListSol.getSelectedItem().toString();
            if (!NomSol.equals("") || !NomSol.equals(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("AUCUN"))) {
                this.IdSol = MySoil.GetSolByName(NomSol);
            }
        }
        catch (NullPointerException rex) {
            // empty catch block
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.SetIlotMenuStatut(true);
        this.dispose();
    }

    private void jComboBoxListSolMouseEntered(MouseEvent evt) {
        if (this.jComboBoxListSol.isEnabled() && !this.jComboBoxListSol.isPopupVisible()) {
            this.afficheDialogInfoRight();
            this.JTextAreaInfo.setText(ResourceBundle.getBundle("Interfaces/resources/IlotPlotBundle").getString("LE TYPE DE SOL SERA AFFICH\u00c9 DANS LE TABLEAU R\u00c9CAPITULATIF APR\u00c8S L'ENREGISTREMENT VOS DONN\u00c9ES"));
        }
    }

    private void jComboBoxListSolMouseExited(MouseEvent evt) {
        this.jDialogInfoShow.setVisible(false);
        this.JTextAreaInfo.setText("");
    }

    private void jComboBoxErodabilityPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jComboBoxErodability.getSelectedItem().toString(), row, 9);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void NbRotAnneeFieldFocusLost(FocusEvent evt) {
        try {
            if (!this.NbRotAnneeField.getText().isEmpty()) {
                String ValueGet = this.Tool.RemplaceVirgule(this.NbRotAnneeField.getText());
                if (ValueGet.length() != ValueGet.lastIndexOf(".") + 1) {
                    this.NbRotAnneeField.setText(ValueGet);
                }
                if (this.NbRotAnneeField.getText().equals("0")) {
                    this.NbRotAnneeField.setText("1");
                }
                if (this.SetIlot != 0) {
                    int IdStation = ((Ilot)this.entityManager.find(Ilot.class, (Object)this.SetIlot)).getStationmeteo().getIdstationmeteo();
                    this.DetectModeAnneeClimat(IdStation);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void NbRotAnneeFieldKeyTyped(KeyEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ParcelleForm().setVisible(true);
            }
        });
    }
}

