/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.SQLException;
import org.apache.derby.client.am.Diagnosable;
import org.apache.derby.client.am.ErrorKey;
import org.apache.derby.client.am.ExceptionFormatter;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.ResourceUtilities;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlState;
import org.apache.derby.client.am.Sqlca;

public class SqlException
extends SQLException
implements Diagnosable {
    Throwable throwable_ = null;
    protected Sqlca sqlca_ = null;
    private String batchPositionLabel_;

    public SqlException(LogWriter logWriter, ErrorKey errorKey) {
        super(ResourceUtilities.getResource("1") + ResourceUtilities.getResource(errorKey.getResourceKey()), errorKey.getSQLState(), errorKey.getErrorCode());
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, ErrorKey errorKey, Object[] objectArray) {
        super(ResourceUtilities.getResource("1") + ResourceUtilities.getResource(errorKey.getResourceKey(), objectArray), errorKey.getSQLState(), errorKey.getErrorCode());
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, ErrorKey errorKey, Object object) {
        this(logWriter, errorKey, new Object[]{object});
    }

    public SqlException(LogWriter logWriter, Sqlca sqlca) {
        this.sqlca_ = sqlca;
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter) {
        super(null, null, -99999);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, String string) {
        super(string, null, -99999);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, Throwable throwable, String string) {
        super(string, null, -99999);
        this.throwable_ = throwable;
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, Throwable throwable, String string, SqlState sqlState) {
        super(string, sqlState.getState(), -99999);
        this.throwable_ = throwable;
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, Throwable throwable, String string, String string2) {
        super(string, string2, -99999);
        this.throwable_ = throwable;
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, String string, SqlState sqlState) {
        super(string, sqlState.getState(), -99999);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, String string, String string2) {
        super(string, string2, -99999);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, String string, SqlState sqlState, SqlCode sqlCode) {
        super(string, sqlState == null ? null : sqlState.getState(), sqlCode.getCode());
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, String string, String string2, int n) {
        super(string, string2, n);
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, Throwable throwable, String string, SqlState sqlState, SqlCode sqlCode) {
        super(string, sqlState.getState(), sqlCode.getCode());
        this.throwable_ = throwable;
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    public SqlException(LogWriter logWriter, Throwable throwable, String string, String string2, int n) {
        super(string, string2, n);
        this.throwable_ = throwable;
        if (logWriter != null) {
            logWriter.traceDiagnosable(this);
        }
    }

    void setBatchPositionLabel(int n) {
        this.batchPositionLabel_ = "Error for batch element #" + n + ": ";
    }

    public Sqlca getSqlca() {
        return this.sqlca_;
    }

    public Throwable getThrowable() {
        return this.throwable_;
    }

    public String getMessage() {
        String string = this.sqlca_ == null ? super.getMessage() : this.sqlca_.getJDBCMessage();
        if (this.batchPositionLabel_ == null) {
            return string;
        }
        return this.batchPositionLabel_ + string;
    }

    public String getSQLState() {
        if (this.sqlca_ == null) {
            return super.getSQLState();
        }
        return this.sqlca_.getSqlState();
    }

    public int getErrorCode() {
        if (this.sqlca_ == null) {
            return super.getErrorCode();
        }
        return this.sqlca_.getSqlCode();
    }

    public void printTrace(PrintWriter printWriter, String string) {
        ExceptionFormatter.printTrace(this, printWriter, string);
    }

    SqlException copyAsUnchainedSQLException(LogWriter logWriter) {
        if (this.sqlca_ != null) {
            return new SqlException(logWriter, this.sqlca_);
        }
        return new SqlException(logWriter, this.getMessage(), this.getSQLState(), this.getErrorCode());
    }
}

