/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.util.StringTokenizer;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ProductLevel;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Version;

public abstract class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final short SQL_BEST_ROWID = 1;
    private static final short SQL_ROWVER = 2;
    private static final short SQL_INDEX_UNIQUE = 0;
    private static final short SQL_INDEX_ALL = 1;
    protected Agent agent_;
    protected Connection connection_;
    private static final int numberOfMetaDataInfoMethods__ = 108;
    private Object[] metaDataInfoCache_ = new Object[108];
    private boolean metaDataInfoIsCached_ = false;
    public ProductLevel productLevel_;
    private ResultSet lastGetColumnPrivilegesResultSet_ = null;
    private ResultSet lastGetColumnsResultSet_ = null;
    private ResultSet lastGetForeignKeysResultSet_ = null;
    private ResultSet lastGetPrimaryKeysResultSet_ = null;
    private ResultSet lastGetProcedureColumnsResultSet_ = null;
    private ResultSet lastGetProceduresResultSet_ = null;
    private ResultSet lastGetSpecialColumnsResultSet_ = null;
    private ResultSet lastGetStatisticsResultSet_ = null;
    private ResultSet lastGetTablePrivilegesResultSet_ = null;
    private ResultSet lastGetTablesResultSet_ = null;
    private ResultSet lastGetUDTsResultSet_ = null;
    private ResultSet lastGetTypeInfoResultSet_ = null;
    private ResultSet lastGetAttrResultSet_ = null;
    private ResultSet lastGetSuperTypesResultSet_ = null;
    private ResultSet lastGetSuperTablesResultSet_ = null;
    public boolean useServerXAState_ = true;
    private static final int allProceduresAreCallable__ = 0;
    private static final int allTablesAreSelectable__ = 1;
    private static final int nullsAreSortedHigh__ = 2;
    private static final int nullsAreSortedLow__ = 3;
    private static final int nullsAreSortedAtStart__ = 4;
    private static final int nullsAreSortedAtEnd__ = 5;
    private static final int usesLocalFiles__ = 6;
    private static final int usesLocalFilePerTable__ = 7;
    private static final int storesUpperCaseIdentifiers__ = 8;
    private static final int storesLowerCaseIdentifiers__ = 9;
    private static final int storesMixedCaseIdentifiers__ = 10;
    private static final int storesUpperCaseQuotedIdentifiers__ = 11;
    private static final int storesLowerCaseQuotedIdentifiers__ = 12;
    private static final int storesMixedCaseQuotedIdentifiers__ = 13;
    private static final int getSQLKeywords__ = 14;
    private static final int getNumericFunctions__ = 15;
    private static final int getStringFunctions__ = 16;
    private static final int getSystemFunctions__ = 17;
    private static final int getTimeDateFunctions__ = 18;
    private static final int getSearchStringEscape__ = 19;
    private static final int getExtraNameCharacters__ = 20;
    private static final int supportsAlterTableWithAddColumn__ = 21;
    private static final int supportsAlterTableWithDropColumn__ = 22;
    private static final int supportsConvert__ = 23;
    private static final int supportsConvertType__ = 24;
    private static final int supportsDifferentTableCorrelationNames__ = 25;
    private static final int supportsExpressionsInOrderBy__ = 26;
    private static final int supportsOrderByUnrelated__ = 27;
    private static final int supportsGroupBy__ = 28;
    private static final int supportsGroupByUnrelated__ = 29;
    private static final int supportsGroupByBeyondSelect__ = 30;
    private static final int supportsMultipleResultSets__ = 31;
    private static final int supportsMultipleTransactions__ = 32;
    private static final int supportsCoreSQLGrammar__ = 33;
    private static final int supportsExtendedSQLGrammar__ = 34;
    private static final int supportsANSI92IntermediateSQL__ = 35;
    private static final int supportsANSI92FullSQL__ = 36;
    private static final int supportsIntegrityEnhancementFacility__ = 37;
    private static final int supportsOuterJoins__ = 38;
    private static final int supportsFullOuterJoins__ = 39;
    private static final int supportsLimitedOuterJoins__ = 40;
    private static final int getSchemaTerm__ = 41;
    private static final int getProcedureTerm__ = 42;
    private static final int getCatalogTerm__ = 43;
    private static final int isCatalogAtStart__ = 44;
    private static final int getCatalogSeparator__ = 45;
    private static final int supportsSchemasInDataManipulation__ = 46;
    private static final int supportsSchemasInProcedureCalls__ = 47;
    private static final int supportsSchemasInTableDefinitions__ = 48;
    private static final int supportsSchemasInIndexDefinitions__ = 49;
    private static final int supportsSchemasInPrivilegeDefinitions__ = 50;
    private static final int supportsCatalogsInDataManipulation__ = 51;
    private static final int supportsCatalogsInProcedureCalls__ = 52;
    private static final int supportsCatalogsInTableDefinitions__ = 53;
    private static final int supportsCatalogsInIndexDefinitions__ = 54;
    private static final int supportsCatalogsInPrivilegeDefinitions__ = 55;
    private static final int supportsPositionedDelete__ = 56;
    private static final int supportsPositionedUpdate__ = 57;
    private static final int supportsSelectForUpdate__ = 58;
    private static final int supportsStoredProcedures__ = 59;
    private static final int supportsSubqueriesInComparisons__ = 60;
    private static final int supportsUnion__ = 61;
    private static final int supportsUnionAll__ = 62;
    private static final int supportsOpenCursorsAcrossCommit__ = 63;
    private static final int supportsOpenCursorsAcrossRollback__ = 64;
    private static final int supportsOpenStatementsAcrossCommit__ = 65;
    private static final int supportsOpenStatementsAcrossRollback__ = 66;
    private static final int getMaxBinaryLiteralLength__ = 67;
    private static final int getMaxCharLiteralLength__ = 68;
    private static final int getMaxColumnNameLength__ = 69;
    private static final int getMaxColumnsInGroupBy__ = 70;
    private static final int getMaxColumnsInIndex__ = 71;
    private static final int getMaxColumnsInOrderBy__ = 72;
    private static final int getMaxColumnsInSelect__ = 73;
    private static final int getMaxColumnsInTable__ = 74;
    private static final int getMaxConnections__ = 75;
    private static final int getMaxCursorNameLength__ = 76;
    private static final int getMaxIndexLength__ = 77;
    private static final int getMaxSchemaNameLength__ = 78;
    private static final int getMaxProcedureNameLength__ = 79;
    private static final int getMaxCatalogNameLength__ = 80;
    private static final int getMaxRowSize__ = 81;
    private static final int doesMaxRowSizeIncludeBlobs__ = 82;
    private static final int getMaxStatementLength__ = 83;
    private static final int getMaxStatements__ = 84;
    private static final int getMaxTableNameLength__ = 85;
    private static final int getMaxTablesInSelect__ = 86;
    private static final int getMaxUserNameLength__ = 87;
    private static final int getDefaultTransactionIsolation__ = 88;
    private static final int supportsTransactions__ = 89;
    private static final int supportsTransactionIsolationLevel__ = 90;
    private static final int supportsDataDefinitionAndDataManipulationTransactions__ = 91;
    private static final int supportsDataManipulationTransactionsOnly__ = 92;
    private static final int dataDefinitionCausesTransactionCommit__ = 93;
    private static final int dataDefinitionIgnoredInTransactions__ = 94;
    private static final int supportsResultSetType__ = 95;
    private static final int supportsResultSetConcurrency__ = 96;
    private static final int ownUpdatesAreVisible__ = 97;
    private static final int ownDeletesAreVisible__ = 98;
    private static final int ownInsertsAreVisible__ = 99;
    private static final int othersUpdatesAreVisible__ = 100;
    private static final int othersDeletesAreVisible__ = 101;
    private static final int othersInsertsAreVisible__ = 102;
    private static final int updatesAreDetected__ = 103;
    private static final int deletesAreDetected__ = 104;
    private static final int insertsAreDetected__ = 105;
    private static final int supportsBatchUpdates__ = 106;

    protected DatabaseMetaData(Agent agent, Connection connection, ProductLevel productLevel) {
        this.agent_ = agent;
        this.connection_ = connection;
        this.productLevel_ = productLevel;
        this.computeFeatureSet_();
        if (connection.isXAConnection()) {
            connection.xaHostVersion_ = this.productLevel_.versionLevel_;
        }
    }

    public boolean allProceduresAreCallable() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(0);
    }

    public boolean allTablesAreSelectable() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(1);
    }

    public boolean nullsAreSortedHigh() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(2);
    }

    public boolean nullsAreSortedLow() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(3);
    }

    public boolean nullsAreSortedAtStart() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(4);
    }

    public boolean nullsAreSortedAtEnd() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(5);
    }

    public boolean usesLocalFiles() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(6);
    }

    public boolean usesLocalFilePerTable() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(7);
    }

    public boolean storesUpperCaseIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(8);
    }

    public boolean storesLowerCaseIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(9);
    }

    public boolean storesMixedCaseIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(10);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(11);
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(12);
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(13);
    }

    public String getSQLKeywords() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(14);
    }

    public String getNumericFunctions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(15);
    }

    public String getStringFunctions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(16);
    }

    public String getSystemFunctions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(17);
    }

    public String getTimeDateFunctions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(18);
    }

    public String getSearchStringEscape() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(19);
    }

    public String getExtraNameCharacters() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(20);
    }

    public boolean supportsAlterTableWithAddColumn() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(21);
    }

    public boolean supportsAlterTableWithDropColumn() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(22);
    }

    public boolean supportsConvert() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(23);
    }

    public boolean supportsConvert(int n, int n2) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean_supportsConvert(24, n, n2);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(25);
    }

    public boolean supportsExpressionsInOrderBy() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(26);
    }

    public boolean supportsOrderByUnrelated() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(27);
    }

    public boolean supportsGroupBy() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(28);
    }

    public boolean supportsGroupByUnrelated() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(29);
    }

    public boolean supportsGroupByBeyondSelect() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(30);
    }

    public boolean supportsMultipleResultSets() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(31);
    }

    public boolean supportsMultipleTransactions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(32);
    }

    public boolean supportsCoreSQLGrammar() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(33);
    }

    public boolean supportsExtendedSQLGrammar() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(34);
    }

    public boolean supportsANSI92IntermediateSQL() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(35);
    }

    public boolean supportsANSI92FullSQL() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(36);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(37);
    }

    public boolean supportsOuterJoins() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(38);
    }

    public boolean supportsFullOuterJoins() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(39);
    }

    public boolean supportsLimitedOuterJoins() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(40);
    }

    public String getSchemaTerm() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(41);
    }

    public String getProcedureTerm() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(42);
    }

    public String getCatalogTerm() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(43);
    }

    public boolean isCatalogAtStart() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(44);
    }

    public String getCatalogSeparator() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(45);
    }

    public boolean supportsSchemasInDataManipulation() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(46);
    }

    public boolean supportsSchemasInProcedureCalls() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(47);
    }

    public boolean supportsSchemasInTableDefinitions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(48);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(49);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(50);
    }

    public boolean supportsCatalogsInDataManipulation() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(51);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(52);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(53);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(54);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(55);
    }

    public boolean supportsPositionedDelete() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(56);
    }

    public boolean supportsPositionedUpdate() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(57);
    }

    public boolean supportsSelectForUpdate() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(58);
    }

    public boolean supportsStoredProcedures() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(59);
    }

    public boolean supportsSubqueriesInComparisons() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(60);
    }

    public boolean supportsUnion() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(61);
    }

    public boolean supportsUnionAll() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(62);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(63);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(64);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(65);
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(66);
    }

    public int getMaxBinaryLiteralLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(67);
    }

    public int getMaxCharLiteralLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(68);
    }

    public int getMaxColumnNameLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(69);
    }

    public int getMaxColumnsInGroupBy() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(70);
    }

    public int getMaxColumnsInIndex() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(71);
    }

    public int getMaxColumnsInOrderBy() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(72);
    }

    public int getMaxColumnsInSelect() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(73);
    }

    public int getMaxColumnsInTable() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(74);
    }

    public int getMaxConnections() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(75);
    }

    public int getMaxCursorNameLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(76);
    }

    public int getMaxIndexLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(77);
    }

    public int getMaxSchemaNameLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(78);
    }

    public int getMaxProcedureNameLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(79);
    }

    public int getMaxCatalogNameLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(80);
    }

    public int getMaxRowSize() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(81);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(82);
    }

    public int getMaxStatementLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(83);
    }

    public int getMaxStatements() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(84);
    }

    public int getMaxTableNameLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(85);
    }

    public int getMaxTablesInSelect() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(86);
    }

    public int getMaxUserNameLength() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(87);
    }

    public int getDefaultTransactionIsolation() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(88);
    }

    public boolean supportsTransactions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(89);
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(90, n);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(91);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(92);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(93);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(94);
    }

    public boolean supportsResultSetType(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(95, n);
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt_SupportsResultSetConcurrency(96, n, n2);
    }

    public boolean ownUpdatesAreVisible(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(97, n);
    }

    public boolean ownDeletesAreVisible(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(98, n);
    }

    public boolean ownInsertsAreVisible(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(99, n);
    }

    public boolean othersUpdatesAreVisible(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(100, n);
    }

    public boolean othersDeletesAreVisible(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(101, n);
    }

    public boolean othersInsertsAreVisible(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(102, n);
    }

    public boolean updatesAreDetected(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(103, n);
    }

    public boolean deletesAreDetected(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(104, n);
    }

    public boolean insertsAreDetected(int n) throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(105, n);
    }

    public boolean supportsBatchUpdates() throws SqlException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(106);
    }

    public boolean supportsSavepoints() throws SqlException {
        this.checkForClosedConnection();
        return this.productLevel_.greaterThanOrEqualTo(5, 2, 0);
    }

    public abstract String getURL_() throws SqlException;

    public String getURL() throws SqlException {
        this.checkForClosedConnection();
        return this.getURL_();
    }

    public String getUserName() throws SqlException {
        this.checkForClosedConnection();
        return this.connection_.user_;
    }

    public boolean isReadOnly() throws SqlException {
        return false;
    }

    public String getDatabaseProductName() throws SqlException {
        this.checkForClosedConnection();
        return this.productLevel_.databaseProductName_;
    }

    public String getDatabaseProductVersion() throws SqlException {
        this.checkForClosedConnection();
        return this.productLevel_.databaseProductVersion_;
    }

    public String getDriverName() throws SqlException {
        this.checkForClosedConnection();
        return "Apache Derby Network Client JDBC Driver";
    }

    public String getDriverVersion() throws SqlException {
        this.checkForClosedConnection();
        return Version.getDriverVersion();
    }

    public int getDriverMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return Version.getMinorVersion();
    }

    public boolean supportsMixedCaseIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public String getIdentifierQuoteString() throws SqlException {
        this.checkForClosedConnection();
        return "\"";
    }

    public boolean supportsColumnAliasing() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsNonNullableColumns() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getProcedures", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getProceduresX(string, string2, string3);
        }
    }

    private ResultSet getProceduresX(String string, String string2, String string3) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLPROCEDURES(?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, this.getOptions());
        this.lastGetProceduresResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetProceduresResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getProcedureColumns", (Object)string, (Object)string2, (Object)string3, (Object)string4);
            }
            return this.getProcedureColumnsX(string, string2, string3, string4);
        }
    }

    private ResultSet getProcedureColumnsX(String string, String string2, String string3, String string4) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLPROCEDURECOLS(?,?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, string4);
        preparedStatement.setStringX(5, this.getOptions());
        this.lastGetProcedureColumnsResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetProcedureColumnsResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTables", (Object)string, (Object)string2, (Object)string3, (Object)stringArray);
            }
            return this.getTablesX(string, string2, string3, stringArray);
        }
    }

    private ResultSet getTablesX(String string, String string2, String string3, String[] stringArray) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLTABLES(?,?,?,?,?)");
        if (string == null) {
            preparedStatement.setNullX(1, 12);
        } else {
            preparedStatement.setStringX(1, string);
        }
        if (string2 == null) {
            preparedStatement.setNullX(2, 12);
        } else {
            preparedStatement.setStringX(2, string2);
        }
        if (string3 == null) {
            preparedStatement.setNullX(3, 12);
        } else {
            preparedStatement.setStringX(3, string3);
        }
        String string4 = new String();
        if (stringArray == null) {
            preparedStatement.setNullX(4, 12);
        } else if (stringArray.length == 1 && stringArray[0].trim().equals("%")) {
            preparedStatement.setStringX(4, stringArray[0]);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    string4 = string4.concat(",");
                }
                string4 = string4.concat("'" + stringArray[i] + "'");
            }
            preparedStatement.setStringX(4, string4);
        }
        preparedStatement.setStringX(5, this.getOptions());
        this.lastGetTablesResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetTablesResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getSchemas() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getSchemas");
            }
            return this.getSchemasX();
        }
    }

    private ResultSet getSchemasX() throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLTABLES('', '', '', '', 'GETSCHEMAS=1')");
        return preparedStatement.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCatalogs() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCatalogs");
            }
            return this.getCatalogsX();
        }
    }

    private ResultSet getCatalogsX() throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLTABLES('', '', '', '', 'GETCATALOGS=1')");
        return preparedStatement.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTableTypes() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTableTypes");
            }
            return this.getTableTypesX();
        }
    }

    private ResultSet getTableTypesX() throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = null;
        preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLTABLES(?,?,?,?,?)");
        preparedStatement.setStringX(1, "");
        preparedStatement.setStringX(2, "");
        preparedStatement.setStringX(3, "");
        preparedStatement.setStringX(4, "%");
        int n = this.connection_.holdability() == 1 ? 1 : 0;
        preparedStatement.setStringX(5, "DATATYPE='JDBC';GETTABLETYPES=1; CURSORHOLD=" + n);
        this.lastGetTablesResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetTablesResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getColumns", (Object)string, (Object)string2, (Object)string3, (Object)string4);
            }
            this.checkForClosedConnection();
            return this.getColumnsX(string, string2, string3, string4);
        }
    }

    private ResultSet getColumnsX(String string, String string2, String string3, String string4) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLCOLUMNS(?,?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, string4);
        preparedStatement.setStringX(5, this.getOptions());
        this.lastGetColumnsResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetColumnsResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getColumnPrivileges", (Object)string, (Object)string2, (Object)string3, (Object)string4);
            }
            return this.getColumnPrivilegesX(string, string2, string3, string4);
        }
    }

    private ResultSet getColumnPrivilegesX(String string, String string2, String string3, String string4) throws SqlException {
        this.checkForClosedConnection();
        if (string3 == null) {
            throw new SqlException(this.agent_.logWriter_, "getColumnPrivileges(): null not allowed for table name");
        }
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLCOLPRIVILEGES(?,?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, string4);
        preparedStatement.setStringX(5, this.getOptions());
        this.lastGetColumnPrivilegesResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetColumnPrivilegesResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTablePrivileges", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getTablePrivilegesX(string, string2, string3);
        }
    }

    private ResultSet getTablePrivilegesX(String string, String string2, String string3) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLTABLEPRIVILEGES(?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, this.getOptions());
        this.lastGetTablePrivilegesResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetTablePrivilegesResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBestRowIdentifier", (Object)string, (Object)string2, (Object)string3, n, bl);
            }
            return this.getBestRowIdentifierX(string, string2, string3, n, bl);
        }
    }

    private ResultSet getBestRowIdentifierX(String string, String string2, String string3, int n, boolean bl) throws SqlException {
        this.checkForClosedConnection();
        if (string3 == null) {
            throw new SqlException(this.agent_.logWriter_, "getBestRowIdentifier(): null not allowed for table name");
        }
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLSPECIALCOLUMNS(?,?,?,?,?,?,?)");
        preparedStatement.setIntX(1, 1);
        preparedStatement.setStringX(2, string);
        preparedStatement.setStringX(3, string2);
        preparedStatement.setStringX(4, string3);
        preparedStatement.setIntX(5, n);
        if (bl) {
            preparedStatement.setShortX(6, (short)1);
        } else {
            preparedStatement.setShortX(6, (short)0);
        }
        preparedStatement.setStringX(7, this.getOptions());
        this.lastGetSpecialColumnsResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetSpecialColumnsResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getVersionColumns", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getVersionColumnsX(string, string2, string3);
        }
    }

    private ResultSet getVersionColumnsX(String string, String string2, String string3) throws SqlException {
        this.checkForClosedConnection();
        if (string3 == null) {
            throw new SqlException(this.agent_.logWriter_, "getBestRowIdentifier(): null not allowed for table name");
        }
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLSPECIALCOLUMNS(?,?,?,?,?,?,?)");
        preparedStatement.setIntX(1, 2);
        preparedStatement.setStringX(2, string);
        preparedStatement.setStringX(3, string2);
        preparedStatement.setStringX(4, string3);
        preparedStatement.setIntX(5, 0);
        preparedStatement.setShortX(6, (short)0);
        preparedStatement.setStringX(7, this.getOptions());
        this.lastGetSpecialColumnsResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetSpecialColumnsResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getPrimaryKeys", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getPrimaryKeysX(string, string2, string3);
        }
    }

    private ResultSet getPrimaryKeysX(String string, String string2, String string3) throws SqlException {
        this.checkForClosedConnection();
        if (string3 == null) {
            throw new SqlException(this.agent_.logWriter_, "getIndexInfo(): null not allowed for table name");
        }
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLPRIMARYKEYS(?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, this.getOptions());
        this.lastGetPrimaryKeysResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetPrimaryKeysResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getImportedKeys", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getImportedKeysX(string, string2, string3);
        }
    }

    private ResultSet getImportedKeysX(String string, String string2, String string3) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        preparedStatement.setStringX(1, "");
        preparedStatement.setStringX(2, null);
        preparedStatement.setStringX(3, "");
        preparedStatement.setStringX(4, string);
        preparedStatement.setStringX(5, string2);
        preparedStatement.setStringX(6, string3);
        if (this.connection_.holdability() == 1) {
            preparedStatement.setStringX(7, "DATATYPE='JDBC';IMPORTEDKEY=1; CURSORHOLD=1");
        } else {
            preparedStatement.setStringX(7, "DATATYPE='JDBC';IMPORTEDKEY=1; CURSORHOLD=0");
        }
        this.lastGetForeignKeysResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetForeignKeysResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getExportedKeys", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getExportedKeysX(string, string2, string3);
        }
    }

    private ResultSet getExportedKeysX(String string, String string2, String string3) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, "");
        preparedStatement.setStringX(5, null);
        preparedStatement.setStringX(6, "");
        if (this.connection_.holdability() == 1) {
            preparedStatement.setStringX(7, "DATATYPE='JDBC';EXPORTEDKEY=1; CURSORHOLD=1");
        } else {
            preparedStatement.setStringX(7, "DATATYPE='JDBC';EXPORTEDKEY=1; CURSORHOLD=0");
        }
        this.lastGetForeignKeysResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetForeignKeysResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCrossReference", string, string2, string3, string4, string5, string6);
            }
            return this.getCrossReferenceX(string, string2, string3, string4, string5, string6);
        }
    }

    private ResultSet getCrossReferenceX(String string, String string2, String string3, String string4, String string5, String string6) throws SqlException {
        this.checkForClosedConnection();
        if (string3 == null) {
            throw new SqlException(this.agent_.logWriter_, "getCrossReference(): null not allowed for primary table name");
        }
        if (string6 == null) {
            throw new SqlException(this.agent_.logWriter_, "getCrossReference(): null not allowed for foreign table name");
        }
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        preparedStatement.setStringX(4, string4);
        preparedStatement.setStringX(5, string5);
        preparedStatement.setStringX(6, string6);
        preparedStatement.setStringX(7, this.getOptions());
        this.lastGetForeignKeysResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetForeignKeysResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTypeInfo() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTypeInfo");
            }
            return this.getTypeInfoX();
        }
    }

    private ResultSet getTypeInfoX() throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLGETTYPEINFO(?,?)");
        preparedStatement.setShortX(1, (short)0);
        preparedStatement.setStringX(2, this.getOptions());
        this.lastGetTypeInfoResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetTypeInfoResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getIndexInfo", (Object)string, (Object)string2, (Object)string3, bl, bl2);
            }
            return this.getIndexInfoX(string, string2, string3, bl, bl2);
        }
    }

    private ResultSet getIndexInfoX(String string, String string2, String string3, boolean bl, boolean bl2) throws SqlException {
        this.checkForClosedConnection();
        if (string3 == null) {
            throw new SqlException(this.agent_.logWriter_, "getIndexInfo(): null not allowed for table name");
        }
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLSTATISTICS(?,?,?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        if (bl) {
            preparedStatement.setShortX(4, (short)0);
        } else {
            preparedStatement.setShortX(4, (short)1);
        }
        if (bl2) {
            preparedStatement.setShortX(5, (short)1);
        } else {
            preparedStatement.setShortX(5, (short)0);
        }
        preparedStatement.setStringX(6, this.getOptions());
        this.lastGetStatisticsResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetStatisticsResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getUDTs", (Object)string, (Object)string2, (Object)string3, (Object)nArray);
            }
            return this.getUDTsX(string, string2, string3, nArray);
        }
    }

    private ResultSet getUDTsX(String string, String string2, String string3, int[] nArray) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.SQLUDTS(?,?,?,?,?)");
        preparedStatement.setStringX(1, string);
        preparedStatement.setStringX(2, string2);
        preparedStatement.setStringX(3, string3);
        String string4 = new String();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if (i > 0) {
                string4 = string4.concat(",");
            }
            string4 = string4.concat(String.valueOf(nArray[i]));
        }
        preparedStatement.setStringX(4, string4);
        preparedStatement.setStringX(5, this.getOptions());
        this.lastGetUDTsResultSet_ = this.executeCatalogQuery(preparedStatement);
        return this.lastGetUDTsResultSet_;
    }

    private String getOptions() {
        int n = this.connection_.holdability() == 1 ? 1 : 0;
        return "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=" + n;
    }

    private ResultSet executeCatalogQuery(PreparedStatement preparedStatement) throws SqlException {
        try {
            return preparedStatement.executeQueryX();
        }
        catch (SqlException sqlException) {
            if (sqlException.getErrorCode() == -440) {
                SqlException sqlException2 = new SqlException(this.agent_.logWriter_, "The required stored procedure is not installed on the server.");
                sqlException2.setNextException(sqlException);
                throw sqlException2;
            }
            if (sqlException.getErrorCode() == -444) {
                SqlException sqlException3 = new SqlException(this.agent_.logWriter_, "The load module name for the stored procedure on the server is not found. ");
                sqlException3.setNextException(sqlException);
                throw sqlException3;
            }
            throw sqlException;
        }
    }

    public java.sql.Connection getConnection() throws SqlException {
        this.checkForClosedConnection();
        return this.connection_;
    }

    public boolean supportsNamedParameters() throws SqlException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SqlException {
        this.checkForClosedConnection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getSuperTypes(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getSuperTypes", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getSuperTypesX();
        }
    }

    private ResultSet getSuperTypesX() throws SqlException {
        this.checkForClosedConnection();
        String string = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,VARCHAR('', 128) AS TYPE_NAME,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_CAT,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_SCHEM,VARCHAR('', 128) AS SUPERTYPE_NAME FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR ";
        PreparedStatement preparedStatement = this.connection_.prepareDynamicCatalogQuery(string);
        this.lastGetSuperTypesResultSet_ = preparedStatement.executeQueryX();
        return this.lastGetSuperTypesResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getSuperTables(String string, String string2, String string3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getSuperTables", (Object)string, (Object)string2, (Object)string3);
            }
            return this.getSuperTablesX();
        }
    }

    private ResultSet getSuperTablesX() throws SqlException {
        this.checkForClosedConnection();
        String string = "SELECT CAST(NULL AS VARCHAR(128)) AS TABLE_CAT,CAST(NULL AS VARCHAR(128)) AS TABLE_SCHEM,VARCHAR('', 128) AS TABLE_NAME,VARCHAR('', 128) AS SUPERTABLE_NAME FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        PreparedStatement preparedStatement = this.connection_.prepareDynamicCatalogQuery(string);
        this.lastGetSuperTablesResultSet_ = preparedStatement.executeQueryX();
        return this.lastGetSuperTablesResultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getAttributes(String string, String string2, String string3, String string4) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getAttributes", (Object)string, (Object)string2, (Object)string3, (Object)string4);
            }
            return this.getAttributesX();
        }
    }

    private ResultSet getAttributesX() throws SqlException {
        this.checkForClosedConnection();
        String string = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,VARCHAR('', 128) AS TYPE_NAME,VARCHAR('',128) AS ATTR_NAME,SMALLINT(0) AS DATA_TYPE,VARCHAR('',129) AS ATTR_TYPE_NAME,0 AS ATTR_SIZE,0 AS DECIMAL_DIGITS,0 AS NUM_PREC_RADIX,2 AS NULLABLE,CAST(NULL AS VARCHAR(254)) AS REMARKS,CAST(NULL AS VARCHAR(128)) AS ATTR_DEF,0 AS SQL_DATA_TYPE,0 AS SQL_DATETIME_SUB,0 AS CHAR_OCTET_LENGTH,0 AS ORDINAL_POSITION,VARCHAR('',128) AS IS_NULLABLE,CAST(NULL AS VARCHAR(128)) AS SCOPE_CATALOG,CAST(NULL AS VARCHAR(128)) AS SCOPE_SCHEMA,CAST(NULL AS VARCHAR(128)) AS SCOPE_TABLE,CAST(NULL AS SMALLINT) AS SOURCE_DATA_TYPE FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        PreparedStatement preparedStatement = this.connection_.prepareDynamicCatalogQuery(string);
        this.lastGetAttrResultSet_ = preparedStatement.executeQueryX();
        return this.lastGetAttrResultSet_;
    }

    public boolean supportsResultSetHoldability(int n) throws SqlException {
        this.checkForClosedConnection();
        return true;
    }

    public int getResultSetHoldability() throws SqlException {
        this.checkForClosedConnection();
        return 1;
    }

    public int getDatabaseMajorVersion() throws SqlException {
        this.checkForClosedConnection();
        return this.productLevel_.versionLevel_;
    }

    public int getDatabaseMinorVersion() throws SqlException {
        this.checkForClosedConnection();
        return this.productLevel_.releaseLevel_;
    }

    public int getJDBCMajorVersion() throws SqlException {
        this.checkForClosedConnection();
        return 3;
    }

    public int getJDBCMinorVersion() throws SqlException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getSQLStateType() throws SqlException {
        this.checkForClosedConnection();
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SqlException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsStatementPooling() throws SqlException {
        this.checkForClosedConnection();
        return false;
    }

    protected abstract void computeFeatureSet_();

    private boolean getMetaDataInfoBoolean(int n) throws SqlException {
        if (this.metaDataInfoIsCached_) {
            return (Integer)this.metaDataInfoCache_[n] != 0;
        }
        this.metaDataInfoCall();
        return (Integer)this.metaDataInfoCache_[n] != 0;
    }

    private int getMetaDataInfoInt(int n) throws SqlException {
        if (this.metaDataInfoIsCached_) {
            return (Integer)this.metaDataInfoCache_[n];
        }
        this.metaDataInfoCall();
        return (Integer)this.metaDataInfoCache_[n];
    }

    private String getMetaDataInfoString(int n) throws SqlException {
        if (this.metaDataInfoIsCached_) {
            return (String)this.metaDataInfoCache_[n];
        }
        this.metaDataInfoCall();
        return (String)this.metaDataInfoCache_[n];
    }

    private boolean getMetaDataInfoBooleanWithType(int n, int n2) throws SqlException {
        String string = null;
        if (this.metaDataInfoIsCached_) {
            string = (String)this.metaDataInfoCache_[n];
        } else {
            this.metaDataInfoCall();
            string = (String)this.metaDataInfoCache_[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (new Integer(stringTokenizer.nextToken()) != n2) continue;
            return true;
        }
        return false;
    }

    private boolean getMetaDataInfoInt_SupportsResultSetConcurrency(int n, int n2, int n3) throws SqlException {
        String string = null;
        if (this.metaDataInfoIsCached_) {
            string = (String)this.metaDataInfoCache_[n];
        } else {
            this.metaDataInfoCall();
            string = (String)this.metaDataInfoCache_[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
            if (new Integer(stringTokenizer2.nextToken()) != n3) continue;
            while (stringTokenizer.hasMoreTokens()) {
                if (new Integer(stringTokenizer.nextToken()) != n2) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean getMetaDataInfoBoolean_supportsConvert(int n, int n2, int n3) throws SqlException {
        String string = null;
        if (this.metaDataInfoIsCached_) {
            string = (String)this.metaDataInfoCache_[n];
        } else {
            this.metaDataInfoCall();
            string = (String)this.metaDataInfoCache_[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
            if (new Integer(stringTokenizer2.nextToken()) != n2) continue;
            while (stringTokenizer.hasMoreTokens()) {
                if (new Integer(stringTokenizer.nextToken()) != n3) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metaDataInfoCall() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            PreparedStatement preparedStatement = this.prepareMetaDataQuery("SYSIBM.MetaData()");
            ResultSet resultSet = preparedStatement.executeQueryX();
            resultSet.nextX();
            int n = resultSet.getMetaDataX().getColumnCount();
            for (int i = 0; i < n && i < this.metaDataInfoCache_.length; ++i) {
                this.metaDataInfoCache_[i] = resultSet.getObjectX(i + 1);
            }
            this.metaDataInfoIsCached_ = true;
            resultSet.closeX();
        }
    }

    private PreparedStatement prepareMetaDataQuery(String string) throws SqlException {
        PreparedStatement preparedStatement = this.connection_.prepareStatementX("CALL " + string, 1003, 1007, this.connection_.holdability(), 2, null);
        return preparedStatement;
    }

    private void checkForClosedConnection() throws SqlException {
        if (this.connection_.isClosedX()) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, "DatabaseMetaData method called after connection was closed");
        }
        this.agent_.checkForDeferredExceptions();
    }
}

