/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetIndoubtTransaction;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.jdbc.ClientDataSource;

public class NetXAConnection
extends NetConnection {
    public NetXAConnection(NetLogWriter netLogWriter, String string, String string2, ClientDataSource clientDataSource, int n, boolean bl) throws SqlException {
        super(netLogWriter, string, string2, clientDataSource, n, bl);
        this.checkPlatformVersion();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void setCorrelatorToken(byte[] byArray) {
        this.crrtkn_ = byArray;
    }

    public byte[] getCorrelatorToken() {
        return this.crrtkn_;
    }

    void setNetXAResource(NetXAResource netXAResource) {
        this.xares_ = netXAResource;
    }

    public void writeLocalXAStart_() throws SqlException {
        this.netAgent_.netConnectionRequest_.writeLocalXAStart(this);
    }

    public void readLocalXAStart_() throws SqlException {
        this.netAgent_.netConnectionReply_.readLocalXAStart(this);
    }

    public void writeLocalXACommit_() throws SqlException {
        this.netAgent_.netConnectionRequest_.writeLocalXACommit(this);
    }

    public void readLocalXACommit_() throws SqlException {
        this.netAgent_.netConnectionReply_.readLocalXACommit(this);
    }

    public void writeLocalXARollback_() throws SqlException {
        this.netAgent_.netConnectionRequest_.writeLocalXARollback(this);
    }

    public void readLocalXARollback_() throws SqlException {
        this.netAgent_.netConnectionReply_.readLocalXARollback(this);
    }

    public void writeTransactionStart(Statement statement) throws SqlException {
        if (!this.isXAConnection_) {
            return;
        }
        int n = this.getXAState();
        this.xares_.exceptionsOnXA = null;
    }

    public void setIndoubtTransactions(Hashtable hashtable) {
        if (this.indoubtTransactions_ != null) {
            this.indoubtTransactions_.clear();
        }
        this.indoubtTransactions_ = hashtable;
    }

    public byte[] getUOWID(Xid xid) {
        NetIndoubtTransaction netIndoubtTransaction = (NetIndoubtTransaction)this.indoubtTransactions_.get(xid);
        if (netIndoubtTransaction == null) {
            return null;
        }
        byte[] byArray = netIndoubtTransaction.getUOWID();
        return byArray;
    }

    public int getPort(Xid xid) {
        NetIndoubtTransaction netIndoubtTransaction = (NetIndoubtTransaction)this.indoubtTransactions_.get(xid);
        if (netIndoubtTransaction == null) {
            return -1;
        }
        return netIndoubtTransaction.getPort();
    }

    public void writeCommit() throws SqlException {
        if (this.isXAConnection_) {
            int n = this.getXAState();
            if (n == 0) {
                this.xares_.callInfoArray_[this.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
                this.writeLocalXACommit_();
            }
        } else {
            this.writeLocalCommit_();
        }
    }

    public void readCommit() throws SqlException {
        if (this.isXAConnection_) {
            int n = this.getXAState();
            NetXACallInfo netXACallInfo = this.xares_.callInfoArray_[this.currXACallInfoOffset_];
            netXACallInfo.xaRetVal_ = 0;
            if (n == 0) {
                this.readLocalXACommit_();
            }
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 1;
                this.xares_.xaRetValErrorAccumSQL(netXACallInfo, 0);
                netXACallInfo.xaRetVal_ = 0;
                throw this.xares_.exceptionsOnXA;
            }
        } else {
            this.readLocalCommit_();
        }
    }

    public void writeRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.xares_.callInfoArray_[this.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
            this.writeLocalXARollback_();
        } else {
            this.writeLocalRollback_();
        }
    }

    public void readRollback() throws SqlException {
        if (this.isXAConnection_) {
            NetXACallInfo netXACallInfo = this.xares_.callInfoArray_[this.currXACallInfoOffset_];
            netXACallInfo.xaRetVal_ = 0;
            this.readLocalXARollback_();
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 6;
                this.xares_.xaRetValErrorAccumSQL(netXACallInfo, 0);
                netXACallInfo.xaRetVal_ = 0;
                throw this.xares_.exceptionsOnXA;
            }
            this.setXAState(0);
        } else {
            this.readLocalRollback_();
        }
    }

    public synchronized void close() throws SqlException {
        super.close();
        if (this.open_) {
            return;
        }
        if (this.xares_ != null) {
            this.xares_.removeXaresFromSameRMchain();
        }
    }

    public synchronized void closeX() throws SqlException {
        super.closeX();
        if (this.open_) {
            return;
        }
        if (this.xares_ != null) {
            this.xares_.removeXaresFromSameRMchain();
        }
    }

    public synchronized void closeForReuse() throws SqlException {
        super.closeForReuse();
        if (this.open_) {
            return;
        }
        if (this.xares_ != null) {
            this.xares_.removeXaresFromSameRMchain();
        }
    }

    public synchronized void closeResources() throws SqlException {
        super.closeResources();
        if (this.open_) {
            return;
        }
        if (this.xares_ != null) {
            this.xares_.removeXaresFromSameRMchain();
        }
    }

    private void checkPlatformVersion() throws SqlException {
        int n = 8;
        if (this.xaHostVersion_ >= n) {
            return;
        }
        String string = null;
        string = "Linux, Unix, Windows";
        String string2 = "On " + string + " XA supports version " + n + " and above, this is version " + this.xaHostVersion_;
        throw new SqlException(this.agent_.logWriter_, string2);
    }
}

