/*
 * Decompiled with CFR 0.152.
 */
package Interfaces;

import DataBase.Conduites;
import DataBase.Equipment;
import DataBase.Irrigation;
import DataBase.Technicaloperations;
import Interfaces.LutteProdBioFrame;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import modules.CultureMod;
import modules.IrrigationMod;
import modules.ItkMod;
import modules.LasyTools;
import modules.OutilMod;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;

public class IrrigationFrame
extends JFrame {
    OutilMod Outil = new OutilMod();
    LasyTools Tool = new LasyTools();
    Irrigation i;
    Query MyQuery;
    int IdIrr;
    int idConduite;
    boolean AddIrrigation = false;
    boolean ScreenIrrig = false;
    JMenuItem AddMenuItem;
    private JButton CloseButton;
    JMenuItem DeleteMenuItem;
    JLabel OutilLabel;
    private JButton deleteButton;
    private EntityManager entityManager;
    JMenuItem exitMenuItem;
    JMenu fileMenu;
    JTextField frequenceField;
    JLabel frequenceLabel;
    JComboBox jComboBoxOutil;
    JLabel jLabelCurrentCdt;
    JLabel jLabelCurrentCrop;
    JPanel jPanel1;
    JComboBox jourField;
    JLabel jourLabel;
    private List<Irrigation> list;
    JScrollPane masterScrollPane;
    private JTable masterTable;
    JMenuBar menuBar;
    JComboBox moisField;
    JLabel moisLabel;
    private JButton newButton;
    JTextField quantiteField;
    JLabel quantiteLabel;
    private Query query;
    private JButton saveButton;
    JMenuItem saveMenuItem;
    private BindingGroup bindingGroup;

    public IrrigationFrame() {
        this.initComponents();
    }

    public IrrigationFrame(int idCdt) {
        this.idConduite = idCdt;
        this.InitAll(this.idConduite);
        this.ScreenIrrig = true;
        this.AfficheCdtSelect();
    }

    private void AfficheCdtSelect() {
        CultureMod CropT = new CultureMod();
        this.jLabelCurrentCdt.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONDUITE") + ((Conduites)this.entityManager.find(Conduites.class, (Object)this.idConduite)).getNomcdt());
        this.jLabelCurrentCrop.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CULTURE") + CropT.GetNameCultByIdCdt(this.idConduite));
    }

    private void InitAll(int idCdt) {
        this.initComponents();
        this.setLocation(this.Tool.CentreFrame(this));
        this.InitListOutil();
        this.IniList(idCdt);
        this.refreshData();
        this.SetInterface();
        this.SetFreese(false);
    }

    private void InitListOutil() {
        List OutilList = this.Outil.GetListOfOutil();
        this.jComboBoxOutil.addItem("");
        if (!OutilList.isEmpty()) {
            for (Equipment Eq : OutilList) {
                this.jComboBoxOutil.addItem(Eq.getName());
            }
        }
        this.jComboBoxOutil.setSelectedItem("");
    }

    private void IniList(int idCdte) {
        ItkMod Itk = new ItkMod();
        Object evt = null;
        Object OpList = null;
        boolean IdIrriglis = false;
        String Sql = "";
        String SqlNext = "";
        boolean firstRun = false;
        if (idCdte != 0) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.Reconnect();
            }
            Sql = "SELECT i FROM Irrigation i WHERE i.technicaloperation.conduites.idcdt =" + idCdte;
            this.query = this.entityManager.createQuery(Sql);
        }
        firstRun = false;
    }

    private void SetInterface() {
        int i = 0;
        List IrrOpList = this.entityManager.createQuery("SELECT t FROM Technicaloperations t WHERE t.idtechop = -1").getResultList();
        IrrOpList.clear();
        IrrOpList.addAll(((Conduites)this.entityManager.find(Conduites.class, (Object)this.idConduite)).getTechnicaloperationsCollection());
        if (!IrrOpList.isEmpty()) {
            for (Technicaloperations Op : IrrOpList) {
                if (Op.getIrrigation() == null) continue;
                ++i;
            }
        }
        if (i != 0) {
            this.newButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.AddIrrigation = false;
        } else {
            this.newButton.setEnabled(true);
            this.deleteButton.setEnabled(false);
        }
    }

    private void UpdateData() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void Reconnect() {
        if (this.entityManager.isOpen()) {
            this.entityManager.close();
        }
        EntityManager entityManager = this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)ResourceBundle.getBundle("Interfaces/resources/InterfacePrincipaleBundle").getString("entityManager.persistenceUnit")).createEntityManager();
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
    }

    private void refreshData() {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.entityManager.getTransaction().rollback();
        this.entityManager.getTransaction().begin();
        List data = this.query.getResultList();
        for (Object entity : data) {
            this.entityManager.refresh(entity);
        }
        this.list.clear();
        this.list.addAll(data);
    }

    private void SetFreese(boolean Statut) {
        this.jourField.setEnabled(Statut);
        this.moisField.setEnabled(Statut);
        this.quantiteField.setEnabled(Statut);
        this.saveButton.setEnabled(Statut);
        this.deleteButton.setEnabled(Statut);
        this.jComboBoxOutil.setEnabled(Statut);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        ResourceBundle bundle = ResourceBundle.getBundle("Interfaces/resources/OperationsBundle");
        this.entityManager = Beans.isDesignTime() ? null : Persistence.createEntityManagerFactory((String)bundle.getString("CRITERBASE.DB3PU")).createEntityManager();
        this.query = Beans.isDesignTime() ? null : this.entityManager.createQuery("SELECT i FROM Irrigation i WHERE i.idirr =-1");
        this.list = Beans.isDesignTime() ? Collections.emptyList() : ObservableCollections.observableList(this.query.getResultList());
        this.jPanel1 = new JPanel();
        this.masterScrollPane = new JScrollPane();
        this.masterTable = new JTable();
        this.jourLabel = new JLabel();
        this.moisLabel = new JLabel();
        this.quantiteLabel = new JLabel();
        this.quantiteField = new JTextField();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.saveButton = new JButton();
        this.CloseButton = new JButton();
        this.jourField = new JComboBox();
        this.moisField = new JComboBox();
        this.jLabelCurrentCdt = new JLabel();
        this.jLabelCurrentCrop = new JLabel();
        this.jComboBoxOutil = new JComboBox();
        this.OutilLabel = new JLabel();
        this.frequenceLabel = new JLabel();
        this.frequenceField = new JTextField();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.AddMenuItem = new JMenuItem();
        this.DeleteMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setName("Irrigation");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                IrrigationFrame.this.formComponentShown(evt);
            }
        });
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jPanel1.setName("jPanel1");
        this.masterScrollPane.setName("masterScrollPane");
        this.masterTable.setFont(new Font("Arial", 0, 12));
        this.masterTable.setName("masterTable");
        this.masterTable.setSelectionMode(0);
        JTableBinding<Irrigation, List<Irrigation>, JTable> jTableBinding = SwingBindings.createJTableBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.list, this.masterTable);
        JTableBinding.ColumnBinding columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${jour}"));
        columnBinding.setColumnName(bundle.getString("JOUR"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${mois}"));
        columnBinding.setColumnName(bundle.getString("MOIS"));
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${quantite}"));
        columnBinding.setColumnName(bundle.getString("QUANTITE"));
        columnBinding.setColumnClass(Double.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${idirr}"));
        columnBinding.setColumnName("id");
        columnBinding.setColumnClass(Integer.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${equipment.name}"));
        columnBinding.setColumnName(bundle.getString("OUTIL"));
        columnBinding.setColumnClass(String.class);
        columnBinding = jTableBinding.addColumnBinding(ELProperty.create("${frequence}"));
        columnBinding.setColumnName(bundle.getString("FREQUENCE"));
        columnBinding.setColumnClass(Double.class);
        this.bindingGroup.addBinding(jTableBinding);
        jTableBinding.bind();
        this.masterTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IrrigationFrame.this.masterTableMouseClicked(evt);
            }
        });
        this.masterScrollPane.setViewportView(this.masterTable);
        this.masterTable.getColumnModel().getColumn(0).setMinWidth(45);
        this.masterTable.getColumnModel().getColumn(0).setPreferredWidth(45);
        this.masterTable.getColumnModel().getColumn(0).setMaxWidth(45);
        this.masterTable.getColumnModel().getColumn(1).setMinWidth(50);
        this.masterTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.masterTable.getColumnModel().getColumn(1).setMaxWidth(50);
        this.masterTable.getColumnModel().getColumn(2).setMinWidth(80);
        this.masterTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.masterTable.getColumnModel().getColumn(2).setMaxWidth(80);
        this.masterTable.getColumnModel().getColumn(3).setMinWidth(1);
        this.masterTable.getColumnModel().getColumn(3).setPreferredWidth(1);
        this.masterTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.masterTable.getColumnModel().getColumn(4).setMinWidth(402);
        this.masterTable.getColumnModel().getColumn(4).setPreferredWidth(402);
        this.masterTable.getColumnModel().getColumn(4).setMaxWidth(402);
        this.masterTable.getColumnModel().getColumn(5).setMinWidth(90);
        this.masterTable.getColumnModel().getColumn(5).setPreferredWidth(90);
        this.masterTable.getColumnModel().getColumn(5).setMaxWidth(90);
        this.jourLabel.setBackground(new Color(51, 51, 51));
        this.jourLabel.setFont(new Font("Arial", 0, 12));
        this.jourLabel.setForeground(new Color(255, 254, 255));
        this.jourLabel.setText(bundle.getString("JOUR"));
        this.jourLabel.setFocusable(false);
        this.jourLabel.setName("jourLabel");
        this.jourLabel.setRequestFocusEnabled(false);
        this.moisLabel.setBackground(new Color(51, 51, 51));
        this.moisLabel.setFont(new Font("Arial", 0, 12));
        this.moisLabel.setForeground(new Color(255, 254, 255));
        this.moisLabel.setText(bundle.getString("MOIS"));
        this.moisLabel.setFocusable(false);
        this.moisLabel.setName("moisLabel");
        this.moisLabel.setRequestFocusEnabled(false);
        this.quantiteLabel.setBackground(new Color(51, 51, 51));
        this.quantiteLabel.setFont(new Font("Arial", 0, 12));
        this.quantiteLabel.setForeground(new Color(255, 254, 255));
        this.quantiteLabel.setText(bundle.getString("QUANTITE (MM)"));
        this.quantiteLabel.setFocusable(false);
        this.quantiteLabel.setName("quantiteLabel");
        this.quantiteLabel.setRequestFocusEnabled(false);
        this.quantiteField.setFont(new Font("Arial", 0, 12));
        this.quantiteField.setForeground(new Color(0, 1, 0));
        this.quantiteField.setName("quantiteField");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.quantite}"), this.quantiteField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.quantiteField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                IrrigationFrame.this.quantiteFieldCaretUpdate(evt);
            }
        });
        this.newButton.setFont(new Font("Arial", 1, 12));
        this.newButton.setForeground(new Color(0, 1, 0));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.newButton.setText(bundle.getString("AJOUTER"));
        this.newButton.setBorder(null);
        this.newButton.setBorderPainted(false);
        this.newButton.setContentAreaFilled(false);
        this.newButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.newButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.newButton.setHorizontalTextPosition(0);
        this.newButton.setName("newButton");
        this.newButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrrigationFrame.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setFont(new Font("Arial", 1, 12));
        this.deleteButton.setForeground(new Color(0, 1, 0));
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.deleteButton.setText(bundle.getString("SUPPRIMER"));
        this.deleteButton.setBorder(null);
        this.deleteButton.setBorderPainted(false);
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setName("deleteButton");
        this.deleteButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrrigationFrame.this.deleteButtonActionPerformed(evt);
            }
        });
        this.saveButton.setFont(new Font("Arial", 1, 12));
        this.saveButton.setForeground(new Color(0, 1, 0));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.saveButton.setText(bundle.getString("ENREGISTRER"));
        this.saveButton.setBorder(null);
        this.saveButton.setBorderPainted(false);
        this.saveButton.setContentAreaFilled(false);
        this.saveButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setName("saveButton");
        this.saveButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrrigationFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.CloseButton.setFont(new Font("Arial", 1, 12));
        this.CloseButton.setForeground(new Color(0, 1, 0));
        this.CloseButton.setIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple chrome2.png")));
        this.CloseButton.setText(bundle.getString("FERMER"));
        this.CloseButton.setBorder(null);
        this.CloseButton.setBorderPainted(false);
        this.CloseButton.setContentAreaFilled(false);
        this.CloseButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.CloseButton.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple Black.png")));
        this.CloseButton.setHorizontalTextPosition(0);
        this.CloseButton.setName("CloseButton");
        this.CloseButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/Interfaces/resources/oval simple white.png")));
        this.CloseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                IrrigationFrame.this.CloseButtonMouseReleased(evt);
            }
        });
        this.jourField.setFont(new Font("Arial", 0, 12));
        this.jourField.setForeground(new Color(0, 1, 0));
        this.jourField.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"}));
        this.jourField.setName("jourField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.jour}"), this.jourField, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.jourField.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                IrrigationFrame.this.jourFieldPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.moisField.setFont(new Font("Arial", 0, 12));
        this.moisField.setForeground(new Color(0, 1, 0));
        this.moisField.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}));
        this.moisField.setName("moisField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.mois}"), this.moisField, BeanProperty.create("selectedItem"));
        this.bindingGroup.addBinding(binding);
        this.moisField.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                IrrigationFrame.this.moisFieldPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.jLabelCurrentCdt.setFont(new Font("Arial", 1, 12));
        this.jLabelCurrentCdt.setForeground(new Color(204, 255, 204));
        this.jLabelCurrentCdt.setText(bundle.getString("CONDUITE"));
        this.jLabelCurrentCdt.setName("jLabelCurrentCdt");
        this.jLabelCurrentCrop.setFont(new Font("Arial", 1, 12));
        this.jLabelCurrentCrop.setForeground(new Color(204, 255, 204));
        this.jLabelCurrentCrop.setText(bundle.getString("CULTURE"));
        this.jLabelCurrentCrop.setName("jLabelCurrentCrop");
        this.jComboBoxOutil.setFont(new Font("Arial", 0, 12));
        this.jComboBoxOutil.setName("jComboBoxOutil");
        this.OutilLabel.setFont(new Font("Arial", 0, 12));
        this.OutilLabel.setForeground(new Color(255, 254, 255));
        this.OutilLabel.setText(bundle.getString("OUTIL"));
        this.OutilLabel.setName("OutilLabel");
        this.OutilLabel.setForeground(new Color(255, 255, 255));
        this.frequenceLabel.setBackground(new Color(51, 51, 51));
        this.frequenceLabel.setFont(new Font("Arial", 0, 12));
        this.frequenceLabel.setForeground(new Color(255, 254, 255));
        this.frequenceLabel.setText(bundle.getString("FR\u00c9QUENCE"));
        this.frequenceLabel.setFocusable(false);
        this.frequenceLabel.setName("frequenceLabel");
        this.frequenceLabel.setRequestFocusEnabled(false);
        this.frequenceField.setFont(new Font("Arial", 0, 12));
        this.frequenceField.setForeground(new Color(0, 1, 0));
        this.frequenceField.setName("frequenceField");
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.masterTable, ELProperty.create("${selectedElement.frequence}"), this.frequenceField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.frequenceField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                IrrigationFrame.this.frequenceFieldCaretUpdate(evt);
            }
        });
        this.frequenceField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                IrrigationFrame.this.frequenceFieldFocusLost(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.masterScrollPane)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.newButton, -2, 120, -2).addGap(65, 65, 65).addComponent(this.deleteButton, -2, 120, -2).addGap(65, 65, 65).addComponent(this.saveButton, -2, 120, -2).addGap(65, 65, 65).addComponent(this.CloseButton, -2, 120, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelCurrentCdt, -2, 183, -2).addGap(53, 53, 53).addComponent(this.jLabelCurrentCrop, -2, 224, -2)))).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.OutilLabel).addGap(29, 29, 29).addComponent(this.jComboBoxOutil, -2, 336, -2).addGap(19, 19, 19).addComponent(this.frequenceLabel, -2, 102, -2).addGap(11, 11, 11).addComponent(this.frequenceField, -2, 60, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jourLabel).addGap(29, 29, 29).addComponent(this.jourField, -2, 65, -2).addGap(85, 85, 85).addComponent(this.moisLabel).addGap(26, 26, 26).addComponent(this.moisField, -2, 65, -2).addGap(85, 85, 85).addComponent(this.quantiteLabel, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.quantiteField, -2, 60, -2))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCurrentCdt).addComponent(this.jLabelCurrentCrop)).addGap(18, 18, 18).addComponent(this.masterScrollPane, -2, 179, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jourLabel).addComponent(this.jourField, -2, 20, -2).addComponent(this.moisLabel).addComponent(this.moisField, -2, 20, -2).addComponent(this.quantiteLabel).addComponent(this.quantiteField, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.OutilLabel).addComponent(this.jComboBoxOutil, -2, 20, -2).addComponent(this.frequenceLabel).addComponent(this.frequenceField, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton, -2, 45, -2).addComponent(this.CloseButton, -2, 45, -2).addComponent(this.deleteButton, -2, 45, -2).addComponent(this.saveButton, -2, 45, -2)).addContainerGap()));
        this.menuBar.setName("menuBar");
        this.fileMenu.setText(bundle.getString("DONNEES_IRRIGATIONS"));
        this.fileMenu.setName("fileMenu");
        this.fileMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IrrigationFrame.this.fileMenuMouseClicked(evt);
            }
        });
        this.AddMenuItem.setText(bundle.getString("AJOUTER"));
        this.AddMenuItem.setName("AddMenuItem");
        this.AddMenuItem.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyPressed(MenuKeyEvent evt) {
                IrrigationFrame.this.AddMenuItemMenuKeyPressed(evt);
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent evt) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent evt) {
            }
        });
        this.fileMenu.add(this.AddMenuItem);
        this.DeleteMenuItem.setText(bundle.getString("SUPPRIMER"));
        this.DeleteMenuItem.setName("DeleteMenuItem");
        this.DeleteMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IrrigationFrame.this.DeleteMenuItemMouseClicked(evt);
            }
        });
        this.fileMenu.add(this.DeleteMenuItem);
        this.saveMenuItem.setText(bundle.getString("ENREGISTRER"));
        this.saveMenuItem.setName("saveMenuItem");
        this.saveMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IrrigationFrame.this.saveMenuItemMouseClicked(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.exitMenuItem.setText(bundle.getString("FERMER"));
        this.exitMenuItem.setName("exitMenuItem");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrrigationFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.bindingGroup.bind();
        this.pack();
    }

    private void saveMenuItemMouseClicked(MouseEvent evt) {
        ActionEvent ev = null;
        this.saveButtonActionPerformed(ev);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void fileMenuMouseClicked(MouseEvent evt) {
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(true);
        this.jourField.requestFocus();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        if (this.newButton.getText().equals(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("AJOUTER"))) {
            IrrigationMod Irrmod = new IrrigationMod();
            this.i = new Irrigation();
            this.IdIrr = Irrmod.getLastIrrigId() + 1;
            this.i.setIdirr(this.IdIrr);
            this.entityManager.merge((Object)this.i);
            this.list.add(this.i);
            int row = this.list.size() - 1;
            this.masterTable.setRowSelectionInterval(row, row);
            this.masterTable.scrollRectToVisible(this.masterTable.getCellRect(row, 0, true));
            this.SetFreese(true);
            this.frequenceField.setText("1");
            this.jComboBoxOutil.setSelectedItem("");
            this.jourField.requestFocus();
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("ANNULER"));
            this.deleteButton.setEnabled(false);
            this.AddIrrigation = true;
        } else {
            this.refreshData();
            this.SetFreese(false);
            this.AddIrrigation = false;
            this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("AJOUTER"));
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int choix = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONFIRMER_SUPPRESSION"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("SUPPRESSION"), 2);
        if (this.masterTable.getSelectedRow() != -1) {
            if (choix == 0) {
                if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                    this.entityManager.getTransaction().begin();
                }
                int[] selected = this.masterTable.getSelectedRows();
                ArrayList<Irrigation> toRemove = new ArrayList<Irrigation>(selected.length);
                for (int idx = 0; idx < selected.length; ++idx) {
                    Irrigation ir = this.list.get(this.masterTable.convertRowIndexToModel(selected[idx]));
                    toRemove.add(ir);
                    this.entityManager.remove(this.entityManager.find(Irrigation.class, (Object)ir.getIdirr()));
                }
                this.SetFreese(false);
                this.IniList(this.idConduite);
                this.UpdateData();
                this.entityManager.getTransaction().commit();
                this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("AJOUTER"));
            }
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("S\u00c9LECTIONNER_LIGNE"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("SUPPRESSION_IMPOSSIBLE"), -1);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        block25: {
            String jour = "";
            String mois = "";
            String qt = "";
            LasyTools T = new LasyTools();
            boolean DataNoset = false;
            int j = 0;
            int m = 0;
            double freq = 0.0;
            double q = 0.0;
            try {
                if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                    this.entityManager.getTransaction().begin();
                }
                this.newButton.setText(ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("AJOUTER"));
                this.i = (Irrigation)this.entityManager.find(Irrigation.class, (Object)this.IdIrr);
                try {
                    jour = this.jourField.getSelectedItem().toString();
                    j = T.SetAsA_Int(jour);
                }
                catch (NullPointerException ex) {
                    j = 0;
                    DataNoset = true;
                }
                catch (ParseException ex) {
                    DataNoset = true;
                    Logger.getLogger(LutteProdBioFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    mois = this.moisField.getSelectedItem().toString();
                    m = T.SetAsA_Int(mois);
                }
                catch (NullPointerException ex) {
                    m = 0;
                    DataNoset = true;
                }
                catch (ParseException ex) {
                    DataNoset = true;
                    Logger.getLogger(LutteProdBioFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    qt = this.quantiteField.getText().toString();
                    q = T.SetAsAdouble(qt);
                }
                catch (NullPointerException ex) {
                    q = 0.0;
                    DataNoset = true;
                }
                catch (ParseException ex) {
                    DataNoset = true;
                    Logger.getLogger(LutteProdBioFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    freq = T.SetAsAdouble(this.frequenceField.getText().toString());
                }
                catch (NullPointerException ex) {
                    freq = 0.0;
                    DataNoset = true;
                }
                catch (ParseException ex) {
                    DataNoset = true;
                    Logger.getLogger(LutteProdBioFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (!DataNoset) {
                    if (!this.Outil.VerifFrequence(this.frequenceField)) {
                        this.frequenceField.setForeground(Color.red);
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VALEUR_INFERIEURE_FREQUENCE"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VALEUR INCORRECTE"), -1);
                        break block25;
                    }
                    this.frequenceField.setForeground(Color.getColor("#000100"));
                    this.i.setJour(j);
                    this.i.setMois(m);
                    this.i.setQuantite(q);
                    this.i.setFrequence(freq);
                    try {
                        int IDequip = this.Outil.GetIdOutilByName(this.jComboBoxOutil.getSelectedItem().toString());
                        this.i.setEquipment((Equipment)this.entityManager.find(Equipment.class, (Object)IDequip));
                        double CoutEnergie = this.Outil.GetEquipCoutNRJ(this.idConduite, IDequip);
                        this.i.setCoutenergetique(CoutEnergie);
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    this.MergeOrPersistInBase(this.i);
                    if (this.AddIrrigation) {
                        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                            this.Reconnect();
                        }
                        try {
                            ItkMod Itk = new ItkMod();
                            Itk.AddNewOp(2, this.IdIrr, this.idConduite);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(IrrigationFrame.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.entityManager.refresh(this.entityManager.find(Irrigation.class, (Object)this.IdIrr));
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("ENREGISTREMENT REUSSI"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONFIRMATION_SAUVEGARDE"), -1);
                    } else {
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("MISE_A_JOUR EFFECTUEE"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("CONFIRMATION_MISE_A_JOUR"), -1);
                    }
                    this.IniList(this.idConduite);
                    this.refreshData();
                    this.AddIrrigation = false;
                    this.SetFreese(false);
                    break block25;
                }
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VEUILLEZ RENSEIGNER L'ENSEMBLE DES INFORMATIONS"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VALEURS MANQUANTES"), -1);
            }
            catch (RollbackException rex) {
                rex.printStackTrace();
                this.entityManager.getTransaction().begin();
                ArrayList<Object> merged = new ArrayList<Object>(this.list.size());
                for (Irrigation i : this.list) {
                    merged.add(this.entityManager.merge((Object)i));
                }
                this.list.clear();
                this.list.addAll(merged);
            }
        }
    }

    public void MergeOrPersistInBase(Object T) {
        if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        try {
            this.entityManager.merge(T);
            this.entityManager.getTransaction().commit();
        }
        catch (EntityExistsException | RollbackException Ex) {
            if (!Beans.isDesignTime() && !this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().begin();
            }
            this.entityManager.persist(T);
            this.entityManager.getTransaction().commit();
        }
        this.entityManager.clear();
        this.entityManager.close();
    }

    private void CloseButtonMouseReleased(MouseEvent evt) {
        this.dispose();
    }

    private void AddMenuItemMenuKeyPressed(MenuKeyEvent evt) {
        ActionEvent ev = null;
        this.newButtonActionPerformed(ev);
    }

    private void DeleteMenuItemMouseClicked(MouseEvent evt) {
        ActionEvent ev = null;
        this.deleteButtonActionPerformed(ev);
    }

    private void masterTableMouseClicked(MouseEvent evt) {
        int RowSelect = 0;
        try {
            RowSelect = this.masterTable.getSelectedRow();
            this.IdIrr = this.Tool.SetAsA_Int(this.masterTable.getValueAt(RowSelect, 3).toString());
            this.SetFreese(true);
            this.jourField.setSelectedItem(this.masterTable.getValueAt(RowSelect, 0).toString());
            this.moisField.setSelectedItem(this.masterTable.getValueAt(RowSelect, 1).toString());
            this.jComboBoxOutil.setSelectedItem(this.masterTable.getValueAt(RowSelect, 4).toString());
        }
        catch (ParseException ex) {
            Logger.getLogger(IrrigationFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void jourFieldPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.jourField.getSelectedItem().toString(), row, 0);
            }
        }
        catch (NullPointerException ex) {
            System.out.println("jourField =null");
        }
    }

    private void moisFieldPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.moisField.getSelectedItem().toString(), row, 1);
            }
        }
        catch (NullPointerException ex) {
            System.out.println("moisField =null");
        }
    }

    private void quantiteFieldCaretUpdate(CaretEvent evt) {
        int row = 0;
        try {
            if (this.masterTable.getSelectedRow() != -1) {
                row = this.masterTable.getSelectedRow();
                this.masterTable.setValueAt(this.quantiteField.getText().toString(), row, 2);
            }
        }
        catch (NullPointerException ex) {
            System.out.println("quantiteField =null");
        }
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void frequenceFieldCaretUpdate(CaretEvent evt) {
    }

    private void frequenceFieldFocusLost(FocusEvent evt) {
        if (!this.Outil.VerifFrequence(this.frequenceField)) {
            this.frequenceField.setForeground(Color.red);
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VALEUR_INFERIEURE_FREQUENCE"), ResourceBundle.getBundle("Interfaces/resources/OperationsBundle").getString("VALEUR INCORRECTE"), -1);
        } else {
            this.frequenceField.setForeground(Color.getColor("#000100"));
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new IrrigationFrame().setVisible(true);
            }
        });
    }
}

